/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.util.skiplist;

import java.io.Flushable;
import net.metanotion.util.skiplist.SkipList;

public class SkipSpan
implements Flushable {
    public static final int MAX_SIZE = 256;
    public int nKeys = 0;
    public Comparable[] keys;
    public Object[] vals;
    public SkipSpan next;
    public SkipSpan prev;

    public SkipSpan newInstance(SkipList sl) {
        return new SkipSpan(this.keys.length);
    }

    public void killInstance() {
    }

    @Override
    public void flush() {
    }

    protected SkipSpan() {
    }

    public SkipSpan(int size) {
        if (size < 1 || size > 256) {
            throw new IllegalArgumentException("Invalid span size " + size);
        }
        this.keys = new Comparable[size];
        this.vals = new Object[size];
    }

    public String print() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("Span with ").append(this.nKeys).append(" keys\n");
        if (this.nKeys > 0 && this.keys != null && this.vals != null) {
            for (int i = 0; i < this.nKeys; ++i) {
                buf.append('\t').append(this.keys[i]).append(" => ").append(this.vals[i]).append('\n');
            }
        }
        if (this.next != null) {
            buf.append(this.next.print());
        }
        return buf.toString();
    }

    private int binarySearch(Comparable key) {
        int high = this.nKeys - 1;
        int low = 0;
        while (low <= high) {
            int cur = low + high >>> 1;
            int cmp = this.keys[cur].compareTo(key);
            if (cmp > 0) {
                high = cur - 1;
                continue;
            }
            if (cmp < 0) {
                low = cur + 1;
                continue;
            }
            return cur;
        }
        return -1 * (low + 1);
    }

    public SkipSpan getEnd() {
        if (this.next == null) {
            return this;
        }
        return this.next.getEnd();
    }

    public SkipSpan getSpan(Comparable key, int[] search) {
        if (this.nKeys == 0) {
            search[0] = -1;
            return this;
        }
        if (this.keys[this.nKeys - 1].compareTo(key) < 0) {
            if (this.next == null) {
                search[0] = -1 * (this.nKeys - 1) - 1;
                return this;
            }
            return this.next.getSpan(key, search);
        }
        search[0] = this.binarySearch(key);
        return this;
    }

    public Object get(Comparable key) {
        if (this.nKeys == 0) {
            return null;
        }
        if (this.keys[this.nKeys - 1].compareTo(key) < 0) {
            if (this.next == null) {
                return null;
            }
            return this.next.get(key);
        }
        int loc = this.binarySearch(key);
        if (loc < 0) {
            return null;
        }
        return this.vals[loc];
    }

    private void pushTogether(int hole) {
        for (int i = hole; i < this.nKeys - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.vals[i] = this.vals[i + 1];
        }
        --this.nKeys;
    }

    private void pushApart(int start) {
        for (int i = this.nKeys - 1; i >= start; --i) {
            this.keys[i + 1] = this.keys[i];
            this.vals[i + 1] = this.vals[i];
        }
        ++this.nKeys;
    }

    private void split(int loc, Comparable key, Object val, SkipList sl) {
        int start;
        SkipSpan right = this.newInstance(sl);
        if (this.next != null) {
            this.next.prev = right;
        }
        right.next = this.next;
        right.prev = this;
        this.next = right;
        for (int i = start = (this.keys.length + 1) / 2; i < this.keys.length; ++i) {
            try {
                right.keys[i - start] = this.keys[i];
                right.vals[i - start] = this.vals[i];
                ++right.nKeys;
                --this.nKeys;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("i " + i + " start " + start);
                System.out.println("key: " + this.keys[i].toString());
                throw e;
            }
        }
        if (loc >= start) {
            right.pushApart(loc - start);
            right.keys[loc - start] = key;
            right.vals[loc - start] = val;
        } else {
            this.pushApart(loc);
            this.keys[loc] = key;
            this.vals[loc] = val;
        }
        this.flush();
        this.next.flush();
    }

    private SkipSpan insert(int loc, Comparable key, Object val, SkipList sl) {
        sl.addItem();
        if (this.nKeys == this.keys.length) {
            this.split(loc, key, val, sl);
            return this.next;
        }
        this.pushApart(loc);
        this.keys[loc] = key;
        this.vals[loc] = val;
        this.flush();
        return null;
    }

    public SkipSpan put(Comparable key, Object val, SkipList sl) {
        if (this.nKeys == 0) {
            sl.addItem();
            this.keys[0] = key;
            this.vals[0] = val;
            ++this.nKeys;
            this.flush();
            return null;
        }
        int loc = this.binarySearch(key);
        if (loc < 0) {
            loc = -1 * (loc + 1);
            if (this.next != null) {
                int cmp = this.next.firstKey().compareTo(key);
                if (loc >= this.nKeys && cmp > 0) {
                    if (this.nKeys == this.keys.length) {
                        if (this.next.nKeys == this.keys.length) {
                            return this.insert(loc, key, val, sl);
                        }
                        return this.next.put(key, val, sl);
                    }
                    return this.insert(loc, key, val, sl);
                }
                if (cmp > 0) {
                    return this.insert(loc, key, val, sl);
                }
                return this.next.put(key, val, sl);
            }
            return this.insert(loc, key, val, sl);
        }
        this.vals[loc] = val;
        this.flush();
        return null;
    }

    public Object[] remove(Comparable key, SkipList sl) {
        if (this.nKeys == 0) {
            return null;
        }
        if (this.keys[this.nKeys - 1].compareTo(key) < 0) {
            if (this.next == null) {
                return null;
            }
            return this.next.remove(key, sl);
        }
        int loc = this.binarySearch(key);
        if (loc < 0) {
            return null;
        }
        Object o = this.vals[loc];
        Object[] res = new Object[2];
        res[0] = o;
        sl.delItem();
        if (this.nKeys == 1) {
            if (this.prev == null && this.next != null) {
                res[1] = this.next;
                for (int i = 0; i < this.next.nKeys; ++i) {
                    this.keys[i] = this.next.keys[i];
                    this.vals[i] = this.next.vals[i];
                }
                this.nKeys = this.next.nKeys;
                SkipSpan nn = this.next.next;
                this.next.killInstance();
                if (nn != null) {
                    nn.prev = this;
                    nn.flush();
                }
                this.next = nn;
                this.flush();
            } else {
                if (this.prev != null) {
                    this.prev.next = this.next;
                    this.prev.flush();
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                    this.next.flush();
                    this.next = null;
                }
                if (this.prev != null) {
                    this.prev = null;
                    this.killInstance();
                    res[1] = this;
                } else {
                    this.flush();
                    res[1] = null;
                }
                this.nKeys = 0;
            }
        } else {
            this.pushTogether(loc);
            this.flush();
        }
        return res;
    }

    public Comparable firstKey() {
        return this.keys[0];
    }
}

