/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.util.skiplist;

import java.io.Flushable;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.metanotion.io.block.BlockFile;
import net.metanotion.util.skiplist.SkipList;
import net.metanotion.util.skiplist.SkipSpan;

public class SkipLevels
implements Flushable {
    public static final int MAX_SIZE = 32;
    public SkipLevels[] levels;
    public SkipSpan bottom;
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(BlockFile.class);

    public SkipLevels newInstance(int levels, SkipSpan ss, SkipList sl) {
        return new SkipLevels(levels, ss);
    }

    public void killInstance() {
    }

    @Override
    public void flush() {
    }

    protected SkipLevels() {
    }

    public SkipLevels(int size, SkipSpan span) {
        if (size < 1 || size > 32) {
            throw new IllegalArgumentException("Invalid Level Skip size");
        }
        this.levels = new SkipLevels[size];
        this.bottom = span;
    }

    public String print() {
        StringBuilder buf = new StringBuilder(128);
        String k = this.bottom.nKeys == 0 ? "empty" : (this.key() != null ? this.key().toString() : "null");
        buf.append("LVLS: ").append(k).append(" :: ");
        for (int i = 0; i < this.levels.length; ++i) {
            buf.append(i);
            if (this.levels[i] != null) {
                buf.append("->").append(this.levels[i].key()).append(' ');
                continue;
            }
            buf.append("->() ");
        }
        buf.append('\n');
        return buf.toString();
    }

    public String printAll() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.print());
        if (this.levels[0] != null) {
            buf.append('\n');
            buf.append(this.levels[0].print());
        }
        return buf.toString();
    }

    public SkipSpan getEnd() {
        for (int i = this.levels.length - 1; i >= 0; --i) {
            if (this.levels[i] == null) continue;
            return this.levels[i].getEnd();
        }
        return this.bottom.getEnd();
    }

    public SkipSpan getSpan(int start, Comparable key, int[] search) {
        for (int i = Math.min(start, this.levels.length - 1); i >= 0; --i) {
            if (this.levels[i] == null || this.levels[i].key().compareTo(key) > 0) continue;
            return this.levels[i].getSpan(i, key, search);
        }
        return this.bottom.getSpan(key, search);
    }

    public Comparable key() {
        return this.bottom.firstKey();
    }

    public Object get(int start, Comparable key) {
        for (int i = Math.min(start, this.levels.length - 1); i >= 0; --i) {
            if (this.levels[i] == null || this.levels[i].key().compareTo(key) > 0) continue;
            return this.levels[i].get(i, key);
        }
        return this.bottom.get(key);
    }

    public Object[] remove(int start, Comparable key, SkipList sl) {
        Object[] res = null;
        SkipLevels slvls = null;
        for (int i = Math.min(start, this.levels.length - 1); i >= 0; --i) {
            int cmp;
            if (this.levels[i] == null || (cmp = this.levels[i].key().compareTo(key)) >= 0 && (i != 0 || cmp > 0)) continue;
            res = this.levels[i].remove(i, key, sl);
            if (res != null && res[1] != null) {
                slvls = (SkipLevels)res[1];
                if (this.levels.length >= slvls.levels.length) {
                    res[1] = null;
                }
                for (int j = 0; j < Math.min(slvls.levels.length, this.levels.length); ++j) {
                    if (this.levels[j] != slvls) continue;
                    this.levels[j] = slvls.levels[j];
                }
                this.flush();
            }
            return res;
        }
        res = this.bottom.remove(key, sl);
        if (res != null && res[1] != null) {
            if (res[1] == this.bottom) {
                res[1] = this;
            } else {
                boolean isFirst;
                boolean bl = isFirst = sl.first == this.bottom;
                if (isFirst && this.levels[0] != null) {
                    SkipSpan ssres = (SkipSpan)res[1];
                    if (this.bottom.firstKey().equals(ssres.firstKey())) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("First Level, bottom.remove() copied and did not return itself!!!! in remove " + key);
                            this._log.info("Us:     " + this.print());
                            this._log.info("next:   " + this.levels[0].print());
                            this._log.info("ssres.firstKey():   " + ssres.firstKey());
                            this._log.info("ssres.keys[0]:   " + ssres.keys[0]);
                            this._log.info("FIXUP TIME");
                        }
                        SkipLevels replace = this.levels[0];
                        for (int i = 0; i < this.levels.length && this.levels[i] != null && i < replace.levels.length; ++i) {
                            if (this.levels[i].key().equals(replace.key())) {
                                if (this._log.shouldLog(20)) {
                                    this._log.info("equal level " + i);
                                }
                                this.levels[i] = replace.levels[i];
                                continue;
                            }
                            if (!this._log.shouldLog(20)) continue;
                            this._log.info("not equal level " + i + ' ' + this.levels[i].key());
                        }
                        this.flush();
                        if (this._log.shouldLog(20)) {
                            this._log.info("new Us: " + this.print());
                        }
                        replace.killInstance();
                    }
                }
                res[1] = null;
            }
        }
        if (this.bottom.nKeys == 0 && sl.first != this.bottom) {
            if (res == null) {
                this._log.warn("WTF killing with no return value " + this.print());
            } else if (res[1] == null) {
                this._log.warn("WTF killing with no return value 1 " + this.print());
            } else if (res[1] != this) {
                this._log.warn("WTF killing with return value not us " + res[1] + ' ' + this.print());
            }
            this.killInstance();
        }
        return res;
    }

    public SkipLevels put(int start, Comparable key, Object val, SkipList sl) {
        int height;
        boolean modified = false;
        for (int i = Math.min(start, this.levels.length - 1); i >= 0; --i) {
            if (this.levels[i] == null || this.levels[i].key().compareTo(key) > 0) continue;
            SkipLevels slvls = this.levels[i].put(i, key, val, sl);
            if (slvls != null) {
                for (int j = i + 1; j < Math.min(slvls.levels.length, this.levels.length); ++j) {
                    slvls.levels[j] = this.levels[j];
                    this.levels[j] = slvls;
                    modified = true;
                }
                if (this.levels.length < slvls.levels.length) {
                    if (modified) {
                        this.flush();
                        slvls.flush();
                    }
                    return slvls;
                }
            }
            if (modified) {
                this.flush();
                if (slvls != null) {
                    slvls.flush();
                }
            }
            return null;
        }
        SkipSpan ss = this.bottom.put(key, val, sl);
        if (ss != null && (height = sl.generateColHeight()) != 0) {
            SkipLevels slvls = this.newInstance(height, ss, sl);
            for (int i = 0; i < Math.min(height, this.levels.length); ++i) {
                slvls.levels[i] = this.levels[i];
                this.levels[i] = slvls;
                modified = true;
            }
            if (modified) {
                this.flush();
                slvls.flush();
            }
            if (this.levels.length < height) {
                return slvls;
            }
        }
        return null;
    }

    public boolean blvlck(boolean fix) {
        return false;
    }

    public boolean blvlck(boolean fix, int width, SkipLevels[] prevLevels) {
        return false;
    }
}

