/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.util.Addresses;
import net.i2p.util.Log;

class OutboundEstablishState {
    private final RouterContext _context;
    private final Log _log;
    private byte[] _sentX;
    private byte[] _bobIP;
    private int _bobPort;
    private final DHSessionKeyBuilder.Factory _keyFactory;
    private DHSessionKeyBuilder _keyBuilder;
    private byte[] _receivedY;
    private byte[] _aliceIP;
    private int _alicePort;
    private long _receivedRelayTag;
    private long _receivedSignedOnTime;
    private SessionKey _sessionKey;
    private SessionKey _macKey;
    private Signature _receivedSignature;
    private byte[] _receivedEncryptedSignature;
    private byte[] _receivedIV;
    private long _sentSignedOnTime;
    private Signature _sentSignature;
    private final long _establishBegin;
    private long _lastSend;
    private long _nextSend;
    private RemoteHostId _remoteHostId;
    private final RemoteHostId _claimedAddress;
    private final RouterIdentity _remotePeer;
    private final boolean _allowExtendedOptions;
    private final boolean _needIntroduction;
    private final SessionKey _introKey;
    private final Queue<OutNetMessage> _queuedMessages;
    private OutboundState _currentState;
    private long _introductionNonce;
    private boolean _isFirstMessageOurDSM;
    private final UDPAddress _remoteAddress;
    private boolean _complete;
    private int _confirmedSentCount;
    private int _requestSentCount;
    private int _introSentCount;
    private long _confirmedSentTime;
    private long _requestSentTime;
    private long _introSentTime;
    private static final long RETRANSMIT_DELAY = 3000L;
    private static final long MAX_DELAY = 15000L;
    private static final long WAIT_FOR_HOLE_PUNCH_DELAY = 500L;

    public OutboundEstablishState(RouterContext ctx, RemoteHostId claimedAddress, RemoteHostId remoteHostId, RouterIdentity remotePeer, boolean allowExtendedOptions, boolean needIntroduction, SessionKey introKey, UDPAddress addr, DHSessionKeyBuilder.Factory dh) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundEstablishState.class);
        if (claimedAddress != null) {
            this._bobIP = claimedAddress.getIP();
            this._bobPort = claimedAddress.getPort();
        } else {
            this._bobPort = -1;
        }
        this._claimedAddress = claimedAddress;
        this._remoteHostId = remoteHostId;
        this._allowExtendedOptions = allowExtendedOptions;
        this._needIntroduction = needIntroduction;
        this._remotePeer = remotePeer;
        this._introKey = introKey;
        this._queuedMessages = new LinkedBlockingQueue<OutNetMessage>();
        this._establishBegin = ctx.clock().now();
        this._remoteAddress = addr;
        this._introductionNonce = -1L;
        this._keyFactory = dh;
        if (addr.getIntroducerCount() > 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("new outbound establish to " + remotePeer.calculateHash() + ", with address: " + addr);
            }
            this._currentState = OutboundState.OB_STATE_PENDING_INTRO;
        } else {
            this._currentState = OutboundState.OB_STATE_UNKNOWN;
        }
    }

    public synchronized OutboundState getState() {
        return this._currentState;
    }

    public synchronized boolean complete() {
        boolean already = this._complete;
        this._complete = true;
        return already;
    }

    public UDPAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setIntroNonce(long nonce) {
        this._introductionNonce = nonce;
    }

    public long getIntroNonce() {
        return this._introductionNonce;
    }

    public boolean isExtendedOptionsAllowed() {
        return this._allowExtendedOptions;
    }

    public boolean needIntroduction() {
        return this._needIntroduction;
    }

    public void addMessage(OutNetMessage msg) {
        DatabaseStoreMessage dsm;
        I2NPMessage m;
        if (this._queuedMessages.isEmpty() && (m = msg.getMessage()).getType() == 1 && (dsm = (DatabaseStoreMessage)m).getKey().equals(this._context.routerHash())) {
            this._isFirstMessageOurDSM = true;
        }
        if (!this._queuedMessages.contains(msg)) {
            this._queuedMessages.offer(msg);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("attempt to add duplicate msg to queue: " + msg);
        }
    }

    public boolean isFirstMessageOurDSM() {
        return this._isFirstMessageOurDSM;
    }

    public OutNetMessage getNextQueuedMessage() {
        return this._queuedMessages.poll();
    }

    public RouterIdentity getRemoteIdentity() {
        return this._remotePeer;
    }

    public SessionKey getIntroKey() {
        return this._introKey;
    }

    private void prepareSessionRequest() {
        this._keyBuilder = this._keyFactory.getBuilder();
        byte[] X = this._keyBuilder.getMyPublicValue().toByteArray();
        if (X.length == 257) {
            this._sentX = new byte[256];
            System.arraycopy(X, 1, this._sentX, 0, this._sentX.length);
        } else if (X.length == 256) {
            this._sentX = X;
        } else {
            this._sentX = new byte[256];
            System.arraycopy(X, 0, this._sentX, this._sentX.length - X.length, X.length);
        }
    }

    public synchronized byte[] getSentX() {
        if (this._sentX == null) {
            this.prepareSessionRequest();
        }
        return this._sentX;
    }

    public synchronized byte[] getSentIP() {
        return this._bobIP;
    }

    public synchronized int getSentPort() {
        return this._bobPort;
    }

    public synchronized void receiveSessionCreated(UDPPacketReader.SessionCreatedReader reader) {
        if (this._currentState == OutboundState.OB_STATE_VALIDATION_FAILED) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Session created already failed");
            }
            return;
        }
        if (this._receivedY != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Session created already received, ignoring");
            }
            return;
        }
        this._receivedY = new byte[256];
        reader.readY(this._receivedY, 0);
        if (this._aliceIP == null) {
            this._aliceIP = new byte[reader.readIPSize()];
        }
        reader.readIP(this._aliceIP, 0);
        this._alicePort = reader.readPort();
        this._receivedRelayTag = reader.readRelayTag();
        this._receivedSignedOnTime = reader.readSignedOnTime();
        SigType type = this._remotePeer.getSigningPublicKey().getType();
        if (type == null) {
            this.fail();
            this.packetReceived();
            return;
        }
        int sigLen = type.getSigLen();
        int mod = sigLen % 16;
        int pad = mod == 0 ? 0 : 16 - mod;
        int esigLen = sigLen + pad;
        this._receivedEncryptedSignature = new byte[esigLen];
        reader.readEncryptedSignature(this._receivedEncryptedSignature, 0, esigLen);
        this._receivedIV = new byte[16];
        reader.readIV(this._receivedIV, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session created:Sig: " + Base64.encode(this._receivedEncryptedSignature) + "receivedIV: " + Base64.encode(this._receivedIV) + "AliceIP: " + Addresses.toString(this._aliceIP) + " RelayTag: " + this._receivedRelayTag + " SignedOn: " + this._receivedSignedOnTime + ' ' + this.toString());
        }
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN || this._currentState == OutboundState.OB_STATE_REQUEST_SENT || this._currentState == OutboundState.OB_STATE_INTRODUCED || this._currentState == OutboundState.OB_STATE_PENDING_INTRO) {
            this._currentState = OutboundState.OB_STATE_CREATED_RECEIVED;
        }
        this.packetReceived();
    }

    public synchronized boolean validateSessionCreated() {
        if (this._currentState == OutboundState.OB_STATE_VALIDATION_FAILED) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Session created already failed");
            }
            return false;
        }
        if (this._receivedSignature != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Session created already validated");
            }
            return true;
        }
        boolean valid = true;
        try {
            this.generateSessionKey();
        }
        catch (DHSessionKeyBuilder.InvalidPublicParameterException ippe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + this.getRemoteHostId() + " sent us an invalid DH parameter", ippe);
            }
            valid = false;
        }
        if (valid) {
            this.decryptSignature();
        }
        if (valid && this.verifySessionCreated()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Session created passed validation");
            }
            return true;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Session created failed validation, clearing state for " + this._remoteHostId.toString());
        }
        this.fail();
        return false;
    }

    public synchronized void fail() {
        this._receivedY = null;
        this._aliceIP = null;
        this._receivedRelayTag = 0L;
        this._receivedSignedOnTime = -1L;
        this._receivedEncryptedSignature = null;
        this._receivedIV = null;
        this._receivedSignature = null;
        if (this._keyBuilder != null) {
            if (this._keyBuilder.getPeerPublicValue() == null) {
                this._keyFactory.returnUnused(this._keyBuilder);
            }
            this._keyBuilder = null;
        }
        this._currentState = OutboundState.OB_STATE_VALIDATION_FAILED;
        this._nextSend = this._context.clock().now();
    }

    private void generateSessionKey() throws DHSessionKeyBuilder.InvalidPublicParameterException {
        if (this._sessionKey != null) {
            return;
        }
        if (this._keyBuilder == null) {
            throw new DHSessionKeyBuilder.InvalidPublicParameterException("Illegal state - never generated a key builder");
        }
        this._keyBuilder.setPeerPublicValue(this._receivedY);
        this._sessionKey = this._keyBuilder.getSessionKey();
        ByteArray extra = this._keyBuilder.getExtraBytes();
        this._macKey = new SessionKey(new byte[32]);
        System.arraycopy(extra.getData(), 0, this._macKey.getData(), 0, 32);
        if (this._log.shouldLog(10)) {
            this._log.debug("Established outbound keys.  cipher: " + this._sessionKey + " mac: " + this._macKey);
        }
    }

    private void decryptSignature() {
        if (this._receivedEncryptedSignature == null) {
            throw new NullPointerException("encrypted signature is null! this=" + this.toString());
        }
        if (this._sessionKey == null) {
            throw new NullPointerException("SessionKey is null!");
        }
        if (this._receivedIV == null) {
            throw new NullPointerException("IV is null!");
        }
        this._context.aes().decrypt(this._receivedEncryptedSignature, 0, this._receivedEncryptedSignature, 0, this._sessionKey, this._receivedIV, this._receivedEncryptedSignature.length);
        SigType type = this._remotePeer.getSigningPublicKey().getType();
        int sigLen = type.getSigLen();
        int mod = sigLen % 16;
        if (mod != 0) {
            byte[] signatureBytes = new byte[sigLen];
            System.arraycopy(this._receivedEncryptedSignature, 0, signatureBytes, 0, sigLen);
            this._receivedSignature = new Signature(type, signatureBytes);
        } else {
            this._receivedSignature = new Signature(type, this._receivedEncryptedSignature);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Decrypted received signature: " + Base64.encode(this._receivedSignature.getData()));
        }
    }

    private boolean verifySessionCreated() {
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        int off = 0;
        System.arraycopy(this._sentX, 0, signed, off, this._sentX.length);
        System.arraycopy(this._receivedY, 0, signed, off += this._sentX.length, this._receivedY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._receivedY.length, this._aliceIP.length);
        DataHelper.toLong(signed, off += this._aliceIP.length, 2, this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong(signed, off += this._bobIP.length, 2, this._bobPort);
        DataHelper.toLong(signed, off += 2, 4, this._receivedRelayTag);
        DataHelper.toLong(signed, off += 4, 4, this._receivedSignedOnTime);
        boolean valid = this._context.dsa().verifySignature(this._receivedSignature, signed, this._remotePeer.getSigningPublicKey());
        if (this._log.shouldLog(10) || this._log.shouldLog(30) && !valid) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Signed sessionCreated:");
            buf.append(" Alice: ").append(Addresses.toString(this._aliceIP, this._alicePort));
            buf.append(" Bob: ").append(Addresses.toString(this._bobIP, this._bobPort));
            buf.append(" RelayTag: ").append(this._receivedRelayTag);
            buf.append(" SignedOn: ").append(this._receivedSignedOnTime);
            buf.append(" signature: ").append(Base64.encode(this._receivedSignature.getData()));
            if (valid) {
                this._log.debug(buf.toString());
            } else if (this._log.shouldLog(30)) {
                this._log.warn("INVALID: " + buf.toString());
            }
        }
        return valid;
    }

    public synchronized SessionKey getCipherKey() {
        return this._sessionKey;
    }

    public synchronized SessionKey getMACKey() {
        return this._macKey;
    }

    public synchronized long getReceivedRelayTag() {
        return this._receivedRelayTag;
    }

    public synchronized long getSentSignedOnTime() {
        return this._sentSignedOnTime;
    }

    public synchronized long getReceivedSignedOnTime() {
        return this._receivedSignedOnTime;
    }

    public synchronized byte[] getReceivedIP() {
        return this._aliceIP;
    }

    public synchronized int getReceivedPort() {
        return this._alicePort;
    }

    public synchronized void prepareSessionConfirmed() {
        if (this._sentSignedOnTime > 0L) {
            return;
        }
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        this._sentSignedOnTime = this._context.clock().now() / 1000L;
        int off = 0;
        System.arraycopy(this._sentX, 0, signed, off, this._sentX.length);
        System.arraycopy(this._receivedY, 0, signed, off += this._sentX.length, this._receivedY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._receivedY.length, this._aliceIP.length);
        DataHelper.toLong(signed, off += this._aliceIP.length, 2, this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong(signed, off += this._bobIP.length, 2, this._bobPort);
        DataHelper.toLong(signed, off += 2, 4, this._receivedRelayTag);
        DataHelper.toLong(signed, off += 4, 4, this._sentSignedOnTime);
        this._sentSignature = this._context.dsa().sign(signed, this._context.keyManager().getSigningPrivateKey());
    }

    public synchronized Signature getSentSignature() {
        return this._sentSignature;
    }

    public synchronized void confirmedPacketsSent() {
        long delay;
        this._lastSend = this._context.clock().now();
        if (this._confirmedSentCount == 0) {
            delay = 3000L;
            this._confirmedSentTime = this._lastSend;
        } else {
            delay = Math.min(3000L << this._confirmedSentCount, this._confirmedSentTime + 15000L - this._lastSend);
        }
        ++this._confirmedSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send confirm packets, nextSend in " + delay);
        }
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN || this._currentState == OutboundState.OB_STATE_PENDING_INTRO || this._currentState == OutboundState.OB_STATE_INTRODUCED || this._currentState == OutboundState.OB_STATE_REQUEST_SENT || this._currentState == OutboundState.OB_STATE_CREATED_RECEIVED) {
            this._currentState = OutboundState.OB_STATE_CONFIRMED_PARTIALLY;
        }
    }

    public long getConfirmedSentTime() {
        return this._confirmedSentTime;
    }

    public synchronized void requestSent() {
        long delay;
        this._lastSend = this._context.clock().now();
        if (this._requestSentCount == 0) {
            delay = 3000L;
            this._requestSentTime = this._lastSend;
        } else {
            delay = Math.min(3000L << this._requestSentCount, this._requestSentTime + 15000L - this._lastSend);
        }
        ++this._requestSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send a request packet, nextSend in " + delay);
        }
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN || this._currentState == OutboundState.OB_STATE_INTRODUCED) {
            this._currentState = OutboundState.OB_STATE_REQUEST_SENT;
        }
    }

    public long getRequestSentTime() {
        return this._requestSentTime;
    }

    public synchronized void introSent() {
        long delay;
        this._lastSend = this._context.clock().now();
        if (this._introSentCount == 0) {
            delay = 3000L;
            this._introSentTime = this._lastSend;
        } else {
            delay = Math.min(3000L << this._introSentCount, this._introSentTime + 15000L - this._lastSend);
        }
        ++this._introSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._currentState == OutboundState.OB_STATE_UNKNOWN) {
            this._currentState = OutboundState.OB_STATE_PENDING_INTRO;
        }
    }

    public long getIntroSentTime() {
        return this._introSentTime;
    }

    public synchronized void introductionFailed() {
        this._nextSend = this._context.clock().now();
    }

    public synchronized void introduced(byte[] bobIP, int bobPort) {
        if (this._currentState != OutboundState.OB_STATE_PENDING_INTRO) {
            return;
        }
        this._nextSend = this._context.clock().now() + 500L;
        this._currentState = OutboundState.OB_STATE_INTRODUCED;
        if (this._claimedAddress != null && bobPort == this._bobPort && DataHelper.eq(bobIP, this._bobIP)) {
            this._remoteHostId = this._claimedAddress;
        } else {
            this._bobIP = bobIP;
            this._bobPort = bobPort;
            this._remoteHostId = new RemoteHostId(bobIP, bobPort);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Introduced to " + this._remoteHostId + ", now lets get on with establishing");
        }
    }

    synchronized boolean receiveHolePunch() {
        if (this._currentState != OutboundState.OB_STATE_INTRODUCED) {
            return false;
        }
        if (this._requestSentCount > 0) {
            return false;
        }
        long now = this._context.clock().now();
        if (this._log.shouldLog(20)) {
            this._log.info(this.toString() + " accelerating SessionRequest by " + (this._nextSend - now) + " ms");
        }
        this._nextSend = now;
        return true;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._establishBegin;
    }

    public long getEstablishBeginTime() {
        return this._establishBegin;
    }

    public synchronized long getNextSendTime() {
        return this._nextSend;
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    RemoteHostId getClaimedAddress() {
        return this._claimedAddress;
    }

    public synchronized void dataReceived() {
        this.packetReceived();
        this._currentState = OutboundState.OB_STATE_CONFIRMED_COMPLETELY;
    }

    private void packetReceived() {
        this._nextSend = this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug("Got a packet, nextSend == now");
        }
    }

    public String toString() {
        return "OES " + this._remoteHostId + ' ' + (Object)((Object)this._currentState);
    }

    public static enum OutboundState {
        OB_STATE_UNKNOWN,
        OB_STATE_REQUEST_SENT,
        OB_STATE_CREATED_RECEIVED,
        OB_STATE_CONFIRMED_PARTIALLY,
        OB_STATE_CONFIRMED_COMPLETELY,
        OB_STATE_PENDING_INTRO,
        OB_STATE_INTRODUCED,
        OB_STATE_VALIDATION_FAILED;

    }
}

