/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.RouterContext;
import net.i2p.router.message.CloveSet;
import net.i2p.util.Log;

public class GarlicMessageReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final CloveReceiver _receiver;
    private final Hash _clientDestination;

    public GarlicMessageReceiver(RouterContext context, CloveReceiver receiver) {
        this(context, receiver, null);
    }

    public GarlicMessageReceiver(RouterContext context, CloveReceiver receiver, Hash clientDestination) {
        this._context = context;
        this._log = context.logManager().getLog(GarlicMessageReceiver.class);
        this._clientDestination = clientDestination;
        this._receiver = receiver;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void receive(GarlicMessage message) {
        CloveSet set;
        PrivateKey decryptionKey;
        SessionKeyManager skm;
        block8: {
            if (this._clientDestination != null) {
                LeaseSetKeys keys = this._context.keyManager().getKeys(this._clientDestination);
                skm = this._context.clientManager().getClientSessionKeyManager(this._clientDestination);
                if (keys != null && skm != null) {
                    decryptionKey = keys.getDecryptionKey();
                    break block8;
                } else {
                    if (!this._log.shouldLog(30)) return;
                    this._log.warn("Not trying to decrypt a garlic routed message to a disconnected client");
                    return;
                }
            }
            decryptionKey = this._context.keyManager().getPrivateKey();
            skm = this._context.sessionKeyManager();
        }
        if ((set = this._context.garlicMessageParser().getGarlicCloves(message, decryptionKey, skm)) != null) {
            for (int i = 0; i < set.getCloveCount(); ++i) {
                GarlicClove clove = set.getClove(i);
                this.handleClove(clove);
            }
            return;
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("CloveMessageParser failed to decrypt the message [" + message.getUniqueId() + "]", new Exception("Decrypt garlic failed"));
            }
            this._context.statManager().addRateData("crypto.garlic.decryptFail", 1L);
            this._context.messageHistory().messageProcessingError(message.getUniqueId(), message.getClass().getName(), "Garlic could not be decrypted");
        }
    }

    private void handleClove(GarlicClove clove) {
        if (!this.isValid(clove)) {
            return;
        }
        this._receiver.handleClove(clove.getInstructions(), clove.getData());
    }

    private boolean isValid(GarlicClove clove) {
        boolean rv;
        String invalidReason = this._context.messageValidator().validateMessage(clove.getCloveId(), clove.getExpiration().getTime());
        boolean bl = rv = invalidReason == null;
        if (!rv) {
            String howLongAgo = DataHelper.formatDuration(this._context.clock().now() - clove.getExpiration().getTime());
            if (this._log.shouldLog(10)) {
                this._log.debug("Clove is NOT valid: id=" + clove.getCloveId() + " expiration " + howLongAgo + " ago", new Exception("Invalid within..."));
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Clove is NOT valid: id=" + clove.getCloveId() + " expiration " + howLongAgo + " ago: " + invalidReason + ": " + clove);
            }
            this._context.messageHistory().messageProcessingError(clove.getCloveId(), clove.getData().getClass().getSimpleName(), "Clove is not valid (expiration " + howLongAgo + " ago)");
        }
        return rv;
    }

    public static interface CloveReceiver {
        public void handleClove(DeliveryInstructions var1, I2NPMessage var2);
    }
}

