/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.Writer;
import java.util.Date;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class InNetMessagePool
implements Service {
    private final Log _log;
    private final RouterContext _context;
    private final HandlerJobBuilder[] _handlerJobBuilders;
    private final List<I2NPMessage> _pendingDataMessages;
    private final List<Hash> _pendingDataMessagesFrom;
    private final List<I2NPMessage> _pendingGatewayMessages;
    private SharedShortCircuitDataJob _shortCircuitDataJob;
    private SharedShortCircuitGatewayJob _shortCircuitGatewayJob;
    private boolean _alive;
    private boolean _dispatchThreaded;
    private static final int MAX_I2NP_MESSAGE_TYPE = 31;
    public static final String PROP_DISPATCH_THREADED = "router.dispatchThreaded";
    public static final boolean DEFAULT_DISPATCH_THREADED = false;
    private static final boolean DISPATCH_DIRECT = true;

    public InNetMessagePool(RouterContext context) {
        this._context = context;
        this._handlerJobBuilders = new HandlerJobBuilder[32];
        this._pendingDataMessages = null;
        this._pendingDataMessagesFrom = null;
        this._pendingGatewayMessages = null;
        this._log = this._context.logManager().getLog(InNetMessagePool.class);
        this._context.statManager().createRateStat("inNetPool.dropped", "How often do we drop a message", "InNetPool", new long[]{3600000L});
        this._context.statManager().createRateStat("inNetPool.droppedDeliveryStatusDelay", "How long after a delivery status message is created do we receive it back again (for messages that are too slow to be handled)", "InNetPool", new long[]{3600000L});
        this._context.statManager().createRateStat("inNetPool.duplicate", "How often do we receive a duplicate message", "InNetPool", new long[]{3600000L});
        this._context.statManager().createRateStat("inNetPool.droppedDbLookupResponseMessage", "How often we drop a slow-to-arrive db search response", "InNetPool", new long[]{3600000L});
    }

    public synchronized HandlerJobBuilder registerHandlerJobBuilder(int i2npMessageType, HandlerJobBuilder builder) {
        HandlerJobBuilder old = this._handlerJobBuilders[i2npMessageType];
        this._handlerJobBuilders[i2npMessageType] = builder;
        return old;
    }

    @Deprecated
    public synchronized HandlerJobBuilder unregisterHandlerJobBuilder(int i2npMessageType) {
        HandlerJobBuilder old = this._handlerJobBuilders[i2npMessageType];
        this._handlerJobBuilders[i2npMessageType] = null;
        return old;
    }

    public int add(I2NPMessage messageBody, RouterIdentity fromRouter, Hash fromRouterHash) {
        int replies;
        long exp = messageBody.getMessageExpiration();
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd ID " + messageBody.getUniqueId() + " exp. " + new Date(exp) + " type " + messageBody.getClass().getSimpleName());
        }
        int type = messageBody.getType();
        String invalidReason = null;
        invalidReason = type == 18 ? this._context.messageValidator().validateMessage(exp) : this._context.messageValidator().validateMessage(messageBody.getUniqueId(), exp);
        if (invalidReason != null) {
            int level = 30;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "Dropping message [" + messageBody.getUniqueId() + " expiring on " + exp + "]: " + messageBody.getClass().getSimpleName() + ": " + invalidReason + ": " + messageBody);
            }
            this._context.statManager().addRateData("inNetPool.dropped", 1L);
            this._context.statManager().addRateData("inNetPool.duplicate", 1L);
            this._context.messageHistory().droppedOtherMessage(messageBody, fromRouter != null ? fromRouter.calculateHash() : fromRouterHash);
            this._context.messageHistory().messageProcessingError(messageBody.getUniqueId(), messageBody.getClass().getSimpleName(), "Duplicate/expired");
            return -1;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Message received [" + messageBody.getUniqueId() + " expiring on " + exp + "] is NOT a duplicate or exipired");
        }
        boolean jobFound = false;
        boolean allowMatches = true;
        if (type == 19) {
            this.shortCircuitTunnelGateway(messageBody);
            allowMatches = false;
        } else if (type == 18) {
            this.shortCircuitTunnelData(messageBody, fromRouterHash);
            allowMatches = false;
        } else if (type > 0 && type < this._handlerJobBuilders.length) {
            HandlerJobBuilder builder = this._handlerJobBuilders[type];
            if (this._log.shouldLog(10)) {
                this._log.debug("Add msg to the pool - builder: " + builder + " type: " + messageBody.getClass().getSimpleName());
            }
            if (builder != null) {
                Job job = builder.createJob(messageBody, fromRouter, fromRouterHash);
                if (job != null) {
                    this._context.jobQueue().addJob(job);
                    jobFound = true;
                } else {
                    jobFound = true;
                }
            }
        }
        if (allowMatches && (replies = this.handleReplies(messageBody)) <= 0) {
            if (!jobFound) {
                this._context.messageHistory().droppedOtherMessage(messageBody, fromRouter != null ? fromRouter.calculateHash() : fromRouterHash);
                if (type == 10) {
                    long arr = ((DeliveryStatusMessage)messageBody).getArrival();
                    if (arr > 10L) {
                        long timeSinceSent = this._context.clock().now() - arr;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Dropping unhandled delivery status message created " + timeSinceSent + "ms ago: " + messageBody);
                        }
                        this._context.statManager().addRateData("inNetPool.droppedDeliveryStatusDelay", timeSinceSent);
                    }
                } else if (type == 3) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Dropping slow db lookup response: " + messageBody);
                    }
                    this._context.statManager().addRateData("inNetPool.droppedDbLookupResponseMessage", 1L);
                } else if (type == 2) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Dropping netDb lookup due to throttling");
                    }
                } else {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Message expiring on " + messageBody.getMessageExpiration() + " was not handled by a HandlerJobBuilder - DROPPING: " + messageBody, new Exception("f00!"));
                    }
                    this._context.statManager().addRateData("inNetPool.dropped", 1L);
                }
            } else {
                String mtype = messageBody.getClass().getName();
                this._context.messageHistory().receiveMessage(mtype, messageBody.getUniqueId(), messageBody.getMessageExpiration(), fromRouterHash, true);
                return 0;
            }
        }
        String mtype = messageBody.getClass().getName();
        this._context.messageHistory().receiveMessage(mtype, messageBody.getUniqueId(), messageBody.getMessageExpiration(), fromRouterHash, true);
        return 0;
    }

    public int handleReplies(I2NPMessage messageBody) {
        List<OutNetMessage> origMessages = this._context.messageRegistry().getOriginalMessages(messageBody);
        int sz = origMessages.size();
        if (sz <= 0) {
            return 0;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Original messages for inbound message: " + sz);
            if (sz > 1) {
                this._log.debug("Orig: " + origMessages + " \nthe above are replies for: " + messageBody);
            }
        }
        for (int i = 0; i < sz; ++i) {
            OutNetMessage omsg = origMessages.get(i);
            ReplyJob job = omsg.getOnReplyJob();
            if (this._log.shouldLog(10)) {
                this._log.debug("Original message [" + i + "] " + omsg.getReplySelector() + " : " + omsg + ": reply job: " + job);
            }
            if (job == null) continue;
            job.setMessage(messageBody);
            this._context.jobQueue().addJob(job);
        }
        return sz;
    }

    private void shortCircuitTunnelGateway(I2NPMessage messageBody) {
        this.doShortCircuitTunnelGateway(messageBody);
    }

    private void doShortCircuitTunnelGateway(I2NPMessage messageBody) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Shortcut dispatch tunnelGateway message " + messageBody);
        }
        this._context.tunnelDispatcher().dispatch((TunnelGatewayMessage)messageBody);
    }

    private void shortCircuitTunnelData(I2NPMessage messageBody, Hash from) {
        this.doShortCircuitTunnelData(messageBody, from);
    }

    private void doShortCircuitTunnelData(I2NPMessage messageBody, Hash from) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Shortcut dispatch tunnelData message " + messageBody);
        }
        this._context.tunnelDispatcher().dispatch((TunnelDataMessage)messageBody, from);
    }

    @Override
    public void renderStatusHTML(Writer out) {
    }

    @Override
    public synchronized void restart() {
        this.shutdown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startup();
    }

    @Override
    public synchronized void shutdown() {
        this._alive = false;
    }

    @Override
    public synchronized void startup() {
        this._alive = true;
        this._dispatchThreaded = false;
        String threadedStr = this._context.getProperty(PROP_DISPATCH_THREADED);
        if (threadedStr != null) {
            this._dispatchThreaded = Boolean.parseBoolean(threadedStr);
        }
        if (this._dispatchThreaded) {
            this._context.statManager().createRateStat("pool.dispatchDataTime", "How long a tunnel dispatch takes", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
            this._context.statManager().createRateStat("pool.dispatchGatewayTime", "How long a tunnel gateway dispatch takes", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
            I2PThread data = new I2PThread(new TunnelDataDispatcher(), "Tunnel data dispatcher");
            data.setDaemon(true);
            data.start();
            I2PThread gw = new I2PThread(new TunnelGatewayDispatcher(), "Tunnel gateway dispatcher");
            gw.setDaemon(true);
            gw.start();
        }
    }

    private class SharedShortCircuitDataJob
    extends JobImpl {
        public SharedShortCircuitDataJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Dispatch tunnel participant message";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            int remaining = 0;
            I2NPMessage msg = null;
            Hash from = null;
            List list = InNetMessagePool.this._pendingDataMessages;
            synchronized (list) {
                if (!InNetMessagePool.this._pendingDataMessages.isEmpty()) {
                    msg = (I2NPMessage)InNetMessagePool.this._pendingDataMessages.remove(0);
                    from = (Hash)InNetMessagePool.this._pendingDataMessagesFrom.remove(0);
                }
                remaining = InNetMessagePool.this._pendingDataMessages.size();
            }
            if (msg != null) {
                InNetMessagePool.this.doShortCircuitTunnelData(msg, from);
            }
            if (remaining > 0) {
                this.getContext().jobQueue().addJob(this);
            }
        }
    }

    private class SharedShortCircuitGatewayJob
    extends JobImpl {
        public SharedShortCircuitGatewayJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Dispatch tunnel gateway message";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            I2NPMessage msg = null;
            int remaining = 0;
            List list = InNetMessagePool.this._pendingGatewayMessages;
            synchronized (list) {
                if (!InNetMessagePool.this._pendingGatewayMessages.isEmpty()) {
                    msg = (I2NPMessage)InNetMessagePool.this._pendingGatewayMessages.remove(0);
                }
                remaining = InNetMessagePool.this._pendingGatewayMessages.size();
            }
            if (msg != null) {
                InNetMessagePool.this.doShortCircuitTunnelGateway(msg);
            }
            if (remaining > 0) {
                this.getContext().jobQueue().addJob(this);
            }
        }
    }

    private class TunnelDataDispatcher
    implements Runnable {
        private TunnelDataDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (InNetMessagePool.this._alive) {
                I2NPMessage msg = null;
                Hash from = null;
                try {
                    List list = InNetMessagePool.this._pendingDataMessages;
                    synchronized (list) {
                        if (InNetMessagePool.this._pendingDataMessages.isEmpty()) {
                            InNetMessagePool.this._pendingDataMessages.wait();
                        } else {
                            msg = (I2NPMessage)InNetMessagePool.this._pendingDataMessages.remove(0);
                            from = (Hash)InNetMessagePool.this._pendingDataMessagesFrom.remove(0);
                        }
                    }
                    if (msg == null) continue;
                    long before = InNetMessagePool.this._context.clock().now();
                    InNetMessagePool.this.doShortCircuitTunnelData(msg, from);
                    long elapsed = InNetMessagePool.this._context.clock().now() - before;
                    InNetMessagePool.this._context.statManager().addRateData("pool.dispatchDataTime", elapsed);
                }
                catch (InterruptedException before) {
                }
                catch (OutOfMemoryError oome) {
                    throw oome;
                }
                catch (RuntimeException e) {
                    if (!InNetMessagePool.this._log.shouldLog(50)) continue;
                    InNetMessagePool.this._log.log(50, "Error in the tunnel data dispatcher", e);
                }
            }
        }
    }

    private class TunnelGatewayDispatcher
    implements Runnable {
        private TunnelGatewayDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (InNetMessagePool.this._alive) {
                I2NPMessage msg = null;
                try {
                    List list = InNetMessagePool.this._pendingGatewayMessages;
                    synchronized (list) {
                        if (InNetMessagePool.this._pendingGatewayMessages.isEmpty()) {
                            InNetMessagePool.this._pendingGatewayMessages.wait();
                        } else {
                            msg = (I2NPMessage)InNetMessagePool.this._pendingGatewayMessages.remove(0);
                        }
                    }
                    if (msg == null) continue;
                    long before = InNetMessagePool.this._context.clock().now();
                    InNetMessagePool.this.doShortCircuitTunnelGateway(msg);
                    long elapsed = InNetMessagePool.this._context.clock().now() - before;
                    InNetMessagePool.this._context.statManager().addRateData("pool.dispatchGatewayTime", elapsed);
                }
                catch (InterruptedException before) {
                }
                catch (OutOfMemoryError oome) {
                    throw oome;
                }
                catch (RuntimeException e) {
                    if (!InNetMessagePool.this._log.shouldLog(50)) continue;
                    InNetMessagePool.this._log.log(50, "Error in the tunnel gateway dispatcher", e);
                }
            }
        }
    }
}

