/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigestStandalone;

@Deprecated
public abstract class BaseHashStandalone
implements IMessageDigestStandalone {
    protected String name;
    protected int hashSize;
    protected int blockSize;
    protected long count;
    protected byte[] buffer;

    protected BaseHashStandalone(String name, int hashSize, int blockSize) {
        this.name = name;
        this.hashSize = hashSize;
        this.blockSize = blockSize;
        this.buffer = new byte[blockSize];
        this.resetContext();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int hashSize() {
        return this.hashSize;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public void update(byte b) {
        int i = (int)(this.count % (long)this.blockSize);
        ++this.count;
        this.buffer[i] = b;
        if (i == this.blockSize - 1) {
            this.transform(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(byte[] b, int offset, int len) {
        int n = (int)(this.count % (long)this.blockSize);
        this.count += (long)len;
        int partLen = this.blockSize - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.transform(this.buffer, 0);
            i = partLen;
            while (i + this.blockSize - 1 < len) {
                this.transform(b, offset + i);
                i += this.blockSize;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    @Override
    public byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        byte[] result = this.getResult();
        this.reset();
        return result;
    }

    @Override
    public void reset() {
        this.count = 0L;
        int i = 0;
        while (i < this.blockSize) {
            this.buffer[i++] = 0;
        }
        this.resetContext();
    }

    @Override
    public abstract Object clone();

    @Override
    public abstract boolean selfTest();

    protected abstract byte[] padBuffer();

    protected abstract byte[] getResult();

    protected abstract void resetContext();

    protected abstract void transform(byte[] var1, int var2);
}

