/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Queue;
import net.i2p.util.Clock;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;
import net.i2p.util.LogRecordFormatter;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

abstract class LogWriterBase
implements Runnable {
    private static final long CONFIG_READ_INTERVAL = 50000L;
    static final long FLUSH_INTERVAL = 29000L;
    private static final long MIN_FLUSH_INTERVAL = 2000L;
    private static final long MAX_FLUSH_INTERVAL = 300000L;
    private long _lastReadConfig;
    protected final LogManager _manager;
    protected volatile boolean _write;
    private LogRecord _last;
    private volatile long _flushInterval = 29000L;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public LogWriterBase(LogManager manager) {
        this._manager = manager;
        this._lastReadConfig = Clock.getInstance().now();
    }

    public abstract String currentFile();

    protected abstract void writeRecord(LogRecord var1, String var2);

    protected abstract void writeRecord(int var1, String var2);

    protected abstract void flushWriter();

    protected abstract void closeWriter();

    public void stopWriting() {
        this._write = false;
    }

    public void setFlushInterval(long interval) {
        this._flushInterval = Math.min(300000L, Math.max(2000L, interval));
    }

    @Override
    public void run() {
        this._write = true;
        boolean shouldReadConfig = !SystemVersion.isAndroid();
        try {
            while (this._write) {
                this.flushRecords();
                if (!this._write || !shouldReadConfig) continue;
                this.rereadConfig();
            }
        }
        catch (RuntimeException e) {
            System.err.println("Error writing the log: " + e);
            e.printStackTrace();
        }
        this.closeWriter();
    }

    public void flushRecords() {
        this.flushRecords(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRecords(boolean shouldWait) {
        try {
            Queue<LogRecord> records = this._manager.getQueue();
            if (records == null) {
                return;
            }
            if (!records.isEmpty()) {
                LogRecord rec;
                if (this._last != null && this._last.getDate() < this._manager.getContext().clock().now() - 1800000L) {
                    this._last = null;
                }
                int dupCount = 0;
                while ((rec = records.poll()) != null) {
                    if (this._manager.shouldDropDuplicates() && rec.equals(this._last)) {
                        ++dupCount;
                    } else {
                        if (dupCount > 0) {
                            this.writeDupMessage(dupCount, this._last);
                            dupCount = 0;
                        }
                        this.writeRecord(rec);
                    }
                    this._last = rec;
                }
                if (dupCount > 0) {
                    this.writeDupMessage(dupCount, this._last);
                }
                this.flushWriter();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (shouldWait) {
                try {
                    LogWriterBase logWriterBase = this;
                    synchronized (logWriterBase) {
                        this.wait(this._flushInterval);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void writeDupMessage(int dupCount, LogRecord lastRecord) {
        String dmsg = this.dupMessage(dupCount, lastRecord, false);
        this.writeRecord(lastRecord.getPriority(), dmsg);
        if (this._manager.getDisplayOnScreenLevel() <= lastRecord.getPriority() && this._manager.displayOnScreen()) {
            System.out.print(dmsg);
        }
        dmsg = this.dupMessage(dupCount, lastRecord, true);
        this._manager.getBuffer().add(dmsg);
        if (lastRecord.getPriority() >= 50) {
            this._manager.getBuffer().addCritical(dmsg);
        }
    }

    private String dupMessage(int dupCount, LogRecord lastRecord, boolean reverse) {
        String arrows = reverse ? (SystemVersion.isAndroid() ? "vvv" : "&darr;&darr;&darr;") : "^^^";
        return LogRecordFormatter.getWhen(this._manager, lastRecord) + ' ' + arrows + ' ' + this._t(dupCount, "1 similar message omitted", "{0} similar messages omitted") + ' ' + arrows + LogRecordFormatter.NL;
    }

    private String _t(int a, String b, String c) {
        return Translate.getString(a, b, c, this._manager.getContext(), BUNDLE_NAME);
    }

    private void rereadConfig() {
        long now = Clock.getInstance().now();
        if (now - this._lastReadConfig > 50000L) {
            this._manager.rereadConfig();
            this._lastReadConfig = now;
        }
    }

    private void writeRecord(LogRecord rec) {
        String val = LogRecordFormatter.formatRecord(this._manager, rec, true);
        this.writeRecord(rec, val);
        this._manager.getBuffer().add(val);
        if (rec.getPriority() >= 50) {
            this._manager.getBuffer().addCritical(val);
        }
        if (this._manager.getDisplayOnScreenLevel() <= rec.getPriority() && this._manager.displayOnScreen()) {
            if (this._manager.getContext().hasWrapper() || SystemVersion.isAndroid()) {
                System.out.print(LogRecordFormatter.formatRecord(this._manager, rec, false));
            } else {
                System.out.print(val);
            }
        }
    }
}

