/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TableColumn(Table table, int n) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        table.createItem(this, table.getColumnCount());
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        table.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return 0;
        }
        long l = this.parent.handle;
        return (int)OS.SendMessage(l, 4125, (long)n, 0L);
    }

    public void pack() {
        long l;
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        long l2 = this.parent.handle;
        int n2 = (int)OS.SendMessage(l2, 4125, (long)n, 0L);
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, true);
        int n3 = (int)OS.SendMessage(l2, OS.LVM_GETSTRINGWIDTH, 0L, tCHAR) + 12;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n3 += 3;
        }
        boolean bl = false;
        if (this.image != null || this.parent.sortColumn == this) {
            bl = true;
            Image image = null;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                if (OS.COMCTL32_MAJOR < 6) {
                    image = this.display.getSortImage(this.parent.sortDirection);
                } else {
                    n3 += 10;
                }
            } else {
                image = this.image;
            }
            if (image != null) {
                Rectangle rectangle = image.getBounds();
                n3 += rectangle.width;
            }
            int n4 = 0;
            if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
                l = OS.SendMessage(l2, 4127, 0L, 0L);
                n4 = (int)OS.SendMessage(l, 4629, 0L, 0L);
            } else {
                n4 = OS.GetSystemMetrics(45) * 3;
            }
            n3 += n4 * 4;
        }
        this.parent.ignoreColumnResize = true;
        int n5 = 0;
        if (this.parent.hooks(41)) {
            RECT rECT = new RECT();
            l = OS.SendMessage(l2, 4127, 0L, 0L);
            OS.SendMessage(l, 4615, (long)n, rECT);
            OS.MapWindowPoints(l, l2, rECT, 2);
            long l3 = OS.GetDC(l2);
            long l4 = 0L;
            long l5 = OS.SendMessage(l2, 49, 0L, 0L);
            if (l5 != 0L) {
                l4 = OS.SelectObject(l3, l5);
            }
            int n6 = (int)OS.SendMessage(l2, 4100, 0L, 0L);
            for (int i = 0; i < n6; ++i) {
                TableItem tableItem = this.parent._getItem(i, false);
                if (tableItem == null) continue;
                long l6 = tableItem.fontHandle(n);
                if (l6 != -1L) {
                    l6 = OS.SelectObject(l3, l6);
                }
                Event event = this.parent.sendMeasureItemEvent(tableItem, i, n, l3);
                if (l6 != -1L) {
                    l6 = OS.SelectObject(l3, l6);
                }
                if (this.isDisposed() || this.parent.isDisposed()) break;
                n5 = Math.max(n5, event.x + event.width - rECT.left);
            }
            if (l5 != 0L) {
                OS.SelectObject(l3, l4);
            }
            OS.ReleaseDC(l2, l3);
            OS.SendMessage(l2, 4126, (long)n, (long)n5);
        } else {
            OS.SendMessage(l2, 4126, (long)n, -1L);
            n5 = (int)OS.SendMessage(l2, 4125, (long)n, 0L);
            if (n == 0) {
                long l7;
                int[] nArray;
                int[] nArray2;
                long l8;
                if (this.parent.imageList == null) {
                    n5 += 2;
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && !this.parent.firstColumnImage && (l8 = OS.SendMessage(l2, 4098, 1L, 0L)) != 0L) {
                    nArray2 = new int[1];
                    nArray = new int[1];
                    OS.ImageList_GetIconSize(l8, nArray2, nArray);
                    n5 += nArray2[0];
                }
                if ((this.parent.style & 0x20) != 0 && (l7 = OS.SendMessage(l2, 4098, 2L, 0L)) != 0L) {
                    nArray2 = new int[1];
                    nArray = new int[1];
                    OS.ImageList_GetIconSize(l7, nArray2, nArray);
                    n5 += nArray2[0];
                }
            }
        }
        if (n3 > n5) {
            if (!bl) {
                boolean bl2;
                RECT rECT = null;
                boolean bl3 = bl2 = n == this.parent.getColumnCount() - 1;
                if (bl2) {
                    rECT = new RECT();
                    OS.GetWindowRect(l2, rECT);
                    OS.UpdateWindow(l2);
                    int n7 = 30;
                    this.SetWindowPos(l2, 0L, 0, 0, 0, rECT.bottom - rECT.top, n7);
                }
                OS.SendMessage(l2, 4126, (long)n, -2L);
                if (bl2) {
                    int n8 = 22;
                    this.SetWindowPos(l2, 0L, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n8);
                }
            } else {
                OS.SendMessage(l2, 4126, (long)n, (long)n3);
            }
        } else if (n == 0) {
            OS.SendMessage(l2, 4126, (long)n, (long)n5);
        }
        this.parent.ignoreColumnResize = false;
        int n9 = (int)OS.SendMessage(l2, 4125, (long)n, 0L);
        if (n2 != n9) {
            this.updateToolTip(n);
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            boolean bl4 = false;
            int[] nArray = this.parent.getColumnOrder();
            TableColumn[] tableColumnArray = this.parent.getColumns();
            for (int i = 0; i < nArray.length; ++i) {
                TableColumn tableColumn = tableColumnArray[nArray[i]];
                if (bl4 && !tableColumn.isDisposed()) {
                    tableColumn.updateToolTip(nArray[i]);
                    tableColumn.sendEvent(10);
                }
                if (tableColumn != this) continue;
                bl4 = true;
            }
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        long l = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(l, OS.LVM_GETCOLUMN, (long)n2, lVCOLUMN);
        lVCOLUMN.fmt &= 0xFFFFFFFC;
        int n3 = 0;
        if ((this.style & 0x4000) == 16384) {
            n3 = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            n3 = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            n3 = 1;
        }
        lVCOLUMN.fmt |= n3;
        OS.SendMessage(l, OS.LVM_SETCOLUMN, (long)n2, lVCOLUMN);
        if (n2 != 0) {
            this.parent.forceResize();
            RECT rECT = new RECT();
            RECT rECT2 = new RECT();
            OS.GetClientRect(l, rECT);
            long l2 = OS.SendMessage(l, 4127, 0L, 0L);
            OS.SendMessage(l2, 4615, (long)n2, rECT2);
            OS.MapWindowPoints(l2, l, rECT2, 2);
            rECT.left = rECT2.left;
            rECT.right = rECT2.right;
            OS.InvalidateRect(l, rECT, true);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean bl, boolean bl2) {
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        long l = this.parent.handle;
        if (OS.COMCTL32_MAJOR < 6) {
            long l2 = OS.SendMessage(l, 4127, 0L, 0L);
            HDITEM hDITEM = new HDITEM();
            hDITEM.mask = 52;
            OS.SendMessage(l2, OS.HDM_GETITEM, (long)n, hDITEM);
            hDITEM.fmt &= 0xFFFFEFFF;
            if (image != null) {
                if (bl) {
                    hDITEM.mask &= 0xFFFFFFDF;
                    hDITEM.fmt &= 0xFFFFF7FF;
                    hDITEM.fmt |= 0x2000;
                    hDITEM.hbm = image.handle;
                } else {
                    hDITEM.mask &= 0xFFFFFFEF;
                    hDITEM.fmt &= 0xFFFFDFFF;
                    hDITEM.fmt |= 0x800;
                    hDITEM.iImage = this.parent.imageIndexHeader(image);
                }
                if (bl2) {
                    hDITEM.fmt |= 0x1000;
                }
            } else {
                hDITEM.fmt &= 0xFFFFD7FF;
            }
            OS.SendMessage(l2, OS.HDM_SETITEM, (long)n, hDITEM);
        } else {
            LVCOLUMN lVCOLUMN = new LVCOLUMN();
            lVCOLUMN.mask = 17;
            OS.SendMessage(l, OS.LVM_GETCOLUMN, (long)n, lVCOLUMN);
            if (image != null) {
                lVCOLUMN.fmt |= 0x800;
                lVCOLUMN.iImage = this.parent.imageIndexHeader(image);
                if (bl2) {
                    lVCOLUMN.fmt |= 0x1000;
                }
            } else {
                lVCOLUMN.mask &= 0xFFFFFFEF;
                lVCOLUMN.fmt &= 0xFFFFE7FF;
            }
            OS.SendMessage(l, OS.LVM_SETCOLUMN, (long)n, lVCOLUMN);
        }
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.moveable = bl;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
    }

    void setSortDirection(int n) {
        if (OS.COMCTL32_MAJOR >= 6) {
            RECT rECT;
            int n2 = this.parent.indexOf(this);
            if (n2 == -1) {
                return;
            }
            long l = this.parent.handle;
            long l2 = OS.SendMessage(l, 4127, 0L, 0L);
            HDITEM hDITEM = new HDITEM();
            hDITEM.mask = 36;
            OS.SendMessage(l2, OS.HDM_GETITEM, (long)n2, hDITEM);
            switch (n) {
                case 128: {
                    hDITEM.fmt &= 0xFFFFF5FF;
                    hDITEM.fmt |= 0x400;
                    if (this.image != null) break;
                    hDITEM.mask &= 0xFFFFFFDF;
                    break;
                }
                case 1024: {
                    hDITEM.fmt &= 0xFFFFF3FF;
                    hDITEM.fmt |= 0x200;
                    if (this.image != null) break;
                    hDITEM.mask &= 0xFFFFFFDF;
                    break;
                }
                case 0: {
                    hDITEM.fmt &= 0xFFFFF9FF;
                    if (this.image != null) {
                        hDITEM.fmt |= 0x800;
                        hDITEM.iImage = this.parent.imageIndexHeader(this.image);
                        break;
                    }
                    hDITEM.fmt &= 0xFFFFF7FF;
                    hDITEM.mask &= 0xFFFFFFDF;
                }
            }
            OS.SendMessage(l2, OS.HDM_SETITEM, (long)n2, hDITEM);
            this.parent.forceResize();
            RECT rECT2 = new RECT();
            OS.GetClientRect(l, rECT2);
            if ((int)OS.SendMessage(l, 4096, 0L, 0L) != -1) {
                int n3 = (int)OS.SendMessage(l, 4270, 0L, 0L);
                int n4 = n == 0 ? -1 : n2;
                OS.SendMessage(l, 4236, (long)n4, 0L);
                RECT rECT3 = new RECT();
                if (n3 != -1 && OS.SendMessage(l2, 4615, (long)n3, rECT3) != 0L) {
                    OS.MapWindowPoints(l2, l, rECT3, 2);
                    rECT2.left = rECT3.left;
                    rECT2.right = rECT3.right;
                    OS.InvalidateRect(l, rECT2, true);
                }
            }
            if (OS.SendMessage(l2, 4615, (long)n2, rECT = new RECT()) != 0L) {
                OS.MapWindowPoints(l2, l, rECT, 2);
                rECT2.left = rECT.left;
                rECT2.right = rECT.right;
                OS.InvalidateRect(l, rECT2, true);
            }
        } else {
            switch (n) {
                case 128: 
                case 1024: {
                    this.setImage(this.display.getSortImage(n), true, true);
                    break;
                }
                case 0: {
                    this.setImage(this.image, false, false);
                }
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setText(string);
        long l = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(l, OS.LVM_GETCOLUMN, (long)n, lVCOLUMN);
        boolean bl = !OS.IsWinCE && OS.WIN32_VERSION <= OS.VERSION(4, 10);
        long l2 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string, bl), true);
        int n2 = tCHAR.length() * TCHAR.sizeof;
        long l3 = OS.HeapAlloc(l2, 8, n2);
        OS.MoveMemory(l3, tCHAR, n2);
        lVCOLUMN.mask |= 4;
        lVCOLUMN.pszText = l3;
        long l4 = OS.SendMessage(l, OS.LVM_SETCOLUMN, (long)n, lVCOLUMN);
        if (l3 != 0L) {
            OS.HeapFree(l2, 0, l3);
        }
        if (l4 == 0L) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        long l = this.parent.headerToolTipHandle;
        if (l == 0L) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        long l = this.parent.handle;
        if (n != (int)OS.SendMessage(l, 4125, (long)n2, 0L)) {
            OS.SendMessage(l, 4126, (long)n2, (long)n);
        }
    }

    void updateToolTip(int n) {
        RECT rECT;
        long l;
        long l2;
        long l3 = this.parent.headerToolTipHandle;
        if (l3 != 0L && OS.SendMessage(l2 = OS.SendMessage(l = this.parent.handle, 4127, 0L, 0L), 4615, (long)n, rECT = new RECT()) != 0L) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.hwnd = l2;
            tOOLINFO.uId = this.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(l3, OS.TTM_NEWTOOLRECT, 0L, tOOLINFO);
        }
    }
}

