/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.udp.DummyThrottle;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.MTU;
import net.i2p.router.transport.udp.MessageQueue;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.OutboundRefiller;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.PacketPusher;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.Sorters;
import net.i2p.router.transport.udp.TimedWeightedPriorityMessageQueue;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.util.RandomIterator;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.VersionComparator;

public class UDPTransport
extends TransportImpl
implements TimedWeightedPriorityMessageQueue.FailedListener {
    private final Log _log;
    private final List<UDPEndpoint> _endpoints;
    private final Object _addDropLock = new Object();
    private final Map<Hash, PeerState> _peersByIdent;
    private final Map<RemoteHostId, PeerState> _peersByRemoteHost;
    private PacketHandler _handler;
    private EstablishmentManager _establisher;
    private final MessageQueue _outboundMessages;
    private final OutboundMessageFragments _fragments;
    private final OutboundMessageFragments.ActiveThrottle _activeThrottle;
    private OutboundRefiller _refiller;
    private volatile PacketPusher _pusher;
    private final InboundMessageFragments _inboundFragments;
    private PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private final ExpirePeerEvent _expireEvent;
    private final PeerTestEvent _testEvent;
    private final PacketBuilder _destroyBuilder;
    private CommSystemFacade.Status _reachabilityStatus;
    private long _reachabilityStatusLastUpdated;
    private int _reachabilityStatusUnchanged;
    private long _introducersSelectedOn;
    private long _lastInboundReceivedOn;
    private final DHSessionKeyBuilder.Factory _dhFactory;
    private int _mtu;
    private int _mtu_ipv6;
    private boolean _mismatchLogged;
    private final int _networkID;
    private boolean _haveIPv6Address;
    private long _lastInboundIPv6;
    private boolean _needsRebuild;
    private final Object _rebuildLock = new Object();
    private SessionKey _introKey;
    private final Set<RemoteHostId> _dropList;
    private volatile long _expireTimeout;
    private Hash _lastFrom;
    private byte[] _lastOurIP;
    private int _lastOurPort;
    private RouterAddress _currentOurV4Address;
    private RouterAddress _currentOurV6Address;
    private static final int DROPLIST_PERIOD = 600000;
    public static final String STYLE = "SSU";
    public static final String PROP_INTERNAL_PORT = "i2np.udp.internalPort";
    @Deprecated
    public static final int DEFAULT_INTERNAL_PORT = 8887;
    public static final String PROP_EXTERNAL_HOST = "i2np.udp.host";
    public static final String PROP_EXTERNAL_PORT = "i2np.udp.port";
    public static final String PROP_PREFER_UDP = "i2np.udp.preferred";
    private static final String DEFAULT_PREFER_UDP = "false";
    private static final String PROP_FIXED_PORT = "i2np.udp.fixedPort";
    public static final String PROP_SOURCES = "i2np.udp.addressSources";
    public static final String DEFAULT_SOURCES = Transport.AddressSource.SOURCE_INTERFACE.toConfigString() + ',' + Transport.AddressSource.SOURCE_UPNP.toConfigString() + ',' + Transport.AddressSource.SOURCE_SSU.toConfigString();
    public static final String PROP_IP = "i2np.lastIP";
    public static final String PROP_IP_CHANGE = "i2np.lastIPChange";
    public static final String PROP_LAPTOP_MODE = "i2np.laptopMode";
    public static final String PROP_FORCE_INTRODUCERS = "i2np.udp.forceIntroducers";
    public static final String PROP_ALLOW_DIRECT = "i2np.udp.allowDirect";
    public static final String PROP_BIND_INTERFACE = "i2np.udp.bindInterface";
    private static final String PROP_DEFAULT_MTU = "i2np.udp.mtu";
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    private static final String CAP_TESTING = "B";
    private static final String CAP_TESTING_INTRO = "BC";
    public static final int PUBLIC_RELAY_COUNT = 3;
    private static final boolean USE_PRIORITY = false;
    private static final int[] PRIORITY_LIMITS = new int[]{100, 200, 300, 400, 500, 1000};
    private static final int[] PRIORITY_WEIGHT = new int[]{1, 1, 1, 1, 1, 2};
    private static final int MAX_CONSECUTIVE_FAILED = 5;
    public static final int DEFAULT_COST = 5;
    private static final int TEST_FREQUENCY = 780000;
    private static final int MIN_TEST_FREQUENCY = 45000;
    static final long[] RATES = new long[]{600000L};
    private static final int[] BID_VALUES = new int[]{15, 20, 50, 65, 80, 95, 100, 115, 999999};
    private static final int FAST_PREFERRED_BID = 0;
    private static final int SLOW_PREFERRED_BID = 1;
    private static final int FAST_BID = 2;
    private static final int SLOW_BID = 3;
    private static final int SLOWEST_BID = 4;
    private static final int SLOWEST_COST_BID = 5;
    private static final int NEAR_CAPACITY_BID = 6;
    private static final int NEAR_CAPACITY_COST_BID = 7;
    private static final int TRANSIENT_FAIL_BID = 8;
    private final TransportBid[] _cachedBid;
    private static final String THINSP = " / ";
    private static final String MIN_SIGTYPE_VERSION = "0.9.17";
    private static final int ALLOW_IP_CHANGE_INTERVAL = 120000;
    private boolean gotIPv4Addr = false;
    private boolean gotIPv6Addr = false;
    private static final int MIN_PEERS = 3;
    private static final int MIN_INTRODUCER_POOL = 5;
    public static final int EXPIRE_TIMEOUT = 1200000;
    private static final int MAX_IDLE_TIME = 1200000;
    public static final int MIN_EXPIRE_TIMEOUT = 165000;
    private static final DecimalFormat _fmt = new DecimalFormat("#,##0.00");
    private static final DecimalFormat _pctFmt = new DecimalFormat("#0.0%");
    private static final String PROP_REACHABILITY_STATUS_OVERRIDE = "i2np.udp.status";

    public UDPTransport(RouterContext ctx, DHSessionKeyBuilder.Factory dh) {
        super(ctx);
        this._networkID = ctx.router().getNetworkID();
        this._dhFactory = dh;
        this._log = ctx.logManager().getLog(UDPTransport.class);
        this._peersByIdent = new ConcurrentHashMap<Hash, PeerState>(128);
        this._peersByRemoteHost = new ConcurrentHashMap<RemoteHostId, PeerState>(128);
        this._dropList = new ConcurrentHashSet<RemoteHostId>(2);
        this._endpoints = new CopyOnWriteArrayList<UDPEndpoint>();
        DummyThrottle mq = new DummyThrottle();
        this._outboundMessages = null;
        this._activeThrottle = mq;
        this._cachedBid = new SharedBid[BID_VALUES.length];
        for (int i = 0; i < BID_VALUES.length; ++i) {
            this._cachedBid[i] = new SharedBid(BID_VALUES[i]);
        }
        this._destroyBuilder = new PacketBuilder(this._context, this);
        this._fragments = new OutboundMessageFragments(this._context, this, this._activeThrottle);
        this._inboundFragments = new InboundMessageFragments(this._context, this._fragments, this);
        this._expireTimeout = 1200000L;
        this._expireEvent = new ExpirePeerEvent();
        this._testEvent = new PeerTestEvent();
        this._reachabilityStatus = CommSystemFacade.Status.UNKNOWN;
        this._introManager = new IntroductionManager(this._context, this);
        this._introducersSelectedOn = -1L;
        this._lastInboundReceivedOn = -1L;
        this._mtu = 1484;
        this._mtu_ipv6 = 1280;
        this.setupPort();
        this._needsRebuild = true;
        this._context.statManager().createRateStat("udp.alreadyConnected", "What is the lifetime of a reestablished session", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeer", "How long ago did we receive from a dropped peer (duration == session lifetime", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeerInactive", "How long ago did we receive from a dropped peer (duration == session lifetime)", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressTestInsteadOfUpdate", "How many times we fire off a peer test of ourselves instead of adjusting our own reachable address?", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressUpdated", "How many times we adjust our own reachable IP address", "udp", RATES);
        this._context.statManager().createRateStat("udp.proactiveReestablish", "How long a session was idle for when we proactively reestablished it", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerDroplist", "How many peers currently have their packets dropped outright when a new peer is added to the list?", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerConsecutiveFailures", "How many consecutive failed sends to a peer did we attempt before giving up and reestablishing a new session (lifetime is inactivity perood)", "udp", RATES);
        this._context.simpleTimer2().addPeriodicEvent(new PingIntroducers(), 123750L);
    }

    private void setupPort() {
        int port = this.getRequestedPort();
        if (port < 0) {
            port = UDPEndpoint.selectRandomPort(this._context);
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_INTERNAL_PORT, Integer.toString(port));
            changes.put(PROP_EXTERNAL_PORT, Integer.toString(port));
            this._context.router().saveConfig(changes, null);
            this._log.logAlways(20, "UDP selected random port " + port);
        }
    }

    private synchronized void startup() {
        String fixedHost;
        this._fragments.shutdown();
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.shutdown();
            this._endpoints.remove(endpoint);
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        this._inboundFragments.shutdown();
        this._introManager.reset();
        UDPPacket.clearCache();
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting SSU transport listening");
        }
        this._introKey = new SessionKey(new byte[32]);
        System.arraycopy(this._context.routerHash().getData(), 0, this._introKey.getData(), 0, 32);
        String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
        if (bindTo == null && (fixedHost = this._context.getProperty(PROP_EXTERNAL_HOST)) != null && fixedHost.length() > 0) {
            try {
                String testAddr = InetAddress.getByName(fixedHost).getHostAddress();
                if (Addresses.getAddresses().contains(testAddr)) {
                    bindTo = testAddr;
                }
            }
            catch (UnknownHostException testAddr) {
                // empty catch block
            }
        }
        ArrayList<InetAddress> bindToAddrs = new ArrayList<InetAddress>(4);
        if (bindTo != null) {
            String[] bta = DataHelper.split(bindTo, "[,; \r\n\t]");
            for (int i = 0; i < bta.length; ++i) {
                String bt = bta[i];
                if (bt.length() <= 0) continue;
                try {
                    bindToAddrs.add(InetAddress.getByName(bt));
                    continue;
                }
                catch (UnknownHostException uhe) {
                    this._log.error("Invalid SSU bind interface specified [" + bt + "]", uhe);
                }
            }
        }
        int oldIPort = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        int oldBindPort = this.getListenPort(false);
        int oldEPort = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        int port = oldIPort > 0 ? oldIPort : (oldBindPort > 0 ? oldBindPort : oldEPort);
        if (!bindToAddrs.isEmpty() && this._log.shouldLog(30)) {
            this._log.warn("Binding only to " + bindToAddrs);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Binding to the port: " + port);
        }
        if (this._endpoints.isEmpty()) {
            if (bindToAddrs.isEmpty()) {
                UDPEndpoint endpoint = new UDPEndpoint(this._context, this, port, null);
                this._endpoints.add(endpoint);
                this.setMTU(null);
            } else {
                for (InetAddress bindToAddr : bindToAddrs) {
                    UDPEndpoint endpoint = new UDPEndpoint(this._context, this, port, bindToAddr);
                    this._endpoints.add(endpoint);
                    this.setMTU(bindToAddr);
                }
            }
        } else {
            for (UDPEndpoint endpoint : this._endpoints) {
                if (!endpoint.isIPv4()) continue;
                endpoint.setListenPort(port);
                break;
            }
        }
        if (this._establisher == null) {
            this._establisher = new EstablishmentManager(this._context, this);
        }
        if (this._testManager == null) {
            this._testManager = new PeerTestManager(this._context, this);
        }
        if (this._handler == null) {
            this._handler = new PacketHandler(this._context, this, this._establisher, this._inboundFragments, this._testManager, this._introManager);
        }
        int newPort = -1;
        for (UDPEndpoint endpoint : this._endpoints) {
            try {
                endpoint.startup();
                if (newPort < 0 && endpoint.isIPv4()) {
                    newPort = endpoint.getListenPort();
                }
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Started " + endpoint);
            }
            catch (SocketException se) {
                this._endpoints.remove(endpoint);
                this._log.error("Failed to start " + endpoint, se);
            }
        }
        if (this._endpoints.isEmpty()) {
            this._log.log(50, "Unable to open UDP port");
            this.setReachabilityStatus(CommSystemFacade.Status.HOSED);
            return;
        }
        if (newPort > 0 && (newPort != port || newPort != oldIPort || newPort != oldEPort)) {
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_INTERNAL_PORT, Integer.toString(newPort));
            changes.put(PROP_EXTERNAL_PORT, Integer.toString(newPort));
            this._context.router().saveConfig(changes, null);
        }
        this._handler.startup();
        this._fragments.startup();
        this._inboundFragments.startup();
        this._pusher = new PacketPusher(this._context, this._fragments, this._endpoints);
        this._pusher.startup();
        this._establisher.startup();
        this._expireEvent.setIsAlive(true);
        this._reachabilityStatus = CommSystemFacade.Status.UNKNOWN;
        this._testEvent.setIsAlive(true);
        this._testEvent.reschedule(10000L);
        if (newPort > 0 && bindToAddrs.isEmpty()) {
            for (InetAddress ia : this.getSavedLocalAddresses()) {
                if (ia.getAddress().length == 16) {
                    this._lastInboundIPv6 = this._context.clock().now();
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK);
                } else if (!this.isIPv4Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                }
                this.rebuildExternalAddress(ia.getHostAddress(), newPort, false);
            }
        } else if (newPort > 0 && !bindToAddrs.isEmpty()) {
            for (InetAddress ia : bindToAddrs) {
                if (ia.getAddress().length == 16) {
                    this._lastInboundIPv6 = this._context.clock().now();
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK);
                } else if (!this.isIPv4Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                }
                this.rebuildExternalAddress(ia.getHostAddress(), newPort, false);
            }
        }
        if (this.isIPv4Firewalled()) {
            if (this._lastInboundIPv6 > 0L) {
                this.setReachabilityStatus(CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN);
            } else {
                this.setReachabilityStatus(CommSystemFacade.Status.REJECT_UNSOLICITED);
            }
        }
        this.rebuildExternalAddress(false);
    }

    public synchronized void shutdown() {
        this.destroyAll();
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.shutdown();
            this._endpoints.remove(endpoint);
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        this._fragments.shutdown();
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        this._inboundFragments.shutdown();
        this._expireEvent.setIsAlive(false);
        this._testEvent.setIsAlive(false);
        this._peersByRemoteHost.clear();
        this._peersByIdent.clear();
        this._dropList.clear();
        this._introManager.reset();
        UDPPacket.clearCache();
        UDPAddress.clearCache();
        this._lastInboundIPv6 = 0L;
    }

    public void fail(UDPEndpoint endpoint) {
        if (this._endpoints.remove(endpoint)) {
            this._log.log(50, "UDP port failure: " + endpoint);
            if (this._endpoints.isEmpty()) {
                this._log.log(50, "No more UDP sockets open");
                this.setReachabilityStatus(CommSystemFacade.Status.HOSED);
            }
            this.rebuildExternalAddress();
        }
    }

    private boolean isAlive() {
        return this._inboundFragments.isAlive();
    }

    SessionKey getIntroKey() {
        return this._introKey;
    }

    int getExternalPort(boolean ipv6) {
        int rv;
        RouterAddress addr = this.getCurrentAddress(ipv6);
        if (addr != null && (rv = addr.getPort()) > 0) {
            return rv;
        }
        return this.getRequestedPort(ipv6);
    }

    byte[] getExternalIP() {
        RouterAddress addr = this.getCurrentAddress(false);
        if (addr != null) {
            return addr.getIP();
        }
        return null;
    }

    boolean isTooClose(byte[] ip) {
        if (this.allowLocal()) {
            return false;
        }
        for (RouterAddress addr : this.getCurrentAddresses()) {
            byte[] myip = addr.getIP();
            if (myip == null || ip.length != myip.length || !(ip.length == 4 ? DataHelper.eq(ip, 0, myip, 0, 2) : ip.length == 16 && DataHelper.eq(ip, 0, myip, 0, 8))) continue;
            return true;
        }
        return false;
    }

    private int getListenPort(boolean ipv6) {
        for (UDPEndpoint endpoint : this._endpoints) {
            if ((ipv6 || !endpoint.isIPv4()) && (!ipv6 || !endpoint.isIPv6())) continue;
            return endpoint.getListenPort();
        }
        return -1;
    }

    @Override
    public int getRequestedPort() {
        return this.getRequestedPort(false);
    }

    private int getRequestedPort(boolean ipv6) {
        int rv = this.getListenPort(ipv6);
        if (rv > 0) {
            return rv;
        }
        rv = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        if (rv > 0) {
            return rv;
        }
        return this._context.getProperty(PROP_EXTERNAL_PORT, -1);
    }

    private int setMTU(InetAddress addr) {
        String p = this._context.getProperty(PROP_DEFAULT_MTU);
        if (p != null) {
            try {
                int pmtu = Integer.parseInt(p);
                this._mtu = MTU.rectify(false, pmtu);
                this._mtu_ipv6 = MTU.rectify(true, pmtu);
                return this._mtu;
            }
            catch (NumberFormatException pmtu) {
                // empty catch block
            }
        }
        int mtu = MTU.getMTU(addr);
        if (addr != null && addr.getAddress().length == 16) {
            if (mtu <= 0) {
                mtu = 1280;
            }
            this._mtu_ipv6 = mtu;
        } else {
            if (mtu <= 0) {
                mtu = 1484;
            }
            this._mtu = mtu;
        }
        return mtu;
    }

    int getMTU(boolean ipv6) {
        return ipv6 ? this._mtu_ipv6 : this._mtu;
    }

    void inboundConnectionReceived(boolean isIPv6) {
        if (isIPv6) {
            this._lastInboundIPv6 = this._context.clock().now();
            if (this._currentOurV6Address != null) {
                this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK);
            }
        } else {
            this._lastInboundReceivedOn = System.currentTimeMillis();
        }
    }

    @Override
    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        boolean changed;
        if (this._log.shouldLog(30)) {
            this._log.warn("Received address: " + Addresses.toString(ip, port) + " from: " + (Object)((Object)source));
        }
        if (ip == null) {
            return;
        }
        if (!this.isPubliclyRoutable(ip) && !this.allowLocal()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address: " + Addresses.toString(ip, port) + " from: " + (Object)((Object)source));
            }
            return;
        }
        if (source == Transport.AddressSource.SOURCE_INTERFACE && ip.length == 16) {
            this._haveIPv6Address = true;
        }
        if (this.explicitAddressSpecified()) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains(source.toConfigString())) {
            return;
        }
        if (!this.isAlive()) {
            if (source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_UPNP) {
                try {
                    InetAddress ia = InetAddress.getByAddress(ip);
                    this.saveLocalAddress(ia);
                }
                catch (UnknownHostException ia) {
                    // empty catch block
                }
            }
            return;
        }
        if (source == Transport.AddressSource.SOURCE_INTERFACE) {
            if (ip.length == 4) {
                if (this.gotIPv4Addr) {
                    return;
                }
                this.gotIPv4Addr = true;
            } else if (ip.length == 16) {
                if (this.gotIPv6Addr) {
                    return;
                }
                this.gotIPv6Addr = true;
            }
        }
        if ((changed = this.changeAddress(ip, port)) && source == Transport.AddressSource.SOURCE_INTERFACE) {
            if (ip.length == 4) {
                if (!this.isIPv4Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                }
            } else if (ip.length == 16) {
                this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK);
            }
        }
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the SSU port: " + port + " via " + Addresses.toString(ip, externalPort));
            } else {
                this._log.warn("UPnP has failed to open the SSU port: " + port + " reason: " + reason);
            }
        }
        if (success && ip != null && this.getExternalIP() != null && !this.isIPv4Firewalled()) {
            this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void externalAddressReceived(Hash from, byte[] ourIP, int ourPort) {
        boolean inboundRecent;
        boolean isValid = this.isValid(ourIP) && TransportUtil.isValidPort(ourPort);
        boolean explicitSpecified = this.explicitAddressSpecified();
        boolean bl = inboundRecent = this._lastInboundReceivedOn + 120000L > System.currentTimeMillis();
        if (this._log.shouldLog(20)) {
            this._log.info("External address received: " + Addresses.toString(ourIP, ourPort) + " from " + from + ", isValid? " + isValid + ", explicitSpecified? " + explicitSpecified + ", receivedInboundRecent? " + inboundRecent + " status " + (Object)((Object)this._reachabilityStatus));
        }
        if (ourIP.length != 4) {
            return;
        }
        if (explicitSpecified) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains("ssu")) {
            return;
        }
        if (!isValid) {
            if (this._log.shouldLog(40)) {
                this._log.error("The router " + from + " told us we have an invalid IP - " + Addresses.toString(ourIP, ourPort) + ".  Lets throw tomatoes at them");
            }
            this.markUnreachable(from);
            return;
        }
        RouterAddress addr = this.getCurrentExternalAddress(false);
        if (inboundRecent && addr != null && addr.getPort() > 0 && addr.getHost() != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring IP address suggestion, since we have received an inbound con recently");
            }
        } else {
            boolean changeIt = false;
            UDPTransport uDPTransport = this;
            synchronized (uDPTransport) {
                if (from.equals(this._lastFrom) || !UDPTransport.eq(this._lastOurIP, this._lastOurPort, ourIP, ourPort)) {
                    this._lastFrom = from;
                    this._lastOurIP = ourIP;
                    this._lastOurPort = ourPort;
                    if (this._log.shouldLog(20)) {
                        this._log.info("The router " + from + " told us we have a new IP - " + Addresses.toString(ourIP, ourPort) + ".  Wait until somebody else tells us the same thing.");
                    }
                } else {
                    this._lastFrom = from;
                    this._lastOurIP = ourIP;
                    this._lastOurPort = ourPort;
                    changeIt = true;
                }
            }
            if (changeIt) {
                if (this._log.shouldLog(20)) {
                    this._log.info(from + " and " + this._lastFrom + " agree we have a new IP - " + Addresses.toString(ourIP, ourPort) + ".  Changing address.");
                }
                this.changeAddress(ourIP, ourPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeAddress(byte[] ourIP, int ourPort) {
        int externalListenPort;
        boolean fixedPort = this.getIsPortFixed();
        boolean updated = false;
        boolean fireTest = false;
        boolean isIPv6 = ourIP.length == 16;
        RouterAddress current = this.getCurrentExternalAddress(isIPv6);
        byte[] externalListenHost = current != null ? current.getIP() : null;
        int n = externalListenPort = current != null ? current.getPort() : this.getRequestedPort(isIPv6);
        if (this._log.shouldLog(20)) {
            this._log.info("Change address? status = " + (Object)((Object)this._reachabilityStatus) + " diff = " + (this._context.clock().now() - this._reachabilityStatusLastUpdated) + " old = " + Addresses.toString(externalListenHost, externalListenPort) + " new = " + Addresses.toString(ourIP, ourPort));
        }
        if (fixedPort && externalListenPort > 0 || ourPort <= 0) {
            ourPort = externalListenPort;
        }
        UDPTransport uDPTransport = this;
        synchronized (uDPTransport) {
            if (ourPort > 0 && !UDPTransport.eq(externalListenHost, externalListenPort, ourIP, ourPort)) {
                RouterAddress newAddr;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Trying to change our external address to " + Addresses.toString(ourIP, ourPort));
                }
                updated = (newAddr = this.rebuildExternalAddress(ourIP, ourPort, true)) != null;
            } else if (this._log.shouldLog(20)) {
                this._log.info("Same address as the current one");
            }
        }
        if (fireTest) {
            this._context.statManager().addRateData("udp.addressTestInsteadOfUpdate", 1L);
        } else if (updated) {
            this._context.statManager().addRateData("udp.addressUpdated", 1L);
            HashMap<String, String> changes = new HashMap<String, String>();
            if (ourIP.length == 4 && !fixedPort) {
                changes.put(PROP_EXTERNAL_PORT, Integer.toString(ourPort));
            }
            if (ourIP.length == 4) {
                this._context.commSystem().queueLookup(ourIP);
            }
            String oldIP = this._context.getProperty(PROP_IP);
            String newIP = Addresses.toString(ourIP);
            if (ourIP.length == 4 && !newIP.equals(oldIP)) {
                long lastChanged = 0L;
                long now = this._context.clock().now();
                String lcs = this._context.getProperty(PROP_IP_CHANGE);
                if (lcs != null) {
                    try {
                        lastChanged = Long.parseLong(lcs);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                changes.put(PROP_IP, newIP);
                changes.put(PROP_IP_CHANGE, Long.toString(now));
                this._context.router().saveConfig(changes, null);
                if (oldIP != null) {
                    this._context.router().eventLog().addEvent("changeIP", newIP);
                }
                if (oldIP != null && System.getProperty("wrapper.version") != null && this._context.getBooleanProperty(PROP_LAPTOP_MODE) && now - lastChanged > 600000L && this._context.router().getUptime() < 600000L) {
                    this._log.log(50, "IP changed, restarting with a new identity and port");
                    this._context.router().killKeys();
                    this._context.router().shutdown(4);
                }
            } else if (ourIP.length == 4 && !fixedPort) {
                this._context.router().saveConfig(changes, null);
            }
            this._context.router().rebuildRouterInfo();
        }
        this._testEvent.forceRunImmediately();
        return updated;
    }

    private static final boolean eq(byte[] laddr, int lport, byte[] raddr, int rport) {
        return rport == lport && DataHelper.eq(laddr, raddr);
    }

    public final boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        if (this.isPubliclyRoutable(addr) && (addr.length != 16 || this._haveIPv6Address)) {
            return true;
        }
        return this.allowLocal();
    }

    boolean allowLocal() {
        return this._context.getBooleanProperty("i2np.udp.allowLocal");
    }

    private boolean getIsPortFixed() {
        String prop = this._context.getProperty(PROP_FIXED_PORT);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        CommSystemFacade.Status status = this.getReachabilityStatus();
        return status != CommSystemFacade.Status.REJECT_UNSOLICITED && status != CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK && status != CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN;
    }

    PeerState getPeerState(RemoteHostId hostInfo) {
        return this._peersByRemoteHost.get(hostInfo);
    }

    List<PeerState> getPeerStatesByIP(RemoteHostId hostInfo) {
        ArrayList<PeerState> rv = new ArrayList<PeerState>(4);
        byte[] ip = hostInfo.getIP();
        if (ip != null && ip.length == 4) {
            for (PeerState ps : this._peersByIdent.values()) {
                if (!DataHelper.eq(ip, ps.getRemoteIP())) continue;
                rv.add(ps);
            }
        }
        return rv;
    }

    PeerState getPeerState(Hash remotePeer) {
        return this._peersByIdent.get(remotePeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changePeerPort(PeerState peer, int newPort) {
        int oldPort;
        Object object = this._addDropLock;
        synchronized (object) {
            oldPort = peer.getRemotePort();
            if (oldPort != newPort) {
                this._peersByRemoteHost.remove(peer.getRemoteHostId());
                peer.changePort(newPort);
                this._peersByRemoteHost.put(peer.getRemoteHostId(), peer);
            }
        }
        if (this._log.shouldInfo() && oldPort != newPort) {
            this._log.info("Changed port from " + oldPort + " to " + newPort + " for " + peer);
        }
    }

    EstablishmentManager getEstablisher() {
        return this._establisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRemotePeerState(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Add remote peer state: " + peer);
        }
        Object object = this._addDropLock;
        synchronized (object) {
            return this.locked_addRemotePeerState(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean locked_addRemotePeerState(PeerState peer) {
        PeerState oldPeer2;
        Hash remotePeer = peer.getRemotePeer();
        long oldEstablishedOn = -1L;
        PeerState oldPeer = null;
        if (remotePeer != null && (oldPeer = this._peersByIdent.put(remotePeer, peer)) != null && oldPeer != peer) {
            if (this._log.shouldInfo()) {
                this._log.info("Peer already connected (PBID): old=" + oldPeer + " new=" + peer);
            }
            peer.loadFrom(oldPeer);
            oldEstablishedOn = oldPeer.getKeyEstablishedTime();
        }
        RemoteHostId remoteId = peer.getRemoteHostId();
        if (oldPeer != null) {
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            this._expireEvent.remove(oldPeer);
            RemoteHostId oldID = oldPeer.getRemoteHostId();
            if (!remoteId.equals(oldID)) {
                PeerState oldPeer22;
                if (this._log.shouldInfo()) {
                    this._log.info(remotePeer + " changed address FROM " + oldID + " TO " + remoteId);
                }
                if ((oldPeer22 = this._peersByRemoteHost.remove(oldID)) != oldPeer && oldPeer22 != null) {
                    oldPeer22.dropOutbound();
                    this._introManager.remove(oldPeer22);
                    this._expireEvent.remove(oldPeer22);
                }
            }
        }
        if (remoteId.getIP() == null && this._log.shouldLog(30)) {
            this._log.warn("Add indirect: " + peer);
        }
        if ((oldPeer2 = this._peersByRemoteHost.put(remoteId, peer)) != null && oldPeer2 != peer && oldPeer2 != oldPeer) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer already connected (PBRH): old=" + oldPeer2 + " new=" + peer);
            }
            peer.loadFrom(oldPeer2);
            oldEstablishedOn = oldPeer2.getKeyEstablishedTime();
            oldPeer2.dropOutbound();
            this._introManager.remove(oldPeer2);
            this._expireEvent.remove(oldPeer2);
        }
        if (this._log.shouldLog(30) && !this._mismatchLogged && this._peersByIdent.size() != this._peersByRemoteHost.size()) {
            this._mismatchLogged = true;
            this._log.warn("Size Mismatch after add: " + peer + " byIDsz = " + this._peersByIdent.size() + " byHostsz = " + this._peersByRemoteHost.size());
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this.markReachable(peer.getRemotePeer(), peer.isInbound());
        this._expireEvent.add(peer);
        this._introManager.add(peer);
        if (oldEstablishedOn > 0L) {
            this._context.statManager().addRateData("udp.alreadyConnected", oldEstablishedOn, 0L);
        }
        Object object = this._rebuildLock;
        synchronized (object) {
            this.rebuildIfNecessary();
            CommSystemFacade.Status status = this.getReachabilityStatus();
            if (status != CommSystemFacade.Status.OK && status != CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN && status != CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED && status != CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK && status != CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN && status != CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED && status != CommSystemFacade.Status.DISCONNECTED && this._reachabilityStatusUnchanged < 7) {
                this._testEvent.forceRunSoon();
            }
        }
        return true;
    }

    @Override
    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        if (inMsg.getType() == 1) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)inMsg;
            DatabaseEntry entry = dsm.getEntry();
            if (entry == null) {
                return;
            }
            if (entry.getType() == 0 && ((RouterInfo)entry).getNetworkId() != this._networkID) {
                Hash peerHash = entry.getHash();
                PeerState peer = this.getPeerState(peerHash);
                if (peer != null) {
                    RemoteHostId remote = peer.getRemoteHostId();
                    this._dropList.add(remote);
                    this._context.statManager().addRateData("udp.dropPeerDroplist", 1L);
                    this._context.simpleTimer2().addEvent(new RemoveDropList(remote), 600000L);
                }
                this.markUnreachable(peerHash);
                this._context.banlist().banlistRouter(peerHash, "Part of the wrong network, version = " + ((RouterInfo)entry).getVersion());
                if (peer != null) {
                    this.sendDestroy(peer);
                }
                this.dropPeer(peerHash, false, "wrong network");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping the peer " + peerHash + " because they are in the wrong net: " + entry);
                }
                return;
            }
            if (entry.getType() == 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Received an RI from the same net");
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Received a leaseSet: " + dsm);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Received another message: " + inMsg.getClass().getName());
        }
        PeerState peer = this.getPeerState(remoteIdentHash);
        super.messageReceived(inMsg, remoteIdent, remoteIdentHash, msToReceive, bytesReceived);
        if (peer != null) {
            peer.expireInboundMessages();
        }
    }

    boolean isInDropList(RemoteHostId peer) {
        return this._dropList.contains(peer);
    }

    void dropPeer(Hash peer, boolean shouldBanlist, String why) {
        PeerState state = this.getPeerState(peer);
        if (state != null) {
            this.dropPeer(state, shouldBanlist, why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropPeer(PeerState peer, boolean shouldBanlist, String why) {
        if (this._log.shouldLog(20)) {
            long now = this._context.clock().now();
            StringBuilder buf = new StringBuilder(4096);
            long timeSinceSend = now - peer.getLastSendTime();
            long timeSinceRecv = now - peer.getLastReceiveTime();
            long timeSinceAck = now - peer.getLastACKSend();
            long timeSinceSendOK = now - peer.getLastSendFullyTime();
            int consec = peer.getConsecutiveFailedSends();
            buf.append("Dropping remote peer: ").append(peer.toString()).append(" banlist? ").append(shouldBanlist);
            buf.append(" lifetime: ").append(now - peer.getKeyEstablishedTime());
            buf.append(" time since send/fully/recv/ack: ").append(timeSinceSend).append(THINSP);
            buf.append(timeSinceSendOK).append(THINSP);
            buf.append(timeSinceRecv).append(THINSP).append(timeSinceAck);
            buf.append(" consec failures: ").append(consec);
            if (why != null) {
                buf.append(" cause: ").append(why);
            }
            this._log.info(buf.toString(), new Exception("Dropped by"));
        }
        Object object = this._addDropLock;
        synchronized (object) {
            this.locked_dropPeer(peer, shouldBanlist, why);
        }
        this.rebuildIfNecessary();
    }

    private void locked_dropPeer(PeerState peer, boolean shouldBanlist, String why) {
        RemoteHostId remoteId;
        PeerState altByHost;
        peer.dropOutbound();
        peer.expireInboundMessages();
        this._introManager.remove(peer);
        this._fragments.dropPeer(peer);
        PeerState altByIdent = null;
        if (peer.getRemotePeer() != null) {
            this.dropPeerCapacities(peer);
            if (shouldBanlist) {
                this.markUnreachable(peer.getRemotePeer());
            }
            long now = this._context.clock().now();
            this._context.statManager().addRateData("udp.droppedPeer", now - peer.getLastReceiveTime(), now - peer.getKeyEstablishedTime());
            altByIdent = this._peersByIdent.remove(peer.getRemotePeer());
        }
        if (altByIdent != (altByHost = this._peersByRemoteHost.remove(remoteId = peer.getRemoteHostId())) && this._log.shouldLog(30)) {
            this._log.warn("Mismatch on remove, RHID = " + remoteId + " byID = " + altByIdent + " byHost = " + altByHost + " byIDsz = " + this._peersByIdent.size() + " byHostsz = " + this._peersByRemoteHost.size());
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this._expireEvent.remove(peer);
        if (altByIdent != null && peer != altByIdent) {
            this.locked_dropPeer(altByIdent, shouldBanlist, "recurse");
        }
        if (altByHost != null && peer != altByHost) {
            this.locked_dropPeer(altByHost, shouldBanlist, "recurse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIfNecessary() {
        Object object = this._rebuildLock;
        synchronized (object) {
            if (this.locked_needsRebuild()) {
                this.rebuildExternalAddress();
            }
        }
    }

    private boolean locked_needsRebuild() {
        boolean rv;
        if (this._needsRebuild) {
            return true;
        }
        if (this._context.router().isHidden()) {
            return false;
        }
        RouterAddress addr = this.getCurrentAddress(false);
        if (this.introducersRequired()) {
            UDPAddress ua = new UDPAddress(addr);
            int valid = 0;
            for (int i = 0; i < ua.getIntroducerCount(); ++i) {
                PeerState peer;
                byte[] key = ua.getIntroducerKey(i);
                if (key.length != 32 || (peer = this.getPeerState(new Hash(key))) == null) continue;
                ++valid;
            }
            long sinceSelected = this._context.clock().now() - this._introducersSelectedOn;
            if (valid >= 3) {
                if (sinceSelected > 1020000L) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Our introducers are valid, but haven't changed in " + DataHelper.formatDuration(sinceSelected) + ", so lets rechoose");
                    }
                    return true;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Our introducers are valid and were selected " + DataHelper.formatDuration(sinceSelected) + " ago");
                }
                return false;
            }
            if (sinceSelected > 120000L) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Need more introducers (have " + valid + " need " + 3 + ')');
                }
                return true;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Need more introducers (have " + valid + " need " + 3 + ')' + " but we just chose them " + DataHelper.formatDuration(sinceSelected) + " ago so wait");
            }
            return false;
        }
        byte[] externalListenHost = addr != null ? addr.getIP() : null;
        int externalListenPort = addr != null ? addr.getPort() : -1;
        boolean bl = rv = externalListenHost == null || externalListenPort <= 0;
        if (!rv && addr.getOption("ihost0") != null) {
            rv = true;
        }
        if (rv) {
            if (this._log.shouldLog(20)) {
                this._log.info("Need to initialize our direct SSU info (" + Addresses.toString(externalListenHost, externalListenPort) + ')');
            }
        } else if (addr.getPort() <= 0 || addr.getHost() == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our direct SSU info is initialized, but not used in our address yet");
            }
            rv = true;
        }
        return rv;
    }

    private void dropPeerCapacities(PeerState peer) {
    }

    void send(UDPPacket packet) {
        if (this._pusher != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending packet " + packet);
            }
            this._pusher.send(packet);
        } else {
            this._log.error("No pusher", new Exception());
        }
    }

    void sendDestroy(PeerState peer) {
        if (peer.getCurrentCipherKey() == null) {
            return;
        }
        UDPPacket pkt = this._destroyBuilder.buildSessionDestroyPacket(peer);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending destroy to : " + peer);
        }
        this.send(pkt);
    }

    private void destroyAll() {
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.clearOutbound();
        }
        int howMany = this._peersByIdent.size();
        int burst = 8;
        int pps = Math.max(48, this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 1000 / 4 / 48);
        int burstps = pps / 8;
        int toSleep = Math.max(8, 1000 / burstps);
        int count = 0;
        if (this._log.shouldInfo()) {
            this._log.info("Sending destroy to : " + howMany + " peers");
        }
        for (PeerState peer : this._peersByIdent.values()) {
            this.sendDestroy(peer);
            if (++count % 8 != 0) continue;
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException interruptedException) {}
        }
        toSleep = Math.min(howMany / 3, 750);
        if (toSleep > 0) {
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        String v;
        RouterIdentity id;
        if (dataSize > 32768L) {
            return null;
        }
        Hash to = toAddress.getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (peer != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("bidding on a message to an established peer: " + peer);
            }
            if (this.preferUDP()) {
                return this._cachedBid[0];
            }
            return this._cachedBid[2];
        }
        if (this._reachabilityStatus == CommSystemFacade.Status.HOSED) {
            this.markUnreachable(to);
            return null;
        }
        RouterAddress addr = this.getTargetAddress(toAddress);
        if (addr == null) {
            this.markUnreachable(to);
            return null;
        }
        SigType type = toAddress.getIdentity().getSigType();
        if (type == null || !type.isAvailable()) {
            this.markUnreachable(to);
            return null;
        }
        RouterInfo us = this._context.router().getRouterInfo();
        if (us != null && (id = us.getIdentity()).getSigType() != SigType.DSA_SHA1 && VersionComparator.comp(v = toAddress.getVersion(), MIN_SIGTYPE_VERSION) < 0) {
            this.markUnreachable(to);
            return null;
        }
        if (!this.allowConnection()) {
            return this._cachedBid[8];
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("bidding on a message to an unestablished peer: " + to);
        }
        int count = this._peersByIdent.size();
        if (this.alwaysPreferUDP() || count < 3 || this.introducersRequired() && this._introManager.introducerCount() < 5) {
            return this._cachedBid[1];
        }
        if (this.preferUDP()) {
            return this._cachedBid[3];
        }
        if (this.haveCapacity()) {
            if (addr.getCost() > 5) {
                return this._cachedBid[5];
            }
            return this._cachedBid[4];
        }
        if (addr.getCost() > 5) {
            return this._cachedBid[7];
        }
        return this._cachedBid[6];
    }

    RouterAddress getTargetAddress(RouterInfo target) {
        List<RouterAddress> addrs = this.getTargetAddresses(target);
        for (int i = 0; i < addrs.size(); ++i) {
            RouterAddress addr = addrs.get(i);
            if (addr.getOption("ihost0") == null) {
                byte[] ip = addr.getIP();
                int port = addr.getPort();
                if (ip == null || !TransportUtil.isValidPort(port) || !this.isValid(ip) || Arrays.equals(ip, this.getExternalIP()) && !this.allowLocal()) {
                    continue;
                }
            } else if (this.getIPv6Config() == TransportUtil.IPv6Config.IPV6_ONLY) continue;
            return addr;
        }
        return null;
    }

    private boolean preferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && !DEFAULT_PREFER_UDP.equals(pref);
    }

    private boolean alwaysPreferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && "always".equals(pref);
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    @Override
    public void send(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        if (msg.getTarget() == null) {
            return;
        }
        if (msg.getTarget().getIdentity() == null) {
            return;
        }
        if (this._establisher == null) {
            this.failed(msg, "UDP not up yet");
            return;
        }
        msg.timestamp("sending on UDP transport");
        Hash to = msg.getTarget().getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending to " + (to != null ? to.toString() : ""));
        }
        if (peer != null) {
            long lastSend = peer.getLastSendFullyTime();
            long lastRecv = peer.getLastReceiveTime();
            long now = this._context.clock().now();
            int inboundActive = peer.expireInboundMessages();
            if (lastSend > 0L && lastRecv > 0L && now - lastSend > 1200000L && now - lastRecv > 1200000L && peer.getConsecutiveFailedSends() > 0 && inboundActive <= 0) {
                this.dropPeer(peer, false, "proactive reconnection");
                msg.timestamp("peer is really idle, dropping con and reestablishing");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Proactive reestablish to " + to);
                }
                this._establisher.establish(msg);
                this._context.statManager().addRateData("udp.proactiveReestablish", now - lastSend, now - peer.getKeyEstablishedTime());
                return;
            }
            msg.timestamp("enqueueing for an already established peer");
            if (this._log.shouldLog(10)) {
                this._log.debug("Add to fragments for " + to);
            }
            this._fragments.add(msg);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Establish new connection to " + to);
            }
            msg.timestamp("establishing a new connection");
            this._establisher.establish(msg);
        }
    }

    void sendIfEstablished(OutNetMessage msg) {
        this._fragments.add(msg);
    }

    void send(I2NPMessage msg, PeerState peer) {
        block3: {
            try {
                OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting a data message to a new peer: " + peer);
                }
                this._fragments.add(state, peer);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Shouldnt happen", new Exception("I did it"));
            }
        }
    }

    void send(I2NPMessage msg, List<OutNetMessage> msgs, PeerState peer) {
        block5: {
            try {
                int sz = msgs.size();
                ArrayList<OutboundMessageState> states = new ArrayList<OutboundMessageState>(sz + 1);
                if (msg != null) {
                    OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
                    states.add(state);
                }
                for (int i = 0; i < sz; ++i) {
                    OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msgs.get(i), peer);
                    states.add(state);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting " + states.size() + " data messages to a new peer: " + peer);
                }
                this._fragments.add(states, peer);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block5;
                this._log.warn("Shouldnt happen", new Exception("I did it"));
            }
        }
    }

    void send(List<I2NPMessage> msgs, PeerState peer) {
        block4: {
            try {
                int sz = msgs.size();
                ArrayList<OutboundMessageState> states = new ArrayList<OutboundMessageState>(sz);
                for (int i = 0; i < sz; ++i) {
                    OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msgs.get(i), peer);
                    states.add(state);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting " + sz + " data messages to a new peer: " + peer);
                }
                this._fragments.add(states, peer);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Shouldnt happen", new Exception("I did it"));
            }
        }
    }

    @Override
    protected void outboundMessageReady() {
        throw new UnsupportedOperationException("Not used for UDP");
    }

    @Override
    public void startListening() {
        this.startup();
    }

    @Override
    public void stopListening() {
        this.shutdown();
        this.replaceAddress(null);
    }

    private boolean explicitAddressSpecified() {
        String h = this._context.getProperty(PROP_EXTERNAL_HOST);
        return h != null && h.length() > 0;
    }

    @Override
    public List<RouterAddress> updateAddress() {
        this.rebuildExternalAddress(false);
        return this.getCurrentAddresses();
    }

    private RouterAddress rebuildExternalAddress() {
        if (this._log.shouldLog(10)) {
            this._log.debug("REA1");
        }
        return this.rebuildExternalAddress(true);
    }

    private RouterAddress rebuildExternalAddress(boolean allowRebuildRouterInfo) {
        RouterAddress cur;
        if (this._log.shouldLog(10)) {
            this._log.debug("REA2 " + allowRebuildRouterInfo);
        }
        int port = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        Object ip = null;
        String host = null;
        if (this.explicitAddressSpecified()) {
            host = this._context.getProperty(PROP_EXTERNAL_HOST);
            if (host != null) {
                String[] hosts = DataHelper.split(host, "[,; \r\n\t]");
                RouterAddress rv = null;
                for (int i = 0; i < hosts.length; ++i) {
                    String h = hosts[i];
                    if (h.length() <= 0) continue;
                    rv = this.rebuildExternalAddress(h, port, allowRebuildRouterInfo);
                }
                return rv;
            }
        } else if (!this.introducersRequired() && (cur = this.getCurrentExternalAddress(false)) != null) {
            host = cur.getHost();
        }
        return this.rebuildExternalAddress(host, port, allowRebuildRouterInfo);
    }

    private RouterAddress rebuildExternalAddress(byte[] ip, int port, boolean allowRebuildRouterInfo) {
        if (this._log.shouldLog(10)) {
            this._log.debug("REA3 " + Addresses.toString(ip, port));
        }
        if (ip == null) {
            return this.rebuildExternalAddress((String)null, port, allowRebuildRouterInfo);
        }
        if (this.isValid(ip)) {
            return this.rebuildExternalAddress(Addresses.toString(ip), port, allowRebuildRouterInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterAddress rebuildExternalAddress(String host, int port, boolean allowRebuildRouterInfo) {
        Object object = this._rebuildLock;
        synchronized (object) {
            return this.locked_rebuildExternalAddress(host, port, allowRebuildRouterInfo);
        }
    }

    private RouterAddress locked_rebuildExternalAddress(String host, int port, boolean allowRebuildRouterInfo) {
        int mtu;
        boolean directIncluded;
        boolean introducersRequired;
        if (this._log.shouldLog(10)) {
            this._log.debug("REA4 " + host + ':' + port);
        }
        if (this._context.router().isHidden()) {
            return null;
        }
        OrderedProperties options = new OrderedProperties();
        boolean isIPv6 = host != null && host.contains(":");
        boolean bl = introducersRequired = !isIPv6 && this.introducersRequired();
        if (!introducersRequired && this.allowDirectUDP() && port > 0 && host != null) {
            options.setProperty("port", String.valueOf(port));
            options.setProperty("host", host);
            directIncluded = true;
        } else {
            directIncluded = false;
        }
        boolean introducersIncluded = false;
        if (introducersRequired) {
            int found = this._introManager.pickInbound(options, 3);
            if (found > 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Direct? " + directIncluded + " reqd? " + introducersRequired + " picked introducers: " + found);
                }
                this._introducersSelectedOn = this._context.clock().now();
                introducersIncluded = true;
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Direct? " + directIncluded + " reqd? " + introducersRequired + " no introducers");
            }
        }
        if (introducersRequired) {
            options.setProperty("caps", CAP_TESTING);
        } else {
            options.setProperty("caps", CAP_TESTING_INTRO);
        }
        if (host == null) {
            mtu = this._mtu;
        } else {
            try {
                InetAddress ia = InetAddress.getByName(host);
                mtu = this.setMTU(ia);
            }
            catch (UnknownHostException uhe) {
                mtu = this._mtu;
            }
        }
        if (mtu < 1484) {
            options.setProperty("mtu", Integer.toString(mtu));
        }
        if (directIncluded || introducersIncluded) {
            RouterAddress current;
            RouterAddress addr;
            boolean wantsRebuild;
            if (this._introKey != null) {
                options.setProperty("key", this._introKey.toBase64());
            }
            int cost = 5;
            if (!this.haveCapacity(91)) {
                ++cost;
            }
            if (introducersIncluded) {
                cost += 2;
            }
            if (isIPv6) {
                TransportUtil.IPv6Config config = this.getIPv6Config();
                if (config == TransportUtil.IPv6Config.IPV6_PREFERRED) {
                    --cost;
                } else if (config == TransportUtil.IPv6Config.IPV6_NOT_PREFERRED) {
                    ++cost;
                }
            }
            boolean bl2 = wantsRebuild = !(addr = new RouterAddress(STYLE, options, cost)).deepEquals(current = this.getCurrentAddress(isIPv6));
            if (port > 0 && host != null) {
                RouterAddress local;
                if (directIncluded) {
                    local = addr;
                } else {
                    OrderedProperties localOpts = new OrderedProperties();
                    localOpts.setProperty("port", String.valueOf(port));
                    localOpts.setProperty("host", host);
                    local = new RouterAddress(STYLE, localOpts, cost);
                }
                this.replaceCurrentExternalAddress(local, isIPv6);
            }
            if (wantsRebuild) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Address rebuilt: " + addr, new Exception());
                }
                this.replaceAddress(addr);
                if (allowRebuildRouterInfo) {
                    this._context.router().rebuildRouterInfo();
                }
            } else {
                addr = null;
            }
            if (!isIPv6) {
                this._needsRebuild = false;
            }
            return addr;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Wanted to rebuild my SSU address, but couldn't specify either the direct or indirect info (needs introducers? " + introducersRequired + ")", new Exception("source"));
        }
        this._needsRebuild = true;
        if (port > 0 && host != null) {
            OrderedProperties localOpts = new OrderedProperties();
            localOpts.setProperty("port", String.valueOf(port));
            localOpts.setProperty("host", host);
            RouterAddress local = new RouterAddress(STYLE, localOpts, 5);
            this.replaceCurrentExternalAddress(local, isIPv6);
        }
        if (this.hasCurrentAddress()) {
            this.removeAddress(false);
            if (allowRebuildRouterInfo) {
                this._context.router().rebuildRouterInfo();
            }
        }
        return null;
    }

    private void replaceCurrentExternalAddress(RouterAddress ra, boolean isIPv6) {
        if (isIPv6) {
            this._currentOurV6Address = ra;
        } else {
            this._currentOurV4Address = ra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterAddress getCurrentExternalAddress(boolean isIPv6) {
        Object object = this._rebuildLock;
        synchronized (object) {
            return isIPv6 ? this._currentOurV6Address : this._currentOurV4Address;
        }
    }

    @Override
    protected void replaceAddress(RouterAddress address) {
        super.replaceAddress(address);
        this._context.commSystem().notifyReplaceAddress(address);
    }

    @Override
    protected void removeAddress(RouterAddress address) {
        super.removeAddress(address);
        this._context.commSystem().notifyRemoveAddress(address);
    }

    @Override
    protected void removeAddress(boolean ipv6) {
        super.removeAddress(ipv6);
        if (ipv6) {
            this._lastInboundIPv6 = 0L;
        }
        this._context.commSystem().notifyRemoveAddress(ipv6);
    }

    public boolean introducersRequired() {
        CommSystemFacade.Status status = this.getReachabilityStatus();
        switch (status) {
            case REJECT_UNSOLICITED: 
            case DIFFERENT: 
            case IPV4_FIREWALLED_IPV6_OK: 
            case IPV4_FIREWALLED_IPV6_UNKNOWN: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Require introducers, because our status is " + (Object)((Object)status));
                }
                return true;
            }
        }
        if (!this.allowDirectUDP()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Require introducers, because we do not allow direct UDP connections");
            }
            return true;
        }
        return false;
    }

    boolean introducersMaybeRequired() {
        CommSystemFacade.Status status = this.getReachabilityStatus();
        switch (status) {
            case REJECT_UNSOLICITED: 
            case DIFFERENT: 
            case IPV4_FIREWALLED_IPV6_OK: 
            case IPV4_FIREWALLED_IPV6_UNKNOWN: 
            case IPV4_UNKNOWN_IPV6_OK: 
            case IPV4_UNKNOWN_IPV6_FIREWALLED: 
            case UNKNOWN: {
                return true;
            }
        }
        return !this.allowDirectUDP();
    }

    boolean canIntroduce() {
        return !this._context.router().isHidden() && !this.introducersRequired() && this.haveCapacity() && !this._context.netDb().floodfillEnabled() && this._introManager.introducedCount() < 100 && this._introManager.introducedCount() < this.getMaxConnections() / 4;
    }

    private boolean allowDirectUDP() {
        return this._context.getBooleanPropertyDefaultTrue(PROP_ALLOW_DIRECT);
    }

    String getPacketHandlerStatus() {
        PacketHandler handler = this._handler;
        if (handler != null) {
            return handler.getHandlerStatus();
        }
        return "";
    }

    PacketHandler getPacketHandler() {
        return this._handler;
    }

    public void failed(OutboundMessageState msg) {
        this.failed(msg, true);
    }

    void failed(OutboundMessageState msg, boolean allowPeerFailure) {
        if (msg == null) {
            return;
        }
        OutNetMessage m = msg.getMessage();
        if (allowPeerFailure && msg.getPeer() != null && (msg.getMaxSends() >= 10 || msg.isExpired())) {
            int consecutive = msg.getPeer().incrementConsecutiveFailedSends();
            if (this._log.shouldLog(20)) {
                this._log.info("Consecutive failure #" + consecutive + " on " + msg.toString() + " to " + msg.getPeer());
            }
            if (this._context.clock().now() - msg.getPeer().getLastSendFullyTime() > 60000L && consecutive >= 5) {
                this._context.statManager().addRateData("udp.dropPeerConsecutiveFailures", consecutive, msg.getPeer().getInactivityTime());
                this.sendDestroy(msg.getPeer());
                this.dropPeer(msg.getPeer(), false, "too many failures");
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Failed sending " + msg + " to " + msg.getPeer());
        }
        this.noteSend(msg, false);
        if (m != null) {
            super.afterSend(m, false);
        }
    }

    private void noteSend(OutboundMessageState msg, boolean successful) {
        if (!this._context.messageHistory().getDoLog()) {
            return;
        }
        int pushCount = msg.getPushCount();
        int sends = msg.getMaxSends();
        boolean expired = msg.isExpired();
        OutNetMessage m = msg.getMessage();
        PeerState p = msg.getPeer();
        StringBuilder buf = new StringBuilder(64);
        buf.append(" lifetime: ").append(msg.getLifetime());
        buf.append(" sends: ").append(sends);
        buf.append(" pushes: ").append(pushCount);
        buf.append(" expired? ").append(expired);
        buf.append(" unacked: ").append(msg.getUnackedSize());
        if (p != null && !successful) {
            buf.append(" consec_failed: ").append(p.getConsecutiveFailedSends());
            long timeSinceSend = this._context.clock().now() - p.getLastSendFullyTime();
            buf.append(" lastFullSend: ").append(timeSinceSend);
            long timeSinceRecv = this._context.clock().now() - p.getLastReceiveTime();
            buf.append(" lastRecv: ").append(timeSinceRecv);
            buf.append(" xfer: ").append(p.getSendBps()).append("/").append(p.getReceiveBps());
            buf.append(" mtu: ").append(p.getMTU());
            buf.append(" rto: ").append(p.getRTO());
            buf.append(" sent: ").append(p.getMessagesSent()).append("/").append(p.getPacketsTransmitted());
            buf.append(" recv: ").append(p.getMessagesReceived()).append("/").append(p.getPacketsReceived());
            buf.append(" uptime: ").append(this._context.clock().now() - p.getKeyEstablishedTime());
        }
        if (m != null && p != null) {
            this._context.messageHistory().sendMessage(m.getMessageType(), msg.getMessageId(), m.getExpiration(), p.getRemotePeer(), successful, buf.toString());
        } else {
            this._context.messageHistory().sendMessage("establish", msg.getMessageId(), -1L, p != null ? p.getRemotePeer() : null, successful, buf.toString());
        }
    }

    @Override
    public void failed(OutNetMessage msg, String reason) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Send failed: " + reason + " msg: " + msg, new Exception("failed from"));
        }
        if (this._context.messageHistory().getDoLog()) {
            this._context.messageHistory().sendMessage(msg.getMessageType(), msg.getMessageId(), msg.getExpiration(), msg.getTarget().getIdentity().calculateHash(), false, reason);
        }
        super.afterSend(msg, false);
    }

    public void succeeded(OutboundMessageState msg) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending message succeeded: " + msg);
        }
        this.noteSend(msg, true);
        OutNetMessage m = msg.getMessage();
        if (m != null) {
            super.afterSend(m, true);
        }
    }

    @Override
    public int countPeers() {
        return this._peersByIdent.size();
    }

    @Override
    public int countActivePeers() {
        long old = this._context.clock().now() - 300000L;
        int active = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if ((peer.getMessagesReceived() <= 0 || peer.getLastReceiveTime() < old) && (peer.getMessagesSent() <= 0 || peer.getLastSendTime() < old)) continue;
            ++active;
        }
        return active;
    }

    @Override
    public int countActiveSendPeers() {
        long old = this._context.clock().now() - 60000L;
        int active = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if (peer.getLastSendFullyTime() < old) continue;
            ++active;
        }
        return active;
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return this.getPeerState(dest) != null;
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        PeerState peer = this._peersByIdent.get(dest);
        return peer != null && peer.isBacklogged();
    }

    @Override
    public void mayDisconnect(Hash peer) {
        PeerState ps = this._peersByIdent.get(peer);
        if (ps != null && ps.getWeRelayToThemAs() <= 0L && (ps.getTheyRelayToUsAs() <= 0L || ps.getIntroducerTime() < this._context.clock().now() - 0x6DDD00L) && ps.getMessagesReceived() <= 2 && ps.getMessagesSent() <= 2) {
            ps.setMayDisconnect();
        }
    }

    public boolean allowConnection() {
        return this._peersByIdent.size() < this.getMaxConnections();
    }

    @Override
    public Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        boolean includeEverybody = this._context.router().getUptime() < 600000L || this._peersByIdent.size() < 10;
        long now = this._context.clock().now();
        for (PeerState peer : this._peersByIdent.values()) {
            if (!includeEverybody && now - peer.getLastReceiveTime() > 300000L || peer.getRTT() > 1250) continue;
            skews.addElement(peer.getClockSkew() / 1000L);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("UDP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    DHSessionKeyBuilder getDHBuilder() {
        return this._dhFactory.getBuilder();
    }

    DHSessionKeyBuilder.Factory getDHFactory() {
        return this._dhFactory;
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<PeerState> peers = new TreeSet<PeerState>(Sorters.getComparator(sortFlags));
        peers.addAll(this._peersByIdent.values());
        long offsetTotal = 0L;
        int bpsIn = 0;
        int bpsOut = 0;
        long uptimeMsTotal = 0L;
        long cwinTotal = 0L;
        long rttTotal = 0L;
        long rtoTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        long resentTotal = 0L;
        long dupRecvTotal = 0L;
        int numPeers = 0;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"udpcon\">").append(this._t("UDP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._t("Limit")).append(": ").append(this.getMaxConnections());
        buf.append(". ").append(this._t("Timeout")).append(": ").append(DataHelper.formatDuration2(this._expireTimeout));
        if (this._context.getBooleanProperty(PROP_ADVANCED)) {
            buf.append(". ").append(this._t("Status")).append(": ").append(this._t(this._reachabilityStatus.toStatusString()));
        }
        buf.append(".</h3>\n");
        buf.append("<table>\n");
        buf.append("<tr><th class=\"smallhead\" nowrap><a href=\"#def.peer\">").append(this._t("Peer")).append("</a><br>");
        if (sortFlags != 0) {
            Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by peer hash"), 0);
        }
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dir\" title=\"").append(this._t("Direction/Introduction")).append("\">").append(this._t("Dir")).append("</a></th><th class=\"smallhead\" nowrap><a href=\"#def.ipv6\">").append(this._t("IPv6")).append("</a></th><th class=\"smallhead\" nowrap><a href=\"#def.idle\">").append(this._t("Idle")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by idle inbound"), 1);
        buf.append(THINSP);
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by idle outbound"), 2);
        buf.append("</th>");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.rate\">").append(this._t("In/Out")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by inbound rate"), 3);
        buf.append(THINSP);
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by outbound rate"), 4);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.up\">").append(this._t("Up")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by connection uptime"), 16);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.skew\">").append(this._t("Skew")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by clock skew"), 5);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.cwnd\">CWND</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by congestion window"), 6);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.ssthresh\">SST</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by slow start threshold"), 7);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.rtt\">RTT</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by round trip time"), 8);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.rto\">RTO</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by retransmission timeout"), 10);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.mtu\">MTU</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by outbound maximum transmit unit"), 11);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.send\">").append(this._t("TX")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets sent"), 12);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.recv\">").append(this._t("RX")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets received"), 13);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.resent\">").append(this._t("Dup TX")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets retransmitted"), 14);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dupRecv\">").append(this._t("Dup RX")).append("</a><br>");
        Sorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets received more than once"), 15);
        buf.append("</th></tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            int cfs;
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer.getRemotePeer()));
            buf.append("</td><td class=\"cells\" nowrap align=\"left\">");
            if (peer.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._t("Inbound")).append("\">");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._t("Outbound")).append("\">");
            }
            if (peer.getWeRelayToThemAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" height=\"8\" width=\"12\" alt=\"^\" title=\"").append(this._t("We offered to introduce them")).append("\">");
            }
            if (peer.getTheyRelayToUsAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" height=\"8\" width=\"12\" alt=\"V\" title=\"").append(this._t("They offered to introduce us")).append("\">");
            }
            boolean appended = false;
            if (this._activeThrottle.isChoked(peer.getRemotePeer())) {
                buf.append("<br><i>").append(this._t("Choked")).append("</i>");
                appended = true;
            }
            if ((cfs = peer.getConsecutiveFailedSends()) > 0) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>");
                if (cfs == 1) {
                    buf.append(this._t("1 fail"));
                } else {
                    buf.append(this._t("{0} fails", cfs));
                }
                buf.append("</i>");
                appended = true;
            }
            if (this._context.banlist().isBanlisted(peer.getRemotePeer(), STYLE)) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>").append(this._t("Banned")).append("</i>");
                appended = true;
            }
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"center\">");
            if (peer.isIPv6()) {
                buf.append("&#x2713;");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td>");
            long idleIn = Math.max(now - peer.getLastReceiveTime(), 0L);
            long idleOut = Math.max(now - peer.getLastSendTime(), 0L);
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(idleIn));
            buf.append(THINSP);
            buf.append(DataHelper.formatDuration2(idleOut));
            buf.append("</td>");
            int recvBps = idleIn > 15000L ? 0 : peer.getReceiveBps();
            int sendBps = idleOut > 15000L ? 0 : peer.getSendBps();
            buf.append("<td class=\"cells\" align=\"right\" nowrap>");
            buf.append(UDPTransport.formatKBps(recvBps));
            buf.append(THINSP);
            buf.append(UDPTransport.formatKBps(sendBps));
            buf.append("</td>");
            long uptime = now - peer.getKeyEstablishedTime();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(uptime));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            long skew = peer.getClockSkew();
            buf.append(DataHelper.formatDuration2(skew));
            buf.append("</td>");
            offsetTotal += skew;
            long sendWindow = peer.getSendWindowBytes();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sendWindow / 1024L);
            buf.append("K");
            buf.append(THINSP).append(peer.getConcurrentSends());
            buf.append(THINSP).append(peer.getConcurrentSendWindow());
            buf.append(THINSP).append(peer.getConsecutiveSendRejections());
            if (peer.isBacklogged()) {
                buf.append(' ').append(this._t("backlogged"));
            }
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getSlowStartThreshold() / 1024);
            buf.append("K</td>");
            int rtt = peer.getRTT();
            int rto = peer.getRTO();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(rtt));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(rto));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getMTU()).append(THINSP).append(peer.getReceiveMTU());
            buf.append("</td>");
            long sent = peer.getMessagesSent();
            long recv = peer.getMessagesReceived();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(recv);
            buf.append("</td>");
            long resent = peer.getPacketsRetransmitted();
            long dupRecv = peer.getPacketsReceivedDuplicate();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(resent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(dupRecv);
            buf.append("</td>");
            buf.append("</tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
            bpsIn += recvBps;
            bpsOut += sendBps;
            uptimeMsTotal += uptime;
            cwinTotal += sendWindow;
            rttTotal += (long)rtt;
            rtoTotal += (long)rto;
            sendTotal += sent;
            recvTotal += recv;
            resentTotal += resent;
            dupRecvTotal += dupRecv;
            ++numPeers;
        }
        if (numPeers > 0) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"4\" align=\"left\"><b>").append(this.ngettext("{0} peer", "{0} peers", peers.size())).append("</b></td><td align=\"center\" nowrap><b>");
            buf.append(UDPTransport.formatKBps(bpsIn)).append(THINSP).append(UDPTransport.formatKBps(bpsOut));
            long x = uptimeMsTotal / (long)numPeers;
            buf.append("</b></td><td align=\"center\"><b>").append(DataHelper.formatDuration2(x));
            x = offsetTotal / (long)numPeers;
            buf.append("</b></td><td align=\"center\"><b>").append(DataHelper.formatDuration2(x)).append("</b></td>\n<td align=\"center\"><b>");
            buf.append(cwinTotal / (long)(numPeers * 1024) + "K");
            buf.append("</b></td><td>&nbsp;</td>\n<td align=\"center\"><b>");
            buf.append(DataHelper.formatDuration2(rttTotal / (long)numPeers));
            buf.append("</b></td><td align=\"center\"><b>");
            buf.append(DataHelper.formatDuration2(rtoTotal / (long)numPeers));
            buf.append("</b></td><td align=\"center\"><b>").append(this._mtu).append("</b></td><td align=\"center\"><b>");
            buf.append(sendTotal).append("</b></td><td align=\"center\"><b>").append(recvTotal).append("</b></td>\n<td align=\"center\"><b>").append(resentTotal);
            buf.append("</b></td><td align=\"center\"><b>").append(dupRecvTotal).append("</b></td></tr>\n");
            if (sortFlags == 99) {
                buf.append("<tr><td colspan=\"16\">");
                buf.append("peersByIdent: ").append(this._peersByIdent.size());
                buf.append(" peersByRemoteHost: ").append(this._peersByRemoteHost.size());
                int dir = 0;
                int indir = 0;
                for (RemoteHostId rhi : this._peersByRemoteHost.keySet()) {
                    if (rhi.getIP() != null) {
                        ++dir;
                        continue;
                    }
                    ++indir;
                }
                buf.append(" pBRH direct: ").append(dir).append(" indirect: ").append(indir);
                buf.append("</td></tr>");
            }
        }
        buf.append("</table>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatKBps(int bps) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format((float)bps / 1024.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReachabilityStatus(CommSystemFacade.Status status) {
        Object object = this._rebuildLock;
        synchronized (object) {
            this.locked_setReachabilityStatus(status);
        }
    }

    private void locked_setReachabilityStatus(CommSystemFacade.Status newStatus) {
        CommSystemFacade.Status old = this._reachabilityStatus;
        CommSystemFacade.Status status = CommSystemFacade.Status.merge(old, newStatus);
        this._testEvent.setLastTested();
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
            if (status == CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK) {
                status = CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK;
            } else if (status == CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED) {
                status = CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED;
            } else if (status == CommSystemFacade.Status.UNKNOWN) {
                status = CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN;
            }
        }
        if (status != CommSystemFacade.Status.UNKNOWN) {
            if (this._currentOurV6Address == null) {
                if (status == CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN) {
                    status = CommSystemFacade.Status.OK;
                } else if (status == CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN) {
                    status = CommSystemFacade.Status.REJECT_UNSOLICITED;
                } else if (status == CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN) {
                    status = CommSystemFacade.Status.DIFFERENT;
                } else if (status == CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK) {
                    status = CommSystemFacade.Status.REJECT_UNSOLICITED;
                } else if (status == CommSystemFacade.Status.IPV4_SNAT_IPV6_OK) {
                    status = CommSystemFacade.Status.DIFFERENT;
                }
            }
            if (status != old) {
                long now;
                this._reachabilityStatusUnchanged = 0;
                this._reachabilityStatusLastUpdated = now = this._context.clock().now();
                this._reachabilityStatus = status;
            } else {
                ++this._reachabilityStatusUnchanged;
            }
        }
        if (status != old) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Old status: " + (Object)((Object)old) + " New status: " + (Object)((Object)status) + " Caused by update: " + (Object)((Object)newStatus) + " from: ", new Exception("traceback"));
            }
            if (old != CommSystemFacade.Status.UNKNOWN) {
                this._context.router().eventLog().addEvent("reachability", "from " + this._t(old.toStatusString()) + " to " + this._t(status.toStatusString()));
            }
            this.rebuildExternalAddress();
        } else if (this._log.shouldLog(20)) {
            this._log.info("Status unchanged: " + (Object)((Object)this._reachabilityStatus) + " after update: " + (Object)((Object)newStatus) + " (unchanged " + this._reachabilityStatusUnchanged + " consecutive times), last updated " + DataHelper.formatDuration(this._context.clock().now() - this._reachabilityStatusLastUpdated) + " ago");
        }
    }

    @Override
    public CommSystemFacade.Status getReachabilityStatus() {
        String override = this._context.getProperty(PROP_REACHABILITY_STATUS_OVERRIDE);
        if (override != null) {
            if ("ok".equals(override)) {
                return CommSystemFacade.Status.OK;
            }
            if ("err-reject".equals(override)) {
                return CommSystemFacade.Status.REJECT_UNSOLICITED;
            }
            if ("err-different".equals(override)) {
                return CommSystemFacade.Status.DIFFERENT;
            }
        }
        return this._reachabilityStatus;
    }

    @Override
    @Deprecated
    public void recheckReachability() {
    }

    PeerState pickTestPeer(PeerTestState.Role peerRole, RemoteHostId dontInclude) {
        if (peerRole == PeerTestState.Role.ALICE) {
            throw new IllegalArgumentException();
        }
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._peersByIdent.values());
        RandomIterator<PeerState> iter = new RandomIterator<PeerState>(peers);
        while (iter.hasNext()) {
            RouterAddress addr;
            RouterInfo peerInfo;
            PeerState peer = (PeerState)iter.next();
            if (dontInclude != null && dontInclude.equals(peer.getRemoteHostId())) continue;
            byte[] ip = peer.getRemoteIP();
            if (peerRole == PeerTestState.Role.BOB && ip.length != 4 || (peerInfo = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer())) == null) continue;
            ip = null;
            List<RouterAddress> addrs = this.getTargetAddresses(peerInfo);
            Iterator<RouterAddress> i$ = addrs.iterator();
            while (i$.hasNext() && ((ip = (addr = i$.next()).getIP()) == null || ip.length != 4)) {
            }
            if (ip == null || this.isTooClose(ip)) continue;
            return peer;
        }
        return null;
    }

    private boolean shouldTest() {
        return !this._context.router().isHidden() && !this.isIPv4Firewalled();
    }

    private class ExpirePeerEvent
    extends SimpleTimer2.TimedEvent {
        private final Set<PeerState> _expirePeers;
        private final List<PeerState> _expireBuffer;
        private volatile boolean _alive;
        private int _runCount;
        private boolean _lastLoopShort;
        private static final long PING_FIREWALL_TIME = 30000L;
        private static final long PING_FIREWALL_CUTOFF = 15000L;
        private static final int SLICES = 4;
        private static final long SHORT_LOOP_TIME = 3000L;
        private static final long LONG_LOOP_TIME = 25000L;
        private static final long EXPIRE_INCREMENT = 15000L;
        private static final long EXPIRE_DECREMENT = 45000L;
        private static final long MAY_DISCON_TIMEOUT = 10000L;

        public ExpirePeerEvent() {
            super(UDPTransport.this._context.simpleTimer2());
            this._expirePeers = new ConcurrentHashSet<PeerState>(128);
            this._expireBuffer = new ArrayList<PeerState>();
        }

        @Override
        public void timeReached() {
            boolean shortLoop;
            boolean haveCap = UDPTransport.this.haveCapacity(33);
            if (haveCap) {
                long inc = this._lastLoopShort ? 1800L : 15000L;
                UDPTransport.this._expireTimeout = Math.min(UDPTransport.this._expireTimeout + inc, 1200000L);
            } else {
                long dec = this._lastLoopShort ? 5400L : 45000L;
                UDPTransport.this._expireTimeout = Math.max(UDPTransport.this._expireTimeout - dec, 165000L);
            }
            long now = UDPTransport.this._context.clock().now();
            long shortInactivityCutoff = now - UDPTransport.this._expireTimeout;
            long longInactivityCutoff = now - 1200000L;
            long mayDisconCutoff = now - 10000L;
            long pingCutoff = now - 0x6DDD00L;
            long pingFirewallCutoff = now - 15000L;
            boolean shouldPingFirewall = UDPTransport.this._reachabilityStatus != CommSystemFacade.Status.OK;
            int currentListenPort = UDPTransport.this.getListenPort(false);
            boolean pingOneOnly = shouldPingFirewall && UDPTransport.this.getExternalPort(false) == currentListenPort;
            this._lastLoopShort = shortLoop = shouldPingFirewall || !haveCap || UDPTransport.this._context.netDb().floodfillEnabled();
            this._expireBuffer.clear();
            ++this._runCount;
            Iterator<PeerState> iter = this._expirePeers.iterator();
            while (iter.hasNext()) {
                long inactivityCutoff;
                PeerState peer = iter.next();
                if (peer.getWeRelayToThemAs() > 0L || peer.getIntroducerTime() > pingCutoff) {
                    inactivityCutoff = longInactivityCutoff;
                } else if (!(haveCap && peer.isInbound() || !peer.getMayDisconnect() || peer.getMessagesReceived() > 2 || peer.getMessagesSent() > 2)) {
                    if (UDPTransport.this._log.shouldInfo()) {
                        UDPTransport.this._log.info("Possible early disconnect for: " + peer);
                    }
                    inactivityCutoff = mayDisconCutoff;
                } else {
                    inactivityCutoff = shortInactivityCutoff;
                }
                if (peer.getLastReceiveTime() < inactivityCutoff && peer.getLastSendTime() < inactivityCutoff) {
                    this._expireBuffer.add(peer);
                    iter.remove();
                    continue;
                }
                if (!shouldPingFirewall || ((this._runCount ^ peer.hashCode()) & 3) != 0 || peer.getLastSendOrPingTime() >= pingFirewallCutoff || peer.getLastReceiveTime() >= pingFirewallCutoff) continue;
                if (UDPTransport.this._log.shouldLog(10)) {
                    UDPTransport.this._log.debug("Pinging for firewall: " + peer);
                }
                UDPTransport.this.send(UDPTransport.this._destroyBuilder.buildPing(peer));
                peer.setLastPingTime(now);
                if (!pingOneOnly) continue;
                shouldPingFirewall = false;
            }
            if (!this._expireBuffer.isEmpty()) {
                if (UDPTransport.this._log.shouldLog(20)) {
                    UDPTransport.this._log.info("Expiring " + this._expireBuffer.size() + " peers");
                }
                for (PeerState peer : this._expireBuffer) {
                    UDPTransport.this.sendDestroy(peer);
                    UDPTransport.this.dropPeer(peer, false, "idle too long");
                }
                this._expireBuffer.clear();
            }
            if (this._alive) {
                this.schedule(shortLoop ? 3000L : 25000L);
            }
        }

        public void add(PeerState peer) {
            this._expirePeers.add(peer);
        }

        public void remove(PeerState peer) {
            this._expirePeers.remove(peer);
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                this.reschedule(25000L);
            } else {
                this.cancel();
                this._expirePeers.clear();
            }
        }
    }

    private class PeerTestEvent
    extends SimpleTimer2.TimedEvent {
        private boolean _alive;
        private final AtomicLong _lastTested;
        private boolean _forceRun;

        PeerTestEvent() {
            super(UDPTransport.this._context.simpleTimer2());
            this._lastTested = new AtomicLong();
        }

        @Override
        public synchronized void timeReached() {
            if (UDPTransport.this.shouldTest()) {
                long sinceRun = UDPTransport.this._context.clock().now() - this._lastTested.get();
                if (this._forceRun && sinceRun >= 45000L || sinceRun >= 780000L) {
                    this.locked_runTest();
                }
            }
            if (this._alive) {
                long delay = 390000 + UDPTransport.this._context.random().nextInt(780000);
                this.schedule(delay);
            }
        }

        private void locked_runTest() {
            PeerState bob = UDPTransport.this.pickTestPeer(PeerTestState.Role.BOB, null);
            if (bob != null) {
                if (UDPTransport.this._log.shouldLog(20)) {
                    UDPTransport.this._log.info("Running periodic test with bob = " + bob);
                }
                UDPTransport.this._testManager.runTest(bob.getRemoteIPAddress(), bob.getRemotePort(), bob.getCurrentCipherKey(), bob.getCurrentMACKey());
                this.setLastTested();
            } else if (UDPTransport.this._log.shouldLog(30)) {
                UDPTransport.this._log.warn("Unable to run a periodic test, as there are no peers with the capacity required");
            }
            this._forceRun = false;
        }

        public synchronized void forceRunSoon() {
            if (UDPTransport.this.isIPv4Firewalled()) {
                return;
            }
            this._forceRun = true;
            this.reschedule(45000L);
        }

        public synchronized void forceRunImmediately() {
            if (UDPTransport.this.isIPv4Firewalled()) {
                return;
            }
            this._lastTested.set(0L);
            this._forceRun = true;
            this.reschedule(5000L);
        }

        public synchronized void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                long delay = UDPTransport.this._context.random().nextInt(1560000);
                this.reschedule(delay);
            } else {
                this.cancel();
            }
        }

        public void setLastTested() {
            this._lastTested.set(UDPTransport.this._context.clock().now());
        }
    }

    private class PingIntroducers
    implements SimpleTimer.TimedEvent {
        private PingIntroducers() {
        }

        @Override
        public void timeReached() {
            if (UDPTransport.this.introducersRequired()) {
                UDPTransport.this._introManager.pingIntroducers();
            }
        }
    }

    private class RemoveDropList
    implements SimpleTimer.TimedEvent {
        private final RemoteHostId _peer;

        public RemoveDropList(RemoteHostId peer) {
            this._peer = peer;
        }

        @Override
        public void timeReached() {
            UDPTransport.this._dropList.remove(this._peer);
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        @Override
        public Transport getTransport() {
            return UDPTransport.this;
        }

        public String toString() {
            return "UDP bid @ " + this.getLatencyMs();
        }
    }
}

