/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class ReadConfigJob
extends JobImpl {
    private static final long DELAY = 30000L;
    private long _lastRead;

    public ReadConfigJob(RouterContext ctx) {
        super(ctx);
        this._lastRead = ctx.clock().now();
    }

    @Override
    public String getName() {
        return "Read Router Configuration";
    }

    @Override
    public void runJob() {
        File configFile = new File(this.getContext().router().getConfigFilename());
        if (this.shouldReread(configFile)) {
            this.getContext().router().readConfig();
            this._lastRead = this.getContext().clock().now();
            Log log = this.getContext().logManager().getLog(ReadConfigJob.class);
            if (log.shouldLog(30)) {
                log.warn("Reloaded " + configFile);
            }
        }
        this.requeue(30000L);
    }

    private boolean shouldReread(File configFile) {
        if (!configFile.exists()) {
            return false;
        }
        return configFile.lastModified() > this._lastRead;
    }
}

