/*
 * Decompiled with CFR 0.152.
 */
package aktie.crypto;

import aktie.data.CObj;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.encoders.Base64;

public class Utils {
    public static long CID0 = 81985529216486895L;
    public static long CID1 = 1147797409030816545L;
    public static SecureRandom Random = new SecureRandom();
    public static Random NOTSECURERandom = new Random();
    public static int TIMEFUZZ = 14400000;
    public static final byte[] LASTB = new byte[]{0, -128, -64, -32, -16, -8, -4, -2, -1};
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static long fuzzTime(long l) {
        long l2 = new Date().getTime();
        return Math.max(l2 -= (long)Random.nextInt(TIMEFUZZ), l);
    }

    public static long fuzzTime(CObj ... cObjArray) {
        long l = 0L;
        for (CObj cObj : cObjArray) {
            Long l2;
            if (cObj == null || (l2 = cObj.getNumber(CObj.CREATEDON)) == null) continue;
            l = Math.max(l2, l);
        }
        return Utils.fuzzTime(l + 1L);
    }

    public static AsymmetricCipherKeyPair generateKeyPair() {
        RSAKeyGenerationParameters rSAKeyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), Random, 2048, 40);
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.init((KeyGenerationParameters)rSAKeyGenerationParameters);
        return rSAKeyPairGenerator.generateKeyPair();
    }

    public static KeyParameter generateKey() {
        byte[] byArray = new byte[32];
        Random.nextBytes(byArray);
        return new KeyParameter(byArray);
    }

    public static String stringFromPublicKey(RSAKeyParameters rSAKeyParameters) {
        String string = Utils.toString(rSAKeyParameters.getModulus().toByteArray());
        String string2 = Utils.toString(rSAKeyParameters.getExponent().toByteArray());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(",");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static RSAKeyParameters publicKeyFromString(String string) {
        String[] stringArray = string.split(",");
        byte[] byArray = Utils.toByteArray(stringArray[0]);
        byte[] byArray2 = Utils.toByteArray(stringArray[1]);
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        return new RSAKeyParameters(false, bigInteger, bigInteger2);
    }

    public static String stringFromPrivateKey(RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters) {
        String string = Utils.toString(rSAPrivateCrtKeyParameters.getModulus().toByteArray());
        String string2 = Utils.toString(rSAPrivateCrtKeyParameters.getPublicExponent().toByteArray());
        String string3 = Utils.toString(rSAPrivateCrtKeyParameters.getExponent().toByteArray());
        String string4 = Utils.toString(rSAPrivateCrtKeyParameters.getP().toByteArray());
        String string5 = Utils.toString(rSAPrivateCrtKeyParameters.getQ().toByteArray());
        String string6 = Utils.toString(rSAPrivateCrtKeyParameters.getDP().toByteArray());
        String string7 = Utils.toString(rSAPrivateCrtKeyParameters.getDQ().toByteArray());
        String string8 = Utils.toString(rSAPrivateCrtKeyParameters.getQInv().toByteArray());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(",");
        stringBuilder.append(string2);
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(",");
        stringBuilder.append(string4);
        stringBuilder.append(",");
        stringBuilder.append(string5);
        stringBuilder.append(",");
        stringBuilder.append(string6);
        stringBuilder.append(",");
        stringBuilder.append(string7);
        stringBuilder.append(",");
        stringBuilder.append(string8);
        return stringBuilder.toString();
    }

    public static RSAPrivateCrtKeyParameters privateKeyFromString(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 8) {
            throw new RuntimeException("Invalid private key string format");
        }
        byte[] byArray = Utils.toByteArray(stringArray[0]);
        byte[] byArray2 = Utils.toByteArray(stringArray[1]);
        byte[] byArray3 = Utils.toByteArray(stringArray[2]);
        byte[] byArray4 = Utils.toByteArray(stringArray[3]);
        byte[] byArray5 = Utils.toByteArray(stringArray[4]);
        byte[] byArray6 = Utils.toByteArray(stringArray[5]);
        byte[] byArray7 = Utils.toByteArray(stringArray[6]);
        byte[] byArray8 = Utils.toByteArray(stringArray[7]);
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        BigInteger bigInteger3 = new BigInteger(byArray3);
        BigInteger bigInteger4 = new BigInteger(byArray4);
        BigInteger bigInteger5 = new BigInteger(byArray5);
        BigInteger bigInteger6 = new BigInteger(byArray6);
        BigInteger bigInteger7 = new BigInteger(byArray7);
        BigInteger bigInteger8 = new BigInteger(byArray8);
        return new RSAPrivateCrtKeyParameters(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public static String toString(byte[] byArray) {
        try {
            String string = new String(Base64.encode((byte[])byArray), "UTF-8");
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Could not enocde bytes!");
        }
    }

    public static byte[] stringToByteArray(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Ooops.", unsupportedEncodingException);
        }
    }

    public static String toStringRaw(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Ooops.", unsupportedEncodingException);
        }
    }

    public static byte[] toByteArray(String string) {
        if (string == null) {
            return null;
        }
        return Base64.decode((String)string);
    }

    public static void digBytes(Digest digest, byte[] byArray) {
        digest.update(byArray, 0, byArray.length);
    }

    public static byte[] digBytes(byte[] byArray, byte[] byArray2) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray != null) {
            rIPEMD256Digest.update(byArray, 0, byArray.length);
        } else {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
        }
        rIPEMD256Digest.update(byArray2, 0, byArray2.length);
        rIPEMD256Digest.doFinal(byArray, 0);
        return byArray;
    }

    public static byte[] digBytes(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
        }
        rIPEMD256Digest.update(byArray2, 0, byArray2.length);
        rIPEMD256Digest.update(byArray3, 0, byArray3.length);
        rIPEMD256Digest.doFinal(byArray, 0);
        return byArray2;
    }

    public static byte[] digString(byte[] byArray, String string) {
        try {
            return Utils.digBytes(byArray, string.getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new RuntimeException("Invalid encoding: " + unsupportedEncodingException.getMessage());
        }
    }

    public static void digString(Digest digest, String string) {
        try {
            Utils.digBytes(digest, string.getBytes("UTF-16BE"));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not convert string to bytes.");
        }
    }

    public static void digLong(Digest digest, long l) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putLong(l);
        Utils.digBytes(digest, byArray);
    }

    public static void digDouble(Digest digest, double d) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putDouble(d);
        Utils.digBytes(digest, byArray);
    }

    public static byte[] xorBytes(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new RuntimeException("Must XOR byte arrays the same length.");
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
        return byArray;
    }

    public static byte[] xorBytes(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            byArray = new byte[byArray2.length];
        }
        if (byArray2.length != byArray3.length || byArray2.length != byArray.length) {
            throw new RuntimeException("Must XOR byte arrays the same length.");
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i] = (byte)(byArray2[i] ^ byArray3[i]);
        }
        return byArray;
    }

    public static byte[] digByteMap(byte[] byArray, Map<String, byte[]> map) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
            Arrays.fill(byArray, (byte)0);
        }
        byte[] byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            rIPEMD256Digest.reset();
            Utils.digString((Digest)rIPEMD256Digest, entry.getKey());
            Utils.digBytes((Digest)rIPEMD256Digest, entry.getValue());
            rIPEMD256Digest.doFinal(byArray2, 0);
            Utils.xorBytes(byArray, byArray2);
        }
        return byArray;
    }

    public static byte[] getTarget(long l, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)0);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putLong(l);
        return byArray;
    }

    public static boolean checkDig(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length != byArray2.length) {
            throw new RuntimeException("MASK AND DIG NOT THE SAME LENGTH!");
        }
        for (n = 0; byArray[n] == byArray2[n] && n < byArray.length; ++n) {
        }
        if (n == byArray.length) {
            return true;
        }
        return (0xFF & byArray[n]) < (0xFF & byArray2[n]);
    }

    public static byte[] digStringMap(byte[] byArray, Map<String, String> map) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
            Arrays.fill(byArray, (byte)0);
        }
        byte[] byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        for (Map.Entry<String, String> entry : map.entrySet()) {
            rIPEMD256Digest.reset();
            Utils.digString((Digest)rIPEMD256Digest, entry.getKey());
            Utils.digString((Digest)rIPEMD256Digest, entry.getValue());
            rIPEMD256Digest.doFinal(byArray2, 0);
            Utils.xorBytes(byArray, byArray2);
        }
        return byArray;
    }

    public static byte[] digLongMap(byte[] byArray, Map<String, Long> map) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
            Arrays.fill(byArray, (byte)0);
        }
        byte[] byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            rIPEMD256Digest.reset();
            Utils.digString((Digest)rIPEMD256Digest, entry.getKey());
            Utils.digLong((Digest)rIPEMD256Digest, entry.getValue());
            rIPEMD256Digest.doFinal(byArray2, 0);
            Utils.xorBytes(byArray, byArray2);
        }
        return byArray;
    }

    public static byte[] digLongMap(byte[] byArray, byte[] byArray2, byte[] byArray3, Map<String, Long> map) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray3 == null) {
            byArray3 = new byte[rIPEMD256Digest.getDigestSize()];
            Arrays.fill(byArray3, (byte)0);
        }
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
        }
        if (byArray2 == null) {
            byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        }
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            rIPEMD256Digest.reset();
            Utils.digString((Digest)rIPEMD256Digest, entry.getKey());
            Utils.digLong((Digest)rIPEMD256Digest, entry.getValue());
            rIPEMD256Digest.doFinal(byArray2, 0);
            Utils.xorBytes(byArray, byArray3, byArray2);
        }
        return byArray;
    }

    public static byte[] digStringMap(byte[] byArray, byte[] byArray2, byte[] byArray3, Map<String, String> map) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray3 == null) {
            byArray3 = new byte[rIPEMD256Digest.getDigestSize()];
            Arrays.fill(byArray3, (byte)0);
        }
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
        }
        if (byArray2 == null) {
            byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            rIPEMD256Digest.reset();
            Utils.digString((Digest)rIPEMD256Digest, entry.getKey());
            Utils.digString((Digest)rIPEMD256Digest, entry.getValue());
            rIPEMD256Digest.doFinal(byArray2, 0);
            Utils.xorBytes(byArray, byArray3, byArray2);
        }
        return byArray;
    }

    public static byte[] digDoubleMap(byte[] byArray, Map<String, Double> map) {
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        if (byArray == null) {
            byArray = new byte[rIPEMD256Digest.getDigestSize()];
            Arrays.fill(byArray, (byte)0);
        }
        byte[] byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            rIPEMD256Digest.reset();
            Utils.digString((Digest)rIPEMD256Digest, entry.getKey());
            Utils.digDouble((Digest)rIPEMD256Digest, entry.getValue());
            rIPEMD256Digest.doFinal(byArray2, 0);
            Utils.xorBytes(byArray, byArray2);
        }
        return byArray;
    }

    public static byte[] anonymousSymEncode(KeyParameter keyParameter, long l, long l2, byte[] byArray) {
        int n = 8;
        int n2 = 4;
        byte[] byArray2 = new byte[byArray.length + 2 * n + 2 * n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.putInt(Random.nextInt());
        byteBuffer.putLong(l);
        byteBuffer.putLong(l2);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        CBCBlockCipher cBCBlockCipher = new CBCBlockCipher((BlockCipher)new AESEngine());
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)cBCBlockCipher, (BlockCipherPadding)new PKCS7Padding());
        paddedBufferedBlockCipher.init(true, (CipherParameters)keyParameter);
        try {
            int n3 = paddedBufferedBlockCipher.getOutputSize(byArray2.length);
            byte[] byArray3 = new byte[n3];
            int n4 = paddedBufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
            paddedBufferedBlockCipher.doFinal(byArray3, n4);
            return byArray3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] attemptSymDecode(KeyParameter keyParameter, long l, long l2, byte[] byArray) {
        int n = 8;
        int n2 = 4;
        CBCBlockCipher cBCBlockCipher = new CBCBlockCipher((BlockCipher)new AESEngine());
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)cBCBlockCipher, (BlockCipherPadding)new PKCS7Padding());
        paddedBufferedBlockCipher.init(false, (CipherParameters)keyParameter);
        try {
            int n3 = paddedBufferedBlockCipher.getOutputSize(byArray.length);
            if (n3 > 2 * n + 2 * n2) {
                byte[] byArray2 = new byte[n3];
                int n4 = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
                paddedBufferedBlockCipher.doFinal(byArray2, n4);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                byteBuffer.getInt();
                long l3 = byteBuffer.getLong();
                long l4 = byteBuffer.getLong();
                int n5 = byteBuffer.getInt();
                if (l3 == l && l4 == l2 && n5 <= byteBuffer.remaining()) {
                    byte[] byArray3 = new byte[n5];
                    byteBuffer.get(byArray3);
                    return byArray3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] anonymousAsymEncode(RSAKeyParameters rSAKeyParameters, long l, long l2, byte[] byArray) {
        int n = 8;
        int n2 = 4;
        byte[] byArray2 = new byte[byArray.length + n * 2 + n2 * 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.putInt(Random.nextInt());
        byteBuffer.putLong(l);
        byteBuffer.putLong(l2);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        RSAEngine rSAEngine = new RSAEngine();
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)rSAEngine);
        pKCS1Encoding.init(true, (CipherParameters)rSAKeyParameters);
        try {
            byte[] byArray3 = pKCS1Encoding.processBlock(byArray2, 0, byArray2.length);
            return byArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] attemptAsymDecode(RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters, long l, long l2, byte[] byArray) {
        RSAEngine rSAEngine = new RSAEngine();
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)rSAEngine);
        pKCS1Encoding.init(false, (CipherParameters)rSAPrivateCrtKeyParameters);
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            int n = 8;
            int n2 = 4;
            if (byArray2.length > n * 2 + n2 * 2) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                byteBuffer.getInt();
                long l3 = byteBuffer.getLong();
                long l4 = byteBuffer.getLong();
                int n3 = byteBuffer.getInt();
                if (l3 == l && l4 == l2 && n3 <= byteBuffer.remaining()) {
                    byte[] byArray3 = new byte[n3];
                    byteBuffer.get(byArray3);
                    return byArray3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String mergeIds(String string, String string2) {
        byte[] byArray;
        byte[] byArray2 = Utils.toByteArray(string);
        if (byArray2.length != (byArray = Utils.toByteArray(string2)).length) {
            throw new RuntimeException("Lengths must be equal.");
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(0xFF & byArray2[i] ^ 0xFF & byArray[i]);
        }
        return Utils.toString(byArray2);
    }

    public static String mergeIds(String string, String string2, String string3) {
        byte[] byArray = Utils.toByteArray(string);
        byte[] byArray2 = Utils.toByteArray(string2);
        byte[] byArray3 = Utils.toByteArray(string3);
        if (byArray.length != byArray2.length || byArray.length != byArray3.length) {
            throw new RuntimeException("Lengths must be equal.");
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(0xFF & byArray[i] ^ 0xFF & byArray2[i] ^ 0xFF & byArray3[i]);
        }
        return Utils.toString(byArray);
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        return new String(cArray);
    }
}

