/*
 * Decompiled with CFR 0.152.
 */
package aktie.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Wrapper {
    public static int RESTART_RC = 7;
    public static String VERSION_0115 = "version 0.1.15";
    public static String VERSION_0403 = "version 0.4.3";
    public static String VERSION_0405 = "version 0.4.5";
    public static String VERSION_0417;
    public static String VERSION;
    public static String VERSION_FILE;
    public static long RELEASETIME;
    public static String RUNDIR;
    public static String LIBDIR;

    static {
        VERSION = VERSION_0417 = "version 0.4.17";
        VERSION_FILE = "version.txt";
        RELEASETIME = 1464268165000L;
        RUNDIR = "aktie_run_dir";
        LIBDIR = String.valueOf(RUNDIR) + File.separator + "lib";
    }

    public static void main(String[] args) {
        int rc = RESTART_RC;
        while (rc == RESTART_RC) {
            rc = Wrapper.Main(args);
            System.out.println("RC: " + rc);
        }
    }

    public static int Main(String[] args) {
        File updir;
        File bd;
        boolean verbose = false;
        boolean headless = false;
        int ct = 0;
        while (ct < args.length) {
            if ("-v".equals(args[ct])) {
                verbose = true;
            }
            if ("-headless".equals(args[ct])) {
                headless = true;
            }
            ++ct;
        }
        String systype = System.getProperty("os.name");
        System.out.println("SYS: " + systype);
        File f = new File(RUNDIR);
        boolean setstartonfirst = false;
        boolean usesemi = false;
        if (systype.startsWith("Windows")) {
            usesemi = true;
        }
        if ("Mac OS X".equals(systype)) {
            setstartonfirst = true;
        }
        if (!f.exists() || Wrapper.isNewer()) {
            File destfile;
            File sfile;
            Wrapper.deleteLibDir();
            Wrapper.unZipIt();
            LinkedList<String> cmd = new LinkedList<String>();
            cmd.add("java");
            cmd.add("-version");
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.redirectErrorStream(true);
            pb.command(cmd);
            boolean is64bit = false;
            try {
                Matcher m = Pattern.compile("64-Bit").matcher("");
                Process pc = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(pc.getInputStream()));
                String ln = br.readLine();
                while (ln != null) {
                    m.reset(ln);
                    if (m.find()) {
                        is64bit = true;
                    }
                    ln = br.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (systype.startsWith("Linux")) {
                if (is64bit) {
                    sfile = new File(String.valueOf(RUNDIR) + File.separator + "swt" + File.separator + "swt_linux_64.jar");
                    destfile = new File(String.valueOf(RUNDIR) + File.separator + "lib" + File.separator + "swt_linux_64.jar");
                    sfile.renameTo(destfile);
                } else {
                    sfile = new File(String.valueOf(RUNDIR) + File.separator + "swt" + File.separator + "swt_linux.jar");
                    destfile = new File(String.valueOf(RUNDIR) + File.separator + "lib" + File.separator + "swt_linux.jar");
                    sfile.renameTo(destfile);
                }
            }
            if ("Mac OS X".equals(systype)) {
                sfile = new File(String.valueOf(RUNDIR) + File.separator + "swt" + File.separator + "swt_osx.jar");
                destfile = new File(String.valueOf(RUNDIR) + File.separator + "lib" + File.separator + "swt_osx.jar");
                sfile.renameTo(destfile);
            }
            if (systype.startsWith("Windows")) {
                if (is64bit) {
                    sfile = new File(String.valueOf(RUNDIR) + File.separator + "swt" + File.separator + "swt_win_64.jar");
                    destfile = new File(String.valueOf(RUNDIR) + File.separator + "lib" + File.separator + "swt_win_64.jar");
                    sfile.renameTo(destfile);
                } else {
                    sfile = new File(String.valueOf(RUNDIR) + File.separator + "swt" + File.separator + "swt_win.jar");
                    destfile = new File(String.valueOf(RUNDIR) + File.separator + "lib" + File.separator + "swt_win.jar");
                    sfile.renameTo(destfile);
                }
            }
        }
        if (!f.isDirectory()) {
            System.out.println("Oops.  I sorry.  I thought aktie should be a directory!");
            System.exit(1);
        }
        if (!(bd = new File(String.valueOf(RUNDIR) + File.separator + "bak")).exists()) {
            bd.mkdirs();
        }
        if (!(updir = new File(String.valueOf(RUNDIR) + File.separator + "upgrade")).exists()) {
            updir.mkdirs();
        }
        File[] uplst = updir.listFiles();
        System.out.println("Upgrade list: " + uplst.length);
        int c = 0;
        while (c < uplst.length) {
            File uf = uplst[c];
            String ufn = uf.getName();
            String len = Wrapper.getUpdateLength(ufn);
            String rlen = Long.toString(uf.length());
            System.out.println("Checking length: " + ufn + "  " + rlen + " is expected: " + len);
            if (len != null && len.equals(rlen)) {
                Wrapper.unZipUpgrade(uf);
            }
            Wrapper.saveUpdateLength(ufn, "-1");
            ++c;
        }
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add("java");
        if (setstartonfirst) {
            cmd.add("-XstartOnFirstThread");
        }
        if (systype.startsWith("Linux")) {
            cmd.add("-DSWT_GTK3=0");
        }
        cmd.add("-Xmx256m");
        cmd.add("-cp");
        StringBuilder sb = new StringBuilder();
        File libd = new File(LIBDIR);
        System.out.println("LIST LIBS: " + libd.getPath());
        File[] ll = libd.listFiles();
        if (ll != null && ll.length > 0) {
            sb.append(ll[0]);
            int c2 = 1;
            while (c2 < ll.length) {
                if (ll[c2].getPath().endsWith(".jar")) {
                    if (usesemi) {
                        sb.append(";");
                    } else {
                        sb.append(":");
                    }
                    sb.append(ll[c2]);
                }
                ++c2;
            }
        }
        cmd.add(sb.toString());
        if (!headless) {
            cmd.add("aktie.gui.SWTApp");
        } else {
            cmd.add("aktie.headless.HeadlessMain");
        }
        cmd.add(String.valueOf(RUNDIR) + File.separator + "aktie_node");
        if (verbose) {
            cmd.add("-v");
            System.out.println("SETTING VERBOSE!");
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        pb.command(cmd);
        try {
            Process pc = pb.start();
            pc.getInputStream();
            byte[] buf = new byte[1024];
            InputStream is = pc.getInputStream();
            int ln = is.read(buf);
            while (ln >= 0) {
                if (ln > 0) {
                    System.out.write(buf, 0, ln);
                }
                ln = is.read(buf);
            }
            System.out.println("EXITING..");
            try {
                pc.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return pc.exitValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 99;
        }
    }

    public static int[] convertVersionString(String v) {
        Matcher m;
        if (v != null && (m = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)").matcher(v)).find()) {
            int[] va = new int[]{Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3))};
            System.out.println("VERSION: " + va[0] + "." + va[1] + "." + va[2]);
            return va;
        }
        return new int[3];
    }

    public static int compareVersions(String ol, String nv) {
        int[] oldv = Wrapper.convertVersionString(ol);
        int[] newv = Wrapper.convertVersionString(nv);
        int c = 0;
        while (c < oldv.length) {
            System.out.println("oldv: " + oldv[c] + " newv: " + newv[c]);
            if (oldv[c] > newv[c]) {
                return 1;
            }
            if (oldv[c] < newv[c]) {
                return -1;
            }
            ++c;
        }
        return 0;
    }

    public static boolean isNewer() {
        File vf = new File(String.valueOf(RUNDIR) + File.separator + "aktie_node" + File.separator + VERSION_FILE);
        if (vf.exists()) {
            try {
                FileReader fr = new FileReader(vf);
                BufferedReader br = new BufferedReader(fr);
                String oldstr = br.readLine();
                br.close();
                return Wrapper.compareVersions(oldstr, VERSION) < 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void deleteLibDir() {
        File f = new File(LIBDIR);
        if (f.exists() && f.isDirectory()) {
            File[] fl = f.listFiles();
            int c = 0;
            while (c < fl.length) {
                fl[c].delete();
                ++c;
            }
        }
    }

    public static void unZipIt() {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(RUNDIR);
            if (!folder.exists()) {
                folder.mkdir();
            }
            String fn = URLDecoder.decode(Wrapper.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
            File jarfile = new File(fn);
            ZipInputStream zis = new ZipInputStream(new FileInputStream(jarfile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(String.valueOf(RUNDIR) + File.separator + fileName);
                System.out.println("file unzip : " + newFile.getAbsoluteFile());
                File pd = new File(newFile.getParent());
                pd.mkdirs();
                if (pd.isDirectory() && !ze.isDirectory()) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            System.out.println("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void unZipUpgrade(File upfile) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(LIBDIR);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(upfile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(String.valueOf(LIBDIR) + File.separator + fileName);
                if (fileName.startsWith("swt_") && !newFile.exists()) continue;
                System.out.println("file unzip : " + newFile.getAbsoluteFile());
                File pd = new File(newFile.getParent());
                pd.mkdirs();
                if (pd.isDirectory() && !ze.isDirectory()) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                if ("DELETELIST".equals(fileName)) {
                    BufferedReader br = new BufferedReader(new FileReader(newFile));
                    String ln = br.readLine();
                    while (ln != null) {
                        File df = new File(String.valueOf(LIBDIR) + File.separator + ln);
                        if (df.exists() && !df.delete()) {
                            System.out.println("WARNING: COULD NOT REMOVE " + df + " Please do so manually.");
                        }
                        ln = br.readLine();
                    }
                    br.close();
                    newFile.delete();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            System.out.println("Done Upgrading");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Properties loadExistingProps() {
        Properties p = new Properties();
        File propfile = new File(String.valueOf(RUNDIR) + File.separator + "aktie_node" + File.separator + "aktie.pros");
        if (propfile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(propfile);
                p.load(fis);
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public static void savePropsFile(Properties p) {
        File propfile = new File(String.valueOf(RUNDIR) + File.separator + "aktie_node" + File.separator + "aktie.pros");
        try {
            FileOutputStream fos = new FileOutputStream(propfile);
            p.store(fos, "Aktie properties");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getAutoUpdate() {
        boolean update = true;
        Properties p = Wrapper.loadExistingProps();
        String m = p.getProperty("aktie.update");
        if (m != null) {
            try {
                update = Boolean.valueOf(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return update;
    }

    public static void saveAutoUpdate(boolean u) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.update", Boolean.toString(u));
        Wrapper.savePropsFile(p);
    }

    public static String getLastDevMessage() {
        String msg = "Developer messages.";
        Properties p = Wrapper.loadExistingProps();
        String m = p.getProperty("aktie.developerMessage");
        if (m != null) {
            msg = m;
        }
        return msg;
    }

    public static void saveLastDevMessage(String msg) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.developerMessage", msg);
        Wrapper.savePropsFile(p);
    }

    public static int getStartDestinationDelay() {
        int r = 1200;
        Properties p = Wrapper.loadExistingProps();
        String m = p.getProperty("aktie.startdestdelay");
        if (m != null) {
            try {
                r = Integer.valueOf(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return r;
    }

    public static void setStartDestinationDelay(int d) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.startdestdelay", Integer.toString(d));
        Wrapper.savePropsFile(p);
    }

    public static boolean getStartDestinationsOnStartup() {
        boolean r = true;
        Properties p = Wrapper.loadExistingProps();
        String m = p.getProperty("aktie.startdestonstartup");
        if (m != null) {
            try {
                r = Boolean.valueOf(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return r;
    }

    public void saveStartDestinationOnStartup(boolean s) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.startdestonstartup", Boolean.toString(s));
        Wrapper.savePropsFile(p);
    }

    public static String getUpdateLength(String file) {
        Properties p = Wrapper.loadExistingProps();
        return p.getProperty("length." + file);
    }

    public static void saveUpdateLength(String file, String hash) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("length." + file, hash);
        Wrapper.savePropsFile(p);
    }

    public static boolean getEnabledShareManager() {
        Properties p = Wrapper.loadExistingProps();
        boolean e = true;
        String ep = p.getProperty("aktie.sharemanager.enabled");
        if (ep != null && !"true".equals(ep)) {
            e = false;
        }
        return e;
    }

    public static void saveEnabledShareManager(boolean e) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.sharemanager.enabled", Boolean.toString(e));
        Wrapper.savePropsFile(p);
    }

    public static int getClientPort() {
        Properties p = Wrapper.loadExistingProps();
        int rt = 5789;
        String ep = p.getProperty("aktie.client.port");
        if (ep != null) {
            try {
                rt = Integer.valueOf(ep);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rt;
    }

    public static void saveClientPort(int rt) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.client.port", Integer.toString(rt));
        Wrapper.savePropsFile(p);
    }

    public static String getClientInterface() {
        String msg = "0.0.0.0";
        Properties p = Wrapper.loadExistingProps();
        String m = p.getProperty("aktie.client.interface");
        if (m != null) {
            msg = m;
        }
        return msg;
    }

    public static void saveClientInterface(String msg) {
        Properties p = Wrapper.loadExistingProps();
        p.setProperty("aktie.client.interface", msg);
        Wrapper.savePropsFile(p);
    }
}

