/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.standalone;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.data.DataHelper;
import net.i2p.jetty.JettyStart;

public class RunStandalone {
    private final JettyStart _jettyStart;
    private final I2PAppContext _context;
    private int _port = 8002;
    private String _host = "127.0.0.1";
    private static RunStandalone _instance;
    static final File APP_CONFIG_FILE;

    private RunStandalone(String[] args) throws Exception {
        Properties p = new Properties();
        if (APP_CONFIG_FILE.exists()) {
            try {
                DataHelper.loadProps(p, APP_CONFIG_FILE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._context = new I2PAppContext(p);
        File base = this._context.getBaseDir();
        File xml = new File(base, "jetty-i2psnark.xml");
        this._jettyStart = new JettyStart(this._context, null, new String[]{xml.getAbsolutePath()});
        if (args.length > 1) {
            this._port = Integer.parseInt(args[1]);
        }
        if (args.length > 0) {
            this._host = args[0];
        }
    }

    public static synchronized void main(String[] args) {
        try {
            RunStandalone runner = new RunStandalone(args);
            runner.start();
            _instance = runner;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void start() {
        try {
            this._jettyStart.startup();
            String url = "http://" + this._host + ':' + this._port + "/i2psnark/";
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            UrlLauncher launch = new UrlLauncher(this._context, null, new String[]{url});
            launch.startup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this._jettyStart.shutdown(null);
    }

    public static synchronized void shutdown() {
        if (_instance != null) {
            _instance.stop();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(1);
    }

    static {
        APP_CONFIG_FILE = new File("i2psnark-appctx.config");
    }
}

