/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

public class RequestWrapper {
    private final HttpServletRequest httpRequest;
    private final boolean isMultiPartRequest;
    private final Hashtable<String, String> cache = new Hashtable();
    private Hashtable<String, Integer> cachedParameterNames;
    private static final int MAX_STRING_SIZE = 65536;

    public RequestWrapper(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
        String contentType = httpRequest.getContentType();
        this.isMultiPartRequest = contentType != null && contentType.toLowerCase(Locale.US).startsWith("multipart/form-data");
    }

    public HttpSession getSession(boolean b) {
        return this.httpRequest.getSession(b);
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public HttpSession getSession() {
        return this.httpRequest.getSession();
    }

    public Enumeration<String> getParameterNames() {
        if (this.isMultiPartRequest) {
            if (this.cachedParameterNames == null) {
                this.cachedParameterNames = new Hashtable();
                try {
                    Integer DUMMY = 0;
                    for (Part p : this.httpRequest.getParts()) {
                        this.cachedParameterNames.put(p.getName(), DUMMY);
                    }
                }
                catch (IOException ioe) {
                    RequestWrapper.log(ioe);
                }
                catch (ServletException se) {
                    RequestWrapper.log(se);
                }
                catch (IllegalStateException ise) {
                    RequestWrapper.log(ise);
                    throw ise;
                }
            }
            return this.cachedParameterNames.keys();
        }
        return this.httpRequest.getParameterNames();
    }

    public int getContentLength() {
        return this.httpRequest.getContentLength();
    }

    public String getContentType() {
        return this.httpRequest.getContentType();
    }

    public String getContentType(String partName) {
        String result = null;
        if (this.isMultiPartRequest) {
            try {
                Part p = this.httpRequest.getPart(partName);
                if (p != null) {
                    result = p.getContentType();
                }
            }
            catch (IOException ioe) {
                RequestWrapper.log(ioe);
            }
            catch (ServletException se) {
                RequestWrapper.log(se);
            }
            catch (IllegalStateException ise) {
                RequestWrapper.log(ise);
                throw ise;
            }
        }
        return result;
    }

    public Object getAttribute(String string) {
        return this.httpRequest.getAttribute(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getParameter(String name, String defaultValue) {
        String result = defaultValue;
        if (this.isMultiPartRequest) {
            String str = this.cache.get(name);
            if (str != null) {
                return str;
            }
            InputStream in = null;
            try {
                Part p = this.httpRequest.getPart(name);
                if (p == null) return result;
                long len = p.getSize();
                if (len > 65536L) {
                    throw new IOException("String too big: " + len);
                }
                in = p.getInputStream();
                byte[] data = new byte[(int)len];
                DataHelper.read(in, data);
                String enc = this.httpRequest.getCharacterEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                result = new String(data, enc);
                this.cache.put(name, result);
                return result;
            }
            catch (IOException ioe) {
                RequestWrapper.log(ioe);
                return result;
            }
            catch (ServletException se) {
                RequestWrapper.log(se);
                return result;
            }
            catch (IllegalStateException ise) {
                RequestWrapper.log(ise);
                throw ise;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        String str = this.httpRequest.getParameter(name);
        if (str == null) return result;
        return str;
    }

    public String getFilename(String partName) {
        String result = null;
        if (this.isMultiPartRequest) {
            try {
                Part p = this.httpRequest.getPart(partName);
                if (p != null) {
                    result = p.getSubmittedFileName();
                }
            }
            catch (IOException ioe) {
                RequestWrapper.log(ioe);
            }
            catch (ServletException se) {
                RequestWrapper.log(se);
            }
            catch (IllegalStateException ise) {
                RequestWrapper.log(ise);
                throw ise;
            }
        }
        return result;
    }

    public InputStream getInputStream(String partName) {
        InputStream result = null;
        if (this.isMultiPartRequest) {
            try {
                Part p = this.httpRequest.getPart(partName);
                if (p != null) {
                    result = p.getInputStream();
                }
            }
            catch (IOException ioe) {
                RequestWrapper.log(ioe);
            }
            catch (ServletException se) {
                RequestWrapper.log(se);
            }
            catch (IllegalStateException ise) {
                RequestWrapper.log(ise);
                throw ise;
            }
        }
        return result;
    }

    private static void log(Exception e) {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(RequestWrapper.class);
        log.error("Multipart form error", e);
    }
}

