/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.nio.channels.ClosedChannelException;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Logger;

public class I2PLogger
implements Logger {
    private final Log _log;
    private final StringBuilder _buffer = new StringBuilder();

    public I2PLogger() {
        this(I2PAppContext.getGlobalContext());
    }

    public I2PLogger(I2PAppContext ctx) {
        this._log = ctx.logManager().getLog(Server.class);
        if (System.getProperty("DEBUG") != null) {
            this.setDebugEnabled(true);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._log.shouldLog(10);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this._log.setMinimumPriority(10);
        } else {
            this._log.setMinimumPriority(40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.info(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.info(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(20)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                if (arg1 != null && arg1 instanceof Throwable) {
                    this._log.info(this._buffer.toString(), (Throwable)arg1);
                } else {
                    this._log.info(this._buffer.toString());
                }
            }
        }
    }

    @Override
    public void debug(String msg, Throwable th) {
        this._log.debug(msg, th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.debug(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.debug(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(10)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                if (arg1 != null && arg1 instanceof Throwable) {
                    this._log.debug(this._buffer.toString(), (Throwable)arg1);
                } else {
                    this._log.debug(this._buffer.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.warn(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this.warn(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(30)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                if (arg1 != null && arg1 instanceof Throwable) {
                    this._log.warn(this._buffer.toString(), (Throwable)arg1);
                } else {
                    this._log.warn(this._buffer.toString());
                }
            }
        }
    }

    @Override
    public void warn(String msg, Throwable th) {
        if (th != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(msg, th);
            } else if (!(th instanceof ClosedChannelException)) {
                this._log.logAlways(30, msg + ": " + th);
            }
        } else {
            this._log.logAlways(30, msg);
        }
    }

    private void format(String msg, Object arg0, Object arg1) {
        int i1;
        this._buffer.setLength(0);
        int i0 = msg == null ? -1 : msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (i0 >= 0) {
            this.format(msg.substring(0, i0));
            this.format(String.valueOf(arg0 == null ? "null" : arg0));
            if (i1 >= 0) {
                this.format(msg.substring(i0 + 2, i1));
                this.format(String.valueOf(arg1 == null ? "null" : arg1));
                this.format(msg.substring(i1 + 2));
            } else {
                this.format(msg.substring(i0 + 2));
                if (arg1 != null) {
                    this._buffer.append(' ');
                    this.format(String.valueOf(arg1));
                }
            }
        } else {
            this.format(msg);
            if (arg0 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg0));
            }
            if (arg1 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg1));
            }
        }
    }

    private void format(String msg) {
        if (msg == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(msg);
        }
    }

    @Override
    public Logger getLogger(String name) {
        return this;
    }

    public String toString() {
        return "I2PLogger";
    }

    @Override
    public void ignore(Throwable ignored) {
        this.debug("IGNORED", ignored);
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.debug(msg, a1, a2);
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.info(msg, a1, a2);
    }

    @Override
    public void info(String msg, Throwable th) {
        this._log.info(msg, th);
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.warn(msg, a1, a2);
    }

    @Override
    public String getName() {
        return "net.i2p.jetty.I2PLogger";
    }

    @Override
    public void debug(String msg, long arg) {
        this.debug(msg, (Object)arg, (Object)null);
    }
}

