/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.I2PSocketOptionsImpl;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class TCBShare {
    private final I2PAppContext _context;
    private final Log _log;
    private final Map<Destination, Entry> _cache;
    private final CleanEvent _cleaner;
    private final double _rttDampening;
    private final double _wdwDampening;
    private final double _rttDevDampening;
    private static final long EXPIRE_TIME = 600000L;
    private static final long CLEAN_TIME = 300000L;
    private static final double RTT_DAMPENING = 0.75;
    private static final double RTTDEV_DAMPENING = 0.75;
    private static final double WDW_DAMPENING = 0.75;
    private static final String RTT_DAMP_PROP = "i2p.streaming.tcbcache.rttDampening";
    private static final String WDW_DAMP_PROP = "i2p.streaming.tcbcache.wdwDampening";
    private static final String RTTDEV_DAMP_PROP = "i2p.streaming.tcbcache.rttdevDampening";
    private static final int MAX_RTT = 22500;
    private static final int MAX_RTT_DEV = 33750;
    private static final int MAX_WINDOW_SIZE = 64;

    public TCBShare(I2PAppContext ctx, SimpleTimer2 timer) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TCBShare.class);
        Properties props = ctx.getProperties();
        this._rttDampening = I2PSocketOptionsImpl.getDouble(props, RTT_DAMP_PROP, 0.75);
        this._wdwDampening = I2PSocketOptionsImpl.getDouble(props, WDW_DAMP_PROP, 0.75);
        this._rttDevDampening = I2PSocketOptionsImpl.getDouble(props, RTTDEV_DAMP_PROP, 0.75);
        this._cache = new ConcurrentHashMap<Destination, Entry>(4);
        this._cleaner = new CleanEvent(timer);
        this._cleaner.schedule(300000L);
        if (this._log.shouldLog(10)) {
            String log = "Creating TCBCache with rttDamp=%s, rttDevDamp=%s, wdwDamp=%s, expire=%d, clean=%d";
            log = String.format(log, this._rttDampening, this._rttDevDampening, this._wdwDampening, 600000L, 300000L);
            this._log.debug(log);
        }
    }

    public void stop() {
        this._cleaner.cancel();
        this._cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOptsFromShare(Connection con) {
        int wdw;
        int rttDev;
        int rtt;
        Destination dest = con.getRemotePeer();
        if (dest == null) {
            return;
        }
        ConnectionOptions opts = con.getOptions();
        if (opts == null) {
            return;
        }
        Entry e = this._cache.get(dest);
        if (e == null || e.isExpired()) {
            return;
        }
        Entry entry = e;
        synchronized (entry) {
            rtt = e.getRTT();
            rttDev = e.getRTTDev();
            wdw = e.getWindowSize();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("From cache: " + con.getSession().getMyDestination().calculateHash().toBase64().substring(0, 4) + '-' + dest.calculateHash().toBase64().substring(0, 4) + " RTT: " + rtt + " RTTDev: " + rttDev + " wdw: " + wdw);
        }
        opts.loadFromCache(rtt, rttDev, wdw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShareOpts(Connection con) {
        Destination dest = con.getRemotePeer();
        if (dest == null) {
            return;
        }
        if (con.getAckedPackets() <= 0L) {
            return;
        }
        ConnectionOptions opts = con.getOptions();
        if (opts == null) {
            return;
        }
        int old = -1;
        int oldw = -1;
        int oldDev = -1;
        Entry e = this._cache.get(dest);
        if (e == null || e.isExpired()) {
            e = new Entry(opts.getRTT(), opts.getWindowSize(), opts.getRTTDev());
            this._cache.put(dest, e);
        } else {
            Entry entry = e;
            synchronized (entry) {
                old = e.getRTT();
                oldw = e.getWindowSize();
                oldDev = e.getRTTDev();
                e.setRTT(opts.getRTT());
                e.setWindowSize(opts.getWindowSize());
                e.setRTTDev(opts.getRTTDev());
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("To cache: " + con.getSession().getMyDestination().calculateHash().toBase64().substring(0, 4) + '-' + dest.calculateHash().toBase64().substring(0, 4) + " old: " + old + " con: " + opts.getRTT() + " new: " + e.getRTT() + " oldDev: " + oldDev + " conDev: " + opts.getRTTDev() + " newDev: " + e.getRTTDev() + " oldw: " + oldw + " conw: " + opts.getWindowSize() + " neww: " + e.getWindowSize());
        }
    }

    private class CleanEvent
    extends SimpleTimer2.TimedEvent {
        public CleanEvent(SimpleTimer2 timer) {
            super(timer);
        }

        @Override
        public void timeReached() {
            Iterator iter = TCBShare.this._cache.values().iterator();
            while (iter.hasNext()) {
                if (!((Entry)iter.next()).isExpired()) continue;
                iter.remove();
            }
            this.schedule(300000L);
        }
    }

    private class Entry {
        int _rtt;
        int _wdw;
        int _rttDev;
        long _updated;

        public Entry(int ms, int wdw, int rttDev) {
            this._rtt = ms;
            this._wdw = wdw;
            this._rttDev = rttDev;
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized int getRTT() {
            return this._rtt;
        }

        public synchronized void setRTT(int ms) {
            this._rtt = (int)(TCBShare.this._rttDampening * (double)this._rtt + (1.0 - TCBShare.this._rttDampening) * (double)ms);
            if (this._rtt > 22500) {
                this._rtt = 22500;
            }
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized int getRTTDev() {
            return this._rttDev;
        }

        public synchronized void setRTTDev(int count) {
            this._rttDev = (int)(TCBShare.this._rttDevDampening * (double)this._rttDev + (1.0 - TCBShare.this._rttDevDampening) * (double)count);
            if (this._rttDev > 33750) {
                this._rttDev = 33750;
            }
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized int getWindowSize() {
            return this._wdw;
        }

        public synchronized void setWindowSize(int wdw) {
            this._wdw = (int)(0.5 + TCBShare.this._wdwDampening * (double)this._wdw + (1.0 - TCBShare.this._wdwDampening) * (double)wdw);
            if (this._wdw > 64) {
                this._wdw = 64;
            }
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized boolean isExpired() {
            return this._updated < TCBShare.this._context.clock().now() - 600000L;
        }
    }
}

