/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;

public class PcapWriter
implements Closeable,
Flushable {
    private static final byte[] FILE_HEADER = new byte[]{-95, -78, -61, -44, 0, 2, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 1};
    private static final byte[] MAC_HEADER = new byte[]{1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 8, 0};
    private static final byte[] IP_HEADER_1 = new byte[]{69, 0};
    private static final byte[] IP_HEADER_2 = new byte[]{18, 52, 64, 0, 64, 6};
    private static final byte[] UNK_IP = new byte[]{-1, 0, 0, 0};
    private static final byte[] MY_UNK_IP = new byte[]{127, 0, 0, 0};
    private static final int MAX_PAYLOAD_BYTES = 10;
    private static final int MAX_OPTION_LEN = 40;
    private static final byte OPTION_END = 0;
    private static final byte OPTION_MSS = 2;
    private static final byte OPTION_PING = 6;
    private static final byte OPTION_PONG = 7;
    private static final byte OPTION_SIGREQ = 85;
    private static final byte OPTION_SIG = 86;
    private static final byte OPTION_RDELAY = -34;
    private static final byte OPTION_ODELAY = -48;
    private static final byte OPTION_FROM = -16;
    private static final byte OPTION_NACK = -84;
    private final OutputStream _fos;
    private final I2PAppContext _context;

    public PcapWriter(I2PAppContext ctx, String file) throws IOException {
        this._context = ctx;
        File f = new File(ctx.getLogDir(), file);
        this._fos = new BufferedOutputStream(new FileOutputStream(f), 65536);
        this._fos.write(FILE_HEADER);
    }

    @Override
    public void close() {
        try {
            this._fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            this._fos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(PacketLocal pkt) throws IOException {
        try {
            this.wrt(pkt, pkt.getConnection(), false);
        }
        catch (DataFormatException dfe) {
            dfe.printStackTrace();
            throw new IOException(dfe.toString());
        }
    }

    public void write(Packet pkt, Connection con) throws IOException {
        try {
            this.wrt(pkt, con, true);
        }
        catch (DataFormatException dfe) {
            dfe.printStackTrace();
            throw new IOException(dfe.toString());
        }
    }

    private synchronized void wrt(Packet pkt, Connection con, boolean isInbound) throws IOException, DataFormatException {
        byte[] srcAddr;
        byte[] dstAddr;
        int includeLen = Math.min(10, pkt.getPayloadSize());
        Options opts = new Options();
        if (pkt.isFlagSet(128)) {
            opts.add((byte)2, 2, pkt.getOptionalMaxSize());
        }
        if (pkt.isFlagSet(64)) {
            opts.add((byte)-48, 2, pkt.getOptionalDelay());
        }
        if (pkt.getResendDelay() > 0) {
            opts.add((byte)-34, 1, pkt.getResendDelay());
        }
        if (pkt.isFlagSet(16)) {
            opts.add((byte)85);
        }
        if (pkt.isFlagSet(8)) {
            opts.add((byte)86);
        }
        if (pkt.isFlagSet(32)) {
            opts.add((byte)-16);
        }
        if (pkt.isFlagSet(512)) {
            if (pkt.getSendStreamId() > 0L) {
                opts.add((byte)6);
            } else {
                opts.add((byte)7);
            }
        }
        if (pkt.getNacks() != null) {
            opts.add((byte)-84, 1, pkt.getNacks().length);
        }
        int optLen = opts.size();
        byte[] options = opts.getData();
        long now = isInbound ? this._context.clock().now() : ((PacketLocal)pkt).getLastSend();
        DataHelper.writeLong(this._fos, 4, now / 1000L);
        DataHelper.writeLong(this._fos, 4, 1000L * (now % 1000L));
        DataHelper.writeLong(this._fos, 4, 54 + optLen + includeLen);
        DataHelper.writeLong(this._fos, 4, 58 + optLen + pkt.getPayloadSize());
        this._fos.write(MAC_HEADER);
        int length = 40 + optLen + pkt.getPayloadSize();
        this._fos.write(IP_HEADER_1);
        DataHelper.writeLong(this._fos, 2, length);
        this._fos.write(IP_HEADER_2);
        if (isInbound) {
            if (con != null) {
                dstAddr = new byte[4];
                dstAddr[0] = 127;
                dstAddr[1] = 0;
                System.arraycopy(con.getSession().getMyDestination().calculateHash().getData(), 0, dstAddr, 2, 2);
            } else {
                dstAddr = MY_UNK_IP;
            }
            srcAddr = con != null && con.getRemotePeer() != null ? con.getRemotePeer().calculateHash().getData() : (pkt.getOptionalFrom() != null ? pkt.getOptionalFrom().calculateHash().getData() : UNK_IP);
        } else {
            if (con != null) {
                srcAddr = new byte[4];
                srcAddr[0] = 127;
                srcAddr[1] = 0;
                System.arraycopy(con.getSession().getMyDestination().calculateHash().getData(), 0, srcAddr, 2, 2);
            } else {
                srcAddr = MY_UNK_IP;
            }
            dstAddr = con != null && con.getRemotePeer() != null ? con.getRemotePeer().calculateHash().getData() : UNK_IP;
        }
        int checksum = length;
        checksum = PcapWriter.update(checksum, IP_HEADER_1);
        checksum = PcapWriter.update(checksum, IP_HEADER_2);
        checksum = PcapWriter.update(checksum, srcAddr, 4);
        checksum = PcapWriter.update(checksum, dstAddr, 4);
        DataHelper.writeLong(this._fos, 2, checksum ^ 0xFFFF);
        this._fos.write(srcAddr, 0, 4);
        this._fos.write(dstAddr, 0, 4);
        DataHelper.writeLong(this._fos, 2, pkt.getReceiveStreamId() & 0xFFFFL);
        DataHelper.writeLong(this._fos, 2, pkt.getSendStreamId() & 0xFFFFL);
        long seq = pkt.isFlagSet(1) ? 0xFFFFFFFFL : pkt.getSequenceNum();
        DataHelper.writeLong(this._fos, 4, seq);
        long acked = 0L;
        if (con != null) {
            acked = PcapWriter.getLowestAckedThrough(pkt, con);
        }
        DataHelper.writeLong(this._fos, 4, acked);
        int flags = 0;
        if (pkt.isFlagSet(2)) {
            flags |= 1;
        }
        if (pkt.isFlagSet(1)) {
            flags |= 2;
        }
        if (pkt.isFlagSet(4)) {
            flags |= 4;
        }
        if (!pkt.isFlagSet(1024)) {
            flags |= 0x10;
        }
        int osb = 5 + optLen / 4 << 4;
        DataHelper.writeLong(this._fos, 1, osb);
        DataHelper.writeLong(this._fos, 1, flags);
        long window = 3L;
        long msgSize = 1730L;
        if (con != null) {
            if (isInbound) {
                window = con.getLastSendId() + (long)con.getOptions().getWindowSize() - acked;
            } else {
                long ready = con.getInputStream().getHighestReadyBlockId();
                int available = con.getOptions().getInboundBufferSize() - con.getInputStream().getTotalReadySize();
                int allowedBlocks = available / con.getOptions().getMaxMessageSize();
                window = ready + (long)allowedBlocks - pkt.getSequenceNum();
            }
            if (window <= 1L) {
                window = 2L;
            }
            msgSize = con.getOptions().getMaxMessageSize();
        }
        if ((window *= msgSize) > 65535L) {
            window = 65535L;
        }
        DataHelper.writeLong(this._fos, 2, window);
        DataHelper.writeLong(this._fos, 4, 0L);
        if (optLen > 0) {
            this._fos.write(options, 0, optLen);
        }
        if (includeLen > 0) {
            this._fos.write(pkt.getPayload().getData(), 0, includeLen);
        }
        if (pkt.isFlagSet(2)) {
            this._fos.flush();
        }
    }

    private static long getLowestAckedThrough(Packet pkt, Connection con) {
        long[] nacks = pkt.getNacks();
        long lowest = pkt.getAckThrough();
        if (nacks != null) {
            for (int i = 0; i < nacks.length; ++i) {
                if (nacks[i] - 1L >= lowest) continue;
                lowest = nacks[i] - 1L;
            }
        }
        return Math.max(0L, ++lowest);
    }

    private static int update(int checksum, byte[] b) {
        return PcapWriter.update(checksum, b, b.length);
    }

    private static int update(int checksum, byte[] b, int len) {
        int rv = checksum;
        for (int i = 0; i < len; i += 2) {
            if ((rv += b[i] << 8 & 0xFF00 | b[i + 1] & 0xFF) <= 65535) continue;
            rv &= 0xFFFF;
            ++rv;
        }
        return rv;
    }

    private static class Options {
        private final byte[] _b = new byte[40];
        private int _len;

        public byte[] getData() {
            return this._b;
        }

        public int size() {
            return (this._len + 3) / 4 * 4;
        }

        public void add(byte type) {
            this.add(type, 0, 0);
        }

        public void add(byte type, int datalen, int data) {
            if (this._len + datalen + 2 > 40) {
                return;
            }
            this._b[this._len++] = type;
            this._b[this._len++] = (byte)(datalen + 2);
            if (datalen > 0) {
                for (int i = datalen - 1; i >= 0; --i) {
                    this._b[this._len++] = (byte)(data >> i * 8 & 0xFF);
                }
            }
            if (this._len < 40) {
                this._b[this._len] = 0;
            }
        }
    }
}

