/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.Properties;
import net.i2p.client.streaming.I2PSocketOptions;

class I2PSocketOptionsImpl
implements I2PSocketOptions {
    private long _connectTimeout;
    private long _readTimeout;
    private long _writeTimeout;
    private int _maxBufferSize;
    private int _localPort;
    private int _remotePort;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int DEFAULT_READ_TIMEOUT = -1;
    public static final int DEFAULT_WRITE_TIMEOUT = -1;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;

    public I2PSocketOptionsImpl() {
        this(System.getProperties());
    }

    public I2PSocketOptionsImpl(I2PSocketOptions opts) {
        this(System.getProperties());
        if (opts != null) {
            this._connectTimeout = opts.getConnectTimeout();
            this._readTimeout = opts.getReadTimeout();
            this._writeTimeout = opts.getWriteTimeout();
            this._maxBufferSize = opts.getMaxBufferSize();
            this._localPort = opts.getLocalPort();
            this._remotePort = opts.getPort();
        }
    }

    public I2PSocketOptionsImpl(Properties opts) {
        this.init(opts);
    }

    public void setProperties(Properties opts) {
        if (opts == null) {
            return;
        }
        if (opts.getProperty("i2p.streaming.bufferSize") != null) {
            this._maxBufferSize = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.bufferSize", 65536);
        }
        if (opts.getProperty("i2p.streaming.connectTimeout") != null) {
            this._connectTimeout = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.connectTimeout", 60000);
        }
        if (opts.getProperty("i2p.streaming.readTimeout") != null) {
            this._readTimeout = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.readTimeout", -1);
        }
        if (opts.getProperty("i2p.streaming.writeTimeout") != null) {
            this._writeTimeout = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.writeTimeout", -1);
        }
    }

    protected void init(Properties opts) {
        this._maxBufferSize = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.bufferSize", 65536);
        this._connectTimeout = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.connectTimeout", 60000);
        this._readTimeout = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.readTimeout", -1);
        this._writeTimeout = I2PSocketOptionsImpl.getInt(opts, "i2p.streaming.writeTimeout", -1);
    }

    protected static int getInt(Properties opts, String name, int defaultVal) {
        if (opts == null) {
            return defaultVal;
        }
        String val = opts.getProperty(name);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static double getDouble(Properties opts, String name, double defaultVal) {
        if (opts == null) {
            return defaultVal;
        }
        String val = opts.getProperty(name);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    @Override
    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public void setConnectTimeout(long ms) {
        this._connectTimeout = ms;
    }

    @Override
    public long getReadTimeout() {
        return this._readTimeout;
    }

    @Override
    public void setReadTimeout(long ms) {
        this._readTimeout = ms;
    }

    @Override
    public int getMaxBufferSize() {
        return this._maxBufferSize;
    }

    @Override
    public void setMaxBufferSize(int numBytes) {
        this._maxBufferSize = numBytes;
    }

    @Override
    public long getWriteTimeout() {
        return this._writeTimeout;
    }

    @Override
    public void setWriteTimeout(long ms) {
        this._writeTimeout = ms;
    }

    @Override
    public int getPort() {
        return this._remotePort;
    }

    @Override
    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("bad port");
        }
        this._remotePort = port;
    }

    @Override
    public int getLocalPort() {
        return this._localPort;
    }

    @Override
    public void setLocalPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("bad port");
        }
        this._localPort = port;
    }
}

