/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.data;

import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.data.CustomData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UninstallData {
    private List<String> installedFilesList;
    private List<String> uninstallableFilesList;
    private List<ExecutableFile> executablesList;
    private String uninstallerJarFilename;
    private String uninstallerPath;
    private final List<CustomData> listeners = new ArrayList<CustomData>();
    private final List<CustomData> jars = new ArrayList<CustomData>();
    private final List<String> nativeLibs = new ArrayList<String>();
    private Map<String, Object> additionalData;
    private ArrayList<String> unInstallScripts;
    public static final String ROOTSCRIPT = "rootscript";

    public UninstallData() {
        this.installedFilesList = new ArrayList<String>();
        this.uninstallableFilesList = new ArrayList<String>();
        this.executablesList = new ArrayList<ExecutableFile>();
        this.additionalData = new HashMap<String, Object>();
        this.unInstallScripts = new ArrayList();
    }

    public synchronized void addFile(String path, boolean uninstall) {
        if (path != null) {
            this.installedFilesList.add(path);
            if (uninstall) {
                this.uninstallableFilesList.add(path);
            }
        }
    }

    public List<String> getInstalledFilesList() {
        return this.installedFilesList;
    }

    public List<String> getUninstalableFilesList() {
        return this.uninstallableFilesList;
    }

    public synchronized void addExecutable(ExecutableFile file) {
        this.executablesList.add(file);
    }

    public List<ExecutableFile> getExecutablesList() {
        return this.executablesList;
    }

    public synchronized String getUninstallerJarFilename() {
        return this.uninstallerJarFilename;
    }

    public synchronized void setUninstallerJarFilename(String name) {
        this.uninstallerJarFilename = name;
    }

    public String getUninstallerPath() {
        return this.uninstallerPath;
    }

    public void setUninstallerPath(String path) {
        this.uninstallerPath = path;
    }

    public void addUninstallerListener(CustomData listener) {
        this.listeners.add(listener);
    }

    public List<CustomData> getUninstallerListeners() {
        return this.listeners;
    }

    public void addJar(CustomData jar) {
        this.jars.add(jar);
    }

    public List<CustomData> getJars() {
        return this.jars;
    }

    public void addNativeLibrary(String path) {
        this.nativeLibs.add(path);
    }

    public List<String> getNativeLibraries() {
        return this.nativeLibs;
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public void addAdditionalData(String name, Object value) {
        this.additionalData.put(name, value);
    }

    public void addUninstallScript(String aRootUninstallScript) {
        this.unInstallScripts.add(aRootUninstallScript == null ? "" : aRootUninstallScript);
    }

    public ArrayList<String> getUninstallScripts() {
        return this.unInstallScripts;
    }
}

