/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

class TestJob
extends JobImpl {
    private final Log _log;
    private final TunnelPool _pool;
    private final PooledTunnelCreatorConfig _cfg;
    private boolean _found;
    private TunnelInfo _outTunnel;
    private TunnelInfo _replyTunnel;
    private PooledTunnelCreatorConfig _otherTunnel;
    private SessionTag _encryptTag;
    private RatchetSessionTag _ratchetEncryptTag;
    private static final AtomicInteger __id = new AtomicInteger();
    private int _id;
    private static final int TEST_DELAY = 40000;

    public TestJob(RouterContext ctx, PooledTunnelCreatorConfig cfg, TunnelPool pool) {
        super(ctx);
        this._log = ctx.logManager().getLog(TestJob.class);
        this._cfg = cfg;
        this._pool = pool != null ? pool : cfg.getTunnelPool();
        if (this._pool == null && this._log.shouldLog(40)) {
            this._log.error("Invalid tunnel test configuration: no pool for " + cfg, new Exception("origin"));
        }
        this.getTiming().setStartAfter((long)this.getDelay() + ctx.clock().now());
    }

    @Override
    public String getName() {
        return "Test tunnel";
    }

    @Override
    public void runJob() {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        RouterContext ctx = this.getContext();
        long lag = ctx.jobQueue().getMaxLag();
        if (lag > 3000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Deferring test of " + this._cfg + " due to job lag = " + lag);
            }
            ctx.statManager().addRateData("tunnel.testAborted", this._cfg.getLength());
            this.scheduleRetest();
            return;
        }
        if (ctx.router().gracefulShutdownInProgress()) {
            return;
        }
        this._found = false;
        boolean isExpl = this._pool.getSettings().isExploratory();
        if (this._cfg.isInbound()) {
            this._replyTunnel = this._cfg;
            this._outTunnel = isExpl ? ctx.tunnelManager().selectOutboundTunnel() : ctx.tunnelManager().selectOutboundTunnel(this._pool.getSettings().getDestination());
            this._otherTunnel = (PooledTunnelCreatorConfig)this._outTunnel;
        } else {
            this._replyTunnel = isExpl ? ctx.tunnelManager().selectInboundTunnel() : ctx.tunnelManager().selectInboundTunnel(this._pool.getSettings().getDestination());
            this._outTunnel = this._cfg;
            this._otherTunnel = (PooledTunnelCreatorConfig)this._replyTunnel;
        }
        if (this._replyTunnel == null || this._outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Insufficient tunnels to test " + this._cfg + " with: " + this._replyTunnel + " / " + this._outTunnel);
            }
            ctx.statManager().addRateData("tunnel.testAborted", this._cfg.getLength());
            this.scheduleRetest();
        } else {
            int testPeriod = this.getTestPeriod();
            long now = ctx.clock().now();
            long testExpiration = now + (long)testPeriod;
            DeliveryStatusMessage m = new DeliveryStatusMessage(ctx);
            m.setArrival(now);
            m.setMessageExpiration(testExpiration);
            m.setMessageId(ctx.random().nextLong(0xFFFFFFFFL));
            ReplySelector sel = new ReplySelector(m.getMessageId(), testExpiration);
            OnTestReply onReply = new OnTestReply();
            OnTestTimeout onTimeout = new OnTestTimeout(now);
            OutNetMessage msg = ctx.messageRegistry().registerPending(sel, onReply, onTimeout);
            onReply.setSentMessage(msg);
            this.sendTest(m, testPeriod);
        }
    }

    private void sendTest(I2NPMessage m, int testPeriod) {
        RouterContext ctx = this.getContext();
        this._id = __id.getAndIncrement();
        if (ctx.random().nextInt(4) != 0) {
            MessageWrapper.OneTimeSession sess = !this._pool.getSettings().isExploratory() ? MessageWrapper.generateSession(ctx, this._pool.getSettings().getDestination(), (long)testPeriod, false) : MessageWrapper.generateSession(ctx, testPeriod);
            if (sess == null) {
                this.scheduleRetest();
                return;
            }
            if (sess.tag != null) {
                this._encryptTag = sess.tag;
                m = MessageWrapper.wrap(ctx, m, sess.key, sess.tag);
            } else {
                this._ratchetEncryptTag = sess.rtag;
                m = MessageWrapper.wrap(ctx, m, sess.key, sess.rtag);
            }
            if (m == null) {
                this.scheduleRetest();
                return;
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("Sending tunnel test unencrypted, test #" + this._id);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending garlic test #" + this._id + " msg ID: " + m.getUniqueId() + " of " + this._outTunnel + " / " + this._replyTunnel);
        }
        ctx.tunnelDispatcher().dispatchOutbound(m, this._outTunnel.getSendTunnelId(0), this._replyTunnel.getReceiveTunnelId(0), this._replyTunnel.getPeer(0));
    }

    public void testSuccessful(int ms) {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        this.getContext().statManager().addRateData("tunnel.testSuccessLength", this._cfg.getLength());
        this.getContext().statManager().addRateData("tunnel.testSuccessTime", ms);
        this._outTunnel.incrementVerifiedBytesTransferred(1024);
        this.noteSuccess(ms, this._outTunnel);
        this.noteSuccess(ms, this._replyTunnel);
        this._cfg.testJobSuccessful(ms);
        if (this._otherTunnel.getLength() > 1) {
            this._otherTunnel.testJobSuccessful(ms);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Tunnel test #" + this._id + " successful in " + ms + "ms: " + this._cfg);
        }
        this.scheduleRetest();
    }

    private void noteSuccess(long ms, TunnelInfo tunnel) {
        if (tunnel != null) {
            for (int i = 0; i < tunnel.getLength(); ++i) {
                this.getContext().profileManager().tunnelTestSucceeded(tunnel.getPeer(i), ms);
            }
        }
    }

    private void testFailed(long timeToFail) {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        if (this._found) {
            this.noteSuccess(timeToFail, this._outTunnel);
            this.noteSuccess(timeToFail, this._replyTunnel);
        }
        if (this._pool.getSettings().isExploratory()) {
            this.getContext().statManager().addRateData("tunnel.testExploratoryFailedTime", timeToFail);
        } else {
            this.getContext().statManager().addRateData("tunnel.testFailedTime", timeToFail);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Tunnel test #" + this._id + " failed in " + timeToFail + "ms: " + this._cfg);
        }
        boolean keepGoing = this._cfg.tunnelFailed();
        if (this._otherTunnel.getLength() > 1) {
            this._otherTunnel.tunnelFailed();
        }
        if (keepGoing) {
            this.scheduleRetest(true);
        } else if (this._pool.getSettings().isExploratory()) {
            this.getContext().statManager().addRateData("tunnel.testExploratoryFailedCompletelyTime", timeToFail);
        } else {
            this.getContext().statManager().addRateData("tunnel.testFailedCompletelyTime", timeToFail);
        }
    }

    private int getDelay() {
        return 40000 + this.getContext().random().nextInt(13333);
    }

    private int getTestPeriod() {
        Rate r;
        if (this._outTunnel == null || this._replyTunnel == null) {
            return 15000;
        }
        RateStat tspt = this.getContext().statManager().getRate("transport.sendProcessingTime");
        if (tspt != null && (r = tspt.getRate(60000L)) != null) {
            int delay = 3 * (int)r.getAverageValue();
            return delay + 2500 * (this._outTunnel.getLength() + this._replyTunnel.getLength());
        }
        return 15000;
    }

    private void scheduleRetest() {
        this.scheduleRetest(false);
    }

    private void scheduleRetest(boolean asap) {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        if (asap) {
            if (this._cfg.getExpiration() > this.getContext().clock().now() + 60000L) {
                this.requeue(10000 + this.getContext().random().nextInt(10000));
            }
        } else {
            int delay = this.getDelay();
            if (this._cfg.getExpiration() > this.getContext().clock().now() + (long)delay + (long)(3 * this.getTestPeriod())) {
                this.requeue(delay);
            }
        }
    }

    private class OnTestReply
    extends JobImpl
    implements ReplyJob {
        private long _successTime;
        private OutNetMessage _sentMessage;

        public OnTestReply() {
            super(TestJob.this.getContext());
        }

        @Override
        public String getName() {
            return "Tunnel test success";
        }

        public void setSentMessage(OutNetMessage m) {
            this._sentMessage = m;
        }

        @Override
        public void runJob() {
            if (this._sentMessage != null) {
                this.getContext().messageRegistry().unregisterPending(this._sentMessage);
            }
            if (this._successTime < (long)TestJob.this.getTestPeriod()) {
                TestJob.this.testSuccessful((int)this._successTime);
            } else {
                TestJob.this.testFailed(this._successTime);
            }
            TestJob.this._found = true;
        }

        @Override
        public void setMessage(I2NPMessage message) {
            this._successTime = this.getContext().clock().now() - ((DeliveryStatusMessage)message).getArrival();
        }

        @Override
        public String toString() {
            StringBuilder rv = new StringBuilder(64);
            rv.append("Testing tunnel ").append(TestJob.this._cfg.toString());
            rv.append(" successful after ").append(this._successTime);
            return rv.toString();
        }
    }

    private class OnTestTimeout
    extends JobImpl {
        private final long _started;

        public OnTestTimeout(long now) {
            super(TestJob.this.getContext());
            this._started = now;
        }

        @Override
        public String getName() {
            return "Tunnel test timeout";
        }

        @Override
        public void runJob() {
            SessionKeyManager skm;
            if (TestJob.this._log.shouldDebug()) {
                TestJob.this._log.debug("Tunnel test #" + TestJob.this._id + " timeout: found? " + TestJob.this._found);
            }
            if (!(TestJob.this._found || TestJob.this._encryptTag == null && TestJob.this._ratchetEncryptTag == null || (skm = !TestJob.this._pool.getSettings().isExploratory() ? this.getContext().clientManager().getClientSessionKeyManager(TestJob.this._pool.getSettings().getDestination()) : this.getContext().sessionKeyManager()) == null)) {
                if (TestJob.this._encryptTag != null) {
                    skm.consumeTag(TestJob.this._encryptTag);
                } else {
                    RatchetSKM rskm = skm instanceof RatchetSKM ? (RatchetSKM)skm : (skm instanceof MuxedSKM ? ((MuxedSKM)skm).getECSKM() : null);
                    if (rskm != null) {
                        rskm.consumeTag(TestJob.this._ratchetEncryptTag);
                    }
                }
            }
            if (!TestJob.this._found) {
                TestJob.this.testFailed(this.getContext().clock().now() - this._started);
            }
        }

        @Override
        public String toString() {
            StringBuilder rv = new StringBuilder(64);
            rv.append("Testing tunnel ").append(TestJob.this._cfg.toString());
            rv.append(" timed out");
            return rv.toString();
        }
    }

    private class ReplySelector
    implements MessageSelector {
        private final long _id;
        private final long _expiration;

        public ReplySelector(long id, long expiration) {
            this._id = id;
            this._expiration = expiration;
            TestJob.this._found = false;
        }

        @Override
        public boolean continueMatching() {
            return !TestJob.this._found && TestJob.this.getContext().clock().now() < this._expiration;
        }

        @Override
        public long getExpiration() {
            return this._expiration;
        }

        @Override
        public boolean isMatch(I2NPMessage message) {
            if (message.getType() == 10) {
                return ((DeliveryStatusMessage)message).getMessageId() == this._id;
            }
            return false;
        }

        public String toString() {
            StringBuilder rv = new StringBuilder(64);
            rv.append("Testing tunnel ").append(TestJob.this._cfg.toString()).append(" waiting for ");
            rv.append(this._id).append(" found? ").append(TestJob.this._found);
            return rv.toString();
        }
    }
}

