/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import com.southernstorm.noise.protocol.HandshakeState;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.EncType;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.ECIESAEADEngine;
import net.i2p.router.crypto.ratchet.NextSessionKey;
import net.i2p.router.crypto.ratchet.RatchetEntry;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.crypto.ratchet.RatchetTagSet;
import net.i2p.router.crypto.ratchet.ReplyCallback;
import net.i2p.router.crypto.ratchet.SessionKeyAndNonce;
import net.i2p.router.crypto.ratchet.SessionTagListener;
import net.i2p.router.crypto.ratchet.SingleTagSet;
import net.i2p.router.crypto.ratchet.SplitKeys;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class RatchetSKM
extends SessionKeyManager
implements SessionTagListener {
    private final Log _log;
    private final ConcurrentHashMap<PublicKey, OutboundSession> _outboundSessions;
    private final HashMap<PublicKey, List<OutboundSession>> _pendingOutboundSessions;
    private final ConcurrentHashMap<RatchetSessionTag, RatchetTagSet> _inboundTagSets;
    protected final RouterContext _context;
    private volatile boolean _alive;
    private final HKDF _hkdf;
    private final DecayingHashSet _replayFilter;
    private final Destination _destination;
    static final long SESSION_TAG_DURATION_MS = 480000L;
    static final long SESSION_LIFETIME_MAX_MS = 600000L;
    static final long SESSION_PENDING_DURATION_MS = 180000L;
    private static final long SESSION_REPLACE_AGE = 120000L;
    private static final byte[] ZEROLEN = new byte[0];

    public RatchetSKM(RouterContext context) {
        this(context, null);
    }

    public RatchetSKM(RouterContext context, Destination dest) {
        super(context);
        this._log = context.logManager().getLog(RatchetSKM.class);
        this._context = context;
        this._destination = dest;
        this._outboundSessions = new ConcurrentHashMap(64);
        this._pendingOutboundSessions = new HashMap(64);
        this._inboundTagSets = new ConcurrentHashMap(128);
        this._hkdf = new HKDF(context);
        this._replayFilter = new DecayingHashSet(context, 300000, 32, "Ratchet-NS");
        context.eciesEngine().startup();
        this._alive = true;
        new CleanupEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this._alive = false;
        this._inboundTagSets.clear();
        this._outboundSessions.clear();
        HashMap<PublicKey, List<OutboundSession>> hashMap = this._pendingOutboundSessions;
        synchronized (hashMap) {
            this._pendingOutboundSessions.clear();
        }
        this._replayFilter.stopDecaying();
    }

    public Destination getDestination() {
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RatchetTagSet> getRatchetTagSets() {
        ConcurrentHashMap<RatchetSessionTag, RatchetTagSet> concurrentHashMap = this._inboundTagSets;
        synchronized (concurrentHashMap) {
            return new HashSet<RatchetTagSet>(this._inboundTagSets.values());
        }
    }

    private Set<OutboundSession> getOutboundSessions() {
        return new HashSet<OutboundSession>(this._outboundSessions.values());
    }

    @Override
    public SessionKey getCurrentKey(PublicKey target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SessionKey getCurrentOrNewKey(PublicKey target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSession(PublicKey target, SessionKey key) {
        throw new UnsupportedOperationException();
    }

    boolean isDuplicate(PublicKey pk) {
        return this._replayFilter.add(pk.getData(), 0, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createSession(PublicKey target, Destination d, HandshakeState state, ReplyCallback callback) {
        boolean isInbound;
        EncType type = target.getType();
        if (type != EncType.ECIES_X25519) {
            throw new IllegalArgumentException("Bad public key type " + (Object)((Object)type));
        }
        OutboundSession sess = new OutboundSession(target, d, null, state, callback);
        boolean bl = isInbound = state.getRole() == 2;
        if (isInbound) {
            boolean rv = this.addSession(sess, true);
            if (this._log.shouldInfo()) {
                if (rv) {
                    this._log.info("New OB session " + state.hashCode() + " as Bob. Alice: " + RatchetSKM.toString(target));
                } else {
                    this._log.info("Dup OB session " + state.hashCode() + " as Bob. Alice: " + RatchetSKM.toString(target));
                }
            }
            return rv;
        }
        HashMap<PublicKey, List<OutboundSession>> hashMap = this._pendingOutboundSessions;
        synchronized (hashMap) {
            List<OutboundSession> pending = this._pendingOutboundSessions.get(target);
            if (pending != null) {
                pending.add(sess);
                if (this._log.shouldInfo()) {
                    this._log.info("Another new OB session " + state.hashCode() + " as Alice, total now: " + pending.size() + ". Bob: " + RatchetSKM.toString(target));
                }
            } else {
                pending = new ArrayList<OutboundSession>(4);
                pending.add(sess);
                this._pendingOutboundSessions.put(target, pending);
                if (this._log.shouldInfo()) {
                    this._log.info("First new OB session " + state.hashCode() + " as Alice. Bob: " + RatchetSKM.toString(target));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateSession(PublicKey target, HandshakeState oldState, HandshakeState state, ReplyCallback callback, SplitKeys split) {
        boolean isInbound;
        EncType type = target.getType();
        if (type != EncType.ECIES_X25519) {
            throw new IllegalArgumentException("Bad public key type " + (Object)((Object)type));
        }
        boolean bl = isInbound = state.getRole() == 2;
        if (isInbound) {
            OutboundSession sess;
            if (this._log.shouldInfo()) {
                this._log.info("Session " + state.hashCode() + " update as Bob. Alice: " + RatchetSKM.toString(target));
            }
            if ((sess = this.getSession(target)) == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Update Bob session but no session found for " + target);
                }
                return false;
            }
            sess.updateSession(state, callback, split);
        } else {
            if (this._log.shouldInfo()) {
                this._log.info("Session " + oldState.hashCode() + " to " + state.hashCode() + " update as Alice. Bob: " + RatchetSKM.toString(target));
            }
            HashMap<PublicKey, List<OutboundSession>> hashMap = this._pendingOutboundSessions;
            synchronized (hashMap) {
                List<OutboundSession> pending = this._pendingOutboundSessions.get(target);
                if (pending == null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Update Alice session but no pending sessions for " + target);
                    }
                    return false;
                }
                boolean found = false;
                Iterator<OutboundSession> iter = pending.iterator();
                while (iter.hasNext()) {
                    OutboundSession sess = iter.next();
                    HandshakeState pstate = sess.getHandshakeState();
                    if (oldState.equals(pstate)) {
                        if (!found) {
                            found = true;
                            sess.updateSession(state, null, split);
                            boolean ok = this.addSession(sess, false);
                            if (this._log.shouldDebug()) {
                                if (ok) {
                                    this._log.debug("Update Alice session from NSR to ES for " + target);
                                } else {
                                    this._log.debug("Session already updated from NSR to ES for " + target);
                                }
                            }
                            iter.remove();
                            continue;
                        }
                        if (!this._log.shouldDebug()) continue;
                        this._log.debug("Dup pending session " + sess + " for " + target);
                        continue;
                    }
                    if (!this._log.shouldDebug()) continue;
                    this._log.debug("Other pending session " + sess + " for " + target);
                }
                if (found) {
                    this._pendingOutboundSessions.remove(target);
                    if (!pending.isEmpty()) {
                        for (OutboundSession outboundSession : pending) {
                        }
                    }
                } else {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Update Alice session but no session found (out of " + pending.size() + ") for " + target);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    void nextKeyReceived(PublicKey target, NextSessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Got NextKey but no session found for " + target);
            }
            return;
        }
        sess.nextKeyReceived(key);
    }

    boolean registerTimer(PublicKey target, Destination d, SimpleTimer2.TimedEvent timer) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("registerTimer() but no session found for " + target);
            }
            return false;
        }
        return sess.registerTimer(d, timer);
    }

    Destination getDestination(PublicKey target) {
        OutboundSession sess = this.getSession(target);
        if (sess != null) {
            return sess.getDestination();
        }
        return null;
    }

    @Override
    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        throw new UnsupportedOperationException();
    }

    public RatchetEntry consumeNextAvailableTag(PublicKey target) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return null;
        }
        RatchetEntry rv = sess.consumeNext();
        if (this._log.shouldDebug()) {
            if (rv != null) {
                this._log.debug("Using tag " + rv + " to " + RatchetSKM.toString(target));
            } else {
                this._log.debug("No more tags in OB session to " + RatchetSKM.toString(target));
            }
        }
        return rv;
    }

    @Override
    public int getTagsToSend() {
        return 0;
    }

    @Override
    public int getLowThreshold() {
        return 999999;
    }

    @Override
    public boolean shouldSendTags(PublicKey target, SessionKey key, int lowThreshold) {
        return false;
    }

    @Override
    public int getAvailableTags(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0;
        }
        if (sess.getCurrentKey().equals(key)) {
            return sess.availableTags();
        }
        return 0;
    }

    @Override
    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0L;
        }
        if (sess.getCurrentKey().equals(key)) {
            long end = sess.getLastExpirationDate();
            if (end <= 0L) {
                return 0L;
            }
            return end - this._context.clock().now();
        }
        return 0L;
    }

    @Override
    public TagSetHandle tagsDelivered(PublicKey target, SessionKey key, Set<SessionTag> sessionTags) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void failTags(PublicKey target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void failTags(PublicKey target, SessionKey key, TagSetHandle ts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tagsAcked(PublicKey target, SessionKey key, TagSetHandle ts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags, long expire) {
        throw new UnsupportedOperationException();
    }

    public void tagsReceived(SessionKey key, RatchetSessionTag tag, long expire) {
        new SingleTagSet(this, key, tag, this._context.clock().now(), expire);
    }

    private void clearExcess(int overage) {
    }

    @Override
    public SessionKey consumeTag(SessionTag tag) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionKeyAndNonce consumeTag(RatchetSessionTag tag) {
        SessionKeyAndNonce key;
        boolean firstInbound;
        RatchetTagSet tagSet = this._inboundTagSets.remove(tag);
        if (tagSet == null) {
            return null;
        }
        RatchetTagSet ratchetTagSet = tagSet;
        synchronized (ratchetTagSet) {
            firstInbound = !tagSet.getAcked();
            key = tagSet.consume(tag);
            if (key != null) {
                tagSet.setDate(this._context.clock().now());
            }
        }
        if (key != null) {
            PublicKey pk;
            HandshakeState state = tagSet.getHandshakeState();
            if (state == null && (pk = tagSet.getRemoteKey()) != null) {
                OutboundSession sess = this.getSession(pk);
                if (sess != null) {
                    if (firstInbound) {
                        sess.firstTagConsumed(tagSet);
                    } else {
                        sess.tagConsumed(tagSet);
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Tag consumed but session is gone");
                }
            }
            if (this._log.shouldDebug()) {
                if (state != null) {
                    this._log.debug("IB NSR Tag " + key.getNonce() + " consumed: " + tag.toBase64() + " from\n" + tagSet);
                } else {
                    this._log.debug("IB ES Tag " + key.getNonce() + " consumed: " + tag.toBase64() + " from\n" + tagSet);
                }
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("tag " + tag + " not found in tagset!!! " + tagSet);
        }
        return key;
    }

    private OutboundSession getSession(PublicKey target) {
        return this._outboundSessions.get(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSession(OutboundSession sess, boolean isInbound) {
        ConcurrentHashMap<PublicKey, OutboundSession> concurrentHashMap = this._outboundSessions;
        synchronized (concurrentHashMap) {
            boolean rv;
            OutboundSession old = this._outboundSessions.putIfAbsent(sess.getTarget(), sess);
            boolean bl = rv = old == null;
            if (!rv) {
                if (isInbound && old.getEstablishedDate() < this._context.clock().now() - 120000L) {
                    this._outboundSessions.put(sess.getTarget(), sess);
                    rv = true;
                    if (this._log.shouldWarn()) {
                        this._log.warn("Replaced old session, got new NS for " + sess.getTarget());
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Not replacing existing session for " + sess.getTarget());
                }
            }
            return rv;
        }
    }

    private void removeSession(PublicKey target) {
        if (target == null) {
            return;
        }
        OutboundSession session = this._outboundSessions.remove(target);
        if (session != null && this._log.shouldWarn()) {
            this._log.warn("Removing session tags with " + session.availableTags() + " available for " + (session.getLastExpirationDate() - this._context.clock().now()) + "ms more", new Exception("Removed by"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int aggressiveExpire() {
        long now = this._context.clock().now();
        int removed = 0;
        Iterator<RatchetTagSet> iter = this._inboundTagSets.values().iterator();
        while (iter.hasNext()) {
            RatchetTagSet ts = iter.next();
            if (ts.getExpiration() >= now) continue;
            iter.remove();
            ++removed;
        }
        int oremoved = 0;
        int cremoved = 0;
        long exp = now - 480000L;
        Iterator<OutboundSession> iter2 = this._outboundSessions.values().iterator();
        while (iter2.hasNext()) {
            OutboundSession sess = iter2.next();
            oremoved += sess.expireTags(now);
            cremoved += sess.expireCallbacks(now);
            if (sess.getLastUsedDate() >= exp && sess.getLastReceivedDate() >= exp) continue;
            iter2.remove();
            ++oremoved;
        }
        int premoved = 0;
        exp = now - 180000L;
        HashMap<PublicKey, List<OutboundSession>> hashMap = this._pendingOutboundSessions;
        synchronized (hashMap) {
            Iterator<List<OutboundSession>> iter3 = this._pendingOutboundSessions.values().iterator();
            while (iter3.hasNext()) {
                List<OutboundSession> pending = iter3.next();
                Iterator<OutboundSession> liter = pending.iterator();
                while (liter.hasNext()) {
                    OutboundSession sess = liter.next();
                    cremoved += sess.expireCallbacks(now);
                    if (sess.getEstablishedDate() >= exp) continue;
                    liter.remove();
                    ++premoved;
                }
                if (!pending.isEmpty()) continue;
                iter3.remove();
            }
        }
        if ((removed > 0 || oremoved > 0 || premoved > 0 || cremoved > 0) && this._log.shouldInfo()) {
            this._log.info("Expired inbound: " + removed + ", outbound: " + oremoved + ", pending: " + premoved + ", callbacks: " + cremoved);
        }
        return removed + oremoved + premoved;
    }

    @Override
    public boolean addTag(RatchetSessionTag tag, RatchetTagSet ts) {
        return this._inboundTagSets.putIfAbsent(tag, ts) == null;
    }

    @Override
    public void expireTag(RatchetSessionTag tag, RatchetTagSet ts) {
        this._inboundTagSets.remove(tag, ts);
    }

    void registerCallback(PublicKey target, int id, int n, ReplyCallback callback) {
        OutboundSession sess;
        if (this._log.shouldInfo()) {
            this._log.info("Register callback tgt " + target + " id=" + id + " n=" + n + " callback " + callback);
        }
        if ((sess = this.getSession(target)) != null) {
            sess.registerCallback(id, n, callback);
        } else if (this._log.shouldWarn()) {
            this._log.warn("no session found for register callback");
        }
    }

    void receivedACK(PublicKey target, int id, int n) {
        OutboundSession sess = this.getSession(target);
        if (sess != null) {
            sess.receivedACK(id, n);
        } else if (this._log.shouldWarn()) {
            this._log.warn("no session found for received ack");
        }
    }

    void ackRequested(PublicKey target, int id, int n) {
        OutboundSession sess;
        if (this._log.shouldInfo()) {
            this._log.info("rcvd ACK REQUEST id=" + id + " n=" + n);
        }
        if ((sess = this.getSession(target)) != null) {
            sess.ackRequested(id, n);
        } else if (this._log.shouldWarn()) {
            this._log.warn("no session found for ack req");
        }
    }

    private Map<PublicKey, Set<RatchetTagSet>> getRatchetTagSetsByPublicKey() {
        Set<RatchetTagSet> inbound = this.getRatchetTagSets();
        HashMap<PublicKey, Set<RatchetTagSet>> inboundSets = new HashMap<PublicKey, Set<RatchetTagSet>>(inbound.size());
        long now = this._context.clock().now();
        for (RatchetTagSet ts : inbound) {
            PublicKey pk = ts.getRemoteKey();
            if (pk == null || ts.getExpiration() < now) continue;
            HashSet<RatchetTagSet> sets = (HashSet<RatchetTagSet>)inboundSets.get(pk);
            if (sets == null) {
                sets = new HashSet<RatchetTagSet>(4);
                inboundSets.put(pk, sets);
            }
            sets.add(ts);
        }
        return inboundSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h3 class=\"debug_inboundsessions\">Ratchet Inbound sessions</h3><table>");
        Map<PublicKey, Set<RatchetTagSet>> inboundSets = this.getRatchetTagSetsByPublicKey();
        int total = 0;
        int totalSets = 0;
        long now = this._context.clock().now();
        RatchetTagSetComparator comp = new RatchetTagSetComparator();
        ArrayList<RatchetTagSet> sets = new ArrayList<RatchetTagSet>();
        for (Map.Entry<PublicKey, Set<RatchetTagSet>> e : inboundSets.entrySet()) {
            PublicKey skey = e.getKey();
            sets.clear();
            sets.addAll((Collection)e.getValue());
            Collections.sort(sets, comp);
            totalSets += sets.size();
            buf.append("<tr><td><b>From public key:</b> ").append(RatchetSKM.toString(skey)).append("</td><td><b>Sets:</b> ").append(sets.size()).append("</td></tr><tr class=\"expiry\"><td colspan=\"2\"><ul>");
            Iterator iterator = sets.iterator();
            while (iterator.hasNext()) {
                RatchetTagSet ts;
                RatchetTagSet ratchetTagSet = ts = (RatchetTagSet)iterator.next();
                synchronized (ratchetTagSet) {
                    int size = ts.size();
                    total += size;
                    buf.append("<li><b>ID: ");
                    int id = ts.getID();
                    if (id == 65538) {
                        buf.append("NSR");
                    } else if (id == 65539) {
                        buf.append("ES");
                    } else {
                        buf.append(id);
                    }
                    buf.append('/').append(ts.getDebugID());
                    long expires = ts.getExpiration() - now;
                    buf.append(" expires in:</b> ").append(DataHelper.formatDuration2(expires)).append(" with ");
                    buf.append(size).append('+').append(ts.remaining() - size).append(" tags remaining</li>");
                }
            }
            buf.append("</ul></td></tr>\n");
            out.append(buf);
            buf.setLength(0);
        }
        buf.append("<tr><th colspan=\"2\">Total inbound tags: ").append(total).append(" (").append(DataHelper.formatSize2(8 * total)).append("B); sets: ").append(totalSets).append("; sessions: ").append(inboundSets.size()).append("</th></tr>\n</table><h3 class=\"debug_outboundsessions\">Ratchet Outbound sessions</h3><table>");
        totalSets = 0;
        Set<OutboundSession> outbound = this.getOutboundSessions();
        for (OutboundSession sess : outbound) {
            sets.clear();
            sets.addAll(sess.getTagSets());
            Collections.sort(sets, comp);
            totalSets += sets.size();
            buf.append("<tr class=\"debug_outboundtarget\"><td><div class=\"debug_targetinfo\"><b>To public key:</b> ").append(RatchetSKM.toString(sess.getTarget())).append("<br><b>Established:</b> ").append(DataHelper.formatDuration2(now - sess.getEstablishedDate())).append(" ago<br><b>Last Used:</b> ").append(DataHelper.formatDuration2(now - sess.getLastUsedDate())).append(" ago<br><b>Last Rcvd:</b> ").append(DataHelper.formatDuration2(now - sess.getLastReceivedDate())).append(" ago<br>");
            SessionKey sk = sess.getCurrentKey();
            if (sk != null) {
                buf.append("<b>Session key:</b> ").append(sk.toBase64());
            }
            buf.append("</div></td><td><b>Sets:</b> ").append(sets.size()).append("</td></tr><tr><td colspan=\"2\"><ul>");
            Iterator iterator = sets.iterator();
            while (iterator.hasNext()) {
                RatchetTagSet ts;
                RatchetTagSet ratchetTagSet = ts = (RatchetTagSet)iterator.next();
                synchronized (ratchetTagSet) {
                    long expires = ts.getExpiration() - now;
                    if (expires <= 0L) {
                        continue;
                    }
                    int size = ts.remaining();
                    buf.append("<li><b>ID: ");
                    int id = ts.getID();
                    if (id == 65537) {
                        buf.append("NSR");
                    } else {
                        buf.append(id);
                    }
                    buf.append('/').append(ts.getDebugID());
                    if (ts.getAcked()) {
                        buf.append(" acked");
                    }
                    buf.append(" created:</b> ").append(DataHelper.formatTime(ts.getCreated())).append(" <b>last used:</b> ").append(DataHelper.formatTime(ts.getDate()));
                    buf.append(" <b>expires in:</b> ").append(DataHelper.formatDuration2(expires)).append(" with ");
                    buf.append(size).append(" tags remaining");
                    if (ts.getNextKey() != null) {
                        buf.append(" <b>NK sent</b>");
                    }
                }
                buf.append("</li>");
            }
            buf.append("</ul></td></tr>\n");
            out.append(buf);
            buf.setLength(0);
        }
        buf.append("<tr><th colspan=\"2\">Total sets: ").append(totalSets).append("; sessions: ").append(outbound.size()).append("</th></tr>\n</table>");
        out.append(buf);
    }

    private static String toString(PublicKey target) {
        if (target == null) {
            return "null";
        }
        return target.toBase64().substring(0, 20) + "...";
    }

    private class CleanupEvent
    extends SimpleTimer2.TimedEvent {
        public CleanupEvent() {
            super(RatchetSKM.this._context.simpleTimer2(), 180000L);
        }

        @Override
        public void timeReached() {
            if (!RatchetSKM.this._alive) {
                return;
            }
            RatchetSKM.this.aggressiveExpire();
            this.schedule(60000L);
        }
    }

    private class OutboundSession {
        private final PublicKey _target;
        private final HandshakeState _state;
        private ReplyCallback _NScallback;
        private ReplyCallback _NSRcallback;
        private SessionKey _currentKey;
        private final long _established;
        private long _lastUsed;
        private long _lastReceived;
        private final Set<RatchetTagSet> _unackedTagSets;
        private RatchetTagSet _tagSet;
        private final ConcurrentHashMap<Integer, ReplyCallback> _callbacks;
        private final LinkedBlockingQueue<Integer> _acksToSend;
        private SimpleTimer2.TimedEvent _ackTimer;
        private Destination _destination;
        private volatile boolean _acked;
        private int _myOBKeyID = -1;
        private int _currentOBTagSetID;
        private int _myIBKeyID = -1;
        private int _currentIBTagSetID;
        private int _myIBKeySendCount;
        private KeyPair _myIBKeys;
        private KeyPair _myOBKeys;
        private NextSessionKey _myIBKey;
        private NextSessionKey _hisIBKey;
        private NextSessionKey _hisOBKey;
        private NextSessionKey _hisIBKeyWithData;
        private NextSessionKey _hisOBKeyWithData;
        private SessionKey _nextIBRootKey;
        private static final int MIN_RCV_WINDOW_NSR = 12;
        private static final int MAX_RCV_WINDOW_NSR = 12;
        private static final int MIN_RCV_WINDOW_ES = 24;
        private static final int MAX_RCV_WINDOW_ES = 320;
        private static final String INFO_0 = "SessionReplyTags";
        private static final String INFO_7 = "XDHRatchetTagSet";
        private static final int MAX_SEND_ACKS = 16;
        private static final int MAX_SEND_REVERSE_KEY = 128;

        public OutboundSession(PublicKey target, Destination d, SessionKey key, HandshakeState state, ReplyCallback callback) {
            this._target = target;
            this._destination = d;
            this._currentKey = key;
            this._NScallback = callback;
            this._lastUsed = this._established = RatchetSKM.this._context.clock().now();
            this._lastReceived = this._established;
            this._unackedTagSets = new HashSet<RatchetTagSet>(4);
            this._callbacks = new ConcurrentHashMap();
            this._acksToSend = new LinkedBlockingQueue();
            byte[] ck = state.getChainingKey();
            byte[] tagsetkey = new byte[32];
            RatchetSKM.this._hkdf.calculate(ck, ZEROLEN, INFO_0, tagsetkey);
            boolean isInbound = state.getRole() == 2;
            SessionKey rk = new SessionKey(ck);
            SessionKey tk = new SessionKey(tagsetkey);
            if (isInbound) {
                RatchetTagSet tagset;
                this._tagSet = tagset = new RatchetTagSet(RatchetSKM.this._hkdf, state, rk, tk, this._established);
                this._state = null;
                if (RatchetSKM.this._log.shouldDebug()) {
                    RatchetSKM.this._log.debug("New OB Session, rk = " + rk + " tk = " + tk + " 1st tagset:\n" + tagset);
                }
            } else {
                RatchetTagSet tagset = new RatchetTagSet(RatchetSKM.this._hkdf, RatchetSKM.this, state, rk, tk, this._established, 12, 12);
                this._state = state;
                if (RatchetSKM.this._log.shouldDebug()) {
                    RatchetSKM.this._log.debug("New IB Session, rk = " + rk + " tk = " + tk + " 1st tagset:\n" + tagset);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSession(HandshakeState state, ReplyCallback callback, SplitKeys split) {
            boolean isInbound;
            long now;
            SessionKey rk = split.ck;
            this._lastUsed = now = RatchetSKM.this._context.clock().now();
            this._lastReceived = now;
            boolean bl = isInbound = state.getRole() == 2;
            if (isInbound) {
                RatchetTagSet tagset_ab = new RatchetTagSet(RatchetSKM.this._hkdf, RatchetSKM.this, this._target, rk, split.k_ab, now, 0, -1, 24, 320);
                RatchetTagSet tagset_ba = new RatchetTagSet(RatchetSKM.this._hkdf, rk, split.k_ba, now, 0, -1);
                if (RatchetSKM.this._log.shouldDebug()) {
                    RatchetSKM.this._log.debug("Update IB Session, rk = " + rk + " tk = " + split.k_ab + " ES tagset:\n" + tagset_ab);
                    RatchetSKM.this._log.debug("Pending OB Session, rk = " + rk + " tk = " + split.k_ba + " ES tagset:\n" + tagset_ba);
                }
                Set<RatchetTagSet> set = this._unackedTagSets;
                synchronized (set) {
                    this._unackedTagSets.add(tagset_ba);
                    this._NSRcallback = callback;
                }
            }
            RatchetTagSet tagset_ab = new RatchetTagSet(RatchetSKM.this._hkdf, rk, split.k_ab, now, 0, -1);
            RatchetTagSet tagset_ba = new RatchetTagSet(RatchetSKM.this._hkdf, RatchetSKM.this, this._target, rk, split.k_ba, now, 0, -1, 24, 320);
            if (RatchetSKM.this._log.shouldDebug()) {
                RatchetSKM.this._log.debug("Update OB Session, rk = " + rk + " tk = " + split.k_ab + " ES tagset:\n" + tagset_ab);
                RatchetSKM.this._log.debug("Update IB Session, rk = " + rk + " tk = " + split.k_ba + " ES tagset:\n" + tagset_ba);
            }
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                this._tagSet = tagset_ab;
                this._unackedTagSets.clear();
                if (this._NScallback != null) {
                    this._NScallback.onReply();
                    this._NScallback = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextKeyReceived(NextSessionKey key) {
            boolean isReverse = key.isReverse();
            boolean isRequest = key.isRequest();
            boolean hasKey = key.getData() != null;
            int id = key.getID();
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (isReverse) {
                    RatchetTagSet ts;
                    if (isRequest) {
                        if (RatchetSKM.this._log.shouldWarn()) {
                            RatchetSKM.this._log.warn("invalid req+rev in nextkey " + key);
                        }
                        return;
                    }
                    if (key.equals(this._hisIBKey)) {
                        if (RatchetSKM.this._log.shouldDebug()) {
                            RatchetSKM.this._log.debug("Got dup nextkey for OB " + key);
                        }
                        return;
                    }
                    int hisLastIBKeyID = this._hisIBKey == null ? -1 : this._hisIBKey.getID();
                    NextSessionKey receivedKey = key;
                    if (hisLastIBKeyID != id) {
                        if (hisLastIBKeyID != id - 1) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for OB: " + key + " expected " + (hisLastIBKeyID + 1));
                            }
                            return;
                        }
                        if (!hasKey) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for OB w/o key but we don't have it " + key);
                            }
                            return;
                        }
                        this._hisIBKeyWithData = key;
                    } else {
                        if (hasKey) {
                            if (this._hisIBKeyWithData != null && RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for OB with data: " + key + " didn't match previous " + this._hisIBKey + " / " + this._hisIBKeyWithData);
                            }
                            return;
                        }
                        if (this._hisIBKeyWithData == null || this._hisIBKeyWithData.getID() != key.getID()) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for OB w/o key but we don't have it " + key);
                            }
                            return;
                        }
                        key = this._hisIBKeyWithData;
                    }
                    int oldtsID = this._myOBKeyID == -1 && hisLastIBKeyID == -1 ? 0 : 1 + this._myOBKeyID + hisLastIBKeyID;
                    RatchetTagSet oldts = null;
                    if (this._tagSet != null && this._tagSet.getID() == oldtsID) {
                        oldts = this._tagSet;
                    }
                    if (oldts == null) {
                        if (RatchetSKM.this._log.shouldWarn()) {
                            RatchetSKM.this._log.warn("Got nextkey for OB " + key + " but can't find existing OB tagset " + oldtsID);
                        }
                        return;
                    }
                    KeyPair nextKeys = oldts.getNextKeys();
                    if (nextKeys == null) {
                        if (oldtsID == 0 || (oldtsID & 1) != 0 || this._myOBKeys == null) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for OB " + key + " but we didn't send OB keys " + oldtsID);
                            }
                            return;
                        }
                        nextKeys = this._myOBKeys;
                    } else {
                        this._myOBKeys = nextKeys;
                        ++this._myOBKeyID;
                    }
                    this._hisIBKey = receivedKey;
                    PrivateKey priv = nextKeys.getPrivate();
                    PrivateKey sharedSecret = ECIESAEADEngine.doDH(priv, key);
                    byte[] sk = new byte[32];
                    RatchetSKM.this._hkdf.calculate(sharedSecret.getData(), ZEROLEN, INFO_7, sk);
                    SessionKey ssk = new SessionKey(sk);
                    int newtsID = oldtsID + 1;
                    this._tagSet = ts = new RatchetTagSet(RatchetSKM.this._hkdf, oldts.getNextRootKey(), ssk, RatchetSKM.this._context.clock().now(), newtsID, this._myOBKeyID);
                    this._currentOBTagSetID = newtsID;
                    if (RatchetSKM.this._log.shouldWarn()) {
                        RatchetSKM.this._log.warn("Got nextkey " + key + "from " + (this._destination != null ? this._destination.toBase32() : "???") + "\nold OB TS:\n" + oldts + "\nratchet to new OB ES TS:\n" + ts);
                    }
                } else {
                    int newtsID;
                    if (key.equals(this._hisOBKey)) {
                        if (RatchetSKM.this._log.shouldDebug()) {
                            RatchetSKM.this._log.debug("Got dup nextkey for IB " + key);
                        }
                        return;
                    }
                    int hisLastOBKeyID = this._hisOBKey == null ? -1 : this._hisOBKey.getID();
                    NextSessionKey receivedKey = key;
                    if (hisLastOBKeyID != id) {
                        if (hisLastOBKeyID != id - 1) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for IB: " + key + " expected " + (hisLastOBKeyID + 1));
                            }
                            return;
                        }
                        if (!hasKey) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for IB w/o key but we don't have it " + key);
                            }
                            return;
                        }
                        this._hisOBKeyWithData = key;
                    } else {
                        if (hasKey) {
                            if (this._hisOBKeyWithData != null && RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for IB with data: " + key + " didn't match previous " + this._hisOBKey + " / " + this._hisOBKeyWithData);
                            }
                            return;
                        }
                        if (this._hisOBKeyWithData == null || this._hisOBKeyWithData.getID() != key.getID()) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey for IB w/o key but we don't have it " + key);
                            }
                            return;
                        }
                        key = this._hisOBKeyWithData;
                    }
                    if (this._nextIBRootKey == null) {
                        if (RatchetSKM.this._log.shouldWarn()) {
                            RatchetSKM.this._log.warn("Got nextkey for IB but we don't have next root key " + key);
                        }
                        return;
                    }
                    int oldtsID = this._myIBKeyID == -1 && hisLastOBKeyID == -1 ? 0 : 1 + this._myIBKeyID + hisLastOBKeyID;
                    if ((oldtsID & 1) == 0) {
                        if (!isRequest && RatchetSKM.this._log.shouldWarn()) {
                            RatchetSKM.this._log.warn("Got reverse w/o request, generating new key anyway " + key);
                        }
                        this._myIBKeys = RatchetSKM.this._context.commSystem().getXDHFactory().getKeys();
                        ++this._myIBKeyID;
                        this._myIBKey = new NextSessionKey(this._myIBKeys.getPublic().getData(), this._myIBKeyID, true, false);
                    } else {
                        if (this._myIBKeys == null) {
                            if (RatchetSKM.this._log.shouldWarn()) {
                                RatchetSKM.this._log.warn("Got nextkey IB but we don't have old keys " + key);
                            }
                            return;
                        }
                        if (isRequest && RatchetSKM.this._log.shouldWarn()) {
                            RatchetSKM.this._log.warn("Got reverse with request, using old key anyway " + key);
                        }
                        this._myIBKey = new NextSessionKey(this._myIBKeyID, true, false);
                    }
                    this._hisOBKey = receivedKey;
                    PrivateKey sharedSecret = ECIESAEADEngine.doDH(this._myIBKeys.getPrivate(), key);
                    this._currentIBTagSetID = newtsID = oldtsID + 1;
                    this._myIBKeySendCount = 0;
                    byte[] sk = new byte[32];
                    RatchetSKM.this._hkdf.calculate(sharedSecret.getData(), ZEROLEN, INFO_7, sk);
                    SessionKey ssk = new SessionKey(sk);
                    RatchetTagSet ts = new RatchetTagSet(RatchetSKM.this._hkdf, RatchetSKM.this, this._target, this._nextIBRootKey, ssk, RatchetSKM.this._context.clock().now(), newtsID, this._myIBKeyID, 320, 320);
                    this._nextIBRootKey = ts.getNextRootKey();
                    if (RatchetSKM.this._log.shouldWarn()) {
                        RatchetSKM.this._log.warn("Got nextkey " + key + "from " + (this._destination != null ? this._destination.toBase32() : "???") + "\nold IB TS ID #" + oldtsID + "\nratchet to new IB ES TS:\n" + ts);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NextSessionKey getReverseSendKey() {
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (this._myIBKey == null) {
                    return null;
                }
                if (this._myIBKeySendCount > 128) {
                    return null;
                }
                ++this._myIBKeySendCount;
                return this._myIBKey;
            }
        }

        void tagConsumed(RatchetTagSet set) {
            this._lastReceived = set.getDate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firstTagConsumed(RatchetTagSet set) {
            this.tagConsumed(set);
            SessionKey sk = set.getAssociatedKey();
            Set<RatchetTagSet> set2 = this._unackedTagSets;
            synchronized (set2) {
                this._nextIBRootKey = set.getNextRootKey();
                for (RatchetTagSet obSet : this._unackedTagSets) {
                    if (!obSet.getAssociatedKey().equals(sk)) continue;
                    if (RatchetSKM.this._log.shouldDebug()) {
                        RatchetSKM.this._log.debug("First tag received from IB ES\n" + set + "\npromoting OB ES " + obSet);
                    }
                    this._unackedTagSets.clear();
                    this._tagSet = obSet;
                    if (this._NSRcallback != null) {
                        this._NSRcallback.onReply();
                        this._NSRcallback = null;
                    }
                    this._lastUsed = RatchetSKM.this._context.clock().now();
                    return;
                }
                if (RatchetSKM.this._log.shouldDebug()) {
                    RatchetSKM.this._log.debug("First tag received from IB ES\n" + set + " but no corresponding OB ES set found, unacked size: " + this._unackedTagSets.size() + " acked size: " + (this._tagSet != null ? 1 : 0));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<RatchetTagSet> getTagSets() {
            ArrayList<RatchetTagSet> rv;
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                rv = new ArrayList<RatchetTagSet>(this._unackedTagSets);
                if (this._tagSet != null) {
                    rv.add(this._tagSet);
                }
            }
            return rv;
        }

        public PublicKey getTarget() {
            return this._target;
        }

        public HandshakeState getHandshakeState() {
            return this._state;
        }

        public SessionKey getCurrentKey() {
            return this._currentKey;
        }

        public long getEstablishedDate() {
            return this._established;
        }

        public long getLastUsedDate() {
            return this._lastUsed;
        }

        public long getLastReceivedDate() {
            return this._lastReceived;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int expireTags(long now) {
            int removed = 0;
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (this._tagSet != null && this._tagSet.getExpiration() <= now) {
                    this._tagSet = null;
                    ++removed;
                }
                Iterator<RatchetTagSet> iter = this._unackedTagSets.iterator();
                while (iter.hasNext()) {
                    RatchetTagSet set2 = iter.next();
                    if (set2.getExpiration() > now) continue;
                    iter.remove();
                    ++removed;
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RatchetEntry consumeNext() {
            long now = RatchetSKM.this._context.clock().now();
            if (this._lastReceived + 480000L < now) {
                if (RatchetSKM.this._log.shouldInfo()) {
                    RatchetSKM.this._log.info("Expired OB session because IB TS expired");
                }
                return null;
            }
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (this._tagSet != null) {
                    if (this._ackTimer != null) {
                        this._ackTimer.cancel();
                        this._ackTimer = null;
                    }
                    RatchetTagSet ratchetTagSet = this._tagSet;
                    synchronized (ratchetTagSet) {
                        RatchetSessionTag tag = this._tagSet.consumeNext();
                        if (tag != null) {
                            this._lastUsed = now;
                            this._tagSet.setDate(now);
                            SessionKeyAndNonce skn = this._tagSet.consumeNextKey();
                            NextSessionKey fwd = this._tagSet.getNextKey();
                            NextSessionKey rev = this.getReverseSendKey();
                            if ((fwd != null || rev != null) && RatchetSKM.this._log.shouldInfo()) {
                                RatchetSKM.this._log.info("Sending fwd key: " + fwd + " rev key: " + rev + " for " + this._tagSet);
                            }
                            return new RatchetEntry(tag, skn, this._tagSet.getID(), 0, fwd, rev, this.getAcksToSend());
                        }
                        if (RatchetSKM.this._log.shouldInfo()) {
                            RatchetSKM.this._log.info("Removing empty " + this._tagSet);
                        }
                    }
                    this._tagSet = null;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerTimer(Destination d, SimpleTimer2.TimedEvent timer) {
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (this._ackTimer != null) {
                    return false;
                }
                if (d != null) {
                    if (this._destination == null) {
                        this._destination = d;
                    } else if (RatchetSKM.this._log.shouldWarn() && !this._destination.equals(d)) {
                        RatchetSKM.this._log.warn("Destination mismatch? was: " + this._destination.toBase32() + " now: " + d.toBase32());
                    }
                }
                this._ackTimer = timer;
                if (RatchetSKM.this._log.shouldDebug()) {
                    RatchetSKM.this._log.debug("Registered an ack timer to: " + (this._destination != null ? this._destination.toBase32() : this._target.toString()));
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination getDestination() {
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                return this._destination;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int availableTags() {
            long now = RatchetSKM.this._context.clock().now();
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (this._tagSet != null) {
                    RatchetTagSet ratchetTagSet = this._tagSet;
                    synchronized (ratchetTagSet) {
                        if (this._tagSet.getExpiration() > now) {
                            return this._tagSet.remaining();
                        }
                    }
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastExpirationDate() {
            Set<RatchetTagSet> set = this._unackedTagSets;
            synchronized (set) {
                if (this._tagSet != null) {
                    return this._tagSet.getExpiration();
                }
            }
            return -1L;
        }

        public boolean getAckReceived() {
            return this._acked;
        }

        public void registerCallback(int id, int n, ReplyCallback callback) {
            Integer key = id << 16 | n;
            ReplyCallback old = this._callbacks.putIfAbsent(key, callback);
            if (old != null) {
                if (old.getExpiration() < RatchetSKM.this._context.clock().now()) {
                    this._callbacks.put(key, callback);
                } else if (RatchetSKM.this._log.shouldWarn()) {
                    RatchetSKM.this._log.warn("Not replacing callback: " + old);
                }
            }
        }

        public void receivedACK(int id, int n) {
            Integer key = id << 16 | n;
            ReplyCallback callback = this._callbacks.remove(key);
            if (callback != null) {
                if (RatchetSKM.this._log.shouldInfo()) {
                    RatchetSKM.this._log.info("ACK rcvd ID " + id + " n=" + n + " callback " + callback);
                }
                callback.onReply();
            } else if (RatchetSKM.this._log.shouldInfo()) {
                RatchetSKM.this._log.info("ACK rcvd ID " + id + " n=" + n + ", no callback");
            }
        }

        public void ackRequested(int id, int n) {
            Integer key = id << 16 | n;
            this._acksToSend.offer(key);
        }

        private List<Integer> getAcksToSend() {
            if (this._acksToSend == null) {
                return null;
            }
            int sz = this._acksToSend.size();
            if (sz == 0) {
                return null;
            }
            ArrayList<Integer> rv = new ArrayList<Integer>(Math.min(sz, 16));
            this._acksToSend.drainTo(rv, 16);
            if (rv.isEmpty()) {
                return null;
            }
            return rv;
        }

        public int expireCallbacks(long now) {
            if (this._callbacks.isEmpty()) {
                return 0;
            }
            int rv = 0;
            Iterator<ReplyCallback> iter = this._callbacks.values().iterator();
            while (iter.hasNext()) {
                ReplyCallback cb = iter.next();
                if (cb.getExpiration() >= now) continue;
                iter.remove();
                ++rv;
            }
            return rv;
        }
    }

    private static class RatchetTagSetComparator
    implements Comparator<RatchetTagSet>,
    Serializable {
        private RatchetTagSetComparator() {
        }

        @Override
        public int compare(RatchetTagSet l, RatchetTagSet r) {
            return l.getDebugID() - r.getDebugID();
        }
    }
}

