/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.Writer;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class StatisticsManager {
    private final Log _log;
    private final RouterContext _context;
    private final String _networkID;
    public static final String PROP_PUBLISH_RANKINGS = "router.publishPeerRankings";
    private static final int RANDOM_INCLUDE_STATS = 16;
    private static final boolean SIMPLE_STATS = "0.9.66".equals("0.9.58");
    private final DecimalFormat _fmt;
    private final DecimalFormat _pct;
    private static final String[] tunnelStats = new String[]{"Expire", "Reject", "Success"};

    public StatisticsManager(RouterContext context) {
        this._context = context;
        this._fmt = SIMPLE_STATS ? new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.UK)) : new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.UK));
        this._pct = new DecimalFormat("#0.00%", new DecimalFormatSymbols(Locale.UK));
        this._log = context.logManager().getLog(StatisticsManager.class);
        Router r = context.router();
        this._networkID = r != null ? Integer.toString(r.getNetworkID()) : "2";
    }

    public Properties publishStatistics() {
        return this.publishStatistics(this._context.routerHash());
    }

    public Properties publishStatistics(Hash h) {
        String family;
        Properties stats = new Properties();
        stats.setProperty("router.version", "0.9.66");
        stats.setProperty("netId", this._networkID);
        String caps = this._context.router().getCapabilities();
        stats.setProperty("caps", caps);
        if (this._context.getBooleanPropertyDefaultTrue(PROP_PUBLISH_RANKINGS) && this._context.random().nextInt(16) == 0 && this._context.router().getUptime() > 3720000L) {
            this.includeRate("tunnel.participatingTunnels", stats, new long[]{3600000L}, true);
            long rate = 3600000L;
            this.includeTunnelRates("Exploratory", stats, rate);
        }
        if (caps.indexOf(102) >= 0) {
            int ri = this._context.router().getUptime() > 1800000L ? this._context.netDb().getKnownRouters() : 3000 + this._context.random().nextInt(1000);
            stats.setProperty("netdb.knownRouters", String.valueOf(ri));
            int ls = this._context.router().getUptime() > 1800000L ? this._context.netDb().getKnownLeaseSets() : 30 + this._context.random().nextInt(40);
            stats.setProperty("netdb.knownLeaseSets", String.valueOf(ls));
        }
        if ((family = this._context.getProperty("netdb.family.name")) != null) {
            FamilyKeyCrypto fkc;
            String sig = null;
            String key = null;
            RouterInfo oldRI = this._context.router().getRouterInfo();
            if (oldRI != null && family.equals(oldRI.getOption("family")) && (key = oldRI.getOption("family.key")) != null) {
                if (key.contains(";")) {
                    key = null;
                } else {
                    sig = oldRI.getOption("family.sig");
                    if (sig != null) {
                        stats.setProperty("family", family);
                        stats.setProperty("family.key", key);
                        stats.setProperty("family.sig", sig);
                    }
                }
            }
            if ((sig == null || key == null) && (fkc = this._context.router().getFamilyKeyCrypto()) != null) {
                try {
                    stats.putAll(fkc.sign(family, h));
                }
                catch (GeneralSecurityException gse) {
                    this._log.error("Failed to sign router family", gse);
                    stats.remove("family.key");
                    stats.remove("family.sig");
                }
            }
        }
        return stats;
    }

    private void includeRate(String rateName, Properties stats, long[] selectedPeriods, boolean fudgeQuantity) {
        RateStat rate = this._context.statManager().getRate(rateName);
        if (rate == null) {
            return;
        }
        long[] periods = rate.getPeriods();
        for (int i = 0; i < periods.length; ++i) {
            Rate curRate;
            if (periods[i] > this._context.router().getUptime()) continue;
            if (selectedPeriods != null) {
                boolean found = false;
                for (int j = 0; j < selectedPeriods.length; ++j) {
                    if (selectedPeriods[j] != periods[i]) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if ((curRate = rate.getRate(periods[i])) == null || curRate.getLifetimeEventCount() <= 0L) continue;
            stats.setProperty("stat_" + rateName + '.' + StatisticsManager.getPeriod(curRate), this.renderRate(curRate, fudgeQuantity));
        }
    }

    private String renderRate(Rate rate, boolean fudgeQuantity) {
        if (SIMPLE_STATS) {
            return this.num(rate.getAverageValue());
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.num(rate.getAverageValue())).append(';');
        buf.append(this.num(rate.getExtremeAverageValue())).append(';');
        buf.append(this.pct(rate.getPercentageOfLifetimeValue())).append(';');
        if (rate.getLifetimeTotalEventTime() > 0L) {
            buf.append(this.pct(rate.getLastEventSaturation())).append(';');
            buf.append(this.num(rate.getLastSaturationLimit())).append(';');
            buf.append(this.pct(rate.getExtremeEventSaturation())).append(';');
            buf.append(this.num(rate.getExtremeSaturationLimit())).append(';');
        }
        long numPeriods = rate.getLifetimePeriods();
        if (fudgeQuantity) {
            buf.append("555;");
            if (numPeriods > 0L) {
                buf.append("555;555;");
            }
        } else {
            buf.append(this.num(rate.getLastEventCount())).append(';');
            if (numPeriods > 0L) {
                double avgFrequency = (double)rate.getLifetimeEventCount() / (double)numPeriods;
                buf.append(this.num(avgFrequency)).append(';');
                buf.append(this.num(rate.getExtremeEventCount())).append(';');
                buf.append(this.num(rate.getLifetimeEventCount())).append(';');
            }
        }
        return buf.toString();
    }

    private void includeTunnelRates(String tunnelType, Properties stats, long selectedPeriod) {
        Rate curRate;
        RateStat stat;
        String rateName;
        long totalEvents = 0L;
        for (String tunnelStat : tunnelStats) {
            rateName = "tunnel.build" + tunnelType + tunnelStat;
            stat = this._context.statManager().getRate(rateName);
            if (stat == null || (curRate = stat.getRate(selectedPeriod)) == null) continue;
            totalEvents += curRate.getLastEventCount();
        }
        if (totalEvents <= 0L) {
            return;
        }
        for (String tunnelStat : tunnelStats) {
            rateName = "tunnel.build" + tunnelType + tunnelStat;
            stat = this._context.statManager().getRate(rateName);
            if (stat == null || (curRate = stat.getRate(selectedPeriod)) == null) continue;
            double fudgeQuantity = 100.0 * (double)curRate.getLastEventCount() / (double)totalEvents;
            stats.setProperty("stat_" + rateName + '.' + StatisticsManager.getPeriod(curRate), this.renderRate(curRate, fudgeQuantity));
        }
    }

    private String renderRate(Rate rate, double fudgeQuantity) {
        if (SIMPLE_STATS) {
            return "0;0;0;" + this.num(fudgeQuantity);
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.num(rate.getAverageValue())).append(';');
        buf.append(this.num(rate.getExtremeAverageValue())).append(';');
        buf.append(this.pct(rate.getPercentageOfLifetimeValue())).append(';');
        if (rate.getLifetimeTotalEventTime() > 0L) {
            buf.append("0;0;0;0;");
        }
        buf.append(this.num(fudgeQuantity)).append(';');
        return buf.toString();
    }

    private static String getPeriod(Rate rate) {
        return DataHelper.formatDuration(rate.getPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String num(double num) {
        if (num < 0.0) {
            num = 0.0;
        }
        DecimalFormat decimalFormat = this._fmt;
        synchronized (decimalFormat) {
            return this._fmt.format(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String pct(double num) {
        if (num < 0.0) {
            num = 0.0;
        }
        DecimalFormat decimalFormat = this._pct;
        synchronized (decimalFormat) {
            return this._pct.format(num);
        }
    }

    public void renderStatusHTML(Writer out) {
    }
}

