/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

public class Datagram2 {
    private final Destination _from;
    private final byte[] _payload;
    private final Properties _options;
    private static final int INIT_DGRAM_BUFSIZE = 2048;
    private static final int MIN_DGRAM_SIZE = 429;
    private static final int MAX_DGRAM_BUFSIZE = 62464;
    private static final byte VERSION_MASK = 15;
    private static final byte OPTIONS = 16;
    private static final byte OFFLINE = 32;
    private static final byte VERSION = 2;

    private Datagram2(Destination dest, byte[] data, Properties options) {
        this._from = dest;
        this._payload = data;
        this._options = options;
    }

    public static byte[] make(I2PAppContext ctx, I2PSession session, byte[] payload, Hash tohash) throws DataFormatException {
        return Datagram2.make(ctx, session, payload, tohash, null);
    }

    public static byte[] make(I2PAppContext ctx, I2PSession session, byte[] payload, Hash tohash, Properties options) throws DataFormatException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(payload.length + 512);
        try {
            Destination dest = session.getMyDestination();
            dest.writeBytes(out);
            int off = out.size();
            out.write(tohash.getData());
            out.write(0);
            int flags = 2;
            if (options != null && !options.isEmpty()) {
                flags = (byte)(flags | 0x10);
            }
            if (session.isOffline()) {
                flags = (byte)(flags | 0x20);
            }
            out.write(flags);
            if (options != null && !options.isEmpty()) {
                DataHelper.writeProperties(out, options);
            }
            if (session.isOffline()) {
                DataHelper.writeLong(out, 4, session.getOfflineExpiration() / 1000L);
                SigningPublicKey tspk = session.getTransientSigningPublicKey();
                DataHelper.writeLong(out, 2, tspk.getType().getCode());
                tspk.writeBytes(out);
                Signature tsig = session.getOfflineSignature();
                tsig.writeBytes(out);
            }
            out.write(payload);
            byte[] data = out.toByteArray();
            SigningPrivateKey sxPrivKey = session.getPrivateKey();
            Signature sig = ctx.dsa().sign(data, off, out.size() - off, sxPrivKey);
            if (sig == null) {
                throw new IllegalArgumentException("Sig fail");
            }
            sig.writeBytes(out);
            if (out.size() - 32 > 62464) {
                throw new DataFormatException("Too big");
            }
            byte[] rv = out.toByteArray();
            System.arraycopy(rv, off + 32, rv, off, rv.length - (off + 32));
            return Arrays.copyOfRange(rv, 0, rv.length - 32);
        }
        catch (IOException e) {
            throw new DataFormatException("DG2 maker error", e);
        }
    }

    public static Datagram2 load(I2PAppContext ctx, I2PSession session, byte[] dgram) throws DataFormatException, I2PInvalidDatagramException {
        if (dgram.length < 429) {
            throw new DataFormatException("Datagram2 too small: " + dgram.length);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(dgram);
        try {
            Destination rxDest = Destination.create(in);
            int off = dgram.length - in.available();
            in.read();
            int flags = in.read();
            int version = flags & 0xF;
            if (version != 2) {
                throw new DataFormatException("Bad version " + version);
            }
            SigningPublicKey spk = rxDest.getSigningPublicKey();
            SigType type = spk.getType();
            if (type == null) {
                throw new DataFormatException("unsupported sig type");
            }
            int optlen = 0;
            Properties options = null;
            if ((flags & 0x10) != 0) {
                in.mark(0);
                optlen = (int)DataHelper.readLong(in, 2);
                if (optlen > 0) {
                    in.reset();
                    if (in.available() < optlen) {
                        throw new DataFormatException("too small for options: " + dgram.length);
                    }
                    options = DataHelper.readProperties(in, null, true);
                }
                optlen += 2;
            }
            int offlinelen = 0;
            if ((flags & 0x20) != 0) {
                offlinelen = 6;
                int off2 = dgram.length - in.available();
                long transientExpires = DataHelper.readLong(in, 4) * 1000L;
                if (transientExpires < ctx.clock().now()) {
                    throw new I2PInvalidDatagramException("Offline signature expired");
                }
                int itype = (int)DataHelper.readLong(in, 2);
                SigType ttype = SigType.getByCode(itype);
                if (ttype == null || !ttype.isAvailable()) {
                    throw new I2PInvalidDatagramException("Unsupported transient sig type: " + itype);
                }
                SigningPublicKey transientSigningPublicKey = new SigningPublicKey(type);
                byte[] buf = new byte[transientSigningPublicKey.length()];
                offlinelen += buf.length;
                in.read(buf);
                transientSigningPublicKey.setData(buf);
                SigType otype = rxDest.getSigningPublicKey().getType();
                Signature offlineSignature = new Signature(otype);
                buf = new byte[offlineSignature.length()];
                offlinelen += buf.length;
                in.read(buf);
                offlineSignature.setData(buf);
                byte[] data = new byte[]{};
                if (!ctx.dsa().verifySignature(offlineSignature, dgram, off2, 6 + transientSigningPublicKey.length(), spk)) {
                    throw new I2PInvalidDatagramException("Bad offline signature");
                }
            }
            int siglen = type.getSigLen();
            in.skip(in.available() - siglen);
            Signature sig = new Signature(type);
            sig.readBytes(in);
            byte[] buf = new byte[dgram.length + 32 - (off + siglen)];
            System.arraycopy(session.getMyDestination().calculateHash().getData(), 0, buf, 0, 32);
            System.arraycopy(dgram, off, buf, 32, dgram.length - (off + siglen));
            if (!ctx.dsa().verifySignature(sig, buf, spk)) {
                throw new I2PInvalidDatagramException("Bad signature " + (Object)((Object)type));
            }
            if (offlinelen > 0) {
                off += offlinelen;
            }
            int datalen = dgram.length - (off + 2 + optlen + siglen);
            byte[] payload = new byte[datalen];
            System.arraycopy(dgram, off + 2 + optlen, payload, 0, datalen);
            return new Datagram2(rxDest, payload, options);
        }
        catch (IOException e) {
            throw new DataFormatException("Error loading datagram", e);
        }
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public Destination getSender() {
        return this._from;
    }

    public Properties getOptions() {
        return this._options;
    }
}

