/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.xinfo;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PanelHelper;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257009856274970416L;
    private final String panelResourceName;
    private JTextArea textArea;

    public XInfoPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.panelResourceName = PanelHelper.getPanelResourceName(panel, "info", resources);
        String panelName = PanelHelper.getPanelName(panel);
        String titleMessageKey = PanelHelper.getPanelTitleMessageKey(panel, "info", installData);
        this.add((Component)LabelFactory.create(this.getString(titleMessageKey), (Icon)parent.getIcons().get("edit"), 10), "nextLine");
        this.textArea = new JTextArea();
        this.textArea.setName(panelName.equals("XInfoPanel") ? GuiId.XINFO_PANEL_TEXT_AREA.id : GuiId.INFO_PANEL_TEXT_AREA.id);
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
        String textAreaFont = installData.getVariable(panelName + ".font");
        if (textAreaFont != null && textAreaFont.length() > 0) {
            Font font = Font.decode(textAreaFont);
            this.textArea.setFont(font);
        }
        JScrollPane scroller = new JScrollPane(this.textArea);
        this.add((Component)scroller, "nextLine");
        this.getLayoutHelper().completeLayout();
    }

    private String getInfoText() {
        String infoText = this.getResources().getString(this.panelResourceName, null, "Error : could not load the infoText text !");
        if (this.substituteVariables()) {
            infoText = this.installData.getVariables().replace(infoText);
        }
        return infoText;
    }

    @Override
    public void panelActivate() {
        this.textArea.setText(this.getInfoText());
        this.textArea.setCaretPosition(0);
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    protected boolean substituteVariables() {
        return true;
    }
}

