/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.installer.base.InstallDataConfiguratorWithRules;
import com.izforge.izpack.installer.gui.InstallerFrame;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class InstallerController {
    private static final Logger logger = Logger.getLogger(InstallerController.class.getName());
    private InstallerFrame installerFrame;

    public InstallerController(InstallDataConfiguratorWithRules installDataRulesEngineManager, InstallerFrame installerFrame) {
        this.installerFrame = installerFrame;
        installDataRulesEngineManager.configureInstallData();
    }

    public InstallerController buildInstallation() {
        this.run(() -> {
            this.installerFrame.buildGUI();
            this.installerFrame.sizeFrame();
        });
        return this;
    }

    public void launchInstallation() {
        this.run(() -> {
            this.installerFrame.setVisible(true);
            this.installerFrame.navigateNext();
        });
    }

    private void run(Runnable action) {
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(action);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                logger.log(Level.INFO, "Action invocation failed", targetException);
                throw new IzPackException(targetException);
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "Action invocation failed", exception);
                throw new IzPackException(exception);
            }
        }
    }
}

