/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.CommentedMap;
import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.Profile;
import com.izforge.izpack.api.config.spi.IniHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractProfileBuilder
implements IniHandler {
    private Profile.Section _currentSection;
    private List<String> lastComments = new ArrayList<String>();

    AbstractProfileBuilder() {
    }

    @Override
    public void endIni() {
        this.setFooterComment();
    }

    @Override
    public void endSection() {
        this._currentSection = null;
    }

    @Override
    public void handleComment(List<String> comment) {
        this.lastComments.addAll(comment);
    }

    @Override
    public void handleEmptyLine() {
        this.lastComments.add("\u0000");
    }

    @Override
    public void handleOption(String name, String value) {
        if (this.getConfig().isMultiOption()) {
            this._currentSection.add(name, value);
        } else {
            this._currentSection.put(name, value);
        }
        this.putComment(this._currentSection, name);
    }

    @Override
    public void startIni() {
        this.lastComments.clear();
    }

    @Override
    public void startSection(String sectionName) {
        Profile.Section s;
        this._currentSection = this.getConfig().isMultiSection() ? this.getProfile().add(sectionName) : ((s = (Profile.Section)this.getProfile().get(sectionName)) == null ? this.getProfile().add(sectionName) : s);
        this.putComment(this.getProfile(), sectionName);
    }

    abstract Config getConfig();

    abstract Profile getProfile();

    Profile.Section getCurrentSection() {
        return this._currentSection;
    }

    private void setFooterComment() {
        if (this.getConfig().isComment() && !this.lastComments.isEmpty()) {
            this.getProfile().setFooterComment(this.lastComments);
        }
    }

    private void putComment(CommentedMap<String, ?> map, String key) {
        if (this.getConfig().isComment() && !this.lastComments.isEmpty()) {
            map.putComment(key, this.lastComments);
            this.lastComments = new LinkedList<String>();
        }
    }
}

