/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundEstablishState2;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState2;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.I2PThread;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

class EstablishmentManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final int _networkID;
    private final PacketBuilder2 _builder2;
    private final Map<RemoteHostId, Token> _outboundTokens;
    private final Map<RemoteHostId, Token> _inboundTokens;
    private final ObjectCounter<RemoteHostId> _terminationCounter;
    private final ConcurrentHashMap<RemoteHostId, InboundEstablishState> _inboundStates;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundStates;
    private final ConcurrentHashMap<RemoteHostId, List<OutNetMessage>> _queuedOutbound;
    private final ConcurrentHashMap<Long, OutboundEstablishState> _liveIntroductions;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundByClaimedAddress;
    private final ConcurrentHashMap<Hash, OutboundEstablishState> _outboundByHash;
    private final Map<RemoteHostId, Long> _inboundBans;
    private volatile boolean _alive;
    private final Object _activityLock;
    private int _activity;
    private final int DEFAULT_MAX_CONCURRENT_ESTABLISH;
    private static final int DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH = SystemVersion.isSlow() ? 20 : 40;
    private static final int DEFAULT_HIGH_MAX_CONCURRENT_ESTABLISH = 150;
    private static final String PROP_MAX_CONCURRENT_ESTABLISH = "i2np.udp.maxConcurrentEstablish";
    private static final int MAX_QUEUED_OUTBOUND = 50;
    private static final int MAX_QUEUED_PER_PEER = 16;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final int MAX_OB_ESTABLISH_TIME = 25000;
    public static final int MAX_IB_ESTABLISH_TIME = 12000;
    public static final int OB_MESSAGE_TIMEOUT = 15000;
    private static final int DATA_MESSAGE_TIMEOUT = 10000;
    private static final int IB_BAN_TIME = 900000;
    private static final int MIN_TOKENS = 128;
    private static final int MAX_TOKENS = 2048;
    public static final long IB_TOKEN_EXPIRATION = 3600000L;
    private static final long MAX_SKEW = 120000L;
    private static final String TOKEN_FILE = "ssu2tokens.txt";
    private static final int MAX_TERMINATIONS = 2;
    public static final long MAX_TAG_VALUE = 0xFFFFFFFFL;

    public EstablishmentManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(EstablishmentManager.class);
        this._networkID = ctx.router().getNetworkID();
        this._transport = transport;
        this._builder2 = transport.getBuilder2();
        this._inboundStates = new ConcurrentHashMap();
        this._outboundStates = new ConcurrentHashMap();
        this._queuedOutbound = new ConcurrentHashMap();
        this._liveIntroductions = new ConcurrentHashMap();
        this._outboundByClaimedAddress = new ConcurrentHashMap();
        this._outboundByHash = new ConcurrentHashMap();
        this._inboundBans = new LHMCache<RemoteHostId, Long>(32);
        int tokenCacheSize = Math.max(128, Math.min(2048, 3 * this._transport.getMaxConnections() / 4));
        this._inboundTokens = new InboundTokens(tokenCacheSize);
        this._outboundTokens = new LHMCache<RemoteHostId, Token>(tokenCacheSize);
        this._terminationCounter = new ObjectCounter();
        this._activityLock = new Object();
        this.DEFAULT_MAX_CONCURRENT_ESTABLISH = Math.max(DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH, Math.min(150, ctx.bandwidthLimiter().getOutboundKBytesPerSecond() / 2));
        this._context.statManager().createRateStat("udp.inboundEstablishTime", "How long it takes for a new inbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundEstablishTime", "How long it takes for a new outbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayTimeout", "How often a relay request times out before getting a response (due to the target or intro peer being offline)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishDropped", "Dropped an inbound establish message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishRejected", "How many pending outbound connections are there when we refuse to add any more?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishOverflow", "How many messages were queued up on a pending connection when it was too much?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestionOccurred", "How large the cwin was when congestion occurred (duration == sendBps)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestedRTO", "retransmission timeout after congestion (duration == rtt dev)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuIncrease", "How many retransmissions have there been to the peer when the MTU was increased", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuDecrease", "How many retransmissions have there been to the peer when the MTU was decreased", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentActive", "How many messages are currently being sent to the peer when we reject it (period is how many concurrent packets we allow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.allowConcurrentActive", "How many messages are currently being sent to the peer when we accept it (period is how many concurrent packets we allow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentSequence", "How many consecutive concurrency rejections have we had when we stop rejecting (period is how many concurrent packets we are on)", "udp", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.inboundTokenLifetime", "SSU2 token lifetime (ms)", "udp", new long[]{300000L});
        this._context.statManager().createRequiredRateStat("udp.inboundConn", "Inbound UDP Connection", "udp", new long[]{60000L});
    }

    public synchronized void startup() {
        this.loadTokens();
        this._alive = true;
        I2PThread t = new I2PThread(new Establisher(), "UDP Establisher", true);
        t.start();
    }

    public synchronized void shutdown() {
        this._alive = false;
        this.saveTokens();
        this.notifyActivity();
    }

    InboundEstablishState getInboundState(RemoteHostId from) {
        InboundEstablishState state = this._inboundStates.get(from);
        return state;
    }

    OutboundEstablishState getOutboundState(RemoteHostId from) {
        OutboundEstablishState state = this._outboundStates.get(from);
        if (state == null && (state = this._outboundByClaimedAddress.get(from)) != null && this._log.shouldLog(20)) {
            this._log.info("Found by claimed address: " + state);
        }
        return state;
    }

    private int getMaxConcurrentEstablish() {
        return this._context.getProperty(PROP_MAX_CONCURRENT_ESTABLISH, this.DEFAULT_MAX_CONCURRENT_ESTABLISH);
    }

    public void establish(OutNetMessage msg) {
        this.establish(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establish(OutNetMessage msg, boolean queueIfMaxExceeded) {
        RouterInfo toRouterInfo = msg.getTarget();
        RouterAddress ra = this._transport.getTargetAddress(toRouterInfo);
        if (ra == null) {
            this._transport.failed(msg, "Remote peer has no address, cannot establish");
            return;
        }
        RouterIdentity toIdentity = toRouterInfo.getIdentity();
        Hash toHash = toIdentity.calculateHash();
        int id = toRouterInfo.getNetworkId();
        if (id != this._networkID) {
            if (id == -1) {
                this._context.banlist().banlistRouter(toHash, "No network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(toHash, "Not in our network: " + id);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Not in our network: " + toRouterInfo, new Exception());
            }
            this._transport.markUnreachable(toHash);
            this._transport.failed(msg, "Not in our network");
            return;
        }
        UDPAddress addr = new UDPAddress(ra);
        RemoteHostId maybeTo = null;
        InetAddress remAddr = addr.getHostAddress();
        int port = addr.getPort();
        if (remAddr != null && port > 0 && port <= 65535) {
            maybeTo = new RemoteHostId(remAddr.getAddress(), port);
            if (!this._transport.isValid(maybeTo.getIP()) || Arrays.equals(maybeTo.getIP(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
                this._transport.failed(msg, "Remote peer's IP isn't valid");
                this._transport.markUnreachable(toHash);
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                return;
            }
            InboundEstablishState inState = this._inboundStates.get(maybeTo);
            if (inState != null) {
                InboundEstablishState inboundEstablishState = inState;
                synchronized (inboundEstablishState) {
                    switch (inState.getState()) {
                        case IB_STATE_UNKNOWN: 
                        case IB_STATE_REQUEST_RECEIVED: 
                        case IB_STATE_CREATED_SENT: 
                        case IB_STATE_CONFIRMED_PARTIALLY: 
                        case IB_STATE_CONFIRMED_COMPLETELY: 
                        case IB_STATE_TOKEN_REQUEST_RECEIVED: 
                        case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: 
                        case IB_STATE_RETRY_SENT: {
                            inState.addMessage(msg);
                            if (!this._log.shouldLog(30)) break;
                            this._log.debug("OB msg queued to IES");
                            break;
                        }
                        case IB_STATE_COMPLETE: {
                            this._transport.sendIfEstablished(msg);
                            break;
                        }
                        case IB_STATE_FAILED: {
                            this._transport.failed(msg, "OB msg failed during IB establish");
                        }
                    }
                }
                return;
            }
        }
        boolean isIndirect = addr.getIntroducerCount() > 0 || maybeTo == null;
        RemoteHostId to = isIndirect ? new RemoteHostId(toHash) : maybeTo;
        OutboundEstablishState state = null;
        int deferred = 0;
        boolean rejected = false;
        int queueCount = 0;
        state = this._outboundStates.get(to);
        if (state == null && (state = this._outboundByHash.get(toHash)) != null && this._log.shouldLog(20)) {
            this._log.info("Found by hash: " + state);
        }
        if (state == null) {
            if (queueIfMaxExceeded && this._outboundStates.size() >= this.getMaxConcurrentEstablish()) {
                if (this._queuedOutbound.size() >= 50 && !this._queuedOutbound.containsKey(to)) {
                    rejected = true;
                } else {
                    ArrayList<OutNetMessage> newQueued = new ArrayList<OutNetMessage>(16);
                    ArrayList<OutNetMessage> queued = this._queuedOutbound.putIfAbsent(to, newQueued);
                    if (queued == null) {
                        queued = newQueued;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Queueing outbound establish to " + to + ", increase " + PROP_MAX_CONCURRENT_ESTABLISH);
                        }
                    }
                    ArrayList<OutNetMessage> arrayList = queued;
                    synchronized (arrayList) {
                        queueCount = queued.size();
                        if (queueCount < 16) {
                            queued.add(msg);
                            ++queueCount;
                        } else {
                            rejected = true;
                        }
                        deferred = this._queuedOutbound.size();
                    }
                }
            } else {
                boolean isNew;
                SessionKey sessionKey;
                String siv;
                byte[] keyBytes;
                int version = this._transport.getSSUVersion(ra);
                if (isIndirect && version == 2 && ra.getTransportStyle().equals("SSU")) {
                    boolean v2intros = false;
                    int count = addr.getIntroducerCount();
                    long now = this._context.clock().now();
                    for (int i = 0; i < count; ++i) {
                        Hash h = addr.getIntroducerHash(i);
                        long exp = addr.getIntroducerExpiration(i);
                        if (h != null && (exp > now || exp == 0L)) {
                            v2intros = true;
                            break;
                        }
                        if (v2intros) continue;
                        this._transport.markUnreachable(toHash);
                        this._transport.failed(msg, "No v2 introducers");
                        return;
                    }
                }
                if (version == 2) {
                    int mtu = addr.getMTU();
                    boolean isIPv6 = TransportUtil.isIPv6(ra);
                    int ourMTU = this._transport.getMTU(isIPv6);
                    if (mtu > 0 && mtu < 1280 || ourMTU > 0 && ourMTU < 1280) {
                        this._transport.markUnreachable(toHash);
                        this._transport.failed(msg, "MTU too small");
                        return;
                    }
                }
                if ((keyBytes = version == 1 ? null : ((siv = ra.getOption("i")) != null ? Base64.decode(siv) : null)) == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("No intro key\n" + toRouterInfo);
                    }
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has no key, cannot establish");
                    return;
                }
                try {
                    sessionKey = new SessionKey(keyBytes);
                }
                catch (IllegalArgumentException iae) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has bad key, cannot establish");
                    return;
                }
                if (version == 2) {
                    boolean requestIntroduction = !isIndirect && this._transport.introducersMaybeRequired(TransportUtil.isIPv6(ra));
                    try {
                        state = new OutboundEstablishState2(this._context, this._transport, maybeTo, to, toIdentity, requestIntroduction, sessionKey, ra, addr);
                    }
                    catch (IllegalArgumentException iae) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("OES2 error: " + toRouterInfo, iae);
                        }
                        this._transport.markUnreachable(toHash);
                        this._transport.failed(msg, iae.getMessage());
                        return;
                    }
                } else {
                    this._transport.failed(msg, "OB to bad addr? " + ra);
                    return;
                }
                OutboundEstablishState oldState = this._outboundStates.putIfAbsent(to, state);
                boolean bl = isNew = oldState == null;
                if (isNew) {
                    if (isIndirect && maybeTo != null) {
                        this._outboundByClaimedAddress.put(maybeTo, state);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Adding new " + state);
                    }
                } else {
                    state = oldState;
                }
            }
        }
        if (state != null) {
            state.addMessage(msg);
            List<OutNetMessage> queued = this._queuedOutbound.remove(to);
            if (queued != null) {
                List<OutNetMessage> list = queued;
                synchronized (list) {
                    for (OutNetMessage m : queued) {
                        state.addMessage(m);
                    }
                }
            }
        }
        if (rejected) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many pending, rejecting outbound establish to " + to);
            }
            this._transport.failed(msg, "Too many pending outbound connections");
            this._context.statManager().addRateData("udp.establishRejected", deferred);
            return;
        }
        if (queueCount >= 16) {
            this._transport.failed(msg, "Too many pending messages for the given peer");
            this._context.statManager().addRateData("udp.establishOverflow", queueCount, deferred);
            return;
        }
        if (deferred > 0) {
            msg.timestamp("too many deferred establishers");
        } else if (state != null) {
            msg.timestamp("establish state already waiting");
        }
        this.notifyActivity();
    }

    private int getMaxInboundEstablishers() {
        return this.getMaxConcurrentEstablish() / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAllowInboundEstablishment() {
        int probAccept;
        int total;
        int current;
        long periodStart;
        int last;
        if (this._inboundStates.size() >= this.getMaxInboundEstablishers()) {
            return false;
        }
        RateStat rs = this._context.statManager().getRate("udp.inboundConn");
        if (rs == null) {
            return true;
        }
        Rate r = rs.getRate(60000L);
        if (r == null) {
            return true;
        }
        RateAverages ra = RateAverages.getTemp();
        Rate rate = r;
        synchronized (rate) {
            last = (int)r.getLastEventCount();
            periodStart = r.getLastCoalesceDate();
            r.computeAverages(ra, true);
        }
        if (last < 15) {
            last = 15;
        }
        if ((current = (total = (int)ra.getTotalEventCount()) - last) <= 0) {
            return true;
        }
        int lastPeriod = 60000;
        double avg = ra.getAverage();
        int currentTime = (int)(this._context.clock().now() - periodStart);
        if (currentTime <= 5000) {
            return true;
        }
        float lastRate = (float)last / (float)lastPeriod;
        float currentRate = (float)((double)current / (double)currentTime);
        float factor = this._transport.haveCapacity(95) ? 1.05f : 0.95f;
        float minThresh = factor * lastRate;
        if (currentRate > minThresh && ((probAccept = Math.max(1, (int)(512.0f * currentRate / minThresh) - 512)) >= 128 || this._context.random().nextInt(128) < probAccept)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Probabalistic drop incoming (p=" + probAccept + "/128) last rate " + last + "/min current rate " + (int)(currentRate * 60.0f * 1000.0f));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSessionOrTokenRequest(RemoteHostId from, InboundEstablishState2 state, UDPPacket packet) {
        byte[] fromIP = from.getIP();
        if (!TransportUtil.isValidPort(from.getPort()) || !this._transport.isValid(fromIP)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Receive session request from invalid: " + from);
            }
            return;
        }
        boolean isNew = false;
        if (state == null) {
            if (this._context.blocklist().isBlocklisted(fromIP)) {
                if (this._log.shouldInfo()) {
                    this._log.info("Receive session request from blocklisted IP: " + from);
                }
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                if (!this._context.commSystem().isInStrictCountry()) {
                    this.sendTerminationPacket(from, packet, 17);
                }
                return;
            }
            if (!this._context.commSystem().isExemptIncoming(Addresses.toString(fromIP))) {
                if (!this.shouldAllowInboundEstablishment()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Dropping inbound establish");
                    }
                    this._context.statManager().addRateData("udp.establishDropped", 1L);
                    this.sendTerminationPacket(from, packet, 19);
                    return;
                }
                Map<RemoteHostId, Long> map = this._inboundBans;
                synchronized (map) {
                    Long exp = this._inboundBans.get(from);
                    if (exp != null) {
                        if (exp >= this._context.clock().now()) {
                            if (this._log.shouldInfo()) {
                                this._log.info("SSU 2 session request from temp. blocked peer: " + from);
                            }
                            this._context.statManager().addRateData("udp.establishBadIP", 1L);
                            this.sendTerminationPacket(from, packet, 11);
                            return;
                        }
                        this._inboundBans.remove(from);
                    }
                }
                if (!this._transport.allowConnection()) {
                    this.sendTerminationPacket(from, packet, 19);
                    return;
                }
            }
            try {
                state = new InboundEstablishState2(this._context, this._transport, packet);
            }
            catch (GeneralSecurityException gse) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Corrupt Session/Token Request from: " + from, gse);
                }
                this._context.statManager().addRateData("udp.establishDropped", 1L);
                return;
            }
            this._context.statManager().addRateData("udp.inboundConn", 1L);
            InboundEstablishState oldState = this._inboundStates.putIfAbsent(from, state);
            boolean bl = isNew = oldState == null;
            if (!isNew && oldState.getVersion() == 2) {
                state = (InboundEstablishState2)oldState;
            }
        } else {
            try {
                state.receiveSessionOrTokenRequestAfterRetry(packet);
            }
            catch (GeneralSecurityException gse) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Corrupt Session/Token Request after Retry from: " + state, gse);
                }
                this._inboundStates.remove(state.getRemoteHostId());
                return;
            }
        }
        if (this._log.shouldDebug()) {
            if (isNew) {
                this._log.debug("Received NEW session/token request " + state);
            } else {
                this._log.debug("Receive DUP session/token request from: " + state);
            }
        }
        this.notifyActivity();
    }

    private void sendTerminationPacket(RemoteHostId to, UDPPacket fromPacket, int terminationCode) {
        int count = this._terminationCounter.increment(to);
        if (count > 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Rate limit " + count + " not sending termination to: " + to);
            }
            return;
        }
        if (this._transport.isTooClose(to.getIP())) {
            return;
        }
        DatagramPacket pkt = fromPacket.getPacket();
        int len = pkt.getLength();
        if (len < 56) {
            return;
        }
        int off = pkt.getOffset();
        byte[] data = pkt.getData();
        int type = data[off + 12] & 0xFF;
        if (type == 0 && len < SSU2Util.MIN_SESSION_REQUEST_LEN) {
            return;
        }
        long rcvConnID = DataHelper.fromLong8(data, off);
        long sendConnID = DataHelper.fromLong8(data, off + 16);
        if (rcvConnID == 0L || sendConnID == 0L || rcvConnID == sendConnID) {
            return;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Send immediate termination " + terminationCode + " on type " + type + " to: " + to);
        }
        UDPPacket packet = this._builder2.buildRetryPacket(to, pkt.getSocketAddress(), sendConnID, rcvConnID, terminationCode);
        this._transport.send(packet);
    }

    void receiveSessionConfirmed(InboundEstablishState2 state, UDPPacket packet) {
        try {
            state.receiveSessionConfirmed(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt Session Confirmed on: " + state, gse);
            }
            this._inboundStates.remove(state.getRemoteHostId());
            return;
        }
        InboundEstablishState.InboundState istate = state.getState();
        if (istate == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY || istate == InboundEstablishState.InboundState.IB_STATE_COMPLETE) {
            this.handleCompletelyEstablished(state);
        }
        this.notifyActivity();
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session confirmed from: " + state);
        }
    }

    void receiveSessionCreated(OutboundEstablishState2 state, UDPPacket packet) {
        try {
            state.receiveSessionCreated(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt Session Created on: " + state, gse);
            }
            this._outboundStates.remove(state.getRemoteHostId());
            return;
        }
        this.notifyActivity();
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session created from: " + state);
        }
    }

    void receiveRetry(OutboundEstablishState2 state, UDPPacket packet) {
        try {
            state.receiveRetry(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt Retry from: " + state, gse);
            }
            this._outboundStates.remove(state.getRemoteHostId());
            return;
        }
        this.notifyActivity();
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive retry with token " + state.getToken() + " from: " + state);
        }
    }

    void receiveSessionDestroy(RemoteHostId from, PeerState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session destroy (EST) from: " + from);
        }
        this._transport.dropPeer(state, false, "received destroy message");
    }

    void receiveSessionDestroy(RemoteHostId from, OutboundEstablishState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session destroy (OB) from: " + from);
        }
        this._outboundStates.remove(from);
        Hash peer = state.getRemoteIdentity().calculateHash();
        this._transport.dropPeer(peer, false, "received destroy message during OB establish");
    }

    void receiveSessionDestroy(RemoteHostId from) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Receive session destroy (none) from: " + from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerState receiveData(OutboundEstablishState state) {
        state.dataReceived();
        this._outboundStates.remove(state.getRemoteHostId());
        List<OutNetMessage> queued = this._queuedOutbound.remove(state.getRemoteHostId());
        if (queued != null) {
            List<OutNetMessage> list = queued;
            synchronized (list) {
                for (OutNetMessage m : queued) {
                    state.addMessage(m);
                }
            }
        }
        if (this._outboundStates.size() < this.getMaxConcurrentEstablish() && !this._queuedOutbound.isEmpty()) {
            this.locked_admitQueued();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Outbound established: " + state);
        }
        PeerState peer = this.handleCompletelyEstablished(state);
        this.notifyActivity();
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int locked_admitQueued() {
        if (this._queuedOutbound.isEmpty()) {
            return 0;
        }
        int admitted = 0;
        int max = this.getMaxConcurrentEstablish();
        Iterator<Map.Entry<RemoteHostId, List<OutNetMessage>>> iter = this._queuedOutbound.entrySet().iterator();
        while (iter.hasNext() && this._outboundStates.size() < max) {
            Map.Entry<RemoteHostId, List<OutNetMessage>> entry = iter.next();
            try {
                iter.remove();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            List<OutNetMessage> allQueued = entry.getValue();
            ArrayList<OutNetMessage> queued = new ArrayList<OutNetMessage>();
            long now = this._context.clock().now();
            List<OutNetMessage> list = allQueued;
            synchronized (list) {
                for (OutNetMessage msg : allQueued) {
                    if (now - 60000L > msg.getExpiration()) {
                        this._transport.failed(msg, "Took too long in est. mgr OB queue");
                        continue;
                    }
                    queued.add(msg);
                }
            }
            if (queued.isEmpty()) continue;
            for (OutNetMessage m : queued) {
                m.timestamp("no longer deferred... establishing");
                this.establish(m, false);
            }
            ++admitted;
        }
        return admitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyActivity() {
        Object object = this._activityLock;
        synchronized (object) {
            ++this._activity;
            this._activityLock.notifyAll();
        }
    }

    private void handleCompletelyEstablished(InboundEstablishState state) {
        OutNetMessage msg;
        if (state.isComplete()) {
            return;
        }
        RouterIdentity remote = state.getConfirmedIdentity();
        InboundEstablishState2 state2 = (InboundEstablishState2)state;
        PeerState2 peer = state2.getPeerState();
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (inbound): " + state + " - " + peer.getRemotePeer());
        }
        this._transport.addRemotePeerState(peer);
        boolean isIPv6 = state.getSentIP().length == 16;
        this._transport.inboundConnectionReceived(isIPv6);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.inboundEstablishTime", state.getLifetime());
        this.sendInboundComplete(peer);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (this._context.clock().now() - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            this._transport.send(msg);
        }
        state.complete();
    }

    private void sendInboundComplete(PeerState peer) {
        if (this._log.shouldDebug()) {
            this._log.debug("IB confirm: " + peer);
        }
        DatabaseStoreMessage dbsm = this.getOurInfo();
        this._transport.send(dbsm, peer);
    }

    private PeerState handleCompletelyEstablished(OutboundEstablishState state) {
        OutNetMessage msg;
        RouterIdentity rem;
        if (state.complete() && (rem = state.getRemoteIdentity()) != null) {
            return this._transport.getPeerState(rem.getHash());
        }
        long now = this._context.clock().now();
        RouterIdentity remote = state.getRemoteIdentity();
        RemoteHostId claimed = state.getClaimedAddress();
        if (claimed != null) {
            this._outboundByClaimedAddress.remove(claimed, state);
        }
        this._outboundByHash.remove(remote.calculateHash(), state);
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        PeerState2 peer = state2.getPeerState();
        peer.setTheyRelayToUsAs(state.getReceivedRelayTag());
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (outbound): " + state + " - " + peer.getRemotePeer());
        }
        this._transport.addRemotePeerState(peer);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.outboundEstablishTime", state.getLifetime(now));
        I2NPMessage dbsm = null;
        ArrayList<OutNetMessage> msgs = new ArrayList<OutNetMessage>(8);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (now - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            msgs.add(msg);
        }
        this._transport.send(dbsm, msgs, peer);
        return peer;
    }

    public DatabaseStoreMessage getOurInfo() {
        DatabaseStoreMessage m = new DatabaseStoreMessage(this._context);
        m.setEntry(this._context.router().getRouterInfo());
        m.setMessageExpiration(this._context.clock().now() + 10000L);
        return m;
    }

    private void sendCreated(InboundEstablishState state) {
        UDPPacket pkt;
        InboundEstablishState2 state2 = (InboundEstablishState2)state;
        InboundEstablishState.InboundState istate = state2.getState();
        switch (istate) {
            case IB_STATE_CREATED_SENT: {
                if (this._log.shouldInfo()) {
                    this._log.info("Retransmit created to: " + state);
                }
                pkt = state2.getRetransmitSessionCreatedPacket();
                break;
            }
            case IB_STATE_REQUEST_RECEIVED: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send created to: " + state);
                }
                pkt = this._builder2.buildSessionCreatedPacket(state2);
                break;
            }
            case IB_STATE_TOKEN_REQUEST_RECEIVED: 
            case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: 
            case IB_STATE_RETRY_SENT: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send retry to: " + state);
                }
                pkt = this._builder2.buildRetryPacket(state2, 0);
                break;
            }
            default: {
                if (this._log.shouldWarn()) {
                    this._log.warn("Unhandled state " + (Object)((Object)istate) + " on " + state);
                }
                return;
            }
        }
        if (pkt == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + state + " sent us an invalid IP?");
            }
            this._inboundStates.remove(state.getRemoteHostId());
            state.fail();
            return;
        }
        this._transport.send(pkt);
    }

    private void sendRequest(OutboundEstablishState state) {
        UDPPacket packet;
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        OutboundEstablishState.OutboundState ostate = state2.getState();
        switch (ostate) {
            case OB_STATE_REQUEST_SENT: 
            case OB_STATE_REQUEST_SENT_NEW_TOKEN: {
                if (this._log.shouldInfo()) {
                    this._log.info("Retransmit Session Request to: " + state);
                }
                packet = state2.getRetransmitSessionRequestPacket();
                break;
            }
            case OB_STATE_NEEDS_TOKEN: 
            case OB_STATE_TOKEN_REQUEST_SENT: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send Token Request to: " + state);
                }
                packet = this._builder2.buildTokenRequestPacket(state2);
                break;
            }
            case OB_STATE_UNKNOWN: 
            case OB_STATE_RETRY_RECEIVED: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send Session Request to: " + state);
                }
                packet = this._builder2.buildSessionRequestPacket(state2);
                break;
            }
            case OB_STATE_INTRODUCED: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Send Session Request after introduction to: " + state);
                }
                packet = this._builder2.buildSessionRequestPacket(state2);
                break;
            }
            default: {
                if (this._log.shouldWarn()) {
                    this._log.warn("Unhandled state " + (Object)((Object)ostate) + " on " + state);
                }
                return;
            }
        }
        if (packet != null) {
            this._transport.send(packet);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Unable to build a session request packet for " + state);
        }
    }

    private void handlePendingIntro(OutboundEstablishState state) {
        Hash h;
        int i;
        OutboundEstablishState2.IntroState istate;
        long nonce = state.getIntroNonce();
        if (nonce < 0L) {
            OutboundEstablishState old;
            while ((old = this._liveIntroductions.putIfAbsent(nonce = this._context.random().nextLong(0xFFFFFFFFL), state)) != null) {
            }
            state.setIntroNonce(nonce);
        }
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        UDPAddress addr = state.getRemoteAddress();
        int count = addr.getIntroducerCount();
        for (int i2 = 0; i2 < count; ++i2) {
            long tag;
            boolean ok;
            Hash h2 = addr.getIntroducerHash(i2);
            if (h2 == null) continue;
            PeerState bob = null;
            istate = state2.getIntroState(h2);
            switch (istate) {
                case INTRO_STATE_INIT: 
                case INTRO_STATE_CONNECTING: {
                    bob = this._transport.getPeerState(h2);
                    if (bob == null) break;
                    if (bob.getVersion() == 2) {
                        istate = OutboundEstablishState2.IntroState.INTRO_STATE_CONNECTED;
                        state2.setIntroState(h2, istate);
                        break;
                    }
                    istate = OutboundEstablishState2.IntroState.INTRO_STATE_REJECTED;
                    state2.setIntroState(h2, istate);
                    break;
                }
                case INTRO_STATE_CONNECTED: {
                    bob = this._transport.getPeerState(h2);
                    if (bob != null) break;
                    istate = OutboundEstablishState2.IntroState.INTRO_STATE_DISCONNECTED;
                    state2.setIntroState(h2, istate);
                }
            }
            if (bob == null || istate != OutboundEstablishState2.IntroState.INTRO_STATE_CONNECTED) continue;
            if (this._log.shouldDebug()) {
                this._log.debug("Found connected introducer " + bob + " for " + state);
            }
            if (ok = this.sendRelayRequest(tag = addr.getIntroducerTag(i2), (PeerState2)bob, state)) {
                state2.introSent(h2);
            } else {
                state2.setIntroState(h2, OutboundEstablishState2.IntroState.INTRO_STATE_DISCONNECTED);
            }
            return;
        }
        boolean sent = false;
        for (i = 0; i < count; ++i) {
            OutboundEstablishState2.IntroState istate2;
            h = addr.getIntroducerHash(i);
            if (h == null) continue;
            RouterInfo bob = null;
            OutboundEstablishState2.IntroState oldState = istate2 = state2.getIntroState(h);
            switch (istate2) {
                case INTRO_STATE_INIT: 
                case INTRO_STATE_LOOKUP_SENT: 
                case INTRO_STATE_HAS_RI: {
                    bob = this._context.netDb().lookupRouterInfoLocally(h);
                    if (bob == null) break;
                    istate2 = OutboundEstablishState2.IntroState.INTRO_STATE_HAS_RI;
                }
            }
            if (bob != null && istate2 == OutboundEstablishState2.IntroState.INTRO_STATE_HAS_RI) {
                List<RouterAddress> addrs = this._transport.getTargetAddresses(bob);
                for (RouterAddress ra : addrs) {
                    byte[] ip = ra.getIP();
                    int port = ra.getPort();
                    if (ip == null || port <= 0) continue;
                    RemoteHostId rhid = new RemoteHostId(ip, port);
                    OutboundEstablishState oes = this._outboundStates.get(rhid);
                    if (oes != null) {
                        if (!this._log.shouldDebug()) break;
                        this._log.debug("Awaiting pending connection to introducer " + oes + " for " + state);
                        break;
                    }
                    int version = this._transport.getSSUVersion(ra);
                    if (version != 2) continue;
                    if (this._log.shouldDebug()) {
                        this._log.debug("Connecting to introducer " + bob + " for " + state);
                    }
                    DatabaseLookupMessage dlm = new DatabaseLookupMessage(this._context);
                    dlm.setSearchKey(h);
                    dlm.setSearchType(DatabaseLookupMessage.Type.RI);
                    long now = this._context.clock().now();
                    dlm.setMessageExpiration(now + 10000L);
                    dlm.setFrom(this._context.routerHash());
                    OutNetMessage m = new OutNetMessage(this._context, dlm, now + 10000L, 500, bob);
                    this.establish(m);
                    istate2 = OutboundEstablishState2.IntroState.INTRO_STATE_CONNECTING;
                    break;
                }
            }
            if (istate2 == OutboundEstablishState2.IntroState.INTRO_STATE_HAS_RI) {
                istate2 = OutboundEstablishState2.IntroState.INTRO_STATE_REJECTED;
            }
            if (oldState == istate2) continue;
            state2.setIntroState(h, istate2);
        }
        if (sent) {
            state.introSent();
            return;
        }
        for (i = 0; i < count; ++i) {
            h = addr.getIntroducerHash(i);
            if (h == null || (istate = state2.getIntroState(h)) != OutboundEstablishState2.IntroState.INTRO_STATE_INIT) continue;
            if (this._log.shouldDebug()) {
                this._log.debug("Looking up introducer " + h + " for " + state);
            }
            istate = OutboundEstablishState2.IntroState.INTRO_STATE_LOOKUP_SENT;
            state2.setIntroState(h, istate);
            this._context.netDb().lookupRouterInfo(h, null, null, 10000L);
            sent = true;
        }
        if (sent) {
            state.introSent();
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("No valid introducers for " + state);
            }
            this.processExpired(state);
        }
    }

    private boolean sendRelayRequest(long tag, PeerState2 bob, OutboundEstablishState charlie) {
        UDPPacket packet;
        RouterAddress ourra;
        UDPAddress cra = charlie.getRemoteAddress();
        if (cra.isIPv6()) {
            ourra = this._transport.getCurrentExternalAddress(true);
            if (ourra == null) {
                ourra = this._transport.getCurrentExternalAddress(false);
            }
        } else {
            ourra = this._transport.getCurrentExternalAddress(false);
        }
        if (ourra == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No address to send in relay request");
            }
            return false;
        }
        byte[] ourIP = ourra.getIP();
        if (ourIP == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No IP to send in relay request");
            }
            return false;
        }
        int ourPort = this._transport.getRequestedPort();
        byte[] data = SSU2Util.createRelayRequestData(this._context, bob.getRemotePeer(), charlie.getRemoteIdentity().getHash(), charlie.getIntroNonce(), tag, ourIP, ourPort, this._context.keyManager().getSigningPrivateKey());
        if (data == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("sig fail");
            }
            return false;
        }
        try {
            packet = this._builder2.buildRelayRequest(data, bob);
        }
        catch (IOException ioe) {
            return false;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Send relay request to " + bob + " for " + charlie);
        }
        this._transport.send(packet);
        bob.setLastSendTime(this._context.clock().now());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayResponse(PeerState2 bob, long nonce, int code, byte[] data) {
        OutboundEstablishState2.IntroState istate;
        Hash signer;
        long token;
        Long lnonce = nonce;
        OutboundEstablishState charlie = code > 0 && code < 64 ? this._liveIntroductions.get(lnonce) : this._liveIntroductions.remove(lnonce);
        if (charlie == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Dup or unknown RelayResponse: " + nonce);
            }
            return;
        }
        if (charlie.getVersion() != 2) {
            return;
        }
        OutboundEstablishState2 charlie2 = (OutboundEstablishState2)charlie;
        if (code == 0) {
            token = DataHelper.fromLong8(data, data.length - 8);
            data = Arrays.copyOfRange(data, 0, data.length - 8);
        } else {
            token = 0L;
        }
        Hash bobHash = bob.getRemotePeer();
        Hash charlieHash = charlie.getRemoteIdentity().getHash();
        RouterInfo bobRI = this._context.netDb().lookupRouterInfoLocally(bobHash);
        RouterInfo charlieRI = this._context.netDb().lookupRouterInfoLocally(charlieHash);
        if (code > 0 && code < 64) {
            signer = bobHash;
            istate = OutboundEstablishState2.IntroState.INTRO_STATE_BOB_REJECT;
        } else {
            signer = charlieHash;
            istate = code == 0 ? OutboundEstablishState2.IntroState.INTRO_STATE_SUCCESS : OutboundEstablishState2.IntroState.INTRO_STATE_CHARLIE_REJECT;
        }
        RouterInfo signerRI = this._context.netDb().lookupRouterInfoLocally(signer);
        if (signerRI != null) {
            SigningPublicKey spk = signerRI.getIdentity().getSigningPublicKey();
            if (!SSU2Util.validateSig(this._context, SSU2Util.RELAY_RESPONSE_PROLOGUE, bobHash, null, data, spk)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Signature failed relay response " + code + " as alice from:\n" + signerRI);
                }
                istate = OutboundEstablishState2.IntroState.INTRO_STATE_FAILED;
                charlie2.setIntroState(bobHash, istate);
                charlie.fail();
                return;
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Signer RI not found " + signer);
            }
            return;
        }
        if (code == 0) {
            int iplen = data[9] & 0xFF;
            if (iplen != 6 && iplen != 18) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad IP length " + iplen + " from " + charlie);
                }
                istate = OutboundEstablishState2.IntroState.INTRO_STATE_FAILED;
                charlie2.setIntroState(bobHash, istate);
                charlie.fail();
                return;
            }
            int port = (int)DataHelper.fromLong(data, 10, 2);
            byte[] ip = new byte[iplen - 2];
            System.arraycopy(data, 12, ip, 0, iplen - 2);
            if (!TransportUtil.isValidPort(port) || !this._transport.isValid(ip) || this._transport.isTooClose(ip) || DataHelper.eq(ip, bob.getRemoteIP()) || this._context.blocklist().isBlocklisted(ip)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bad relay resp from " + charlie + " for " + Addresses.toString(ip, port));
                }
                istate = OutboundEstablishState2.IntroState.INTRO_STATE_FAILED;
                charlie2.setIntroState(bobHash, istate);
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                this._context.banlist().banlistRouter(charlieHash, "Bad introduction data", null, null, this._context.clock().now() + 21600000L);
                charlie.fail();
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Received RelayResponse from " + charlie + " - they are on " + Addresses.toString(ip, port));
            }
            if (charlieRI == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Charlie RI not found " + charlie);
                }
                charlie2.setIntroState(bobHash, istate);
                return;
            }
            OutboundEstablishState outboundEstablishState = charlie;
            synchronized (outboundEstablishState) {
                RemoteHostId oldId = charlie.getRemoteHostId();
                if (oldId.getIP() == null) {
                    ((OutboundEstablishState2)charlie).introduced(ip, port, token);
                    RemoteHostId newId = charlie.getRemoteHostId();
                    this.addOutboundToken(newId, token, this._context.clock().now() + 10000L);
                    this._outboundByHash.put(charlieHash, charlie);
                    RemoteHostId claimed = charlie.getClaimedAddress();
                    if (!oldId.equals(newId)) {
                        this._outboundStates.remove(oldId);
                        this._outboundStates.put(newId, charlie);
                        if (this._log.shouldLog(20)) {
                            this._log.info("RR replaced " + oldId + " with " + newId + ", claimed address was " + claimed);
                        }
                    }
                    if (claimed != null) {
                        this._outboundByClaimedAddress.remove(oldId, charlie);
                    }
                }
            }
            charlie2.setIntroState(bobHash, istate);
            this.notifyActivity();
        } else if (code >= 64) {
            if (this._log.shouldDebug()) {
                this._log.debug("Received RelayResponse rejection " + code + " from charlie " + charlie);
            }
            charlie2.setIntroState(bobHash, istate);
            if (code == 69) {
                this._context.banlist().banlistRouter(charlieHash, "They banned us", null, null, this._context.clock().now() + 21600000L);
            }
            charlie.fail();
            this._liveIntroductions.remove(lnonce);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Received RelayResponse rejection " + code + " from bob " + bob);
            }
            charlie2.setIntroState(bobHash, istate);
            this.notifyActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHolePunch(RemoteHostId id, UDPPacket packet) {
        long nonce;
        DatagramPacket pkt = packet.getPacket();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rcvConnID = DataHelper.fromLong8(data, off);
        long sendConnID = DataHelper.fromLong8(data, off + 16);
        int type = data[off + 12] & 0xFF;
        if (type != 11) {
            return;
        }
        byte[] introKey = this._transport.getSSU2StaticIntroKey();
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(introKey, 0);
        long n = DataHelper.fromLong(data, off + 8, 4);
        chacha.setNonce(n);
        HPCallback cb = new HPCallback(id);
        long now = this._context.clock().now();
        try {
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            int payloadLen = len - 48;
            SSU2Payload.processPayload(this._context, cb, data, off + 32, payloadLen, false, null);
            if (cb._respCode != 0) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad HolePunch response: " + cb._respCode);
                }
                return;
            }
            long skew = cb._timeReceived - now;
            if (skew > 120000L || skew < -120000L) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Too skewed in hole punch from " + id);
                }
                return;
            }
            nonce = DataHelper.fromLong(cb._respData, 0, 4);
            if (nonce != (rcvConnID & 0xFFFFFFFFL) || nonce != (rcvConnID >> 32 & 0xFFFFFFFFL)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad nonce in hole punch from " + id);
                }
                return;
            }
            long time = DataHelper.fromLong(cb._respData, 4, 4) * 1000L;
            skew = time - now;
            if (skew > 120000L || skew < -120000L) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Too skewed in hole punch from " + id);
                }
                return;
            }
            int ver = cb._respData[8] & 0xFF;
            if (ver != 2) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad hole punch version " + ver + " from " + id);
                }
                return;
            }
        }
        catch (Exception e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad HolePunch packet:\n" + HexDump.dump(data, off, len), e);
            }
            return;
        }
        finally {
            chacha.destroy();
        }
        OutboundEstablishState state = this._outboundStates.get(id);
        if (state != null) {
            if (this._log.shouldInfo()) {
                this._log.info("Hole punch after RelayResponse from " + state);
            }
        } else {
            state = this._liveIntroductions.remove(nonce);
            if (state != null) {
                if (this._log.shouldInfo()) {
                    this._log.info("Hole punch before RelayResponse from " + state);
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("No state found for SSU2 hole punch from " + id);
                }
                return;
            }
        }
        if (state.getVersion() != 2) {
            return;
        }
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        Hash charlieHash = state.getRemoteIdentity().getHash();
        RouterInfo charlieRI = this._context.netDb().lookupRouterInfoLocally(charlieHash);
        if (charlieRI != null) {
            SigningPublicKey spk = charlieRI.getIdentity().getSigningPublicKey();
            UDPAddress addr = state.getRemoteAddress();
            int count = addr.getIntroducerCount();
            data = Arrays.copyOfRange(cb._respData, 0, cb._respData.length - 8);
            boolean ok = false;
            block15: for (int i = 0; i < count; ++i) {
                Hash h = addr.getIntroducerHash(i);
                if (h == null) continue;
                OutboundEstablishState2.IntroState istate = state2.getIntroState(h);
                switch (istate) {
                    case INTRO_STATE_INIT: 
                    case INTRO_STATE_EXPIRED: 
                    case INTRO_STATE_REJECTED: 
                    case INTRO_STATE_CONNECT_FAILED: 
                    case INTRO_STATE_BOB_REJECT: 
                    case INTRO_STATE_CHARLIE_REJECT: 
                    case INTRO_STATE_FAILED: 
                    case INTRO_STATE_INVALID: 
                    case INTRO_STATE_DISCONNECTED: {
                        continue block15;
                    }
                    default: {
                        if (!SSU2Util.validateSig(this._context, SSU2Util.RELAY_RESPONSE_PROLOGUE, h, null, data, spk)) continue block15;
                        if (this._log.shouldInfo()) {
                            this._log.info("Good sig hole punch, credit " + h.toBase64() + " on " + state);
                        }
                        state2.setIntroState(h, OutboundEstablishState2.IntroState.INTRO_STATE_SUCCESS);
                        ok = true;
                        break block15;
                    }
                }
            }
            if (!ok) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Signature failed hole punch on " + state);
                }
                return;
            }
            int iplen = data[9] & 0xFF;
            if (iplen != 6 && iplen != 18) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad IP length " + iplen + " from " + state);
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                this._context.banlist().banlistRouter(state.getRemoteIdentity().getHash(), "Bad introduction data", null, null, this._context.clock().now() + 21600000L);
                state.fail();
                return;
            }
            int port = (int)DataHelper.fromLong(data, 10, 2);
            byte[] ip = new byte[iplen - 2];
            System.arraycopy(data, 12, ip, 0, iplen - 2);
            if (!TransportUtil.isValidPort(port) || !this._transport.isValid(ip) || this._transport.isTooClose(ip) || !DataHelper.eq(ip, id.getIP()) || this._context.blocklist().isBlocklisted(ip)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bad hole punch from " + state + " for " + Addresses.toString(ip, port) + " via " + id);
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                this._context.banlist().banlistRouter(state.getRemoteIdentity().getHash(), "Bad introduction data", null, null, this._context.clock().now() + 21600000L);
                state.fail();
                return;
            }
            int fromPort = id.getPort();
            if (port != fromPort) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Hole punch source mismatch on " + state + " resp. block: " + Addresses.toString(ip, port) + " rcvd. from: " + id);
                }
                if (!TransportUtil.isValidPort(fromPort)) {
                    this._context.statManager().addRateData("udp.relayBadIP", 1L);
                    this._context.banlist().banlistRouter(state.getRemoteIdentity().getHash(), "Bad introduction data", null, null, this._context.clock().now() + 21600000L);
                    state.fail();
                    return;
                }
                port = fromPort;
            } else if (this._log.shouldDebug()) {
                this._log.debug("Received hole punch from " + state + " - they are on " + Addresses.toString(ip, port));
            }
            OutboundEstablishState outboundEstablishState = state;
            synchronized (outboundEstablishState) {
                RemoteHostId oldId = state.getRemoteHostId();
                if (oldId.getIP() == null) {
                    long token = DataHelper.fromLong8(cb._respData, cb._respData.length - 8);
                    state2.introduced(ip, port, token);
                    RemoteHostId newId = state.getRemoteHostId();
                    this.addOutboundToken(newId, token, now + 10000L);
                    this._outboundByHash.put(charlieHash, state);
                    RemoteHostId claimed = state.getClaimedAddress();
                    if (!oldId.equals(newId)) {
                        this._outboundStates.remove(oldId);
                        this._outboundStates.put(newId, state);
                        if (this._log.shouldLog(20)) {
                            this._log.info("HP replaced " + oldId + " with " + newId + ", claimed address was " + claimed);
                        }
                    }
                    if (claimed != null) {
                        this._outboundByClaimedAddress.remove(oldId, state);
                    }
                }
            }
            boolean sendNow = state.receiveHolePunch();
            if (sendNow) {
                if (this._log.shouldInfo()) {
                    this._log.info("Send SessionRequest after HolePunch from " + state);
                }
                this.notifyActivity();
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Charlie RI not found " + state);
            }
            return;
        }
    }

    boolean isValid(byte[] ip, int port) {
        return TransportUtil.isValidPort(port) && ip != null && this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip);
    }

    private void sendConfirmation(OutboundEstablishState state) {
        boolean valid = state.validateSessionCreated();
        if (!valid) {
            if (this._log.shouldLog(30)) {
                this._log.warn("SessionCreated validate failed: " + state);
            }
            return;
        }
        byte[] ip = state.getReceivedIP();
        int port = state.getReceivedPort();
        if (!this._transport.isValid(ip) || port < 1024) {
            state.fail();
            return;
        }
        this._transport.externalAddressReceived(state.getRemoteIdentity().calculateHash(), ip, port);
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        OutboundEstablishState.OutboundState ostate = state2.getState();
        if (ostate == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
            return;
        }
        UDPPacket[] packets = this._builder2.buildSessionConfirmedPackets(state2, this._context.router().getRouterInfo());
        if (packets == null) {
            state.fail();
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send confirm to: " + state);
        }
        for (int i = 0; i < packets.length; ++i) {
            this._transport.send(packets[i]);
        }
        this.handleCompletelyEstablished(state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleInbound() {
        long now = this._context.clock().now();
        long nextSendTime = Long.MAX_VALUE;
        InboundEstablishState inboundState = null;
        boolean expired = false;
        Iterator<InboundEstablishState> iter = this._inboundStates.values().iterator();
        while (iter.hasNext()) {
            InboundEstablishState cur = iter.next();
            InboundEstablishState.InboundState istate = cur.getState();
            if (istate == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY) {
                iter.remove();
                inboundState = cur;
                break;
            }
            if (cur.getLifetime(now) > 12000L || istate == InboundEstablishState.InboundState.IB_STATE_RETRY_SENT && cur.getLifetime(now) >= 5000L) {
                iter.remove();
                inboundState = cur;
                if (this._log.shouldDebug()) {
                    this._log.debug("Expired: " + cur);
                }
                expired = true;
                break;
            }
            if (istate == InboundEstablishState.InboundState.IB_STATE_FAILED || istate == InboundEstablishState.InboundState.IB_STATE_COMPLETE) {
                iter.remove();
                continue;
            }
            long next = cur.getNextSendTime();
            if (next <= now) {
                inboundState = cur;
                break;
            }
            if (next >= nextSendTime) continue;
            nextSendTime = next;
        }
        if (inboundState != null) {
            InboundEstablishState inboundEstablishState = inboundState;
            synchronized (inboundEstablishState) {
                InboundEstablishState.InboundState istate = inboundState.getState();
                switch (istate) {
                    case IB_STATE_REQUEST_RECEIVED: 
                    case IB_STATE_TOKEN_REQUEST_RECEIVED: 
                    case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: {
                        if (expired) {
                            this.processExpired(inboundState);
                            break;
                        }
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_PARTIALLY: {
                        if (!expired) break;
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_CREATED_SENT: 
                    case IB_STATE_RETRY_SENT: {
                        if (expired) {
                            this.processExpired(inboundState);
                            break;
                        }
                        if (inboundState.getNextSendTime() > now) break;
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_COMPLETELY: {
                        RouterIdentity remote = inboundState.getConfirmedIdentity();
                        if (remote != null) {
                            if (this._context.banlist().isBanlistedForever(remote.calculateHash())) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Dropping inbound connection from permanently banlisted peer: " + remote.calculateHash());
                                }
                                this._context.blocklist().add(inboundState.getSentIP());
                                inboundState.fail();
                                this.processExpired(inboundState);
                                break;
                            }
                            this.handleCompletelyEstablished(inboundState);
                            break;
                        }
                        if (this._log.shouldLog(30)) {
                            this._log.warn("confirmed with invalid? " + inboundState);
                        }
                        inboundState.fail();
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_COMPLETE: 
                    case IB_STATE_FAILED: {
                        break;
                    }
                    case IB_STATE_UNKNOWN: {
                        if (!this._log.shouldLog(40)) break;
                        this._log.error("hrm, state is unknown for " + inboundState);
                        break;
                    }
                    default: {
                        if (!this._log.shouldWarn()) break;
                        this._log.warn("Unhandled state on " + inboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleOutbound() {
        long now = this._context.clock().now();
        long nextSendTime = Long.MAX_VALUE;
        OutboundEstablishState outboundState = null;
        Iterator<OutboundEstablishState> iter = this._outboundStates.values().iterator();
        while (iter.hasNext()) {
            OutboundEstablishState cur = iter.next();
            OutboundEstablishState.OutboundState state = cur.getState();
            if (state == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY || state == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
                iter.remove();
                outboundState = cur;
                break;
            }
            if (cur.getLifetime(now) >= 25000L) {
                iter.remove();
                outboundState = cur;
                break;
            }
            long next = cur.getNextSendTime();
            if (next <= now) {
                outboundState = cur;
                break;
            }
            if (next >= nextSendTime) continue;
            nextSendTime = next;
        }
        if (outboundState != null) {
            OutboundEstablishState outboundEstablishState = outboundState;
            synchronized (outboundEstablishState) {
                boolean expired = outboundState.getLifetime(now) >= 25000L;
                switch (outboundState.getState()) {
                    case OB_STATE_NEEDS_TOKEN: 
                    case OB_STATE_UNKNOWN: 
                    case OB_STATE_INTRODUCED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_REQUEST_SENT: 
                    case OB_STATE_REQUEST_SENT_NEW_TOKEN: 
                    case OB_STATE_TOKEN_REQUEST_SENT: 
                    case OB_STATE_RETRY_RECEIVED: {
                        long rtime = outboundState.getRequestSentTime();
                        if (expired || rtime > 0L && rtime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_CREATED_RECEIVED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_PARTIALLY: {
                        long ctime = outboundState.getConfirmedSentTime();
                        if (expired || ctime > 0L && ctime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_COMPLETELY: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.handleCompletelyEstablished(outboundState);
                        break;
                    }
                    case OB_STATE_PENDING_INTRO: {
                        long itime = outboundState.getIntroSentTime();
                        if (expired || itime > 0L && itime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.handlePendingIntro(outboundState);
                        break;
                    }
                    case OB_STATE_VALIDATION_FAILED: {
                        this.processExpired(outboundState);
                        break;
                    }
                    default: {
                        if (!this._log.shouldWarn()) break;
                        this._log.warn("Unhandled state on " + outboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    private void processExpired(OutboundEstablishState outboundState) {
        RemoteHostId claimed;
        boolean removed;
        long nonce = outboundState.getIntroNonce();
        if (nonce >= 0L && (removed = this._liveIntroductions.remove(nonce, outboundState))) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Relay request for " + outboundState + " timed out");
            }
            this._context.statManager().addRateData("udp.sendIntroRelayTimeout", 1L);
        }
        if ((claimed = outboundState.getClaimedAddress()) != null) {
            this._outboundByClaimedAddress.remove(claimed, outboundState);
        }
        this._outboundByHash.remove(outboundState.getRemoteIdentity().calculateHash(), outboundState);
        this._outboundStates.remove(outboundState.getRemoteHostId(), outboundState);
        if (outboundState.getState() != OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
            OutNetMessage msg;
            if (this._log.shouldDebug()) {
                this._log.debug("Expired: " + outboundState);
            }
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.failed(msg, "Expired during failed establish");
            }
            String err = "Took too long to establish OB connection, state = " + (Object)((Object)outboundState.getState());
            Hash peer = outboundState.getRemoteIdentity().calculateHash();
            this._transport.markUnreachable(peer);
            this._transport.dropPeer(peer, false, err);
            outboundState.fail();
        } else {
            OutNetMessage msg;
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.send(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpired(InboundEstablishState inboundState) {
        OutNetMessage msg;
        if (this._log.shouldWarn()) {
            this._log.warn("Expired: " + inboundState);
        }
        RemoteHostId id = inboundState.getRemoteHostId();
        this._inboundStates.remove(id);
        Long exp = this._context.clock().now() + 900000L;
        Map<RemoteHostId, Long> map = this._inboundBans;
        synchronized (map) {
            this._inboundBans.put(id, exp);
        }
        while ((msg = inboundState.getNextQueuedMessage()) != null) {
            this._transport.failed(msg, "Expired during failed establish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutboundToken(RemoteHostId peer, long token, long expires) {
        byte[] ip;
        long now = this._context.clock().now();
        if (expires < now) {
            return;
        }
        if (expires > now + 120000L && (ip = peer.getIP()) != null && ip.length == 4 && this._transport.isSymNatted()) {
            return;
        }
        Token tok = new Token(token, expires, now);
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            this._outboundTokens.put(peer, tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutboundToken(RemoteHostId peer) {
        Token tok;
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            tok = this._outboundTokens.remove(peer);
        }
        if (tok == null) {
            return 0L;
        }
        if (tok.getExpiration() < this._context.clock().now()) {
            return 0L;
        }
        return tok.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ipChanged(boolean isIPv6) {
        Map.Entry<RemoteHostId, Token> e;
        Iterator<Map.Entry<RemoteHostId, Token>> iter;
        if (this._log.shouldWarn()) {
            this._log.warn("IP changed, ipv6? " + isIPv6);
        }
        int len = isIPv6 ? 16 : 4;
        long now = this._context.clock().now();
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            iter = this._outboundTokens.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (e.getKey().getIP().length != len && (long)e.getValue().expires >= now) continue;
                iter.remove();
            }
        }
        map = this._inboundTokens;
        synchronized (map) {
            iter = this._inboundTokens.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (e.getKey().getIP().length != len && (long)e.getValue().expires >= now) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portChanged() {
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            this._outboundTokens.clear();
        }
        map = this._inboundTokens;
        synchronized (map) {
            this._inboundTokens.clear();
        }
    }

    public Token getInboundToken(RemoteHostId peer) {
        return this.getInboundToken(peer, 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getInboundToken(RemoteHostId peer, long expiration) {
        long lifetime;
        Rate r;
        long token;
        while ((token = this._context.random().nextLong()) == 0L) {
        }
        long now = this._context.clock().now();
        RateStat rs = this._context.statManager().getRate("udp.inboundTokenLifetime");
        if (rs != null && (r = rs.getRate(300000L)) != null && (lifetime = (long)(r.getAverageValue() * 0.9)) > 0L) {
            if (lifetime < 120000L) {
                lifetime = 120000L;
            }
            if (lifetime < expiration) {
                expiration = lifetime;
            }
        }
        long expires = now + expiration;
        Token tok = new Token(token, expires, now);
        Map<RemoteHostId, Token> map = this._inboundTokens;
        synchronized (map) {
            Token old = this._inboundTokens.put(peer, tok);
            if (old != null && old.getExpiration() > expires - 120000L) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Resend inbound " + old + " for " + peer);
                }
                this._inboundTokens.put(peer, old);
                return old;
            }
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Add inbound " + tok + " for " + peer);
        }
        return tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInboundTokenValid(RemoteHostId peer, long token) {
        boolean rv;
        Token tok;
        if (token == 0L) {
            return false;
        }
        Map<RemoteHostId, Token> map = this._inboundTokens;
        synchronized (map) {
            tok = this._inboundTokens.get(peer);
            if (tok == null) {
                return false;
            }
            if (tok.getToken() != token) {
                return false;
            }
            this._inboundTokens.remove(peer);
        }
        boolean bl = rv = tok.getExpiration() >= this._context.clock().now();
        if (rv && this._log.shouldDebug()) {
            this._log.debug("Used inbound " + tok + " for " + peer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadTokens() {
        File f = new File(this._context.getConfigDir(), TOKEN_FILE);
        String ourV4Port = Integer.toString(this._transport.getExternalPort(false));
        String ourV6Port = Integer.toString(this._transport.getExternalPort(true));
        RouterAddress addr = this._transport.getCurrentExternalAddress(false);
        String ourV4Addr = addr != null ? addr.getHost() : null;
        addr = this._transport.getCurrentExternalAddress(true);
        String ourV6Addr = addr != null ? addr.getHost() : null;
        if (this._log.shouldDebug()) {
            this._log.debug("Loading SSU2 tokens for " + ourV4Addr + ' ' + ourV4Port + ' ' + ourV6Addr + ' ' + ourV6Port);
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            boolean v4Match = false;
            boolean v6Match = false;
            long now = this._context.clock().now();
            int count = 0;
            Map<RemoteHostId, Token> map = this._inboundTokens;
            synchronized (map) {
                Map<RemoteHostId, Token> map2 = this._outboundTokens;
                synchronized (map2) {
                    String line;
                    while ((line = DataHelper.readLine(in)) != null) {
                        boolean isV6;
                        String[] s;
                        if (line.startsWith("#") || (s = DataHelper.split(line, " ", 5)).length < 3) continue;
                        if (s[0].equals("4")) {
                            v4Match = s[1].equals(ourV4Addr) && s[2].trim().equals(ourV4Port);
                            continue;
                        }
                        if (s[0].equals("6")) {
                            v6Match = s[1].equals(ourV6Addr) && s[2].trim().equals(ourV6Port);
                            continue;
                        }
                        if (!s[0].equals("I") && !s[0].equals("O") || s.length != 5 || (isV6 = s[1].contains(":")) && !v6Match || !isV6 && !v4Match) continue;
                        try {
                            byte[] ip;
                            long exp = Long.parseLong(s[4].trim());
                            if (exp <= now || (ip = Addresses.getIPOnly(s[1])) == null) continue;
                            int port = Integer.parseInt(s[2]);
                            long tok = Long.parseLong(s[3]);
                            RemoteHostId id = new RemoteHostId(ip, port);
                            Token token = new Token(tok, exp, now);
                            if (s[0].equals("I")) {
                                this._inboundTokens.put(id, token);
                            } else {
                                this._outboundTokens.put(id, token);
                            }
                            ++count;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            if (!this._log.shouldDebug()) return;
            this._log.debug("Loaded " + count + " SSU2 tokens");
            return;
        }
        catch (IOException ioe) {
            if (!this._log.shouldWarn()) return;
            this._log.warn("Failed to load SSU2 tokens", ioe);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTokens() {
        File f = new File(this._context.getConfigDir(), TOKEN_FILE);
        try (PrintWriter out = null;){
            RemoteHostId id;
            long exp;
            Token token;
            ArrayList<Map.Entry<RemoteHostId, Token>> tmp;
            String us;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(f), "ISO-8859-1")));
            out.println("# SSU2 tokens, format: IPv4/IPv6/In/Out addr port token expiration");
            RouterAddress addr = this._transport.getCurrentExternalAddress(false);
            if (addr != null && (us = addr.getHost()) != null) {
                out.println("4 " + us + ' ' + this._transport.getExternalPort(false));
            }
            if ((addr = this._transport.getCurrentExternalAddress(true)) != null && (us = addr.getHost()) != null) {
                out.println("6 " + us + ' ' + this._transport.getExternalPort(true));
            }
            long now = this._context.clock().now();
            int count = 0;
            TokenComparator comp = new TokenComparator();
            Object object = this._inboundTokens;
            synchronized (object) {
                tmp = new ArrayList<Map.Entry<RemoteHostId, Token>>(this._inboundTokens.entrySet());
            }
            Collections.sort(tmp, comp);
            for (Map.Entry entry : tmp) {
                token = (Token)entry.getValue();
                exp = token.getExpiration();
                if (exp <= now) continue;
                id = (RemoteHostId)entry.getKey();
                out.println("I " + Addresses.toString(id.getIP()) + ' ' + id.getPort() + ' ' + token.getToken() + ' ' + exp);
                ++count;
            }
            tmp.clear();
            object = this._outboundTokens;
            synchronized (object) {
                tmp.addAll(this._outboundTokens.entrySet());
            }
            Collections.sort(tmp, comp);
            for (Map.Entry entry : tmp) {
                token = (Token)entry.getValue();
                exp = token.getExpiration();
                if (exp <= now) continue;
                id = (RemoteHostId)entry.getKey();
                out.println("O " + Addresses.toString(id.getIP()) + ' ' + id.getPort() + ' ' + token.getToken() + ' ' + exp);
                ++count;
            }
            if (out.checkError()) {
                throw new IOException("Failed write to " + f);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Stored " + count + " SSU2 tokens to " + f);
            }
        }
    }

    private class Establisher
    implements Runnable {
        private long _lastFailsafe;
        private static final long FAILSAFE_INTERVAL = 180000L;
        private long _lastPrinted;
        private static final long PRINT_INTERVAL = 5000L;

        private Establisher() {
        }

        @Override
        public void run() {
            while (EstablishmentManager.this._alive) {
                try {
                    this.doPass();
                }
                catch (RuntimeException re) {
                    EstablishmentManager.this._log.error("Error in the establisher", re);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            EstablishmentManager.this._inboundStates.clear();
            EstablishmentManager.this._outboundStates.clear();
            EstablishmentManager.this._queuedOutbound.clear();
            EstablishmentManager.this._outboundByClaimedAddress.clear();
            EstablishmentManager.this._outboundByHash.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPass() {
            long nextSendTime;
            long delay;
            long now = EstablishmentManager.this._context.clock().now();
            if (EstablishmentManager.this._log.shouldLog(10) && this._lastPrinted + 5000L < now) {
                this._lastPrinted = now;
                int iactive = EstablishmentManager.this._inboundStates.size();
                int oactive = EstablishmentManager.this._outboundStates.size();
                if (iactive > 0 || oactive > 0) {
                    int queued = EstablishmentManager.this._queuedOutbound.size();
                    int live = EstablishmentManager.this._liveIntroductions.size();
                    int claimed = EstablishmentManager.this._outboundByClaimedAddress.size();
                    int hash = EstablishmentManager.this._outboundByHash.size();
                    EstablishmentManager.this._log.debug("OB states: " + oactive + " IB states: " + iactive + " OB queued: " + queued + " intros: " + live + " OB claimed: " + claimed + " hash: " + hash);
                }
            }
            EstablishmentManager.this._activity = 0;
            if (this._lastFailsafe + 180000L < now) {
                this._lastFailsafe = now;
                this.doFailsafe(now);
            }
            if ((delay = (nextSendTime = Math.min(EstablishmentManager.this.handleInbound(), EstablishmentManager.this.handleOutbound())) - now) > 0L) {
                if (delay > 1000L) {
                    delay = 1000L;
                }
                try {
                    Object object = EstablishmentManager.this._activityLock;
                    synchronized (object) {
                        if (EstablishmentManager.this._activity > 0) {
                            return;
                        }
                        EstablishmentManager.this._activityLock.wait(delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFailsafe(long now) {
            OutboundEstablishState state;
            Iterator iter = EstablishmentManager.this._liveIntroductions.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime(now) <= 75000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove LI " + state);
            }
            iter = EstablishmentManager.this._outboundByClaimedAddress.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime(now) <= 75000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove OBBCA " + state);
            }
            iter = EstablishmentManager.this._outboundByHash.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime(now) <= 75000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove OBBH " + state);
            }
            if (EstablishmentManager.this._inboundTokens != null) {
                Token tok;
                Iterator iter2;
                int count = 0;
                Map map = EstablishmentManager.this._inboundTokens;
                synchronized (map) {
                    iter2 = EstablishmentManager.this._inboundTokens.values().iterator();
                    while (iter2.hasNext()) {
                        tok = (Token)iter2.next();
                        if (tok.getExpiration() >= now) continue;
                        iter2.remove();
                        ++count;
                    }
                }
                if (count > 0 && EstablishmentManager.this._log.shouldDebug()) {
                    EstablishmentManager.this._log.debug("Expired " + count + " inbound tokens");
                }
                count = 0;
                map = EstablishmentManager.this._outboundTokens;
                synchronized (map) {
                    iter2 = EstablishmentManager.this._outboundTokens.values().iterator();
                    while (iter2.hasNext()) {
                        tok = (Token)iter2.next();
                        if (tok.getExpiration() >= now) continue;
                        iter2.remove();
                        ++count;
                    }
                }
                if (count > 0 && EstablishmentManager.this._log.shouldDebug()) {
                    EstablishmentManager.this._log.debug("Expired " + count + " outbound tokens");
                }
                EstablishmentManager.this._terminationCounter.clear();
                EstablishmentManager.this._transport.getIntroManager().cleanup();
            }
        }
    }

    private static class HPCallback
    implements SSU2Payload.PayloadCallback {
        private final RemoteHostId _from;
        public long _timeReceived;
        public byte[] _aliceIP;
        public int _alicePort;
        public int _respCode = 999;
        public byte[] _respData;

        public HPCallback(RemoteHostId from) {
            this._from = from;
        }

        @Override
        public void gotDateTime(long time) {
            this._timeReceived = time;
        }

        @Override
        public void gotOptions(byte[] options, boolean isHandshake) {
        }

        @Override
        public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotAddress(byte[] ip, int port) {
            this._aliceIP = ip;
            this._alicePort = port;
        }

        @Override
        public void gotRelayTagRequest() {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotRelayTag(long tag) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotRelayRequest(byte[] data) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotRelayResponse(int status, byte[] data) {
            this._respCode = status;
            this._respData = data;
        }

        @Override
        public void gotRelayIntro(Hash aliceHash, byte[] data) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotToken(long token, long expires) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotI2NP(I2NPMessage msg) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotACK(long ackThru, int acks, byte[] ranges) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotTermination(int reason, long count) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotPathChallenge(RemoteHostId from, byte[] data) {
            throw new IllegalStateException("Bad block in HP");
        }

        @Override
        public void gotPathResponse(RemoteHostId from, byte[] data) {
            throw new IllegalStateException("Bad block in HP");
        }
    }

    private class InboundTokens
    extends LHMCache<RemoteHostId, Token> {
        public InboundTokens(int max) {
            super(max);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<RemoteHostId, Token> eldest) {
            boolean rv = super.removeEldestEntry(eldest);
            if (rv) {
                long lifetime = EstablishmentManager.this._context.clock().now() - eldest.getValue().getWhenAdded();
                EstablishmentManager.this._context.statManager().addRateData("udp.inboundTokenLifetime", lifetime);
                if (EstablishmentManager.this._log.shouldDebug()) {
                    EstablishmentManager.this._log.debug("Remove oldest inbound " + eldest.getValue() + " for " + eldest.getKey());
                }
            }
            return rv;
        }
    }

    public static class Token {
        private final long token;
        private final int expires;
        private final int added;

        public Token(long tok, long exp, long now) {
            this.token = tok;
            this.expires = (int)(exp >> 10);
            this.added = (int)(now >> 10);
        }

        public long getToken() {
            return this.token;
        }

        public long getExpiration() {
            return ((long)this.expires & 0xFFFFFFFFL) << 10;
        }

        public long getWhenAdded() {
            return ((long)this.added & 0xFFFFFFFFL) << 10;
        }

        public String toString() {
            return "Token " + this.token + " added " + DataHelper.formatTime(this.getWhenAdded()) + " expires " + DataHelper.formatTime(this.getExpiration());
        }
    }

    private static class TokenComparator
    implements Comparator<Map.Entry<RemoteHostId, Token>> {
        private TokenComparator() {
        }

        @Override
        public int compare(Map.Entry<RemoteHostId, Token> l, Map.Entry<RemoteHostId, Token> r) {
            long re;
            long le = l.getValue().expires;
            if (le < (re = (long)r.getValue().expires)) {
                return -1;
            }
            if (le > re) {
                return 1;
            }
            return 0;
        }
    }
}

