/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.sybil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.sybil.Points;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateType;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.VersionComparator;

public class PersistSybil {
    private final I2PAppContext _context;
    private final Log _log;
    private static final String SDIR = "sybil-analysis";
    private static final String DIR = "sybil-analysis/results";
    private static final String PFX = "sybil-";
    private static final String SFX = ".txt.gz";
    private static final String BLOCKLIST_SYBIL_FILE = "blocklist-sybil.txt";

    PersistSybil(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PersistSybil.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(long date, Map<Hash, Points> entries) throws IOException {
        SecureDirectory dir = new SecureDirectory(this._context.getConfigDir(), DIR);
        if (!dir.exists()) {
            ((File)dir).mkdirs();
        }
        File file = new File(dir, PFX + date + SFX);
        StringBuilder buf = new StringBuilder(128);
        Writer out = null;
        try {
            out = new OutputStreamWriter(new GZIPOutputStream(new SecureFileOutputStream(file)));
            out.write("# Format (one per line)\n");
            out.write("# Base64 router hash:total points%points:reason%points:reason ...\n");
            for (Map.Entry<Hash, Points> entry : entries.entrySet()) {
                Hash h = entry.getKey();
                Points p = entry.getValue();
                buf.append(h.toBase64()).append(':');
                p.toString(buf);
                buf.append('\n');
                out.append(buf);
                buf.setLength(0);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized List<Long> load() {
        File dir = new File(this._context.getConfigDir(), DIR);
        ArrayList<Long> rv = new ArrayList<Long>();
        File[] files = dir.listFiles(new FileSuffixFilter(PFX, SFX));
        if (files == null) {
            return rv;
        }
        for (File file : files) {
            try {
                String name = file.getName();
                long d = Long.parseLong(name.substring(PFX.length(), name.length() - SFX.length()));
                rv.add(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Collections.sort(rv, Collections.reverseOrder());
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Hash, Points> load(long date) throws IOException {
        File dir = new File(this._context.getConfigDir(), DIR);
        File file = new File(dir, PFX + date + SFX);
        HashMap<Hash, Points> rv = new HashMap<Hash, Points>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
            while ((line = in.readLine()) != null) {
                int colon;
                if (line.startsWith("#") || (colon = line.indexOf(58)) != 44 || line.length() < 46) continue;
                Hash h = new Hash();
                try {
                    h.fromBase64(line.substring(0, 44));
                }
                catch (DataFormatException dfe) {
                    continue;
                }
                Points p = Points.fromString(line.substring(45));
                if (p == null) continue;
                rv.put(h, p);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Long, Points> load(Hash h) throws IOException {
        String bh = h.toBase64() + ':';
        File dir = new File(this._context.getConfigDir(), DIR);
        HashMap<Long, Points> rv = new HashMap<Long, Points>();
        List<Long> dates = this.load();
        for (Long date : dates) {
            File file = new File(dir, PFX + date + SFX);
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
                while ((line = in.readLine()) != null) {
                    Points p;
                    if (!line.startsWith(bh) || line.length() < 46 || (p = Points.fromString(line.substring(45))) == null) continue;
                    rv.put(date, p);
                }
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    public synchronized void removeOld() {
        long age;
        ClientApp console;
        long removeTime = 172800000L;
        ClientAppManager cmgr = this._context.clientAppManager();
        if (cmgr != null && (console = cmgr.getRegisteredApp("console")) != null) {
            removeTime = 864000000L;
        }
        if ((age = this._context.getProperty("router.sybilDeleteOld", removeTime)) <= 0L) {
            return;
        }
        long freq2 = 2L * this._context.getProperty("router.sybilFrequency", 86400000L);
        if (age < freq2) {
            age = freq2;
        }
        if (age < 60000L) {
            return;
        }
        long cutoff = this._context.clock().now() - age;
        File dir = new File(this._context.getConfigDir(), DIR);
        File[] files = dir.listFiles(new FileSuffixFilter(PFX, SFX));
        if (files == null) {
            return;
        }
        int deleted = 0;
        for (File file : files) {
            try {
                String name = file.getName();
                long d = Long.parseLong(name.substring(PFX.length(), name.length() - SFX.length()));
                if (d >= cutoff) continue;
                if (file.delete()) {
                    ++deleted;
                    continue;
                }
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Failed to delete: " + file);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (deleted > 0 && this._log.shouldWarn()) {
            this._log.warn("Deleted " + deleted + " old analysis files");
        }
    }

    public synchronized boolean delete(long date) {
        File dir = new File(this._context.getConfigDir(), DIR);
        File file = new File(dir, PFX + date + SFX);
        return file.delete();
    }

    File getBlocklistFile() {
        File f = new File(this._context.getConfigDir(), SDIR);
        return new File(f, BLOCKLIST_SYBIL_FILE);
    }

    Map<String, Long> readBlocklist() {
        File f = this.getBlocklistFile();
        String prev = this._context.getProperty("router.previousFullVersion");
        if (prev != null && VersionComparator.comp(prev, "2.5.0-3") < 0 && VersionComparator.comp("2.8.1-0", "2.5.0-3") >= 0) {
            f.delete();
            return null;
        }
        Map<String, Long> rv = this.readBlocklist(f);
        if (rv != null) {
            this.notifyVersion(f.lastModified());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Long> readBlocklist(File blFile) {
        HashMap<String, Long> rv = null;
        if (blFile.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "UTF-8"));
                rv = new HashMap<String, Long>();
                String buf = null;
                long now = this._context.clock().now() + 300000L;
                while ((buf = br.readLine()) != null) {
                    String[] ss;
                    int index = buf.indexOf(35);
                    if (index == 0 || (ss = DataHelper.split(buf, ",", 2)).length != 2) continue;
                    try {
                        long exp = Long.parseLong(ss[1]);
                        if (exp < now) continue;
                        rv.put(ss[0], exp);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException ioe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Error reading the blocklist file", ioe);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeBlocklist(Set<String> blocks, long blockUntil) {
        File blFile;
        Map<String, Long> map;
        SecureDirectory dir = new SecureDirectory(this._context.getConfigDir(), SDIR);
        if (!dir.exists()) {
            ((File)dir).mkdirs();
        }
        if ((map = this.readBlocklist(blFile = new File(dir, BLOCKLIST_SYBIL_FILE))) == null) {
            map = new HashMap<String, Long>();
        }
        Long until = blockUntil;
        for (String string : blocks) {
            Long l = map.put(string, until);
            if (l == null || l <= blockUntil) continue;
            map.put(string, l);
        }
        Writer out = null;
        try {
            out = new OutputStreamWriter(new SecureFileOutputStream(blFile));
            out.write("# Format (one per line)\n");
            out.write("# IP or Base64 router hash,expiration (ms)\n");
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                out.write(entry.getKey());
                out.write(44);
                out.write(entry.getValue().toString());
                out.write(10);
            }
            this.notifyVersion(this._context.clock().now());
        }
        catch (IOException iOException) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error writing the blocklist file", iOException);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void notifyVersion(long v) {
        UpdateManager umgr;
        ClientAppManager cmgr = this._context.clientAppManager();
        if (cmgr != null && (umgr = (UpdateManager)((Object)cmgr.getRegisteredApp("update"))) != null) {
            umgr.notifyInstalled(UpdateType.BLOCKLIST, "sybil", Long.toString(v));
        }
    }
}

