/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class LooseFileUnpacker
extends FileUnpacker {
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger(LooseFileUnpacker.class.getName());

    public LooseFileUnpacker(Cancellable cancellable, FileQueue queue, Prompt prompt) {
        super(cancellable, queue);
        this.prompt = prompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(PackFile file, InputStream packInputStream, File target) throws IOException, InstallerException {
        File resolvedFile = file.getFile();
        if (!resolvedFile.exists()) {
            String looseFilesDir = System.getProperty("looseFilesDir", System.getProperty("user.dir"));
            File parent = new File(looseFilesDir);
            resolvedFile = new File(parent, file.getRelativeSourcePath());
        }
        if (resolvedFile.exists()) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(resolvedFile);
                file = new PackFile(resolvedFile.getParentFile(), resolvedFile, file.getTargetPath(), file.osConstraints(), file.override(), file.overrideRenameTo(), file.blockable(), file.getAdditionals());
                this.copy(file, stream, target);
            }
            catch (IOException e) {
                logger.warning("Error when copying file " + resolvedFile + ": " + e);
            }
            finally {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e) {
                    logger.warning("Error when closing stream: " + e);
                }
            }
        } else {
            logger.warning("Could not find loosely bundled file: " + file.getRelativeSourcePath());
            if (this.prompt.confirm(Prompt.Type.WARNING, "File not found", "Could not find loosely bundled file: " + file.getRelativeSourcePath(), Prompt.Options.OK_CANCEL) == Prompt.Option.OK) {
                throw new InstallerException("Installation cancelled");
            }
        }
    }
}

