/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;

class UDPTrackerClient
implements I2PSessionMuxedListener {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final I2PSnarkUtil _util;
    private final Hash _myHash;
    private final int _rPort;
    private final ConcurrentHashMap<HostPort, Tracker> _trackers;
    private final Map<Integer, ReplyWaiter> _sentQueries;
    private boolean _isRunning;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_COMPLETED = 1;
    public static final int EVENT_STARTED = 2;
    public static final int EVENT_STOPPED = 3;
    private static final int ACTION_CONNECT = 0;
    private static final int ACTION_ANNOUNCE = 1;
    private static final int ACTION_SCRAPE = 2;
    private static final int ACTION_ERROR = 3;
    private static final int SEND_CRYPTO_TAGS = 8;
    private static final int LOW_CRYPTO_TAGS = 4;
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final long DEFAULT_QUERY_TIMEOUT = 60000L;
    private static final long CLEAN_TIME = 163000L;
    private static final int DEFAULT_INTERVAL = 3600;
    private static final int MIN_INTERVAL = 900;
    private static final int MAX_INTERVAL = 28800;

    public UDPTrackerClient(I2PAppContext ctx, I2PSession session, I2PSnarkUtil util) {
        this._context = ctx;
        this._session = session;
        this._util = util;
        this._log = ctx.logManager().getLog(UDPTrackerClient.class);
        this._rPort = 6880;
        this._myHash = session.getMyDestination().calculateHash();
        this._trackers = new ConcurrentHashMap(8);
        this._sentQueries = new ConcurrentHashMap<Integer, ReplyWaiter>(32);
    }

    public synchronized void start() {
        if (this._isRunning) {
            return;
        }
        this._session.addMuxedSessionListener(this, 18, this._rPort);
        this._isRunning = true;
    }

    public synchronized void stop() {
        if (!this._isRunning) {
            return;
        }
        this._isRunning = false;
        this._session.removeListener(18, this._rPort);
        this._trackers.clear();
        for (ReplyWaiter w : this._sentQueries.values()) {
            w.cancel();
        }
        this._sentQueries.clear();
    }

    public TrackerResponse announce(byte[] ih, byte[] peerID, int max, long maxWait, String toHost, int toPort, long downloaded, long left, long uploaded, int event, boolean fast) {
        long now = this._context.clock().now();
        long end = now + maxWait;
        if (toPort < 0) {
            throw new IllegalArgumentException();
        }
        Tracker tr = this.getTracker(toHost, toPort);
        if (tr.getDest(fast) == null) {
            if (this._log.shouldInfo()) {
                this._log.info("cannot resolve " + tr);
            }
            return null;
        }
        long toWait = end - now;
        if (!fast) {
            toWait = toWait * 3L / 4L;
        }
        if (toWait < 1000L) {
            if (this._log.shouldInfo()) {
                this._log.info("out of time after resolving: " + tr);
            }
            return null;
        }
        if (fast) {
            toWait = 0L;
        } else {
            toWait = end - now;
            if (toWait < 1000L) {
                if (this._log.shouldInfo()) {
                    this._log.info("out of time after getting conn: " + tr);
                }
                return null;
            }
        }
        ReplyWaiter w = this.sendAnnounce(tr, 0L, ih, peerID, downloaded, left, uploaded, event, max, toWait);
        if (fast) {
            return null;
        }
        if (w == null) {
            if (this._log.shouldInfo()) {
                this._log.info("initial announce failed: " + tr);
            }
            return null;
        }
        boolean success = this.waitAndRetransmit(w, end);
        this._sentQueries.remove(w.getID());
        if (success) {
            return w.getReplyObject();
        }
        if (this._log.shouldInfo()) {
            this._log.info("announce failed after retx: " + tr);
        }
        return null;
    }

    private Tracker getTracker(String host, int port) {
        Tracker ndp = new Tracker(host, port);
        Tracker odp = this._trackers.putIfAbsent(ndp, ndp);
        if (odp != null) {
            ndp = odp;
        }
        return ndp;
    }

    private ReplyWaiter sendAnnounce(Tracker tr, long connID, byte[] ih, byte[] id, long downloaded, long left, long uploaded, int event, int numWant, long toWait) {
        int tid = this._context.random().nextInt();
        byte[] payload = this.sendAnnounce(tr, tid, connID, ih, id, downloaded, left, uploaded, event, numWant);
        if (payload != null) {
            if (toWait > 0L) {
                ReplyWaiter rv = new ReplyWaiter(tid, tr, payload, toWait);
                this._sentQueries.put(tid, rv);
                if (this._log.shouldInfo()) {
                    this._log.info("Sent: " + rv + " timeout: " + toWait);
                }
                return rv;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Sent annc " + event + " to " + tr + " no wait");
            }
        }
        return null;
    }

    private byte[] sendAnnounce(Tracker tr, int tid, long connID, byte[] ih, byte[] id, long downloaded, long left, long uploaded, int event, int numWant) {
        byte[] payload = new byte[98];
        DataHelper.toLong8(payload, 0, connID);
        DataHelper.toLong(payload, 8, 4, 1L);
        DataHelper.toLong(payload, 12, 4, tid);
        System.arraycopy(ih, 0, payload, 16, 20);
        System.arraycopy(id, 0, payload, 36, 20);
        DataHelper.toLong(payload, 56, 8, downloaded);
        DataHelper.toLong(payload, 64, 8, left);
        DataHelper.toLong(payload, 72, 8, uploaded);
        DataHelper.toLong(payload, 80, 4, event);
        DataHelper.toLong(payload, 92, 4, numWant);
        DataHelper.toLong(payload, 96, 2, 6881L);
        boolean rv = this.sendMessage(tr.getDest(true), tr.getPort(), payload, true);
        return (byte[])(rv ? payload : null);
    }

    private boolean waitAndRetransmit(ReplyWaiter w, long untilTime) {
        ReplyWaiter replyWaiter = w;
        synchronized (replyWaiter) {
            block11: while (true) {
                long toWait;
                try {
                    toWait = untilTime - this._context.clock().now();
                    if (toWait <= 0L) {
                        return false;
                    }
                    w.wait(toWait);
                }
                catch (InterruptedException ie) {
                    return false;
                }
                switch (w.getState()) {
                    case INIT: {
                        continue block11;
                    }
                    case SUCCESS: {
                        return true;
                    }
                    case FAIL: {
                        return false;
                    }
                    case TIMEOUT: {
                        if (this._log.shouldInfo()) {
                            this._log.info("Timeout: " + w);
                        }
                        if ((toWait = untilTime - this._context.clock().now()) <= 1000L) {
                            return false;
                        }
                        boolean ok = this.resend(w, Math.min(toWait, w.getSentTo().getTimeout()));
                        if (ok) continue block11;
                        return false;
                    }
                }
            }
        }
    }

    private boolean resend(ReplyWaiter w, long toWait) {
        boolean rv;
        Tracker tr = w.getSentTo();
        int port = tr.getPort();
        if (this._log.shouldInfo()) {
            this._log.info("Resending: " + w + " timeout: " + toWait);
        }
        if (rv = this.sendMessage(tr.getDest(true), port, w.getPayload(), true)) {
            this._sentQueries.put(w.getID(), w);
            w.schedule(toWait);
        }
        return rv;
    }

    private boolean sendMessage(Destination dest, int toPort, byte[] payload, boolean repliable) {
        I2PDatagramMaker dgMaker;
        if (!this._isRunning) {
            if (this._log.shouldInfo()) {
                this._log.info("send failed, not running");
            }
            return false;
        }
        if (dest == null) {
            if (this._log.shouldInfo()) {
                this._log.info("send failed, no dest");
            }
            return false;
        }
        if (dest.calculateHash().equals(this._myHash)) {
            throw new IllegalArgumentException("don't send to ourselves");
        }
        if (repliable && (payload = (dgMaker = new I2PDatagramMaker(this._session)).makeI2PDatagram(payload)) == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("DGM fail");
            }
            return false;
        }
        SendMessageOptions opts = new SendMessageOptions();
        opts.setDate(this._context.clock().now() + 60000L);
        opts.setTagsToSend(8);
        opts.setTagThreshold(4);
        if (!repliable) {
            opts.setSendLeaseSet(false);
        }
        try {
            boolean success = this._session.sendMessage(dest, payload, 0, payload.length, repliable ? 17 : 18, this._rPort, toPort, opts);
            if (!success && this._log.shouldWarn()) {
                this._log.warn("sendMessage fail");
            }
            return success;
        }
        catch (I2PSessionException ise) {
            if (this._log.shouldWarn()) {
                this._log.warn("sendMessage fail", ise);
            }
            return false;
        }
    }

    private void receiveMessage(Destination from, int fromPort, byte[] payload) {
        if (payload.length < 8) {
            if (this._log.shouldInfo()) {
                this._log.info("Got short message: " + payload.length + " bytes");
            }
            return;
        }
        int action = (int)DataHelper.fromLong(payload, 0, 4);
        int tid = (int)DataHelper.fromLong(payload, 4, 4);
        ReplyWaiter waiter = this._sentQueries.remove(tid);
        if (waiter == null) {
            if (this._log.shouldInfo()) {
                this._log.info("Rcvd msg with no one waiting: " + tid);
            }
            return;
        }
        if (action == 1) {
            this.receiveAnnounce(waiter, payload);
        } else if (action == 3) {
            this.receiveError(waiter, payload);
        } else {
            if (this._log.shouldInfo()) {
                this._log.info("Rcvd msg with unknown action: " + action + " for: " + waiter);
            }
            waiter.gotReply(false);
            Tracker tr = waiter.getSentTo();
            tr.gotError();
        }
    }

    private void receiveAnnounce(ReplyWaiter waiter, byte[] payload) {
        Tracker tr = waiter.getSentTo();
        if (payload.length >= 22) {
            Set<Hash> hashes;
            int interval = Math.min(28800, Math.max(900, (int)DataHelper.fromLong(payload, 8, 4)));
            int leeches = (int)DataHelper.fromLong(payload, 12, 4);
            int seeds = (int)DataHelper.fromLong(payload, 16, 4);
            int peers = (int)DataHelper.fromLong(payload, 20, 2);
            if (22 + peers * 32 > payload.length) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Short reply");
                }
                waiter.gotReply(false);
                tr.gotError();
                return;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Rcvd " + peers + " peers from " + tr);
            }
            if (peers > 0) {
                hashes = new HashSet(peers);
                for (int off = 20; off < payload.length; off += 32) {
                    hashes.add(Hash.create(payload, off));
                }
            } else {
                hashes = Collections.emptySet();
            }
            TrackerResponse resp = new TrackerResponse(interval, seeds, leeches, hashes);
            waiter.gotResponse(resp);
            tr.setInterval(interval);
        } else {
            waiter.gotReply(false);
            tr.gotError();
        }
    }

    private void receiveError(ReplyWaiter waiter, byte[] payload) {
        String msg = payload.length > 8 ? DataHelper.getUTF8(payload, 8, payload.length - 8) : "";
        TrackerResponse resp = new TrackerResponse(msg);
        waiter.gotResponse(resp);
        Tracker tr = waiter.getSentTo();
        tr.gotError();
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromPort, int toPort) {
        block6: {
            try {
                byte[] payload = session.receiveMessage(msgId);
                if (payload == null) {
                    return;
                }
                if (toPort == this._rPort) {
                    this.receiveMessage(null, fromPort, payload);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("msg on bad port");
                }
            }
            catch (I2PSessionException e) {
                if (!this._log.shouldWarn()) break block6;
                this._log.warn("bad msg");
            }
        }
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size) {
    }

    @Override
    public void reportAbuse(I2PSession session, int severity) {
    }

    @Override
    public void disconnected(I2PSession session) {
        if (this._log.shouldWarn()) {
            this._log.warn("UDPTC disconnected");
        }
    }

    @Override
    public void errorOccurred(I2PSession session, String message, Throwable error) {
        if (this._log.shouldWarn()) {
            this._log.warn("UDPTC got error msg: ", error);
        }
    }

    private static class HostPort {
        protected final String host;
        protected final int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return this.host.hashCode() ^ this.port;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof HostPort)) {
                return false;
            }
            HostPort dp = (HostPort)o;
            return this.port == dp.port && this.host.equals(dp.host);
        }

        public String toString() {
            return "UDP Tracker " + this.host + ':' + this.port;
        }
    }

    private class ReplyWaiter
    extends SimpleTimer2.TimedEvent {
        private final int tid;
        private final Tracker sentTo;
        private final byte[] data;
        private TrackerResponse replyObject;
        private WaitState state;

        public ReplyWaiter(int tid, Tracker tracker, byte[] payload, long toWait) {
            super(SimpleTimer2.getInstance(), toWait);
            this.state = WaitState.INIT;
            this.tid = tid;
            this.sentTo = tracker;
            this.data = payload;
        }

        public int getID() {
            return this.tid;
        }

        public Tracker getSentTo() {
            return this.sentTo;
        }

        public byte[] getPayload() {
            return this.data;
        }

        public synchronized TrackerResponse getReplyObject() {
            return this.replyObject;
        }

        public synchronized WaitState getState() {
            return this.state;
        }

        public synchronized void gotReply(boolean success) {
            this.cancel();
            UDPTrackerClient.this._sentQueries.remove(this.tid);
            this.setState(success ? WaitState.SUCCESS : WaitState.FAIL);
        }

        private synchronized void setState(WaitState state) {
            this.state = state;
            this.notifyAll();
        }

        public synchronized void gotResponse(TrackerResponse resp) {
            this.replyObject = resp;
            this.gotReply(true);
        }

        @Override
        public synchronized void schedule(long toWait) {
            this.state = WaitState.INIT;
            super.schedule(toWait);
        }

        @Override
        public synchronized void timeReached() {
            if (this.state != WaitState.INIT) {
                return;
            }
            this.sentTo.replyTimeout();
            this.setState(WaitState.TIMEOUT);
            if (UDPTrackerClient.this._log.shouldWarn()) {
                UDPTrackerClient.this._log.warn("timeout waiting for reply from " + this.sentTo);
            }
        }

        @Override
        public String toString() {
            return "Waiting for ID: " + this.tid + " to: " + this.sentTo + " state: " + (Object)((Object)this.state);
        }
    }

    private class Tracker
    extends HostPort {
        private final Object destLock;
        private Destination dest;
        private long expires;
        private long lastHeardFrom;
        private long lastFailed;
        private int consecFails;
        private int interval;
        private static final long DELAY = 15000L;

        public Tracker(String host, int port) {
            super(host, port);
            this.destLock = new Object();
            this.interval = 3600;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination getDest(boolean fast) {
            Object object = this.destLock;
            synchronized (object) {
                if (this.dest == null && !fast) {
                    this.dest = UDPTrackerClient.this._util.getDestination(this.host);
                }
                return this.dest;
            }
        }

        public synchronized void replyTimeout() {
            ++this.consecFails;
            this.lastFailed = UDPTrackerClient.this._context.clock().now();
        }

        public synchronized int getInterval() {
            return this.interval;
        }

        public synchronized void setInterval(int interval) {
            long now;
            this.lastHeardFrom = now = UDPTrackerClient.this._context.clock().now();
            this.consecFails = 0;
            this.interval = interval;
            this.notifyAll();
        }

        public synchronized void gotError() {
            long now;
            this.lastHeardFrom = now = UDPTrackerClient.this._context.clock().now();
            this.consecFails = 0;
            this.notifyAll();
        }

        public synchronized long getTimeout() {
            return 15000L << Math.min(this.consecFails, 3);
        }

        @Override
        public String toString() {
            return "UDP Tracker " + this.host + ':' + this.port + " hasDest? " + (this.dest != null);
        }
    }

    public static class TrackerResponse {
        private final int interval;
        private final int complete;
        private final int incomplete;
        private final String error;
        private final Set<Hash> peers;

        public TrackerResponse(int interval, int seeds, int leeches, Set<Hash> peers) {
            this.interval = interval;
            this.complete = seeds;
            this.incomplete = leeches;
            this.peers = peers;
            this.error = null;
        }

        public TrackerResponse(String errorMsg) {
            this.interval = 3600;
            this.complete = 0;
            this.incomplete = 0;
            this.peers = null;
            this.error = errorMsg;
        }

        public Set<Hash> getPeers() {
            return this.peers;
        }

        public int getPeerCount() {
            int pc = this.peers == null ? 0 : this.peers.size();
            return Math.max(pc, this.complete + this.incomplete - 1);
        }

        public int getSeedCount() {
            return this.complete;
        }

        public int getLeechCount() {
            return this.incomplete;
        }

        public String getFailureReason() {
            return this.error;
        }

        public int getInterval() {
            return this.interval;
        }
    }

    private static enum WaitState {
        INIT,
        SUCCESS,
        TIMEOUT,
        FAIL;

    }
}

