/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import com.izforge.izpack.util.regex.RegexUtil;
import com.izforge.izpack.util.regex.RegexpMatcher;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaRegexpMatcher
implements RegexpMatcher {
    private String pattern;

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    protected Pattern getCompiledPattern(int options) throws RuntimeException {
        int cOptions = this.getCompilerOptions(options);
        try {
            Pattern p = Pattern.compile(this.pattern, cOptions);
            return p;
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean matches(String argument) throws RuntimeException {
        return this.matches(argument, 0);
    }

    @Override
    public boolean matches(String input, int options) throws RuntimeException {
        try {
            Pattern p = this.getCompiledPattern(options);
            return p.matcher(input).find();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Vector<String> getGroups(String argument) throws RuntimeException {
        return this.getGroups(argument, 0);
    }

    @Override
    public Vector<String> getGroups(String input, int options) throws RuntimeException {
        Pattern p = this.getCompiledPattern(options);
        Matcher matcher = p.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int cnt = matcher.groupCount();
        for (int i = 0; i <= cnt; ++i) {
            String match = matcher.group(i);
            if (match == null) {
                match = "";
            }
            v.addElement(match);
        }
        return v;
    }

    protected int getCompilerOptions(int options) {
        int cOptions = 1;
        if (RegexUtil.hasFlag(options, 256)) {
            cOptions |= 2;
        }
        if (RegexUtil.hasFlag(options, 4096)) {
            cOptions |= 8;
        }
        if (RegexUtil.hasFlag(options, 65536)) {
            cOptions |= 0x20;
        }
        return cOptions;
    }
}

