/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.substitutor;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.substitutor.VariableSubstitutorReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;

public class VariableSubstitutorInputStream
extends InputStream {
    private String encoding;
    private Reader substitutorReader;

    public VariableSubstitutorInputStream(InputStream inputStream, Variables variables, SubstitutionType type, boolean bracesRequired) throws UnsupportedEncodingException {
        this(inputStream, null, variables, type, bracesRequired);
    }

    public VariableSubstitutorInputStream(InputStream inputStream, String encoding, Variables variables, SubstitutionType type, boolean bracesRequired) throws UnsupportedEncodingException {
        if (encoding == null) {
            if (type == null) {
                type = SubstitutionType.getDefault();
            }
            switch (type) {
                case TYPE_JAVA_PROPERTIES: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case TYPE_XML: {
                    encoding = "UTF-8";
                }
            }
        }
        this.encoding = encoding;
        InputStreamReader inputStreamReader = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
        this.substitutorReader = new VariableSubstitutorReader(inputStreamReader, variables, type, bracesRequired);
    }

    @Override
    public int read() throws IOException {
        return this.substitutorReader.read();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.substitutorReader);
        super.close();
    }

    public String getEncoding() {
        return this.encoding;
    }
}

