/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.i2p.client.naming.HostTxtEntry;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class HostTxtParser {
    private static final boolean isWindows = SystemVersion.isWindows();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, HostTxtEntry> parse(BufferedReader input) throws IOException {
        try {
            String inputLine;
            HashMap<String, HostTxtEntry> result = new HashMap<String, HostTxtEntry>();
            while ((inputLine = input.readLine()) != null) {
                HostTxtEntry he = HostTxtParser.parse(inputLine, false);
                if (he == null) continue;
                result.put(he.getName(), he);
            }
            HashMap<String, HostTxtEntry> hashMap = result;
            return hashMap;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static HostTxtEntry parse(String inputLine, boolean allowCommandOnly) {
        HostTxtEntry he;
        String dest;
        String name;
        String kv;
        String sprops;
        if (inputLine.startsWith(";")) {
            return null;
        }
        int comment = inputLine.indexOf(35);
        if (comment >= 0) {
            int shebang = inputLine.indexOf("#!");
            if (shebang == comment && shebang + 2 < inputLine.length()) {
                if (comment == 0 && !allowCommandOnly) {
                    return null;
                }
                sprops = inputLine.substring(shebang + 2);
            } else {
                if (comment == 0) {
                    return null;
                }
                sprops = null;
            }
            kv = inputLine.substring(0, comment);
        } else {
            sprops = null;
            kv = inputLine;
        }
        if (comment != 0) {
            String[] splitLine = DataHelper.split(kv, "=", 2);
            if (splitLine.length < 2) {
                return null;
            }
            name = splitLine[0].trim().toLowerCase(Locale.US);
            dest = splitLine[1].trim();
            if (name.length() == 0 || dest.length() == 0) {
                return null;
            }
        } else {
            name = null;
            dest = null;
        }
        if (sprops != null) {
            try {
                he = new HostTxtEntry(name, dest, sprops);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        } else {
            he = new HostTxtEntry(name, dest);
        }
        return he;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, HostTxtEntry> parse(File file) throws IOException {
        FileInputStream fileStream = null;
        try {
            Map<String, HostTxtEntry> rv;
            fileStream = new FileInputStream(file);
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)fileStream, "UTF-8"));
            Map<String, HostTxtEntry> map = rv = HostTxtParser.parse(input);
            return map;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Map<String, HostTxtEntry> parse(File file, Map<String, HostTxtEntry> map) {
        Map<String, HostTxtEntry> result;
        try {
            result = HostTxtParser.parse(file);
            for (Map.Entry<String, HostTxtEntry> entry : map.entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException exp) {
            result = map;
            try {
                HostTxtParser.write(result, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(Map<String, HostTxtEntry> map, BufferedWriter output) throws IOException {
        try {
            for (Map.Entry<String, HostTxtEntry> entry : map.entrySet()) {
                entry.getValue().write(output);
            }
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(Map<String, HostTxtEntry> map, File file) throws IOException {
        boolean success = false;
        if (!isWindows) {
            File tmp = SecureFile.createTempFile("temp-", ".tmp", file.getAbsoluteFile().getParentFile());
            HostTxtParser.write(map, new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(tmp), "UTF-8")));
            success = tmp.renameTo(file);
            if (!success) {
                tmp.delete();
            }
        }
        if (!success) {
            HostTxtParser.write(map, new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(file), "UTF-8")));
        }
    }

    public static void main(String[] args) throws Exception {
        OrderedProperties p;
        HostTxtEntry e;
        boolean quiet = false;
        if (args.length > 0 && args[0].equals("-q")) {
            quiet = true;
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length != 2 || !args[0].equals("validate")) {
            System.err.println("Usage: HostTxtParser validate example.i2p=b64dest[#!key1=val1#key2=val2]");
            System.exit(1);
        }
        if ((e = HostTxtParser.parse(args[1].trim(), false)) == null) {
            if (!quiet) {
                System.err.println("Bad format");
            }
            System.exit(2);
        }
        if (!e.hasValidSig()) {
            if (!quiet) {
                System.err.println("Bad signature for " + e.getName());
                String dest = e.getDest();
                try {
                    Destination d = new Destination(dest);
                    System.err.println(dest);
                    System.err.println(d.toString());
                }
                catch (Exception ex) {
                    System.err.println("Invalid destination: " + dest);
                }
                OrderedProperties p2 = e.getProps();
                if (p2 != null) {
                    for (Map.Entry<Object, Object> m : ((Properties)p2).entrySet()) {
                        System.err.println(m.getKey() + "=" + m.getValue());
                    }
                }
            }
            System.exit(3);
        }
        if ((p = e.getProps()) != null && (p.containsKey("action") || p.containsKey("olddest") || p.containsKey("oldname") || p.containsKey("oldsig")) && !e.hasValidSig()) {
            if (!quiet) {
                System.err.println("Bad inner signature for " + e.getName());
                for (Map.Entry entry : ((Properties)p).entrySet()) {
                    System.err.println(entry.getKey() + "=" + entry.getValue());
                }
            }
            System.exit(4);
        }
        if (!quiet) {
            System.err.println("Good signature for " + e.getName());
            try {
                String dest = e.getDest();
                Destination destination = new Destination(dest);
                System.err.println(dest);
                System.err.println(destination.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (p != null) {
                for (Map.Entry<Object, Object> entry : ((Properties)p).entrySet()) {
                    System.err.println(entry.getKey() + "=" + entry.getValue());
                }
            }
        }
        System.exit(0);
    }
}

