/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.rules;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ComparisonOperator {
    EQUAL("eq"),
    NOTEQUAL("ne"),
    LESSEQUAL("leq"),
    LESS("lt"),
    GREATEREQUAL("geq"),
    GREATER("gt");

    private static Map<String, ComparisonOperator> lookup;
    private String attribute;

    private ComparisonOperator(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public static ComparisonOperator getComparisonOperatorFromAttribute(String attribute) {
        if (attribute != null && lookup.containsKey(attribute)) {
            return lookup.get(attribute);
        }
        return null;
    }

    static {
        lookup = new HashMap<String, ComparisonOperator>();
        for (ComparisonOperator op : EnumSet.allOf(ComparisonOperator.class)) {
            lookup.put(op.getAttribute(), op);
        }
    }
}

