/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.HandleFloodfillDatabaseLookupMessageJob;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class FloodfillDatabaseLookupMessageHandler
implements HandlerJobBuilder {
    private RouterContext _context;
    private FloodfillNetworkDatabaseFacade _facade;
    private Log _log;
    private final long _msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);

    public FloodfillDatabaseLookupMessageHandler(RouterContext context, FloodfillNetworkDatabaseFacade facade) {
        this._context = context;
        this._facade = facade;
        this._log = context.logManager().getLog(FloodfillDatabaseLookupMessageHandler.class);
        this._context.statManager().createRateStat("netDb.lookupsReceived", "How many netDb lookups have we received?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsDropped", "How many netDb lookups did we drop due to throttling?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.nonFFLookupsDropped", "How many netDb lookups did we drop due to us not being a floodfill?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsHandled", "How many netDb lookups have we handled?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatched", "How many netDb lookups did we have the data for?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedLeaseSet", "How many netDb leaseSet lookups did we have the data for?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedReceivedPublished", "How many netDb lookups did we have the data for that were published to us?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedLocalClosest", "How many netDb lookups for local data were received where we are the closest peers?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedLocalNotClosest", "How many netDb lookups for local data were received where we are NOT the closest peers?", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedRemoteNotClosest", "How many netDb lookups for remote data were received where we are NOT the closest peers?", "NetworkDatabase", new long[]{3600000L});
    }

    @Override
    public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        this._context.statManager().addRateData("netDb.lookupsReceived", 1L);
        DatabaseLookupMessage dlm = (DatabaseLookupMessage)receivedMessage;
        if (dlm.getSearchType() == DatabaseLookupMessage.Type.EXPL && !this._context.netDb().floodfillEnabled()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("[dbid: " + this._facade + "] Dropping " + (Object)((Object)dlm.getSearchType()) + " lookup request for " + dlm.getSearchKey() + " (we are not a floodfill), reply was to: " + dlm.getFrom() + " tunnel: " + dlm.getReplyTunnel());
            }
            this._context.statManager().addRateData("netDb.nonFFLookupsDropped", 1L);
            return null;
        }
        if (!this._facade.shouldThrottleLookup(dlm.getFrom(), dlm.getReplyTunnel()) || this._context.routerHash().equals(dlm.getSearchKey())) {
            HandleFloodfillDatabaseLookupMessageJob j = new HandleFloodfillDatabaseLookupMessageJob(this._context, dlm, from, fromHash, this._msgIDBloomXor);
            return j;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("[dbid: " + this._facade + "] Dropping " + (Object)((Object)dlm.getSearchType()) + " lookup request for " + dlm.getSearchKey() + " (throttled), reply was to: " + dlm.getFrom() + " tunnel: " + dlm.getReplyTunnel());
        }
        this._context.statManager().addRateData("netDb.lookupsDropped", 1L);
        return null;
    }
}

