/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.localServer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.naming.NamingService;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.BlindData;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.i2ptunnel.GunzipOutputStream;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.util.PortMapper;
import net.i2p.util.Translate;

public abstract class LocalHTTPServer {
    private static final String ERR_404 = "HTTP/1.1 404 Not Found\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nHTTP Proxy local file not found";
    private static final String ERR_ADD = "HTTP/1.1 409 Bad\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nAdd to addressbook failed - bad parameters";
    private static final String ERR_B32 = "HTTP/1.1 400 Bad\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nB32 update failed - bad parameters";
    private static final String OK = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nCache-Control: max-age=86400\r\nConnection: close\r\n\r\nI2P HTTP proxy OK";
    private static final String NEWKEY = "HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nReferrer-Policy: no-referrer\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n";
    private static final String BUNDLE_NAME = "net.i2p.i2ptunnel.proxy.messages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serveLocalFile(I2PAppContext context, I2PSocketManager sockMgr, OutputStream out, String method, String targetRequest, String query, String proxyNonce, boolean allowGzip) throws IOException {
        Map<String, String> opts;
        if (targetRequest.equals("/")) {
            out.write(OK.getBytes("UTF-8"));
            out.flush();
            return;
        }
        if ((method.equals("GET") || method.equals("HEAD")) && targetRequest.startsWith("/themes/") && !targetRequest.contains("..")) {
            InputStream in;
            String filename = targetRequest.substring(1);
            if (filename.startsWith("themes/console/default/")) {
                filename = filename.replaceFirst("default", context.getProperty("routerconsole.theme", "light"));
            }
            if (filename.endsWith(".css")) {
                filename = filename + ".gz";
            }
            if ((in = LocalHTTPServer.getResource(filename)) != null) {
                try {
                    String type = filename.endsWith(".css.gz") ? "text/css; charset=UTF-8" : (filename.endsWith(".ico") ? "image/x-icon" : (filename.endsWith(".png") ? "image/png" : (filename.endsWith(".jpg") ? "image/jpeg" : "text/html; charset=UTF-8")));
                    out.write("HTTP/1.1 200 OK\r\nContent-Type: ".getBytes("UTF-8"));
                    out.write(type.getBytes("UTF-8"));
                    if (allowGzip && filename.endsWith(".gz")) {
                        out.write("\r\nContent-Encoding: gzip".getBytes("UTF-8"));
                    }
                    out.write("\r\nCache-Control: max-age=86400\r\nConnection: close\r\n\r\n".getBytes("UTF-8"));
                    if (!allowGzip && filename.endsWith(".gz")) {
                        GunzipOutputStream out2 = new GunzipOutputStream(out);
                        DataHelper.copy(in, out2);
                        ((OutputStream)out2).flush();
                    } else {
                        DataHelper.copy(in, out);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException type) {}
                }
                return;
            }
        }
        if (targetRequest.equals("/add")) {
            if (query == null) {
                out.write(ERR_ADD.getBytes("UTF-8"));
                return;
            }
            opts = LocalHTTPServer.decodeQuery(query);
            String url = opts.get("url");
            String host = opts.get("host");
            String b64Dest = opts.get("dest");
            String nonce = opts.get("nonce");
            String referer = opts.get("referer");
            String book = "privatehosts.txt";
            if (opts.get("local") != null) {
                book = "userhosts.txt";
            } else if (opts.get("router") != null) {
                book = "hosts.txt";
            }
            Destination dest = null;
            if (b64Dest != null) {
                try {
                    dest = new Destination(b64Dest);
                }
                catch (DataFormatException dfe) {
                    System.err.println("Bad dest to save?" + b64Dest);
                }
            }
            if (proxyNonce.equals(nonce) && url != null && host != null && dest != null) {
                NamingService ns = context.namingService();
                Properties nsOptions = new Properties();
                nsOptions.setProperty("list", book);
                if (referer != null && referer.startsWith("http")) {
                    String ref = DataHelper.escapeHTML(referer);
                    String from = "<a href=\"" + ref + "\">" + ref + "</a>";
                    nsOptions.setProperty("s", LocalHTTPServer._t("Added via address helper from {0}", from));
                } else {
                    nsOptions.setProperty("s", LocalHTTPServer._t("Added via address helper"));
                }
                boolean success = ns.put(host, dest, nsOptions);
                LocalHTTPServer.writeRedirectPage(out, success, host, book, url);
                return;
            }
            out.write(ERR_ADD.getBytes("UTF-8"));
        } else if (targetRequest.equals("/b32")) {
            String secret;
            if (query == null) {
                out.write(ERR_ADD.getBytes("UTF-8"));
                return;
            }
            opts = LocalHTTPServer.decodeQuery(query);
            String err = null;
            String url = opts.get("url");
            String host = opts.get("host");
            String nonce = opts.get("nonce");
            String code = opts.get("code");
            String privkey = opts.get("privkey");
            if (privkey != null) {
                privkey = privkey.trim();
            }
            if ((secret = opts.get("secret")) != null) {
                secret = secret.trim();
            }
            String action = opts.get("action");
            if (proxyNonce.equals(nonce) && url != null && host != null && code != null) {
                boolean success = true;
                PrivateKey privateKey = null;
                PublicKey publicKey = null;
                if (!code.equals("2") && !code.equals("4")) {
                    secret = null;
                } else if (secret == null || secret.length() == 0) {
                    err = LocalHTTPServer._t("Missing lookup password");
                    success = false;
                }
                int authType = 0;
                if (!code.equals("3") && !code.equals("4")) {
                    privkey = null;
                } else if ("newdh".equals(action) || "newpsk".equals(action)) {
                    KeyPair kp = context.keyGenerator().generatePKIKeys(EncType.ECIES_X25519);
                    privateKey = kp.getPrivate();
                    publicKey = kp.getPublic();
                    authType = action.equals("newdh") ? 1 : 3;
                } else if (privkey == null || privkey.length() == 0) {
                    err = LocalHTTPServer._t("Missing private key");
                    success = false;
                } else {
                    byte[] data = Base64.decode(privkey);
                    if (data == null || data.length != 32) {
                        err = LocalHTTPServer._t("Invalid private key");
                        success = false;
                    } else {
                        privateKey = new PrivateKey(EncType.ECIES_X25519, data);
                        authType = 3;
                    }
                }
                if (success) {
                    try {
                        BlindData bd = Blinding.decode(context, host);
                        SigningPublicKey spk = bd.getUnblindedPubKey();
                        SigType bt = bd.getBlindedSigType();
                        bd = new BlindData(context, spk, bt, secret, authType, privateKey);
                        long now = context.clock().now();
                        bd.setDate(now);
                        long exp = now + (bd.getAuthRequired() || bd.getSecretRequired() ? 31536000000L : 8812800000L);
                        bd.setExpiration(exp);
                        I2PSession sess = sockMgr.getSession();
                        sess.sendBlindingInfo(bd);
                        if ("newdh".equals(action) || "newpsk".equals(action)) {
                            String key = "newdh".equals(action) ? publicKey.toBase64() : privateKey.toBase64();
                            StringBuilder buf = new StringBuilder(1024);
                            PortMapper pm = context.portMapper();
                            String conURL = pm.getConsoleURL();
                            buf.append(NEWKEY).append("<html><head><title>").append(LocalHTTPServer._t("Your new encryption key")).append("</title>\n<link rel=\"shortcut icon\" href=\"http://proxy.i2p/themes/console/images/favicon.ico\" >\n<link href=\"http://proxy.i2p/themes/console/default/proxy.css\" rel=\"stylesheet\" type=\"text/css\" >\n</head><body>\n<div class=logo>\n<a href=\"").append(conURL).append("\" title=\"").append(LocalHTTPServer._t("Router Console")).append("\"><img src=\"http://proxy.i2p/themes/console/images/i2plogo.png\" alt=\"I2P Router Console\" border=\"0\"></a><hr>\n<a href=\"").append(conURL).append("config\">").append(LocalHTTPServer._t("Configuration")).append("</a> <a href=\"").append(conURL).append("help.jsp\">").append(LocalHTTPServer._t("Help")).append("</a>");
                            if (pm.isRegistered("susidns")) {
                                buf.append(" <a href=\"").append(conURL).append("susidns/index\">").append(LocalHTTPServer._t("Address book")).append("</a>\n");
                            }
                            buf.append("</div><div class=warning id=warning>\n<h3>").append(LocalHTTPServer._t("Your new encryption key")).append("</h3>\n<p><textarea rows=\"1\" style=\"min-width: 0; min-height: 0;\" cols=\"70\" wrap=\"off\" readonly=\"readonly\" >").append(key).append("</textarea><p>").append(LocalHTTPServer._t("Copy the key and send it to the server operator.")).append(' ').append(LocalHTTPServer._t("After you are granted permission, you may proceed to the website.")).append("<p><a href=\"").append(url).append("\">").append(url).append("</a></div>");
                            out.write(buf.toString().getBytes("UTF-8"));
                            I2PTunnelHTTPClientBase.writeFooter(out);
                        } else {
                            LocalHTTPServer.writeB32RedirectPage(out, host, url);
                        }
                        return;
                    }
                    catch (IllegalArgumentException iae) {
                        err = iae.toString();
                    }
                    catch (I2PSessionException ise) {
                        err = ise.toString();
                    }
                }
            }
            out.write(ERR_B32.getBytes("UTF-8"));
            if (err != null) {
                out.write(("\n\n" + err + "\n\n" + LocalHTTPServer._t("Go back and fix the error")).getBytes("UTF-8"));
            }
        } else {
            out.write(ERR_404.getBytes("UTF-8"));
        }
        out.flush();
    }

    private static void writeRedirectPage(OutputStream out, boolean success, String host, String book, String url) throws IOException {
        String tbook = "hosts.txt".equals(book) ? LocalHTTPServer._t("router") : ("userhosts.txt".equals(book) ? LocalHTTPServer._t("local") : ("privatehosts.txt".equals(book) ? LocalHTTPServer._t("private") : book));
        PortMapper pm = I2PAppContext.getGlobalContext().portMapper();
        String conURL = pm.getConsoleURL();
        String idn = I2PTunnelHTTPClientBase.decodeIDNHost(host);
        out.write(("HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nReferrer-Policy: no-referrer\r\nConnection: close\r\n\r\n<html><head><title>" + LocalHTTPServer._t("Redirecting to {0}", idn) + "</title>\n<link rel=\"shortcut icon\" href=\"http://proxy.i2p/themes/console/images/favicon.ico\" >\n<link href=\"http://proxy.i2p/themes/console/default/proxy.css\" rel=\"stylesheet\" type=\"text/css\" >\n<meta http-equiv=\"Refresh\" content=\"1; url=" + url + "\">\n</head><body>\n<div class=logo>\n<a href=\"" + conURL + "\" title=\"" + LocalHTTPServer._t("Router Console") + "\"><img src=\"http://proxy.i2p/themes/console/images/i2plogo.png\" alt=\"I2P Router Console\" border=\"0\"></a><hr>\n<a href=\"" + conURL + "config\">" + LocalHTTPServer._t("Configuration") + "</a> <a href=\"" + conURL + "help.jsp\">" + LocalHTTPServer._t("Help") + "</a>").getBytes("UTF-8"));
        if (pm.isRegistered("susidns")) {
            out.write((" <a href=\"" + conURL + "susidns/index\">" + LocalHTTPServer._t("Address Book") + "</a>\n").getBytes("UTF-8"));
        }
        out.write(("</div><div class=warning id=warning>\n<h3>" + (success ? LocalHTTPServer._t("Saved {0} to the {1} address book, redirecting now.", idn, tbook) : LocalHTTPServer._t("Failed to save {0} to the {1} address book, redirecting now.", idn, tbook)) + "</h3>\n<p><a href=\"" + url + "\">" + LocalHTTPServer._t("Click here if you are not redirected automatically.") + "</a></p></div>").getBytes("UTF-8"));
        I2PTunnelHTTPClientBase.writeFooter(out);
        out.flush();
    }

    private static void writeB32RedirectPage(OutputStream out, String host, String url) throws IOException {
        PortMapper pm = I2PAppContext.getGlobalContext().portMapper();
        String conURL = pm.getConsoleURL();
        String idn = I2PTunnelHTTPClientBase.decodeIDNHost(host);
        out.write(("HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nReferrer-Policy: no-referrer\r\nConnection: close\r\n\r\n<html><head><title>" + LocalHTTPServer._t("Redirecting to {0}", idn) + "</title>\n<link rel=\"shortcut icon\" href=\"http://proxy.i2p/themes/console/images/favicon.ico\" >\n<link href=\"http://proxy.i2p/themes/console/default/proxy.css\" rel=\"stylesheet\" type=\"text/css\" >\n<meta http-equiv=\"Refresh\" content=\"1; url=" + url + "\">\n</head><body>\n<div class=logo>\n<a href=\"" + conURL + "\" title=\"" + LocalHTTPServer._t("Router Console") + "\"><img src=\"http://proxy.i2p/themes/console/images/i2plogo.png\" alt=\"I2P Router Console\" border=\"0\"></a><hr>\n<a href=\"" + conURL + "config\">" + LocalHTTPServer._t("Configuration") + "</a> <a href=\"" + conURL + "help.jsp\">" + LocalHTTPServer._t("Help") + "</a>").getBytes("UTF-8"));
        if (pm.isRegistered("susidns")) {
            out.write((" <a href=\"" + conURL + "susidns/index\">" + LocalHTTPServer._t("Address Book") + "</a>\n").getBytes("UTF-8"));
        }
        out.write(("</div><div class=warning id=warning>\n<h3>" + LocalHTTPServer._t("Saved the authentication for {0}, redirecting now.", idn) + "</h3>\n<p><a href=\"" + url + "\">" + LocalHTTPServer._t("Click here if you are not redirected automatically.") + "</a></p></div>").getBytes("UTF-8"));
        I2PTunnelHTTPClientBase.writeFooter(out);
        out.flush();
    }

    private static Map<String, String> decodeQuery(String query) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        int keystart = 0;
        int valstart = -1;
        String key = null;
        for (int i = 0; i <= query.length(); ++i) {
            int c;
            int n = c = i < query.length() ? (int)query.charAt(i) : 38;
            if (c == 59 || c == 38) {
                if (valstart < 0) {
                    key = query.substring(keystart, i);
                }
                if (key.length() > 0) {
                    String newQuery;
                    String decodedKey = LocalHTTPServer.decode(key);
                    String string = newQuery = keystart > 0 ? query.substring(0, keystart - 1) : "";
                    if (i < query.length() - 1) {
                        newQuery = keystart > 0 ? newQuery + query.substring(i) : newQuery + query.substring(i + 1);
                    }
                    String value = valstart >= 0 ? query.substring(valstart, i) : "";
                    String decodedValue = LocalHTTPServer.decode(value);
                    rv.put(decodedKey, decodedValue);
                }
                keystart = i + 1;
                valstart = -1;
                continue;
            }
            if (c != 61 || valstart >= 0) continue;
            key = query.substring(keystart, i);
            valstart = i + 1;
        }
        return rv;
    }

    public static String decode(String s) {
        if (!s.contains("%")) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                buf.append(c);
                continue;
            }
            try {
                buf.append((char)Integer.parseInt(s.substring(++i, ++i + 1), 16));
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                break;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        return buf.toString();
    }

    public static InputStream getResource(String resource) {
        return LocalHTTPServer.class.getResourceAsStream("/net/i2p/i2ptunnel/resources/" + resource);
    }

    protected static String _t(String key) {
        return Translate.getString(key, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _t(String key, Object o) {
        return Translate.getString(key, o, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _t(String key, Object o, Object o2) {
        return Translate.getString(key, o, o2, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }
}

