/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.GunzipOutputStream;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class HTTPResponseOutputStream
extends FilterOutputStream {
    private final Log _log;
    protected ByteArray _headerBuffer;
    private boolean _headerWritten;
    private final byte[] _buf1;
    protected boolean _gzip;
    protected long _dataExpected;
    protected String _contentType;
    protected String _contentEncoding;
    private static final int CACHE_SIZE = 4096;
    private static final ByteCache _cache = ByteCache.getInstance(8, 4096);
    private static final int MAX_HEADER_SIZE = 65536;
    private static final byte NL = 10;
    private static final byte[] CONNECTION_CLOSE = DataHelper.getASCII("Connection: close\r\n");
    private static final byte[] CRLF = DataHelper.getASCII("\r\n");

    public HTTPResponseOutputStream(OutputStream raw) {
        super(raw);
        I2PAppContext context = I2PAppContext.getGlobalContext();
        this._log = context.logManager().getLog(this.getClass());
        this._headerBuffer = (ByteArray)_cache.acquire();
        this._buf1 = new byte[1];
    }

    @Override
    public void write(int c) throws IOException {
        this._buf1[0] = (byte)c;
        this.write(this._buf1, 0, 1);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (this._headerWritten) {
            this.out.write(buf, off, len);
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.ensureCapacity();
            int valid = this._headerBuffer.getValid();
            this._headerBuffer.getData()[valid] = buf[off + i];
            this._headerBuffer.setValid(valid + 1);
            if (!this.headerReceived()) continue;
            this.writeHeader();
            this._headerWritten = true;
            if (i + 1 < len) {
                this.out.write(buf, off + i + 1, len - i - 1);
            }
            return;
        }
    }

    private void ensureCapacity() throws IOException {
        int valid = this._headerBuffer.getValid();
        if (valid >= 65536) {
            throw new IOException("Max header size exceeded: 65536");
        }
        byte[] data = this._headerBuffer.getData();
        int len = data.length;
        if (valid + 1 >= len) {
            int newSize = len * 2;
            ByteArray newBuf = new ByteArray(new byte[newSize]);
            System.arraycopy(data, 0, newBuf.getData(), 0, valid);
            newBuf.setValid(valid);
            newBuf.setOffset(0);
            if (len == 4096) {
                _cache.release(this._headerBuffer);
            }
            this._headerBuffer = newBuf;
        }
    }

    private boolean headerReceived() {
        int valid = this._headerBuffer.getValid();
        if (valid < 3) {
            return false;
        }
        byte[] data = this._headerBuffer.getData();
        byte third = data[valid - 1];
        if (third != 10) {
            return false;
        }
        byte first = data[valid - 3];
        if (first == 10) {
            return true;
        }
        byte second = data[valid - 2];
        return second == 10;
    }

    protected String filterResponseLine(String line) {
        return line;
    }

    private void writeHeader() throws IOException {
        String responseLine = null;
        boolean connectionSent = false;
        int lastEnd = -1;
        byte[] data = this._headerBuffer.getData();
        int valid = this._headerBuffer.getValid();
        for (int i = 0; i < valid; ++i) {
            if (data[i] != 10) continue;
            if (lastEnd == -1) {
                responseLine = DataHelper.getUTF8(data, 0, i + 1);
                responseLine = this.filterResponseLine(responseLine);
                responseLine = responseLine.trim() + "\r\n";
                if (this._log.shouldInfo()) {
                    this._log.info("Response: " + responseLine.trim());
                }
                this.out.write(DataHelper.getUTF8(responseLine));
            } else {
                for (int j = lastEnd + 1; j < i; ++j) {
                    String lcVal;
                    String lcKey;
                    if (data[j] != 58) continue;
                    int keyLen = j - (lastEnd + 1);
                    int valLen = i - (j + 1);
                    if (keyLen <= 0 || valLen < 0) {
                        throw new IOException("Invalid header @ " + j);
                    }
                    String key = DataHelper.getUTF8(data, lastEnd + 1, keyLen);
                    String val = valLen == 0 ? "" : DataHelper.getUTF8(data, j + 2, valLen).trim();
                    if (this._log.shouldInfo()) {
                        this._log.info("Response header [" + key + "] = [" + val + "]");
                    }
                    if ("connection".equals(lcKey = key.toLowerCase(Locale.US))) {
                        if (val.toLowerCase(Locale.US).contains("upgrade")) {
                            this.out.write(DataHelper.getASCII("Connection: " + val + "\r\n"));
                        } else {
                            this.out.write(CONNECTION_CLOSE);
                        }
                        connectionSent = true;
                        break;
                    }
                    if ("proxy-connection".equals(lcKey)) break;
                    if ("content-encoding".equals(lcKey) && "x-i2p-gzip".equals(val.toLowerCase(Locale.US))) {
                        this._gzip = true;
                        break;
                    }
                    if ("proxy-authenticate".equals(lcKey)) break;
                    if ("content-length".equals(lcKey)) {
                        try {
                            this._dataExpected = Long.parseLong(val);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if ("content-type".equals(lcKey)) {
                        this._contentType = val.toLowerCase(Locale.US);
                    } else if ("content-encoding".equals(lcKey)) {
                        this._contentEncoding = val.toLowerCase(Locale.US);
                    } else if ("set-cookie".equals(lcKey) && ((lcVal = val.toLowerCase(Locale.US)).contains("domain=b32.i2p") || lcVal.contains("domain=.b32.i2p") || lcVal.contains("domain=i2p") || lcVal.contains("domain=.i2p"))) {
                        if (!this._log.shouldInfo()) break;
                        this._log.info("Stripping \"" + key + ": " + val + "\" from response ");
                        break;
                    }
                    this.out.write(DataHelper.getUTF8(key.trim() + ": " + val + "\r\n"));
                    break;
                }
            }
            lastEnd = i;
        }
        if (!connectionSent) {
            this.out.write(CONNECTION_CLOSE);
        }
        this.finishHeaders();
        boolean shouldCompress = this.shouldCompress();
        if (this._log.shouldInfo()) {
            this._log.info("After headers: gzip? " + this._gzip + " compress? " + shouldCompress);
        }
        if (data.length == 4096) {
            _cache.release(this._headerBuffer);
        }
        this._headerBuffer = null;
        if (shouldCompress) {
            this.beginProcessing();
        }
    }

    protected boolean shouldCompress() {
        return this._gzip;
    }

    protected void finishHeaders() throws IOException {
        this.out.write(CRLF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this._log.shouldInfo()) {
            this._log.info("Closing " + this.out + " compressed? " + this.shouldCompress(), new Exception("I did it"));
        }
        HTTPResponseOutputStream hTTPResponseOutputStream = this;
        synchronized (hTTPResponseOutputStream) {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginProcessing() throws IOException {
        GunzipOutputStream po = new GunzipOutputStream(this.out);
        HTTPResponseOutputStream hTTPResponseOutputStream = this;
        synchronized (hTTPResponseOutputStream) {
            this.out = po;
        }
    }
}

