/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.util.Util;

public class SecretWithEncapsulationImpl
implements SecretWithEncapsulation {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] sessionKey;
    private final byte[] cipher_text;

    public SecretWithEncapsulationImpl(byte[] sessionKey, byte[] cipher_text) {
        this.sessionKey = sessionKey;
        this.cipher_text = cipher_text;
    }

    @Override
    public byte[] getSecret() {
        byte[] clone = Util.clone(this.sessionKey);
        this.checkDestroyed();
        return clone;
    }

    @Override
    public byte[] getEncapsulation() {
        byte[] clone = Util.clone(this.cipher_text);
        this.checkDestroyed();
        return clone;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.fill(this.sessionKey, (byte)0);
            Arrays.fill(this.cipher_text, (byte)0);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("data has been destroyed");
        }
    }
}

