/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.parameters.AbstractParameter;

public class CollectionComponentParameter
extends AbstractParameter
implements Parameter,
Serializable {
    public static final CollectionComponentParameter ARRAY = new CollectionComponentParameter();
    public static final CollectionComponentParameter ARRAY_ALLOW_EMPTY = new CollectionComponentParameter(true);
    private final boolean emptyCollection;
    private final Class componentKeyType;
    private final Class componentValueType;

    public CollectionComponentParameter() {
        this(false);
    }

    public CollectionComponentParameter(boolean emptyCollection) {
        this(Void.TYPE, emptyCollection);
    }

    public CollectionComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(Object.class, componentValueType, emptyCollection);
    }

    public CollectionComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this.emptyCollection = emptyCollection;
        this.componentKeyType = componentKeyType;
        this.componentValueType = componentValueType;
    }

    @Override
    public Parameter.Resolver resolve(final PicoContainer container, ComponentAdapter<?> forAdapter, ComponentAdapter<?> injecteeAdapter, final Type expectedType, final NameBinding expectedNameBinding, final boolean useNames, Annotation binding) {
        final Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            final Map<Object, ComponentAdapter<?>> componentAdapters = this.getMatchingComponentAdapters(container, forAdapter, this.componentKeyType, this.getValueType(expectedType));
            return new Parameter.Resolver(){

                @Override
                public boolean isResolved() {
                    return CollectionComponentParameter.this.emptyCollection || componentAdapters.size() > 0;
                }

                @Override
                public Object resolveInstance() {
                    Object result = null;
                    if (collectionType.isArray()) {
                        result = CollectionComponentParameter.this.getArrayInstance(container, collectionType, componentAdapters);
                    } else if (Map.class.isAssignableFrom(collectionType)) {
                        result = CollectionComponentParameter.this.getMapInstance(container, collectionType, componentAdapters);
                    } else if (Collection.class.isAssignableFrom(collectionType)) {
                        result = CollectionComponentParameter.this.getCollectionInstance(container, collectionType, componentAdapters, expectedNameBinding, useNames);
                    } else {
                        throw new PicoCompositionException(expectedType + " is not a collective type");
                    }
                    return result;
                }

                @Override
                public ComponentAdapter<?> getComponentAdapter() {
                    return null;
                }
            };
        }
        return new Parameter.NotResolved();
    }

    private Class getCollectionType(Type expectedType) {
        if (expectedType instanceof Class) {
            return this.getCollectionType((Class)expectedType);
        }
        if (expectedType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)expectedType;
            return this.getCollectionType(type.getRawType());
        }
        if (expectedType instanceof GenericArrayType) {
            GenericArrayType type = (GenericArrayType)expectedType;
            Class baseType = this.getGenericArrayBaseType(type.getGenericComponentType());
            return Array.newInstance(baseType, 0).getClass();
        }
        throw new IllegalArgumentException("Unable to get collection type from " + expectedType);
    }

    private Class getGenericArrayBaseType(Type expectedType) {
        if (expectedType instanceof Class) {
            Class type = (Class)expectedType;
            return type;
        }
        if (expectedType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)expectedType;
            return this.getGenericArrayBaseType(type.getRawType());
        }
        throw new IllegalArgumentException("Unable to get collection type from " + expectedType);
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Class valueType = this.getValueType(expectedType);
            Collection<ComponentAdapter<?>> componentAdapters = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).values();
            if (componentAdapters.isEmpty()) {
                if (!this.emptyCollection) {
                    throw new PicoCompositionException(expectedType + " not resolvable, no components of type " + valueType.getName() + " available");
                }
            } else {
                Iterator<ComponentAdapter<?>> iterator = componentAdapters.iterator();
                while (iterator.hasNext()) {
                    ComponentAdapter<?> componentAdapter1;
                    ComponentAdapter<?> componentAdapter = componentAdapter1 = iterator.next();
                    componentAdapter.verify(container);
                }
            }
        } else {
            throw new PicoCompositionException(expectedType + " is not a collective type");
        }
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    protected boolean evaluate(ComponentAdapter adapter) {
        return adapter != null;
    }

    protected Map<Object, ComponentAdapter<?>> getMatchingComponentAdapters(PicoContainer container, ComponentAdapter adapter, Class keyType, Class valueType) {
        LinkedHashMap adapterMap = new LinkedHashMap();
        PicoContainer parent = container.getParent();
        if (parent != null) {
            adapterMap.putAll(this.getMatchingComponentAdapters(parent, adapter, keyType, valueType));
        }
        Collection<ComponentAdapter<?>> allAdapters = container.getComponentAdapters();
        for (ComponentAdapter<?> componentAdapter : allAdapters) {
            adapterMap.remove(componentAdapter.getComponentKey());
        }
        List adapterList = (List)List.class.cast(container.getComponentAdapters(valueType));
        for (ComponentAdapter componentAdapter : adapterList) {
            Object key = componentAdapter.getComponentKey();
            if (adapter != null && key.equals(adapter.getComponentKey()) || !keyType.isAssignableFrom(key.getClass()) || !this.evaluate(componentAdapter)) continue;
            adapterMap.put(key, componentAdapter);
        }
        return adapterMap;
    }

    private Class getCollectionType(Class collectionType) {
        if (collectionType.isArray() || Map.class.isAssignableFrom(collectionType) || Collection.class.isAssignableFrom(collectionType)) {
            return collectionType;
        }
        return null;
    }

    private Class getValueType(Type collectionType) {
        if (collectionType instanceof Class) {
            return this.getValueType((Class)collectionType);
        }
        if (collectionType instanceof ParameterizedType) {
            return this.getValueType((ParameterizedType)collectionType);
        }
        if (collectionType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)collectionType;
            return this.getGenericArrayBaseType(genericArrayType.getGenericComponentType());
        }
        throw new IllegalArgumentException("Unable to determine collection type from " + collectionType);
    }

    private Class getValueType(Class collectionType) {
        Class<?> valueType = this.componentValueType;
        if (collectionType.isArray()) {
            valueType = collectionType.getComponentType();
        }
        return valueType;
    }

    private Class getValueType(ParameterizedType collectionType) {
        Type type;
        Class valueType = this.componentValueType;
        if (Collection.class.isAssignableFrom((Class)collectionType.getRawType()) && (type = collectionType.getActualTypeArguments()[0]) instanceof Class) {
            if (((Class)type).isAssignableFrom(valueType)) {
                return valueType;
            }
            valueType = (Class)type;
        }
        return valueType;
    }

    private Object[] getArrayInstance(PicoContainer container, Class expectedType, Map<Object, ComponentAdapter<?>> adapterList) {
        Object[] result = (Object[])Array.newInstance(expectedType.getComponentType(), adapterList.size());
        int i = 0;
        for (ComponentAdapter<?> componentAdapter : adapterList.values()) {
            result[i] = container.getComponent(componentAdapter.getComponentKey());
            ++i;
        }
        return result;
    }

    private Collection getCollectionInstance(PicoContainer container, Class<? extends Collection> expectedType, Map<Object, ComponentAdapter<?>> adapterList, NameBinding expectedNameBinding, boolean useNames) {
        Class<? extends Collection> collectionType = expectedType;
        if (collectionType.isInterface()) {
            if (List.class.isAssignableFrom(collectionType)) {
                collectionType = ArrayList.class;
            } else if (SortedSet.class.isAssignableFrom(collectionType)) {
                collectionType = TreeSet.class;
            } else if (Set.class.isAssignableFrom(collectionType)) {
                collectionType = HashSet.class;
            } else if (Collection.class.isAssignableFrom(collectionType)) {
                collectionType = ArrayList.class;
            }
        }
        try {
            Collection result = collectionType.newInstance();
            for (ComponentAdapter<?> componentAdapter : adapterList.values()) {
                if (useNames && componentAdapter.getComponentKey() != expectedNameBinding) continue;
                result.add(container.getComponent(componentAdapter.getComponentKey()));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoCompositionException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoCompositionException(e);
        }
    }

    private Map getMapInstance(PicoContainer container, Class<? extends Map> expectedType, Map<Object, ComponentAdapter<?>> adapterList) {
        Class<? extends Map> collectionType = expectedType;
        if (collectionType.isInterface()) {
            if (SortedMap.class.isAssignableFrom(collectionType)) {
                collectionType = TreeMap.class;
            } else if (Map.class.isAssignableFrom(collectionType)) {
                collectionType = HashMap.class;
            }
        }
        try {
            Map result = collectionType.newInstance();
            for (Map.Entry<Object, ComponentAdapter<?>> entry : adapterList.entrySet()) {
                Object key = entry.getKey();
                result.put(key, container.getComponent(key));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoCompositionException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoCompositionException(e);
        }
    }
}

