/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.data.router.RouterInfo;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.TunnelHistory;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;

class CapacityCalculator {
    public static final String PROP_COUNTRY_BONUS = "profileOrganizer.sameCountryBonus";
    static final long GROWTH_FACTOR = 5L;
    private static long ESTIMATE_PERIOD = 3600000L;
    private static final double BONUS_NEW = 0.85;
    private static final double BONUS_ESTABLISHED = 0.65;
    private static final double BONUS_SAME_COUNTRY = 0.0;
    private static final double BONUS_XOR = 0.25;
    private static final double PENALTY_UNREACHABLE = 2.0;
    private static final double BONUS_NON_FLOODFILL = 1.0;

    CapacityCalculator() {
    }

    public static double calc(PeerProfile profile) {
        RouterInfo ri;
        NetworkDatabaseFacade ndb;
        double capacity;
        TunnelHistory history = profile.getTunnelHistory();
        if (CapacityCalculator.tooOld(profile)) {
            capacity = 1.0;
        } else {
            RateStat failedStat;
            RateStat rejectStat;
            RateStat acceptStat = profile.getTunnelCreateResponseTime();
            double capacity10m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat = history.getRejectionRate(), failedStat = history.getFailedRate(), 600000);
            if (capacity10m <= 0.0) {
                capacity = 0.0;
            } else {
                double capacity30m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 1800000);
                double capacity60m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 3600000);
                double capacity1d = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 86400000);
                capacity = capacity10m * CapacityCalculator.periodWeight(600000) + capacity30m * CapacityCalculator.periodWeight(1800000) + capacity60m * CapacityCalculator.periodWeight(3600000) + capacity1d * CapacityCalculator.periodWeight(86400000);
            }
        }
        RouterContext context = profile.getContext();
        long now = context.clock().now();
        if (history.getLastRejectedTransient() > now - 300000L) {
            capacity = 1.0;
        } else if (history.getLastRejectedProbabalistic() > now - 300000L) {
            capacity -= (double)context.random().nextInt(5);
        }
        if (now - profile.getFirstHeardAbout() < 2700000L) {
            capacity += 0.85;
        }
        if (profile.isEstablished()) {
            capacity += 0.65;
        }
        if (profile.isSameCountry()) {
            double bonus = 0.0;
            String b = context.getProperty(PROP_COUNTRY_BONUS);
            if (b != null) {
                try {
                    bonus = Double.parseDouble(b);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            capacity += bonus;
        }
        if (profile.wasUnreachable()) {
            capacity -= 2.0;
        }
        if ((ndb = context.netDb()) != null && !FloodfillNetworkDatabaseFacade.isFloodfill(ri = ndb.lookupRouterInfoLocally(profile.getPeer()))) {
            capacity += 1.0;
        }
        capacity -= (double)profile.getXORDistance() * 0.001953125;
        if ((capacity += (double)profile.getCapacityBonus()) < 0.0) {
            capacity = 0.0;
        }
        return capacity;
    }

    private static boolean tooOld(PeerProfile profile) {
        return !profile.getIsActive(3600000L);
    }

    private static double estimateCapacity(RateStat acceptStat, RateStat rejectStat, RateStat failedStat, int period) {
        double failed;
        long rejected;
        Rate curAccepted = acceptStat.getRate(period);
        Rate curRejected = rejectStat.getRate(period);
        Rate curFailed = failedStat.getRate(period);
        RateAverages ra = RateAverages.getTemp();
        double eventCount = 0.0;
        if (curAccepted != null && (eventCount = (double)curAccepted.computeAverages(ra, false).getTotalEventCount()) > 0.0 && curRejected != null && (rejected = curRejected.computeAverages(ra, false).getTotalEventCount()) > 0L) {
            eventCount *= eventCount / (eventCount + (double)(2L * rejected));
        }
        double stretch = (double)ESTIMATE_PERIOD / (double)period;
        double val = eventCount * stretch;
        if (curFailed != null && (failed = curFailed.computeAverages(ra, false).getTotalValues()) > 0.0) {
            val -= 0.04 * failed * stretch;
        }
        if ((val += 5.0) >= 0.0) {
            return val;
        }
        return 0.0;
    }

    private static double periodWeight(int period) {
        switch (period) {
            case 600000: {
                return 0.4;
            }
            case 1800000: {
                return 0.3;
            }
            case 3600000: {
                return 0.2;
            }
            case 86400000: {
                return 0.1;
            }
        }
        throw new IllegalArgumentException("undefined period passed, period [" + period + "]???");
    }
}

