/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.client.streaming.impl.ConnectionDataReceiver;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.ConnectionPacketHandler;
import net.i2p.client.streaming.impl.I2PSocketFull;
import net.i2p.client.streaming.impl.MessageInputStream;
import net.i2p.client.streaming.impl.MessageOutputStream;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.client.streaming.impl.PacketQueue;
import net.i2p.client.streaming.impl.SchedulerChooser;
import net.i2p.client.streaming.impl.SimpleBandwidthEstimator;
import net.i2p.client.streaming.impl.TaskScheduler;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.BandwidthEstimator;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class Connection {
    private final I2PAppContext _context;
    private final Log _log;
    private final ConnectionManager _connectionManager;
    private final I2PSession _session;
    private Destination _remotePeer;
    private SigningPublicKey _transientSPK;
    private final AtomicLong _sendStreamId = new AtomicLong();
    private final AtomicLong _receiveStreamId = new AtomicLong();
    private volatile long _lastSendTime;
    private final AtomicLong _lastSendId;
    private final AtomicBoolean _resetReceived = new AtomicBoolean();
    private final AtomicLong _resetSentOn = new AtomicLong();
    private final AtomicBoolean _connected = new AtomicBoolean(true);
    private final AtomicBoolean _finalDisconnect = new AtomicBoolean();
    private boolean _hardDisconnected;
    private final MessageInputStream _inputStream;
    private final MessageOutputStream _outputStream;
    private final SchedulerChooser _chooser;
    private long _nextSendTime;
    private final AtomicLong _ackedPackets = new AtomicLong();
    private final long _createdOn;
    private final AtomicLong _closeSentOn = new AtomicLong();
    private final AtomicLong _closeReceivedOn = new AtomicLong();
    private final AtomicInteger _unackedPacketsReceived = new AtomicInteger();
    private long _congestionWindowEnd;
    private volatile long _highestAckedThrough;
    private volatile int _ssthresh;
    private final boolean _isInbound;
    private boolean _updatedShareOpts;
    private final TreeMap<Long, PacketLocal> _outboundPackets;
    private final PacketQueue _outboundQueue;
    private final ConnectionPacketHandler _handler;
    private ConnectionOptions _options;
    private final ConnectionDataReceiver _receiver;
    private I2PSocketFull _socket;
    private String _connectionError;
    private final AtomicLong _disconnectScheduledOn = new AtomicLong();
    private long _lastReceivedOn;
    private final ActivityTimer _activityTimer;
    private long _lastCongestionTime;
    private volatile long _lastCongestionHighestUnacked;
    private volatile boolean _isChoked;
    private volatile boolean _isChoking;
    private final AtomicInteger _unchokesToSend = new AtomicInteger();
    private final AtomicBoolean _ackSinceCongestion;
    private final Object _connectLock;
    private final Object _nextSendLock;
    private final AtomicInteger _activeResends = new AtomicInteger();
    private final ConEvent _connectionEvent;
    private final RetransmitEvent _retransmitEvent;
    private final int _randomWait;
    private final int _localPort;
    private final int _remotePort;
    private final SimpleTimer2 _timer;
    private final BandwidthEstimator _bwEstimator;
    private final AtomicLong _lifetimeBytesSent = new AtomicLong();
    private long _lowestBytesAckedThrough;
    private final AtomicLong _lifetimeBytesReceived = new AtomicLong();
    private final AtomicLong _lifetimeDupMessageSent = new AtomicLong();
    private final AtomicLong _lifetimeDupMessageReceived = new AtomicLong();
    public static final int MAX_RESEND_DELAY = 45000;
    public static final int MIN_RESEND_DELAY = 100;
    public static final int DISCONNECT_TIMEOUT = 300000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private static final long MAX_CONNECT_TIMEOUT = 120000L;
    public static final int MAX_WINDOW_SIZE = 128;
    private static final int UNCHOKES_TO_SEND = 8;
    private static final int MAX_RTX = 16;
    static final int FAST_RETRANSMIT_THRESHOLD = 3;

    public Connection(I2PAppContext ctx, ConnectionManager manager, I2PSession session, SchedulerChooser chooser, SimpleTimer2 timer, PacketQueue queue, ConnectionPacketHandler handler, ConnectionOptions opts, boolean isInbound) {
        this._context = ctx;
        this._connectionManager = manager;
        this._session = session;
        this._chooser = chooser;
        this._outboundQueue = queue;
        this._handler = handler;
        this._isInbound = isInbound;
        this._log = this._context.logManager().getLog(Connection.class);
        this._receiver = new ConnectionDataReceiver(this._context, this);
        this._options = opts != null ? opts : new ConnectionOptions();
        this._inputStream = new MessageInputStream(this._context, this._options.getMaxMessageSize(), this._options.getMaxWindowSize(), this._options.getInboundBufferSize());
        this._outputStream = new MessageOutputStream(this._context, timer, this._receiver, this._options.getMaxMessageSize(), this._options.getMaxInitialMessageSize());
        this._timer = timer;
        this._outboundPackets = new TreeMap();
        if (opts != null) {
            this._localPort = opts.getLocalPort();
            this._remotePort = opts.getPort();
        } else {
            this._localPort = 0;
            this._remotePort = 0;
        }
        this._outputStream.setWriteTimeout((int)this._options.getWriteTimeout());
        this._inputStream.setReadTimeout((int)this._options.getReadTimeout());
        this._lastSendId = new AtomicLong(-1L);
        this._nextSendTime = -1L;
        this._createdOn = this._context.clock().now();
        this._congestionWindowEnd = this._options.getWindowSize() - 1;
        this._highestAckedThrough = -1L;
        this._ssthresh = 64;
        this._lastCongestionTime = -1L;
        this._lastCongestionHighestUnacked = -1L;
        this._lastReceivedOn = -1L;
        this._activityTimer = new ActivityTimer();
        this._ackSinceCongestion = new AtomicBoolean(true);
        this._connectLock = new Object();
        this._nextSendLock = new Object();
        this._connectionEvent = new ConEvent();
        this._retransmitEvent = new RetransmitEvent();
        this._bwEstimator = new SimpleBandwidthEstimator(ctx, this._options);
        this._randomWait = this._context.random().nextInt(10000);
        if (this._log.shouldLog(20)) {
            this._log.info("New connection created with options: " + this._options);
        }
    }

    int getSSThresh() {
        return this._ssthresh;
    }

    public long getNextOutboundPacketNum() {
        return this._lastSendId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packetSendChoke(long timeoutMs) throws IOException, InterruptedException {
        long start = this._context.clock().now();
        long writeExpire = start + timeoutMs;
        boolean started = false;
        while (true) {
            long timeLeft = writeExpire - this._context.clock().now();
            TreeMap<Long, PacketLocal> treeMap = this._outboundPackets;
            synchronized (treeMap) {
                if (!started) {
                    this._context.statManager().addRateData("stream.chokeSizeBegin", (long)this._outboundPackets.size());
                }
                if (start + 300000L < this._context.clock().now()) {
                    return false;
                }
                if (!this._connected.get()) {
                    if (this.getResetReceived()) {
                        throw new I2PSocketException(512);
                    }
                    throw new IOException("Socket closed");
                }
                if (this._outputStream.getClosed()) {
                    throw new IOException("Output stream closed");
                }
                started = true;
                int unacked = this._outboundPackets.size();
                int wsz = this._options.getWindowSize();
                if (this._isChoked || unacked >= wsz || this._activeResends.get() >= (wsz + 1) / 2 || this._lastSendId.get() - this._highestAckedThrough >= (long)Math.min(128, 2 * wsz)) {
                    if (timeoutMs > 0L) {
                        if (timeLeft <= 0L) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("Outbound window is full (choked? " + this._isChoked + ' ' + unacked + " unacked with " + this._activeResends + " active resends and we've waited too long (" + (0L - (timeLeft - timeoutMs)) + "ms): " + this.toString());
                            }
                            return false;
                        }
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Outbound window is full (choked? " + this._isChoked + ' ' + unacked + '/' + wsz + '/' + this._activeResends + "), waiting " + timeLeft);
                        }
                        try {
                            this._outboundPackets.wait(Math.min(timeLeft, 250L));
                        }
                        catch (InterruptedException ie) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("InterruptedException while Outbound window is full (" + this._outboundPackets.size() + "/" + this._activeResends + ")");
                            }
                            throw ie;
                        }
                    } else {
                        try {
                            this._outboundPackets.wait(250L);
                        }
                        catch (InterruptedException ie) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("InterruptedException while Outbound window is full (" + this._outboundPackets.size() + "/" + this._activeResends + ")");
                            }
                            throw ie;
                        }
                    }
                } else {
                    this._context.statManager().addRateData("stream.chokeSizeEnd", (long)this._outboundPackets.size());
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void windowAdjusted() {
        TreeMap<Long, PacketLocal> treeMap = this._outboundPackets;
        synchronized (treeMap) {
            this._outboundPackets.notifyAll();
        }
    }

    void ackImmediately() {
        PacketLocal packet = this._receiver.send(null, 0, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending new ack: " + packet);
        }
    }

    private void sendReset() {
        long now = this._context.clock().now();
        if (this._resetSentOn.get() + 10000L > now) {
            return;
        }
        if (this._resetReceived.get()) {
            return;
        }
        this._resetSentOn.set(now);
        if (this._remotePeer == null || this._sendStreamId.get() <= 0L) {
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, this._remotePeer, this);
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setSendStreamId(this._sendStreamId.get());
        reply.setReceiveStreamId(this._receiveStreamId.get());
        reply.setLocalPort(this._localPort);
        reply.setRemotePort(this._remotePort);
        if (this._outboundQueue.enqueue(reply)) {
            this._unackedPacketsReceived.set(0);
            this._lastSendTime = this._context.clock().now();
            this.resetActivityTimer();
        }
    }

    void sendAvailable() {
        block2: {
            try {
                this._outputStream.flushAvailable(this._receiver, false);
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(40)) break block2;
                this._log.error("Error flushing available", (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(PacketLocal packet) {
        if (packet == null) {
            return;
        }
        this.setNextSendTime(-1L);
        if (this._options.getRequireFullySigned()) {
            packet.setFlag(8);
            packet.setFlag(16);
        }
        if (packet.getSequenceNum() == 0L && !packet.isFlagSet(1)) {
            if (this._isChoking) {
                packet.setOptionalDelay(61000);
                packet.setFlag(64);
            } else if (this._unchokesToSend.decrementAndGet() > 0) {
                packet.setOptionalDelay(0);
                packet.setFlag(64);
            }
        } else {
            TreeMap<Long, PacketLocal> treeMap = this._outboundPackets;
            synchronized (treeMap) {
                this._outboundPackets.put(packet.getSequenceNum(), packet);
                int windowSize = this._options.getWindowSize();
                int remaining = windowSize - this._outboundPackets.size();
                this._outboundPackets.notifyAll();
                if (this._isChoking) {
                    packet.setOptionalDelay(61000);
                    packet.setFlag(64);
                } else if (packet.isFlagSet(2) || this._unchokesToSend.decrementAndGet() > 0 || remaining < 3 || remaining < (windowSize + 2) / 3) {
                    packet.setOptionalDelay(0);
                    packet.setFlag(64);
                }
                int timeout = this._options.getRTO();
                if (this._retransmitEvent.scheduleIfNotRunning(timeout)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this + " Resend in " + timeout + " for " + packet);
                    }
                } else if (this._log.shouldLog(10)) {
                    this._log.debug(this + " timer was already running");
                }
                packet.setTimeout(timeout);
            }
        }
        if (this._outboundQueue.enqueue(packet)) {
            this._unackedPacketsReceived.set(0);
            this._lastSendTime = this._context.clock().now();
            this.resetActivityTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PacketLocal> ackPackets(long ackThrough, long[] nacks) {
        if (ackThrough >= this._highestAckedThrough) {
            if (nacks == null) {
                this._highestAckedThrough = ackThrough;
            } else {
                long lowest = -1L;
                for (int i = 0; i < nacks.length; ++i) {
                    if (lowest >= 0L && nacks[i] >= lowest) continue;
                    lowest = nacks[i];
                }
                if (lowest - 1L > this._highestAckedThrough) {
                    this._highestAckedThrough = lowest - 1L;
                }
            }
        }
        ArrayList<PacketLocal> acked = null;
        boolean anyLeft = false;
        TreeMap<Long, PacketLocal> treeMap = this._outboundPackets;
        synchronized (treeMap) {
            if (!this._outboundPackets.isEmpty()) {
                Map.Entry<Long, PacketLocal> e;
                long id;
                Iterator<Map.Entry<Long, PacketLocal>> iter = this._outboundPackets.entrySet().iterator();
                while (iter.hasNext() && (id = (e = iter.next()).getKey().longValue()) <= ackThrough) {
                    boolean nacked = false;
                    if (nacks != null) {
                        for (int i = 0; i < nacks.length; ++i) {
                            if (nacks[i] != id) continue;
                            nacked = true;
                            PacketLocal nackedPacket = e.getValue();
                            nackedPacket.incrementNACKs();
                            break;
                        }
                    }
                    if (nacked) continue;
                    if (acked == null) {
                        acked = new ArrayList<PacketLocal>(8);
                    }
                    PacketLocal ackedPacket = e.getValue();
                    ackedPacket.ackReceived();
                    acked.add(ackedPacket);
                    iter.remove();
                }
            }
            if (acked != null) {
                this._ackedPackets.addAndGet(acked.size());
                for (int i = 0; i < acked.size(); ++i) {
                    PacketLocal p = (PacketLocal)acked.get(i);
                    if (p.getNumSends() <= 1) continue;
                    this._activeResends.decrementAndGet();
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Active resend of " + p + " successful, # active left: " + this._activeResends);
                }
            }
            if (this._outboundPackets.isEmpty() && this._activeResends.get() != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("All outbound packets acked, clearing " + this._activeResends);
                }
                this._activeResends.set(0);
            }
            anyLeft = !this._outboundPackets.isEmpty();
            this._outboundPackets.notifyAll();
            if (acked != null && !acked.isEmpty()) {
                this._ackSinceCongestion.set(true);
                this._bwEstimator.addSample(acked.size());
                if (anyLeft) {
                    int rto = this._options.getRTO();
                    this._retransmitEvent.pushBackRTO(rto);
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this + " not all packets acked, pushing timer out " + rto);
                    }
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this + " all outstanding packets acked, cancelling timer");
                    }
                    this._retransmitEvent.cancel();
                }
            }
        }
        return acked;
    }

    void eventOccurred() {
        TaskScheduler sched = this._chooser.getScheduler(this);
        long before = System.currentTimeMillis();
        sched.eventOccurred(this);
        long elapsed = System.currentTimeMillis() - before;
        if (elapsed > 250L && this._log.shouldLog(30)) {
            this._log.warn("Took " + elapsed + "ms to pump through " + sched + " on " + this.toString());
        }
    }

    public void notifyCloseSent() {
        if (!this._closeSentOn.compareAndSet(0L, this._context.clock().now()) && this._log.shouldLog(10)) {
            this._log.debug("Sent more than one CLOSE: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReceived() {
        if (this._closeReceivedOn.compareAndSet(0L, this._context.clock().now())) {
            this._inputStream.closeReceived();
            if (this._closeSentOn.get() > 0L) {
                this.disconnect(true);
            } else {
                Object object = this._connectLock;
                synchronized (object) {
                    this._connectLock.notifyAll();
                }
            }
        }
    }

    public void notifyLastPacketAcked() {
        long cso = this._closeSentOn.get();
        if (cso <= 0L) {
            throw new IllegalStateException();
        }
        long cro = this._closeReceivedOn.get();
        if (cro > 0L && cro < cso) {
            this.disconnect(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetReceived() {
        if (!this._resetReceived.compareAndSet(false, true)) {
            return;
        }
        I2PSocketException ioe = new I2PSocketException(512);
        this._outputStream.streamErrorOccurred((IOException)ioe);
        this._inputStream.streamErrorOccurred((IOException)ioe);
        this._connectionError = "Connection reset";
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
        this.disconnectComplete();
    }

    public boolean getResetReceived() {
        return this._resetReceived.get();
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean getIsConnected() {
        return this._connected.get();
    }

    public boolean getHardDisconnected() {
        return this._hardDisconnected;
    }

    public boolean getResetSent() {
        return this._resetSentOn.get() > 0L;
    }

    public long getResetSentOn() {
        return this._resetSentOn.get();
    }

    public long getDisconnectScheduledOn() {
        return this._disconnectScheduledOn.get();
    }

    public void disconnect(boolean cleanDisconnect) {
        this.disconnect(cleanDisconnect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean cleanDisconnect, boolean removeFromConMgr) {
        if (!this._connected.compareAndSet(true, false)) {
            return;
        }
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
        if (this._closeReceivedOn.get() <= 0L) {
            this._inputStream.closeReceived();
        }
        if (cleanDisconnect) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Clean disconnecting, remove? " + removeFromConMgr + ": " + this.toString(), (Throwable)new Exception("discon"));
            }
            this._outputStream.closeInternal();
        } else {
            this._hardDisconnected = true;
            if (this._inputStream.getHighestBlockId() >= 0L && !this.getResetReceived()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Hard disconnecting and sending reset, remove? " + removeFromConMgr + " on " + this.toString(), (Throwable)new Exception("cause"));
                }
                this.sendReset();
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Hard disconnecting, remove? " + removeFromConMgr + " on " + this.toString(), (Throwable)new Exception("cause"));
            }
            this._outputStream.streamErrorOccurred(new IOException("Hard disconnect"));
        }
        if (removeFromConMgr) {
            if (!cleanDisconnect) {
                this.disconnectComplete();
            } else {
                long cro = this._closeReceivedOn.get();
                long cso = this._closeSentOn.get();
                if (cro > 0L && cro < cso && this.getUnackedPacketsSent() <= 0) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Rcv close -> send close -> last acked, skip TIME-WAIT for " + this.toString());
                    }
                    this.disconnectComplete();
                } else {
                    this.scheduleDisconnectEvent();
                }
            }
        }
    }

    public void disconnectComplete() {
        if (!this._finalDisconnect.compareAndSet(false, true)) {
            return;
        }
        this._connected.set(false);
        I2PSocketFull s = this._socket;
        if (s != null) {
            s.destroy2();
            this._socket = null;
        }
        this._outputStream.destroy();
        this._receiver.destroy();
        this._activityTimer.cancel();
        this._retransmitEvent.cancel();
        this._inputStream.streamErrorOccurred(new IOException("Socket closed"));
        if (this._log.shouldLog(20)) {
            this._log.info("Connection disconnect complete: " + this.toString());
        }
        this._connectionManager.removeConnection(this);
        this.killOutstandingPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOutstandingPackets() {
        TreeMap<Long, PacketLocal> treeMap = this._outboundPackets;
        synchronized (treeMap) {
            if (this._outboundPackets.isEmpty()) {
                return;
            }
            for (PacketLocal pl : this._outboundPackets.values()) {
                pl.cancelled();
            }
            this._outboundPackets.clear();
            this._outboundPackets.notifyAll();
        }
    }

    private boolean scheduleDisconnectEvent() {
        if (!this._disconnectScheduledOn.compareAndSet(0L, this._context.clock().now())) {
            return false;
        }
        this.schedule(new DisconnectEvent(), 300000L);
        return true;
    }

    public void scheduleConnectionEvent(long msToWait) {
        this.schedule(this._connectionEvent, msToWait);
    }

    public void schedule(SimpleTimer.TimedEvent event, long msToWait) {
        this._timer.addEvent(event, msToWait);
    }

    public synchronized Destination getRemotePeer() {
        return this._remotePeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemotePeer(Destination peer) {
        if (peer == null) {
            throw new NullPointerException();
        }
        Connection connection = this;
        synchronized (connection) {
            if (this._remotePeer != null) {
                throw new RuntimeException("Remote peer already set [" + this._remotePeer + ", " + peer + "]");
            }
            this._remotePeer = peer;
        }
        this._connectionManager.updateOptsFromShare(this);
    }

    public synchronized SigningPublicKey getRemoteSPK() {
        if (this._transientSPK != null) {
            return this._transientSPK;
        }
        if (this._remotePeer != null) {
            return this._remotePeer.getSigningPublicKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteTransientSPK(SigningPublicKey transientSPK) {
        Connection connection = this;
        synchronized (connection) {
            if (this._transientSPK != null) {
                throw new RuntimeException("Remote SPK already set");
            }
            this._transientSPK = transientSPK;
        }
    }

    public long getSendStreamId() {
        return this._sendStreamId.get();
    }

    public void setSendStreamId(long id) {
        if (!this._sendStreamId.compareAndSet(0L, id)) {
            throw new IllegalStateException("Send stream ID already set [" + this._sendStreamId + ", " + id + "]");
        }
    }

    public long getReceiveStreamId() {
        return this._receiveStreamId.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveStreamId(long id) {
        if (!this._receiveStreamId.compareAndSet(0L, id)) {
            throw new IllegalStateException("Receive stream ID already set [" + this._receiveStreamId + ", " + id + "]");
        }
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public long getLastSendId() {
        return this._lastSendId.get();
    }

    public void setLastSendId(long id) {
        this._lastSendId.set(id);
    }

    public ConnectionOptions getOptions() {
        return this._options;
    }

    public void setOptions(ConnectionOptions opts) {
        this._options = opts;
    }

    public ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public I2PSocketFull getSocket() {
        return this._socket;
    }

    public void setSocket(I2PSocketFull socket) {
        this._socket = socket;
    }

    public int getPort() {
        return this._remotePort;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public String getConnectionError() {
        return this._connectionError;
    }

    public void setConnectionError(String err) {
        this._connectionError = err;
    }

    public long getLifetime() {
        long cso = this._closeSentOn.get();
        if (cso <= 0L) {
            return this._context.clock().now() - this._createdOn;
        }
        return cso - this._createdOn;
    }

    public ConnectionPacketHandler getPacketHandler() {
        return this._handler;
    }

    public long getLifetimeBytesSent() {
        return this._lifetimeBytesSent.get();
    }

    public long getLifetimeBytesReceived() {
        return this._lifetimeBytesReceived.get();
    }

    public long getLifetimeDupMessagesSent() {
        return this._lifetimeDupMessageSent.get();
    }

    public long getLifetimeDupMessagesReceived() {
        return this._lifetimeDupMessageReceived.get();
    }

    public void incrementBytesSent(int bytes) {
        this._lifetimeBytesSent.addAndGet(bytes);
    }

    public void incrementDupMessagesSent(int msgs) {
        this._lifetimeDupMessageSent.addAndGet(msgs);
    }

    public void incrementBytesReceived(int bytes) {
        this._lifetimeBytesReceived.addAndGet(bytes);
    }

    public void incrementDupMessagesReceived(int msgs) {
        this._lifetimeDupMessageReceived.addAndGet(msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSendTime() {
        Object object = this._nextSendLock;
        synchronized (object) {
            return this._nextSendTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSendTime(long when) {
        Object object = this._nextSendLock;
        synchronized (object) {
            long max;
            if (this._nextSendTime >= 0L) {
                if (when < this._nextSendTime) {
                    this._nextSendTime = when;
                }
            } else {
                this._nextSendTime = when;
            }
            if (this._nextSendTime >= 0L && (max = this._context.clock().now() + (long)this._options.getSendAckDelay()) < this._nextSendTime) {
                this._nextSendTime = max;
            }
        }
    }

    public void setChoking(boolean on) {
        if (on != this._isChoking) {
            this._isChoking = on;
            if (this._log.shouldWarn()) {
                this._log.warn("Choking changed to " + on + " on " + this);
            }
            if (!on) {
                this._unchokesToSend.set(8);
            }
            this.ackImmediately();
        } else if (on) {
            this.ackImmediately();
        }
    }

    public void setChoked(boolean on) {
        if (on != this._isChoked) {
            this._isChoked = on;
            if (this._log.shouldWarn()) {
                this._log.warn("Choked changed to " + on + " on " + this);
            }
        }
        if (on) {
            this.congestionOccurred();
            this._options.setWindowSize(1);
        }
    }

    public boolean isChoked() {
        return this._isChoked;
    }

    public long getAckedPackets() {
        return this._ackedPackets.get();
    }

    public long getCreatedOn() {
        return this._createdOn;
    }

    public long getCloseSentOn() {
        return this._closeSentOn.get();
    }

    public long getCloseReceivedOn() {
        return this._closeReceivedOn.get();
    }

    public void updateShareOpts() {
        if (this._closeSentOn.get() > 0L && !this._updatedShareOpts) {
            this._connectionManager.updateShareOpts(this);
            this._updatedShareOpts = true;
        }
    }

    public void incrementUnackedPacketsReceived() {
        this._unackedPacketsReceived.incrementAndGet();
    }

    public int getUnackedPacketsReceived() {
        return this._unackedPacketsReceived.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnackedPacketsSent() {
        TreeMap<Long, PacketLocal> treeMap = this._outboundPackets;
        synchronized (treeMap) {
            return this._outboundPackets.size();
        }
    }

    public long getCongestionWindowEnd() {
        return this._congestionWindowEnd;
    }

    public void setCongestionWindowEnd(long endMsg) {
        this._congestionWindowEnd = endMsg;
    }

    public long getHighestAckedThrough() {
        return this._highestAckedThrough;
    }

    public long getLastActivityOn() {
        return this._lastSendTime > this._lastReceivedOn ? this._lastSendTime : this._lastReceivedOn;
    }

    private void congestionOccurred() {
        if (this._ackSinceCongestion.compareAndSet(true, false)) {
            this._lastCongestionTime = this._context.clock().now();
            this._lastCongestionHighestUnacked = this._lastSendId.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void packetReceived() {
        this._lastReceivedOn = this._context.clock().now();
        this.resetActivityTimer();
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForConnect() {
        long expiration = this._context.clock().now() + this._options.getConnectTimeout();
        while (true) {
            if (this._connected.get() && this._receiveStreamId.get() > 0L && this._sendStreamId.get() > 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): Connected and we have stream IDs");
                }
                return;
            }
            if (this._connectionError != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): connection error found: " + this._connectionError);
                }
                return;
            }
            if (!this._connected.get()) {
                this._connectionError = "Connection failed";
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): not connected");
                }
                return;
            }
            long timeLeft = expiration - this._context.clock().now();
            if (timeLeft <= 0L && this._options.getConnectTimeout() > 0L) {
                if (this._connectionError == null) {
                    this._connectionError = "Connection timed out";
                    this.disconnect(false);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): timed out: " + this._connectionError);
                }
                return;
            }
            if (timeLeft > 120000L) {
                timeLeft = 120000L;
            } else if (this._options.getConnectTimeout() <= 0L) {
                timeLeft = 60000L;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("waitForConnect(): wait " + timeLeft);
            }
            try {
                Object object = this._connectLock;
                synchronized (object) {
                    this._connectLock.wait(timeLeft);
                }
            }
            catch (InterruptedException ie) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): InterruptedException");
                }
                this._connectionError = "InterruptedException";
                return;
            }
        }
    }

    private void resetActivityTimer() {
        long howLong = this._options.getInactivityTimeout();
        if (howLong <= 0L) {
            return;
        }
        this._activityTimer.reschedule(howLong += (long)this._randomWait, false);
    }

    public MessageInputStream getInputStream() {
        return this._inputStream;
    }

    public MessageOutputStream getOutputStream() {
        return this._outputStream;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[Connection ");
        long id = this._receiveStreamId.get();
        if (id > 0L) {
            buf.append(Packet.toId(id));
        } else {
            buf.append("unknown");
        }
        buf.append('/');
        id = this._sendStreamId.get();
        if (id > 0L) {
            buf.append(Packet.toId(id));
        } else {
            buf.append("unknown");
        }
        if (this._isInbound) {
            buf.append(" from ");
        } else {
            buf.append(" to ");
        }
        if (this._remotePeer != null) {
            buf.append(this._remotePeer.toBase32());
        } else {
            buf.append("unknown");
        }
        buf.append(" up ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this._createdOn)));
        buf.append(" wsize: ").append(this._options.getWindowSize());
        buf.append(" cwin: ").append(this._congestionWindowEnd - this._highestAckedThrough);
        buf.append(" rtt: ").append(this._options.getRTT());
        buf.append(" rto: ").append(this._options.getRTO());
        buf.append(" unacked out: ").append(this._outboundPackets.size()).append(" ");
        buf.append("unacked in: ").append(this.getUnackedPacketsReceived());
        int missing = 0;
        long[] nacks = this._inputStream.getNacks();
        if (nacks != null) {
            missing = nacks.length;
            buf.append(" [").append(missing).append(" missing]");
        }
        if (this.getResetSent()) {
            buf.append(" reset sent ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getResetSentOn()))).append(" ago");
        }
        if (this.getResetReceived()) {
            buf.append(" reset rcvd ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getDisconnectScheduledOn()))).append(" ago");
        }
        if (this.getCloseSentOn() > 0L) {
            buf.append(" close sent ");
            long timeSinceClose = this._context.clock().now() - this.getCloseSentOn();
            buf.append(DataHelper.formatDuration((long)timeSinceClose));
            buf.append(" ago");
        }
        if (this.getCloseReceivedOn() > 0L) {
            buf.append(" close rcvd ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getCloseReceivedOn()))).append(" ago");
        }
        buf.append(" sent: ").append(1L + this._lastSendId.get());
        buf.append(" rcvd: ").append(1L + this._inputStream.getHighestBlockId() - (long)missing);
        buf.append(" ackThru ").append(this._highestAckedThrough);
        buf.append(" ssThresh ").append(this._ssthresh);
        buf.append(" minRTT ").append(this._options.getMinRTT());
        buf.append(" maxWin ").append(this._options.getMaxWindowSize());
        buf.append(" MTU ").append(this._options.getMaxMessageSize());
        buf.append("]");
        return buf.toString();
    }

    ResendPacketEvent newResendPacketEvent(PacketLocal packet) {
        return new ResendPacketEvent(packet);
    }

    private class ActivityTimer
    extends SimpleTimer2.TimedEvent {
        public ActivityTimer() {
            super(Connection.this._timer);
            this.setFuzz(5000);
        }

        public void timeReached() {
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug("Fire inactivity timer on " + Connection.this.toString());
            }
            if (!Connection.this._connected.get()) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but we are already closed");
                }
                return;
            }
            long left = this.getTimeLeft();
            if (left > 0L) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there is time left (" + left + ")");
                }
                this.schedule(left);
                return;
            }
            if (Connection.this.getUnackedPacketsSent() > 0) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there are unacked packets");
                }
                return;
            }
            if (Connection.this._options.getInactivityTimeout() <= 0) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there is no timer...");
                }
                return;
            }
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug("Inactivity timeout reached, with action=" + Connection.this._options.getInactivityAction());
            }
            switch (Connection.this._options.getInactivityAction()) {
                case 0: {
                    if (!Connection.this._log.shouldLog(30)) break;
                    Connection.this._log.warn("Inactivity timer expired, not doing anything");
                    break;
                }
                case 2: {
                    if (Connection.this._closeSentOn.get() <= 0L && Connection.this._closeReceivedOn.get() <= 0L) {
                        if (Connection.this._log.shouldLog(30)) {
                            Connection.this._log.warn("Sending some data due to inactivity");
                        }
                        Connection.this._receiver.send(null, 0, 0, true);
                        break;
                    }
                }
                default: {
                    if (Connection.this._log.shouldLog(30)) {
                        Connection.this._log.warn("Closing (inactivity) " + this.toString());
                    }
                    if (Connection.this._log.shouldLog(10)) {
                        StringBuilder buf = new StringBuilder(128);
                        buf.append("last sent was: ").append(Connection.this._context.clock().now() - Connection.this._lastSendTime);
                        buf.append("ms ago, last received was: ").append(Connection.this._context.clock().now() - Connection.this._lastReceivedOn);
                        buf.append("ms ago, inactivity timeout is: ").append(Connection.this._options.getInactivityTimeout());
                        Connection.this._log.debug(buf.toString());
                    }
                    IOException ioe = new IOException("Inactivity timeout");
                    Connection.this._inputStream.streamErrorOccurred(ioe);
                    Connection.this._outputStream.streamErrorOccurred(ioe);
                    Connection.this.disconnect(Connection.this._disconnectScheduledOn.get() > 0L);
                }
            }
        }

        public final long getTimeLeft() {
            if (Connection.this.getLastActivityOn() > 0L) {
                return Connection.this.getLastActivityOn() + (long)Connection.this._options.getInactivityTimeout() - Connection.this._context.clock().now();
            }
            return Connection.this._createdOn + (long)Connection.this._options.getInactivityTimeout() - Connection.this._context.clock().now();
        }
    }

    class ConEvent
    implements SimpleTimer.TimedEvent {
        public void timeReached() {
            Connection.this.eventOccurred();
        }

        public String toString() {
            return "event on " + Connection.this.toString();
        }
    }

    private class DisconnectEvent
    implements SimpleTimer.TimedEvent {
        public DisconnectEvent() {
            if (Connection.this._log.shouldLog(20)) {
                Connection.this._log.info("Connection disconnect timer initiated: 5 minutes to drop " + Connection.this.toString(), (Throwable)new Exception());
            }
        }

        public void timeReached() {
            Connection.this.disconnectComplete();
        }
    }

    class ResendPacketEvent
    extends SimpleTimer2.TimedEvent {
        private final PacketLocal _packet;

        public ResendPacketEvent(PacketLocal packet) {
            super(Connection.this._timer);
            this._packet = packet;
        }

        public void timeReached() {
            this.retransmit();
        }

        void fastRetransmit() {
            this.reschedule(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean retransmit() {
            if (this._packet.getAckTime() > 0) {
                return false;
            }
            if (Connection.this._resetSentOn.get() > 0L || Connection.this._resetReceived.get() || Connection.this._finalDisconnect.get()) {
                this._packet.cancelled();
                return false;
            }
            Connection.this._context.statManager().addRateData("stream.fastRetransmit", this._packet.getLifetime(), this._packet.getLifetime());
            if (Connection.this._isChoking) {
                this._packet.setOptionalDelay(61000);
                this._packet.setFlag(64);
            } else if (Connection.this._unchokesToSend.decrementAndGet() > 0) {
                this._packet.setOptionalDelay(0);
                this._packet.setFlag(64);
            } else {
                this._packet.setFlag(64, false);
            }
            this._packet.setResendDelay(Connection.this._options.getResendDelay() / 1000);
            if (this._packet.getReceiveStreamId() <= 0L) {
                this._packet.setReceiveStreamId(Connection.this._receiveStreamId.get());
            }
            if (this._packet.getSendStreamId() <= 0L) {
                this._packet.setSendStreamId(Connection.this._sendStreamId.get());
            }
            int newWindowSize = Connection.this._options.getWindowSize();
            if (Connection.this._isChoked) {
                Connection.this.congestionOccurred();
                Connection.this._options.setWindowSize(1);
            } else if (Connection.this._ackSinceCongestion.get() && this._packet.getSequenceNum() > Connection.this._lastCongestionHighestUnacked) {
                Connection.this.congestionOccurred();
                Connection.this._context.statManager().addRateData("stream.con.windowSizeAtCongestion", (long)newWindowSize, this._packet.getLifetime());
                Connection.this._options.doubleRTO();
                if (this._packet.getNumSends() == 1) {
                    Connection.this._ssthresh = Math.max((int)(Connection.this._bwEstimator.getBandwidthEstimate() * (float)Connection.this._options.getMinRTT()), 2);
                    Connection.this._ssthresh = Math.min(64, Connection.this._ssthresh);
                    int wsize = Connection.this._options.getWindowSize();
                    Connection.this._options.setWindowSize(Math.min(Connection.this._ssthresh, wsize));
                }
                if (Connection.this._log.shouldLog(20)) {
                    Connection.this._log.info("Congestion, resending packet " + this._packet.getSequenceNum() + " (new windowSize " + newWindowSize + "/" + Connection.this._options.getWindowSize() + ") for " + Connection.this.toString());
                }
                Connection.this.windowAdjusted();
            }
            int numSends = this._packet.getNumSends() + 1;
            if (numSends - 1 > Connection.this._options.getMaxResends()) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Disconnecting, too many resends of " + this._packet);
                }
                this._packet.cancelled();
                Connection.this.disconnect(false);
            } else if (numSends >= 3 && this._packet.isFlagSet(2) && this._packet.getPayloadSize() <= 0 && Connection.this._outboundPackets.size() <= 1 && Connection.this.getCloseReceivedOn() > 0L) {
                if (Connection.this._log.shouldLog(20)) {
                    Connection.this._log.info("Too many CLOSE resends, disconnecting: " + Connection.this.toString());
                }
                this._packet.cancelled();
                Connection.this.disconnect(true);
            } else {
                int timeout = Connection.this._options.getRTO();
                if (timeout > 45000 || timeout <= 0) {
                    timeout = 45000;
                }
                this._packet.setTimeout(timeout);
                if (Connection.this._outboundQueue.enqueue(this._packet)) {
                    if (Connection.this._retransmitEvent.scheduleIfNotRunning(timeout) && Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " fast retransmit and schedule timer");
                    }
                    if (numSends == 2) {
                        Connection.this._activeResends.incrementAndGet();
                    }
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info("Resent packet (fast) " + this._packet + " next resend in " + timeout + "ms activeResends: " + Connection.this._activeResends + " (wsize " + newWindowSize + " lifetime " + (Connection.this._context.clock().now() - this._packet.getCreatedOn()) + "ms)");
                    }
                    Connection.this._unackedPacketsReceived.set(0);
                    Connection.this._lastSendTime = Connection.this._context.clock().now();
                    Connection.this.resetActivityTimer();
                }
            }
            if (this._packet.getAckTime() > 0 && this._packet.getNumSends() > 1) {
                Connection.this._activeResends.decrementAndGet();
                TreeMap treeMap = Connection.this._outboundPackets;
                synchronized (treeMap) {
                    Connection.this._outboundPackets.notifyAll();
                }
            }
            return true;
        }
    }

    class RetransmitEvent
    extends SimpleTimer2.TimedEvent {
        private boolean _scheduled;

        RetransmitEvent() {
            super(Connection.this._timer);
        }

        public synchronized boolean cancel() {
            this._scheduled = false;
            return super.cancel();
        }

        public synchronized boolean scheduleIfNotRunning(long delay) {
            if (this._scheduled) {
                return false;
            }
            this._scheduled = true;
            this.schedule(delay);
            return true;
        }

        public synchronized void pushBackRTO(int rto) {
            if (!this._scheduled && Connection.this._log.shouldWarn()) {
                Connection.this._log.warn(Connection.this + " timer was not scheduled", (Throwable)new Exception());
            }
            this.reschedule(rto, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            if (Connection.this._resetSentOn.get() > 0L || Connection.this._resetReceived.get() || Connection.this._finalDisconnect.get()) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug(Connection.this + " rtx event after close or reset");
                }
                return;
            }
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug(Connection.this + " rtx timer timeReached()");
            }
            Connection.this.congestionOccurred();
            this.pushBackRTO(Connection.this._options.doubleRTO());
            List<Object> toResend = null;
            TreeMap treeMap = Connection.this._outboundPackets;
            synchronized (treeMap) {
                Map.Entry e = Connection.this._outboundPackets.firstEntry();
                if (e == null) {
                    if (Connection.this._log.shouldLog(30)) {
                        Connection.this._log.warn(Connection.this + " Retransmission timer hit but nothing transmitted??");
                    }
                    return;
                }
                PacketLocal packetLocal = (PacketLocal)e.getValue();
                if (packetLocal.getNumSends() == 1) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " cutting ssthresh and window");
                    }
                    Connection.this._ssthresh = Math.max((int)(Connection.this._bwEstimator.getBandwidthEstimate() * (float)Connection.this._options.getMinRTT()), 2);
                    Connection.this._ssthresh = Math.min(64, Connection.this._ssthresh);
                    Connection.this._options.setWindowSize(1);
                } else if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug(Connection.this + " not cutting ssthresh and window");
                }
                toResend = new ArrayList(Connection.this._outboundPackets.values());
                toResend = toResend.subList(0, Math.min(16, (toResend.size() + 1) / 2));
            }
            boolean sentAny = false;
            for (PacketLocal packetLocal : toResend) {
                int nResends = packetLocal.getNumSends();
                if (packetLocal.getNumSends() > Connection.this._options.getMaxResends()) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " packet " + packetLocal + " resent too many times, closing");
                    }
                    packetLocal.cancelled();
                    Connection.this.disconnect(false);
                    return;
                }
                if (packetLocal.getNumSends() >= 3 && packetLocal.isFlagSet(2) && packetLocal.getPayloadSize() <= 0 && Connection.this.getCloseReceivedOn() > 0L) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " too many close resends, closing");
                    }
                    packetLocal.cancelled();
                    Connection.this.disconnect(false);
                    return;
                }
                if (Connection.this._isChoking) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " packet is choking " + packetLocal);
                    }
                    packetLocal.setOptionalDelay(61000);
                    packetLocal.setFlag(64);
                } else if (Connection.this._unchokesToSend.decrementAndGet() > 0) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " packet is unchoking " + packetLocal);
                    }
                    packetLocal.setOptionalDelay(0);
                    packetLocal.setFlag(64);
                } else {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug(Connection.this + " packet clearing flag " + packetLocal);
                    }
                    packetLocal.setFlag(64, false);
                }
                packetLocal.setResendDelay(Connection.this._options.getResendDelay() / 1000);
                if (packetLocal.getReceiveStreamId() <= 0L) {
                    packetLocal.setReceiveStreamId(Connection.this._receiveStreamId.get());
                }
                if (packetLocal.getSendStreamId() <= 0L) {
                    packetLocal.setSendStreamId(Connection.this._sendStreamId.get());
                }
                packetLocal.setTimeout(Connection.this._options.getRTO());
                if (Connection.this._outboundQueue.enqueue(packetLocal)) {
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info(Connection.this + " resent packet " + packetLocal);
                    }
                    if (nResends == 1) {
                        Connection.this._activeResends.incrementAndGet();
                    }
                    sentAny = true;
                    continue;
                }
                if (!Connection.this._log.shouldLog(10)) continue;
                Connection.this._log.debug(Connection.this + " could not resend packet " + packetLocal);
            }
            if (sentAny) {
                Connection.this._lastSendTime = Connection.this._context.clock().now();
                Connection.this.resetActivityTimer();
                Connection.this.windowAdjusted();
            }
        }
    }
}

