/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.binding.OsModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OsConstraintHelper {
    public static List<OsModel> getOsList(IXMLElement element) {
        ArrayList<OsModel> osList = new ArrayList<OsModel>();
        for (IXMLElement osElement : element.getChildrenNamed("os")) {
            osList.add(new OsModel(osElement.getAttribute("arch", null), osElement.getAttribute("family", null), osElement.getAttribute("jre", null), osElement.getAttribute("name", null), osElement.getAttribute("version", null)));
        }
        String osattr = element.getAttribute("os");
        if (osattr != null && osattr.length() > 0) {
            osList.add(new OsModel(null, osattr, null, null, null));
        }
        return osList;
    }

    public static List<OsModel> commonOsList(List<OsModel> osList, List<OsModel> otherOsList) throws UnsatisfiableOsConstraintsException {
        if (osList.isEmpty() && otherOsList.isEmpty()) {
            return Collections.emptyList();
        }
        if (osList.isEmpty()) {
            return otherOsList;
        }
        if (otherOsList.isEmpty()) {
            return osList;
        }
        ArrayList<OsModel> commonOsList = new ArrayList<OsModel>();
        for (OsModel os : osList) {
            for (OsModel otherOs : otherOsList) {
                CommonOsConstraint arch = OsConstraintHelper.commonConstraint(os.getArch(), otherOs.getArch());
                CommonOsConstraint family = OsConstraintHelper.commonConstraint(os.getFamily(), otherOs.getFamily());
                CommonOsConstraint jre = OsConstraintHelper.commonConstraint(os.getJre(), otherOs.getJre());
                CommonOsConstraint name = OsConstraintHelper.commonConstraint(os.getName(), otherOs.getName());
                CommonOsConstraint version = OsConstraintHelper.commonConstraint(os.getVersion(), otherOs.getVersion());
                if (!arch.satisfiable || !family.satisfiable || !jre.satisfiable || !name.satisfiable || !version.satisfiable) continue;
                commonOsList.add(new OsModel(arch.value, family.value, jre.value, name.value, version.value));
            }
        }
        if (!commonOsList.isEmpty()) {
            return commonOsList;
        }
        throw new UnsatisfiableOsConstraintsException(osList, otherOsList);
    }

    private static CommonOsConstraint commonConstraint(String value, String otherValue) {
        if (value == null && otherValue == null) {
            return CommonOsConstraint.ANY;
        }
        if (value == null) {
            return new CommonOsConstraint(otherValue);
        }
        if (otherValue == null) {
            return new CommonOsConstraint(value);
        }
        if (value.equals(otherValue)) {
            return new CommonOsConstraint(value);
        }
        return CommonOsConstraint.NONE;
    }

    public static String toOsContraintsString(List<OsModel> osList) {
        if (osList.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(osList.get(0));
        for (int i = 1; i < osList.size(); ++i) {
            sb.append(" or ");
            sb.append(osList.get(i));
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static class CommonOsConstraint {
        static final CommonOsConstraint ANY = new CommonOsConstraint(true);
        static final CommonOsConstraint NONE = new CommonOsConstraint(false);
        final boolean satisfiable;
        final String value;

        CommonOsConstraint(boolean satisfiable) {
            this.satisfiable = satisfiable;
            this.value = null;
        }

        CommonOsConstraint(String value) {
            this.satisfiable = true;
            this.value = value;
        }
    }

    public static class UnsatisfiableOsConstraintsException
    extends Exception {
        private static final String MESSAGE = "Common OS constraints of %s and %s are unsatisfiable";

        public UnsatisfiableOsConstraintsException(List<OsModel> osList, List<OsModel> otherOsList) {
            super(String.format(MESSAGE, OsConstraintHelper.toOsContraintsString(osList), OsConstraintHelper.toOsContraintsString(otherOsList)));
        }
    }
}

