/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.rules.Condition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PackSelectionCondition
extends Condition {
    private static final long serialVersionUID = -1509855620741701740L;
    private String name;

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        try {
            this.name = xmlcondition.getFirstChildNamed("name").getContent();
        }
        catch (Exception e) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
    }

    private boolean isTrue(List<Pack> selectedpacks) {
        if (selectedpacks != null) {
            for (Pack selectedpack : selectedpacks) {
                if (!this.name.equals(selectedpack.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.isTrue(this.getInstallData().getSelectedPacks());
    }

    @Override
    public String getDependenciesDetails() {
        StringBuilder details = new StringBuilder();
        details.append(this.getId());
        details.append("depends on the selection of pack <b>");
        details.append(this.name);
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl packel = new XMLElementImpl("name", conditionRoot);
        packel.setContent(this.name);
        conditionRoot.addChild(packel);
    }

    public void setPack(String name) {
        this.name = name;
    }

    @Override
    public Set<String> getVarRefs() {
        return new HashSet<String>(1);
    }
}

