/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArraySet<E>
extends AbstractSet<E>
implements Set<E> {
    public static final int MAX_CAPACITY = 32;
    protected final Object[] _entries;
    private final boolean _throwOnFull;
    private int _size;
    private int _overflowIndex;
    private transient int modCount;

    public ArraySet() {
        this(32);
    }

    public ArraySet(Set<? extends E> c) {
        this(c, 32);
    }

    public ArraySet(Set<? extends E> c, int capacity) {
        this(Math.max(capacity, c.size()));
        for (E e : c) {
            this._entries[this._size++] = e;
        }
    }

    public ArraySet(Collection<? extends E> c) {
        this(c, 32);
    }

    public ArraySet(Collection<? extends E> c, int capacity) {
        this(Math.max(capacity, c.size()));
        this.addAll(c);
    }

    public ArraySet(int capacity) {
        this(capacity, true);
    }

    public ArraySet(int capacity, boolean throwOnFull) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("bad capacity");
        }
        this._entries = new Object[capacity];
        this._throwOnFull = throwOnFull;
    }

    protected int indexOf(Object o) {
        if (o != null) {
            for (int i = 0; i < this._size; ++i) {
                if (!o.equals(this._entries[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int i = this.indexOf(o);
        if (i >= 0) {
            this._entries[i] = o;
            return false;
        }
        this.addUnique(o);
        return true;
    }

    public void addUnique(E o) {
        int i;
        if (this._size >= this._entries.length) {
            if (this._throwOnFull) {
                throw new SetFullException();
            }
            if ((i = this._overflowIndex++) >= this._entries.length) {
                i = 0;
                this._overflowIndex = 0;
            }
        } else {
            ++this.modCount;
            i = this._size++;
        }
        this._entries[i] = o;
    }

    @Override
    public void clear() {
        if (this._size != 0) {
            ++this.modCount;
            for (int i = 0; i < this._size; ++i) {
                this._entries[i] = null;
            }
            this._size = 0;
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this._size <= 0;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return false;
        }
        ++this.modCount;
        --this._size;
        for (int j = i; j < this._size; ++j) {
            this._entries[j] = this._entries[j + 1];
        }
        this._entries[this._size] = null;
        return true;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public Iterator<E> iterator() {
        return new ASIterator();
    }

    private class ASIterator
    implements Iterator<E>,
    Serializable {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = ArraySet.access$100(ArraySet.this);

        private ASIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArraySet.this._size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = ArraySet.this._entries[i];
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArraySet.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = ArraySet.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ArraySet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class SetFullException
    extends IllegalStateException {
        private static final long serialVersionUID = 9087390587254111L;
    }
}

