/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.crypto.SipHashInline;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.ClientManagerFacade;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.InverseCapacityComparator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.router.peermanager.SpeedComparator;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.router.util.RandomIterator;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class ProfileOrganizer {
    private final Log _log;
    private final RouterContext _context;
    private final Map<Hash, PeerProfile> _fastPeers;
    private final Map<Hash, PeerProfile> _highCapacityPeers;
    private final Map<Hash, PeerProfile> _wellIntegratedPeers;
    private final Map<Hash, PeerProfile> _notFailingPeers;
    private final List<Hash> _notFailingPeersList;
    private final Map<Hash, PeerProfile> _failingPeers;
    private Hash _us;
    private final ProfilePersistenceHelper _persistenceHelper;
    private Set<PeerProfile> _strictCapacityOrder;
    private double _thresholdSpeedValue;
    private double _thresholdCapacityValue;
    private double _thresholdIntegrationValue;
    private final InverseCapacityComparator _comp;
    public static final String PROP_MINIMUM_FAST_PEERS = "profileOrganizer.minFastPeers";
    public static final int DEFAULT_MINIMUM_FAST_PEERS = 8;
    private static final int DEFAULT_MAXIMUM_FAST_PEERS = 40;
    private static final int ABSOLUTE_MAX_FAST_PEERS = 75;
    public static final String PROP_MINIMUM_HIGH_CAPACITY_PEERS = "profileOrganizer.minHighCapacityPeers";
    public static final int DEFAULT_MINIMUM_HIGH_CAPACITY_PEERS = 10;
    private static final int ABSOLUTE_MAX_HIGHCAP_PEERS = 150;
    private final ReentrantReadWriteLock _reorganizeLock = new ReentrantReadWriteLock(false);
    private static final int MAX_BAD_REPLIES_PER_HOUR = 5;
    private static final long MIN_EXPIRE_TIME = 0x6DDD00L;
    private static final long MAX_EXPIRE_TIME = 21600000L;
    private static final long ADJUST_EXPIRE_TIME = 60000L;
    private static final int ENOUGH_PROFILES = 600;
    private long _currentExpireTime = 21600000L;
    private static final int MIN_NOT_FAILING_ACTIVE = 3;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.UK));

    public ProfileOrganizer(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ProfileOrganizer.class);
        this._comp = new InverseCapacityComparator();
        this._fastPeers = new HashMap<Hash, PeerProfile>(32);
        this._highCapacityPeers = new HashMap<Hash, PeerProfile>(64);
        this._wellIntegratedPeers = new HashMap<Hash, PeerProfile>(128);
        this._notFailingPeers = new HashMap<Hash, PeerProfile>(256);
        this._notFailingPeersList = new ArrayList<Hash>(256);
        this._failingPeers = new HashMap<Hash, PeerProfile>(16);
        this._strictCapacityOrder = new TreeSet<PeerProfile>(this._comp);
        this._persistenceHelper = new ProfilePersistenceHelper(this._context);
        this._context.statManager().createRateStat("peer.profileSortTime", "How long the reorg takes sorting peers", "Peers", new long[]{3600000L});
        this._context.statManager().createRateStat("peer.profileCoalesceTime", "How long the reorg takes coalescing peer stats", "Peers", new long[]{3600000L});
        this._context.statManager().createRateStat("peer.profileThresholdTime", "How long the reorg takes determining the tier thresholds", "Peers", new long[]{3600000L});
        this._context.statManager().createRateStat("peer.profilePlaceTime", "How long the reorg takes placing peers in the tiers", "Peers", new long[]{3600000L});
        this._context.statManager().createRateStat("peer.profileReorgTime", "How long the reorg takes overall", "Peers", new long[]{3600000L});
        this._context.statManager().createRequiredRateStat("peer.failedLookupRate", "Net DB Lookup fail rate", "Peers", new long[]{600000L, 3600000L, 86400000L});
    }

    private void getReadLock() {
        this._reorganizeLock.readLock().lock();
    }

    private boolean tryReadLock() {
        return this._reorganizeLock.readLock().tryLock();
    }

    private void releaseReadLock() {
        this._reorganizeLock.readLock().unlock();
    }

    private boolean tryWriteLock() {
        return this._reorganizeLock.writeLock().tryLock();
    }

    private boolean getWriteLock() {
        try {
            boolean rv = this._reorganizeLock.writeLock().tryLock(3000L, TimeUnit.MILLISECONDS);
            if (!rv && this._log.shouldLog(30)) {
                this._log.warn("no lock, size is: " + this._reorganizeLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void releaseWriteLock() {
        this._reorganizeLock.writeLock().unlock();
    }

    public void setUs(Hash us) {
        this._us = us;
    }

    public Hash getUs() {
        return this._us;
    }

    public double getSpeedThreshold() {
        return this._thresholdSpeedValue;
    }

    public double getCapacityThreshold() {
        return this._thresholdCapacityValue;
    }

    public double getIntegrationThreshold() {
        return this._thresholdIntegrationValue;
    }

    public PeerProfile getProfile(Hash peer) {
        if (peer.equals(this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Who wanted our own profile?", new Exception("I did"));
            }
            return null;
        }
        this.getReadLock();
        try {
            PeerProfile peerProfile = this.locked_getProfile(peer);
            return peerProfile;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public PeerProfile getProfileNonblocking(Hash peer) {
        if (peer.equals(this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Who wanted our own profile?", new Exception("I did"));
            }
            return null;
        }
        if (this.tryReadLock()) {
            try {
                PeerProfile peerProfile = this.locked_getProfile(peer);
                return peerProfile;
            }
            finally {
                this.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerProfile getOrCreateProfileNonblocking(Hash peer) {
        PeerProfile rv;
        if (peer.equals(this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Who wanted our own profile?", new Exception("I did"));
            }
            return null;
        }
        if (!this.tryReadLock()) {
            return null;
        }
        try {
            rv = this.locked_getProfile(peer);
        }
        finally {
            this.releaseReadLock();
        }
        if (rv != null) {
            return rv;
        }
        rv = new PeerProfile(this._context, peer);
        rv.coalesceStats();
        if (!this.tryWriteLock()) {
            return null;
        }
        try {
            PeerProfile old = this.locked_getProfile(peer);
            if (old != null) {
                PeerProfile peerProfile = old;
                return peerProfile;
            }
            this._notFailingPeers.put(peer, rv);
            this._notFailingPeersList.add(peer);
            if (this._thresholdCapacityValue <= (double)rv.getCapacityValue() && this.isSelectable(peer) && this._highCapacityPeers.size() < this.getMaximumHighCapPeers()) {
                this._highCapacityPeers.put(peer, rv);
            }
            this._strictCapacityOrder.add(rv);
        }
        finally {
            this.releaseWriteLock();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerProfile addProfile(PeerProfile profile) {
        if (profile == null) {
            return null;
        }
        Hash peer = profile.getPeer();
        if (peer.equals(this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Who added our own profile?", new Exception("I did"));
            }
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("New profile created for " + peer);
        }
        PeerProfile old = this.getProfile(peer);
        profile.coalesceStats();
        if (!this.getWriteLock()) {
            return old;
        }
        try {
            this._notFailingPeers.put(peer, profile);
            if (old == null) {
                this._notFailingPeersList.add(peer);
            }
            if (this._thresholdCapacityValue <= (double)profile.getCapacityValue() && this.isSelectable(peer) && this._highCapacityPeers.size() < this.getMaximumHighCapPeers()) {
                this._highCapacityPeers.put(peer, profile);
            }
            this._strictCapacityOrder.add(profile);
        }
        finally {
            this.releaseWriteLock();
        }
        return old;
    }

    private int count(Map<Hash, PeerProfile> m) {
        this.getReadLock();
        try {
            int n = m.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public int countFastPeers() {
        return this.count(this._fastPeers);
    }

    public int countHighCapacityPeers() {
        return this.count(this._highCapacityPeers);
    }

    @Deprecated
    public int countWellIntegratedPeers() {
        return this.count(this._wellIntegratedPeers);
    }

    public int countNotFailingPeers() {
        return this.count(this._notFailingPeers);
    }

    public int countFailingPeers() {
        return this.count(this._failingPeers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeers() {
        int activePeers = 0;
        long hideBefore = this._context.clock().now() - 21600000L;
        this.getReadLock();
        try {
            for (PeerProfile profile : this._failingPeers.values()) {
                if (profile.getLastSendSuccessful() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastHeardFrom() < hideBefore) continue;
                ++activePeers;
            }
            for (PeerProfile profile : this._notFailingPeers.values()) {
                if (profile.getLastSendSuccessful() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastHeardFrom() < hideBefore) continue;
                ++activePeers;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return activePeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isX(Map<Hash, PeerProfile> m, Hash peer) {
        this.getReadLock();
        try {
            boolean bl = m.containsKey(peer);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isFast(Hash peer) {
        return this.isX(this._fastPeers, peer);
    }

    public boolean isHighCapacity(Hash peer) {
        return this.isX(this._highCapacityPeers, peer);
    }

    public boolean isWellIntegrated(Hash peer) {
        return this.isX(this._wellIntegratedPeers, peer);
    }

    public boolean isFailing(Hash peer) {
        return false;
    }

    void clearProfiles() {
        if (!this.getWriteLock()) {
            return;
        }
        try {
            this._failingPeers.clear();
            this._fastPeers.clear();
            this._highCapacityPeers.clear();
            this._notFailingPeers.clear();
            this._notFailingPeersList.clear();
            this._wellIntegratedPeers.clear();
            this._strictCapacityOrder.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public boolean peerSendsBadReplies(Hash peer) {
        RateStat invalidReplyRateStat;
        Rate invalidReplyRate;
        PeerProfile profile = this.getProfile(peer);
        return profile != null && profile.getIsExpandedDB() && ((invalidReplyRate = (invalidReplyRateStat = profile.getDBHistory().getInvalidReplyRate()).getRate(1800000L)).getCurrentTotalValue() > 5.0 || invalidReplyRate.getLastTotalValue() > 5.0);
    }

    public boolean exportProfile(Hash profile, OutputStream out) throws IOException {
        boolean rv;
        PeerProfile prof = this.getProfile(profile);
        boolean bl = rv = prof != null;
        if (rv) {
            this._persistenceHelper.writeProfile(prof, out);
        }
        return rv;
    }

    public void selectFastPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectFastPeers(howMany, exclude, matches, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFastPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        this.getReadLock();
        try {
            this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, mask, ipSet);
        }
        finally {
            this.releaseReadLock();
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectFastPeers(" + howMany + "), not enough fast (" + matches.size() + ") going on to highCap");
            }
            this.selectHighCapacityPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug("selectFastPeers(" + howMany + "), found enough fast (" + matches.size() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFastPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, SessionKey randomKey, Slice subTierMode, int mask, MaskedIPSet ipSet) {
        this.getReadLock();
        try {
            int sz;
            if (subTierMode != Slice.SLICE_ALL && ((sz = this._fastPeers.size()) < 6 || subTierMode.mask >= 3 && sz < 12)) {
                subTierMode = Slice.SLICE_ALL;
            }
            if (subTierMode != Slice.SLICE_ALL) {
                this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, randomKey, subTierMode, mask, ipSet);
            } else {
                this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, mask, ipSet);
            }
        }
        finally {
            this.releaseReadLock();
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectFastPeers(" + howMany + "), not enough fast (" + matches.size() + ") going on to highCap");
            }
            this.selectHighCapacityPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug("selectFastPeers(" + howMany + "), found enough fast (" + matches.size() + ")");
        }
    }

    public void selectHighCapacityPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectHighCapacityPeers(howMany, exclude, matches, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectHighCapacityPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        this.getReadLock();
        try {
            this.locked_selectPeers(this._highCapacityPeers, howMany, exclude, matches, mask, ipSet);
        }
        finally {
            this.releaseReadLock();
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectHighCap(" + howMany + "), not enough highcap (" + matches.size() + ") going on to ANFP2");
            }
            this.selectActiveNotFailingPeers2(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug("selectHighCap(" + howMany + "), found enough highCap (" + matches.size() + ")");
        }
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectNotFailingPeers(howMany, exclude, matches, false, 0, null);
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        this.selectNotFailingPeers(howMany, exclude, matches, false, mask, ipSet);
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing) {
        this.selectNotFailingPeers(howMany, exclude, matches, onlyNotFailing, 0, null);
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing, int mask, MaskedIPSet ipSet) {
        if (matches.size() < howMany) {
            this.selectAllNotFailingPeers(howMany, exclude, matches, onlyNotFailing, mask);
        }
    }

    public void selectActiveNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectActiveNotFailingPeers(howMany, exclude, matches, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectActiveNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        if (matches.size() < howMany) {
            Set<Hash> connected = this._context.commSystem().getEstablished();
            this.getReadLock();
            try {
                for (Hash peer : this._notFailingPeers.keySet()) {
                    if (connected.contains(peer)) continue;
                    exclude.add(peer);
                }
                this.locked_selectPeers(this._notFailingPeers, howMany, exclude, matches, mask, ipSet);
            }
            finally {
                this.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectActiveNotFailingPeers2(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        if (matches.size() < howMany) {
            Set<Hash> connected = this._context.commSystem().getEstablished();
            HashMap<Hash, PeerProfile> activePeers = new HashMap<Hash, PeerProfile>(connected.size());
            this.getReadLock();
            try {
                for (Hash peer : connected) {
                    PeerProfile prof = this._notFailingPeers.get(peer);
                    if (prof == null) continue;
                    activePeers.put(peer, prof);
                }
                this.locked_selectPeers(activePeers, howMany, exclude, matches, mask, ipSet);
            }
            finally {
                this.releaseReadLock();
            }
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectANFP2(" + howMany + "), not enough ANFP (" + matches.size() + ") going on to notFailing");
            }
            this.selectNotFailingPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug("selectANFP2(" + howMany + "), found enough ANFP (" + matches.size() + ")");
        }
    }

    public void selectAllNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing) {
        this.selectAllNotFailingPeers(howMany, exclude, matches, onlyNotFailing, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAllNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing, int mask) {
        if (matches.size() < howMany) {
            int orig = matches.size();
            int needed = howMany - orig;
            ArrayList<Hash> selected = new ArrayList<Hash>(needed);
            this.getReadLock();
            try {
                RandomIterator<Hash> iter = new RandomIterator<Hash>(this._notFailingPeersList);
                while (selected.size() < needed && iter.hasNext()) {
                    Hash cur = (Hash)iter.next();
                    if (matches.contains(cur) || exclude != null && exclude.contains(cur)) {
                        if (!this._log.shouldLog(10)) continue;
                        this._log.debug("matched? " + matches.contains(cur) + " exclude: " + exclude + " cur=" + cur.toBase64());
                        continue;
                    }
                    if (onlyNotFailing && this._highCapacityPeers.containsKey(cur)) continue;
                    if (this.isSelectable(cur)) {
                        selected.add(cur);
                        continue;
                    }
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Not selectable: " + cur.toBase64());
                }
            }
            finally {
                this.releaseReadLock();
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Selecting all not failing (strict? " + onlyNotFailing + ") found " + selected.size() + " new peers: " + selected + " all=" + this._notFailingPeersList.size() + " strict=" + this._strictCapacityOrder.size());
            }
            matches.addAll(selected);
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectAllNotFailing(" + howMany + "), not enough (" + matches.size() + ") going on to failing");
            }
            this.selectFailingPeers(howMany, exclude, matches);
        } else if (this._log.shouldLog(20)) {
            this._log.info("selectAllNotFailing(" + howMany + "), enough (" + matches.size() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.getReadLock();
        try {
            this.locked_selectPeers(this._failingPeers, howMany, exclude, matches);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public List<Hash> selectPeersLocallyUnreachable() {
        ArrayList<Hash> n;
        int count;
        this.getReadLock();
        try {
            count = this._notFailingPeers.size();
            n = new ArrayList<Hash>(this._notFailingPeers.keySet());
        }
        finally {
            this.releaseReadLock();
        }
        ArrayList<Hash> l = new ArrayList<Hash>(count / 4);
        for (Hash peer : n) {
            if (this._context.commSystem().wasUnreachable(peer)) {
                l.add(peer);
                continue;
            }
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
            if (info == null) continue;
            RouterAddress ra = info.getTargetAddress("SSU");
            if (ra == null) {
                if (!info.getTargetAddresses("NTCP", "NTCP2").isEmpty()) continue;
                l.add(peer);
                continue;
            }
            if (ra.getOption("itag0") == null) continue;
            l.add(peer);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unreachable: " + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hash> selectPeersRecentlyRejecting() {
        this.getReadLock();
        try {
            long cutoff = this._context.clock().now() - 20000L;
            int count = this._notFailingPeers.size();
            ArrayList<Hash> l = new ArrayList<Hash>(count / 128);
            for (PeerProfile prof : this._notFailingPeers.values()) {
                if (prof.getTunnelHistory().getLastRejectedBandwidth() <= cutoff) continue;
                l.add(prof.getPeer());
            }
            ArrayList<Hash> arrayList = l;
            return arrayList;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Set<Hash> selectAllPeers() {
        this.getReadLock();
        try {
            HashSet<Hash> allPeers = new HashSet<Hash>(this._failingPeers.size() + this._notFailingPeers.size() + this._highCapacityPeers.size() + this._fastPeers.size());
            allPeers.addAll(this._failingPeers.keySet());
            allPeers.addAll(this._notFailingPeers.keySet());
            allPeers.addAll(this._highCapacityPeers.keySet());
            allPeers.addAll(this._fastPeers.keySet());
            HashSet<Hash> hashSet = allPeers;
            return hashSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    void reorganize() {
        this.reorganize(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reorganize(boolean shouldCoalesce, boolean shouldDecay) {
        long sortTime = 0L;
        int coalesceTime = 0;
        long thresholdTime = 0L;
        long placeTime = 0L;
        int profileCount = 0;
        int expiredCount = 0;
        Router r = this._context.router();
        long uptime = r != null ? r.getUptime() : 0L;
        long expireOlderThan = -1L;
        if (uptime > 3600000L) {
            this._currentExpireTime = this.countNotFailingPeers() > 600 ? Math.max(this._currentExpireTime - 60000L, 0x6DDD00L) : Math.min(this._currentExpireTime + 60000L, 21600000L);
            expireOlderThan = this._context.clock().now() - this._currentExpireTime;
        }
        if (shouldCoalesce) {
            this.getReadLock();
            try {
                long coalesceStart = System.currentTimeMillis();
                for (PeerProfile prof : this._strictCapacityOrder) {
                    if (expireOlderThan > 0L && prof.getLastSendSuccessful() <= expireOlderThan) continue;
                    prof.coalesceOnly(shouldDecay);
                }
                coalesceTime = (int)(System.currentTimeMillis() - coalesceStart);
            }
            finally {
                this.releaseReadLock();
            }
        }
        if (!this.getWriteLock()) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Set<PeerProfile> allPeers = this._strictCapacityOrder;
            TreeSet<PeerProfile> reordered = new TreeSet<PeerProfile>(this._comp);
            long sortStart = System.currentTimeMillis();
            for (PeerProfile prof : this._strictCapacityOrder) {
                if (expireOlderThan > 0L && prof.getLastSendSuccessful() <= expireOlderThan) {
                    ++expiredCount;
                    continue;
                }
                prof.updateValues();
                reordered.add(prof);
                ++profileCount;
            }
            sortTime = System.currentTimeMillis() - sortStart;
            this._strictCapacityOrder = reordered;
            long thresholdStart = System.currentTimeMillis();
            this.locked_calculateThresholds(allPeers);
            thresholdTime = System.currentTimeMillis() - thresholdStart;
            this._failingPeers.clear();
            this._fastPeers.clear();
            this._highCapacityPeers.clear();
            this._notFailingPeers.clear();
            this._notFailingPeersList.clear();
            this._wellIntegratedPeers.clear();
            long placeStart = System.currentTimeMillis();
            for (PeerProfile profile : this._strictCapacityOrder) {
                this.locked_placeProfile(profile);
            }
            this.locked_unfailAsNecessary();
            this.locked_demoteHighCapAsNecessary();
            this.locked_promoteFastAsNecessary();
            this.locked_demoteFastAsNecessary();
            placeTime = System.currentTimeMillis() - placeStart;
        }
        finally {
            this.releaseWriteLock();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Profiles reorganized. Expired: " + expiredCount + " Averages: [integration: " + this._thresholdIntegrationValue + ", capacity: " + this._thresholdCapacityValue + ", speed: " + this._thresholdSpeedValue + "]");
        }
        long total = System.currentTimeMillis() - start;
        this._context.statManager().addRateData("peer.profileSortTime", sortTime, profileCount);
        this._context.statManager().addRateData("peer.profileCoalesceTime", coalesceTime, profileCount);
        this._context.statManager().addRateData("peer.profileThresholdTime", thresholdTime, profileCount);
        this._context.statManager().addRateData("peer.profilePlaceTime", placeTime, profileCount);
        this._context.statManager().addRateData("peer.profileReorgTime", total, profileCount);
    }

    private void locked_promoteFastAsNecessary() {
        int minFastPeers = this.getMinimumFastPeers();
        int numToPromote = minFastPeers - this._fastPeers.size();
        if (numToPromote > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info("Need to explicitly promote " + numToPromote + " peers to the fast group");
            }
            for (PeerProfile cur : this._strictCapacityOrder) {
                if (this._fastPeers.containsKey(cur.getPeer()) || cur.getIsFailing() || !this.isSelectable(cur.getPeer()) || !cur.getIsActive()) continue;
                if (this._log.shouldLog(20)) {
                    this._log.info("Fast promoting: " + cur.getPeer().toBase64());
                }
                this._fastPeers.put(cur.getPeer(), cur);
                if (--numToPromote > 0) continue;
                break;
            }
        }
    }

    private void locked_demoteFastAsNecessary() {
        int maxFastPeers = this.getMaximumFastPeers();
        int numToDemote = this._fastPeers.size() - maxFastPeers;
        if (numToDemote > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info("Need to explicitly demote " + numToDemote + " peers from the fast group");
            }
            TreeSet<PeerProfile> sorted = new TreeSet<PeerProfile>(new SpeedComparator());
            sorted.addAll(this._fastPeers.values());
            Iterator iter = sorted.iterator();
            for (int i = 0; i < numToDemote && iter.hasNext(); ++i) {
                this._fastPeers.remove(((PeerProfile)iter.next()).getPeer());
            }
        }
    }

    private void locked_demoteHighCapAsNecessary() {
        int maxHighCapPeers = this.getMaximumHighCapPeers();
        int numToDemote = this._highCapacityPeers.size() - maxHighCapPeers;
        if (numToDemote > 0) {
            Iterator<PeerProfile> iter = this._strictCapacityOrder.iterator();
            int i = 0;
            while (iter.hasNext() && i < maxHighCapPeers) {
                if (!this._highCapacityPeers.containsKey(iter.next().getPeer())) continue;
                ++i;
            }
            i = 0;
            while (iter.hasNext() && i < numToDemote) {
                Hash h = iter.next().getPeer();
                if (this._highCapacityPeers.remove(h) == null) continue;
                this._fastPeers.remove(h);
                ++i;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Demoted " + numToDemote + " peers from high cap, size now " + this._highCapacityPeers.size());
            }
        }
    }

    private void locked_unfailAsNecessary() {
        int notFailingActive = 0;
        for (PeerProfile peer : this._notFailingPeers.values()) {
            if (peer.getIsActive()) {
                ++notFailingActive;
            }
            if (notFailingActive < 3) continue;
            return;
        }
        int needToUnfail = 3 - notFailingActive;
        if (needToUnfail > 0) {
            int unfailed = 0;
            for (PeerProfile best : this._strictCapacityOrder) {
                if (best.getIsActive() && best.getIsFailing()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("All peers were failing, so we have overridden the failing flag for one of the most reliable active peers (" + best.getPeer().toBase64() + ")");
                    }
                    best.setIsFailing(false);
                    this.locked_placeProfile(best);
                    ++unfailed;
                }
                if (unfailed < needToUnfail) continue;
                break;
            }
        }
    }

    private void locked_calculateThresholds(Set<PeerProfile> allPeers) {
        double totalCapacity = 0.0;
        double totalIntegration = 0.0;
        TreeSet<PeerProfile> reordered = new TreeSet<PeerProfile>(this._comp);
        for (PeerProfile profile : allPeers) {
            if (this._us.equals(profile.getPeer()) || profile.getIsFailing() || !profile.getIsActive()) continue;
            totalCapacity += (double)profile.getCapacityValue();
            totalIntegration += (double)profile.getIntegrationValue();
            reordered.add(profile);
        }
        this.locked_calculateCapacityThreshold(totalCapacity, reordered);
        this.locked_calculateSpeedThreshold(reordered);
        this._thresholdIntegrationValue = totalIntegration > 0.0 ? 1.0 * ProfileOrganizer.avg(totalIntegration, reordered.size()) : 1.0;
    }

    private void locked_calculateCapacityThreshold(double totalCapacity, Set<PeerProfile> reordered) {
        int numNotFailing = reordered.size();
        double meanCapacity = ProfileOrganizer.avg(totalCapacity, numNotFailing);
        int minHighCapacityPeers = this.getMinimumHighCapacityPeers();
        int numExceedingMean = 0;
        double thresholdAtMedian = 0.0;
        double thresholdAtMinHighCap = 0.0;
        double thresholdAtLowest = 5.0;
        int cur = 0;
        for (PeerProfile profile : reordered) {
            double val = profile.getCapacityValue();
            if (val > meanCapacity) {
                ++numExceedingMean;
            }
            if (cur == reordered.size() / 2) {
                thresholdAtMedian = val;
            }
            if (cur == minHighCapacityPeers - 1) {
                thresholdAtMinHighCap = val;
            }
            if (cur == reordered.size() - 1) {
                thresholdAtLowest = val;
            }
            ++cur;
        }
        if (numExceedingMean >= minHighCapacityPeers) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity is doing well [" + meanCapacity + "], and includes " + numExceedingMean);
            }
            this._thresholdCapacityValue = meanCapacity;
        } else if (meanCapacity > thresholdAtMedian && reordered.size() / 2 > minHighCapacityPeers) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity [" + meanCapacity + "] is greater than the median, so threshold is that reqd to get the min high cap peers " + thresholdAtMinHighCap);
            }
            this._thresholdCapacityValue = thresholdAtMinHighCap;
        } else if (reordered.size() / 2 >= minHighCapacityPeers) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity [" + meanCapacity + "] is skewed under the median, so use the median threshold " + thresholdAtMedian);
            }
            this._thresholdCapacityValue = thresholdAtMedian;
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity is doing well [" + meanCapacity + "], but there aren't enough of them " + numExceedingMean);
            }
            this._thresholdCapacityValue = Math.max(thresholdAtMinHighCap, thresholdAtLowest);
        }
        if (this._thresholdCapacityValue <= 5.0) {
            this._thresholdCapacityValue = 5.0001;
        }
    }

    private void locked_calculateSpeedThreshold(Set<PeerProfile> reordered) {
        this.locked_calculateSpeedThresholdMean(reordered);
    }

    private void locked_calculateSpeedThresholdMean(Set<PeerProfile> reordered) {
        double total = 0.0;
        int count = 0;
        int maxHighCapPeers = this.getMaximumHighCapPeers();
        for (PeerProfile profile : reordered) {
            if (!((double)profile.getCapacityValue() >= this._thresholdCapacityValue)) break;
            total += (double)profile.getSpeedValue();
            if (++count < maxHighCapPeers) continue;
            break;
        }
        if (count > 0) {
            this._thresholdSpeedValue = total / (double)count;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Threshold value for speed: " + this._thresholdSpeedValue + " out of speeds: " + count);
        }
    }

    private static final double avg(double total, double quantity) {
        if (total > 0.0 && quantity > 0.0) {
            return total / quantity;
        }
        return 0.0;
    }

    private PeerProfile locked_getProfile(Hash peer) {
        PeerProfile cur = this._notFailingPeers.get(peer);
        if (cur != null) {
            return cur;
        }
        cur = this._failingPeers.get(peer);
        return cur;
    }

    private void locked_selectPeers(Map<Hash, PeerProfile> peers, int howMany, Set<Hash> toExclude, Set<Hash> matches) {
        this.locked_selectPeers(peers, howMany, toExclude, matches, 0, null);
    }

    private void locked_selectPeers(Map<Hash, PeerProfile> peers, int howMany, Set<Hash> toExclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        ArrayList<Hash> all = new ArrayList<Hash>(peers.keySet());
        RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
        while (matches.size() < howMany && iter.hasNext()) {
            Hash peer = (Hash)iter.next();
            if (toExclude != null && toExclude.contains(peer) || matches.contains(peer) || this._us.equals(peer)) continue;
            boolean ok = this.isSelectable(peer);
            if (ok) {
                boolean bl = ok = mask <= 0 || this.notRestricted(peer, ipSet, mask);
                if (!ok && this._log.shouldWarn()) {
                    this._log.warn("IP restriction prevents " + peer + " from joining " + matches);
                }
            }
            if (ok) {
                matches.add(peer);
                continue;
            }
            matches.remove(peer);
        }
    }

    private boolean notRestricted(Hash peer, MaskedIPSet ipSet, int mask) {
        MaskedIPSet peerIPs = new MaskedIPSet(this._context, peer, mask);
        if (!ipSet.isEmpty() && ipSet.containsAny(peerIPs)) {
            return false;
        }
        ipSet.addAll(peerIPs);
        return true;
    }

    private void locked_selectPeers(Map<Hash, PeerProfile> peers, int howMany, Set<Hash> toExclude, Set<Hash> matches, SessionKey randomKey, Slice subTierMode, int mask, MaskedIPSet ipSet) {
        ArrayList<Hash> all = new ArrayList<Hash>(peers.keySet());
        byte[] rk = randomKey.getData();
        long k0 = DataHelper.fromLong8(rk, 0);
        long k1 = DataHelper.fromLong8(rk, 8);
        RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
        while (matches.size() < howMany && iter.hasNext()) {
            int subTier;
            Hash peer = (Hash)iter.next();
            if (toExclude != null && toExclude.contains(peer) || matches.contains(peer) || this._us.equals(peer) || ((subTier = this.getSubTier(peer, k0, k1)) & subTierMode.mask) != subTierMode.val) continue;
            boolean ok = this.isSelectable(peer);
            if (ok) {
                boolean bl = ok = mask <= 0 || this.notRestricted(peer, ipSet, mask);
                if (!ok && this._log.shouldWarn()) {
                    this._log.warn("IP restriction prevents " + peer + " from joining " + matches);
                }
            }
            if (ok) {
                matches.add(peer);
                continue;
            }
            matches.remove(peer);
        }
    }

    private int getSubTier(Hash peer, long k0, long k1) {
        return (int)SipHashInline.hash24(k0, k1, peer.getData()) & 3;
    }

    public boolean isSelectable(Hash peer) {
        NetworkDatabaseFacade netDb = this._context.netDb();
        if (netDb == null) {
            return true;
        }
        if (this._context.router() == null) {
            return true;
        }
        if (this._context.banlist() != null && this._context.banlist().isBanlisted(peer)) {
            return false;
        }
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (null != info) {
            if (info.isHidden()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Peer " + peer.toBase64() + " is marked as hidden, disallowing its use");
                }
                return false;
            }
            boolean exclude = TunnelPeerSelector.shouldExclude(this._context, info);
            return !exclude;
        }
        return false;
    }

    private void locked_placeProfile(PeerProfile profile) {
        Hash peer = profile.getPeer();
        if (profile.getIsFailing()) {
            if (!this.shouldDrop(profile)) {
                this._failingPeers.put(peer, profile);
            }
            this._fastPeers.remove(peer);
            this._highCapacityPeers.remove(peer);
            this._wellIntegratedPeers.remove(peer);
            this._notFailingPeers.remove(peer);
            this._notFailingPeersList.remove(peer);
        } else {
            this._failingPeers.remove(peer);
            this._fastPeers.remove(peer);
            this._highCapacityPeers.remove(peer);
            this._wellIntegratedPeers.remove(peer);
            this._notFailingPeers.put(peer, profile);
            this._notFailingPeersList.add(peer);
            if (this._thresholdCapacityValue <= (double)profile.getCapacityValue() && this.isSelectable(peer) && (this._context.commSystem() == null || !this._context.commSystem().isInStrictCountry(peer))) {
                this._highCapacityPeers.put(peer, profile);
                if (this._log.shouldLog(10)) {
                    this._log.debug("High capacity: \t" + peer);
                }
                if (this._thresholdSpeedValue <= (double)profile.getSpeedValue()) {
                    if (!profile.getIsActive()) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Skipping fast mark [!active] for " + peer);
                        }
                    } else {
                        this._fastPeers.put(peer, profile);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Fast: \t" + peer);
                        }
                    }
                }
            }
            if (this._thresholdIntegrationValue <= (double)profile.getIntegrationValue()) {
                this._wellIntegratedPeers.put(peer, profile);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Integrated: \t" + peer);
                }
            }
        }
    }

    private boolean shouldDrop(PeerProfile profile) {
        return false;
    }

    protected int getMinimumFastPeers() {
        ClientManagerFacade cm = this._context.clientManager();
        if (cm == null) {
            return 40;
        }
        int def = Math.min(40, 6 * cm.listClients().size() + 8 - 2);
        return this._context.getProperty(PROP_MINIMUM_FAST_PEERS, def);
    }

    protected int getMaximumFastPeers() {
        return 75;
    }

    protected int getMaximumHighCapPeers() {
        return 150;
    }

    protected int getMinimumHighCapacityPeers() {
        return this._context.getProperty(PROP_MINIMUM_HIGH_CAPACITY_PEERS, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: profileorganizer file.txt.gz [file2.txt.gz] ...");
            System.exit(1);
        }
        RouterContext ctx = new RouterContext(null);
        ProfileOrganizer organizer = new ProfileOrganizer(ctx);
        organizer.setUs(Hash.FAKE_HASH);
        ProfilePersistenceHelper helper = new ProfilePersistenceHelper(ctx);
        for (int i = 0; i < args.length; ++i) {
            PeerProfile profile = helper.readProfile(new File(args[i]));
            if (profile == null) {
                System.err.println("Could not load profile " + args[i]);
                continue;
            }
            organizer.addProfile(profile);
        }
        organizer.reorganize();
        DecimalFormat fmt = new DecimalFormat("0000.0");
        for (Hash peer : organizer.selectAllPeers()) {
            PeerProfile profile = organizer.getProfile(peer);
            if (!profile.getIsActive()) {
                System.out.println("Peer " + peer.toBase64().substring(0, 4) + " [" + (organizer.isFast(peer) ? "IF+R" : (organizer.isHighCapacity(peer) ? "IR  " : (organizer.isFailing(peer) ? "IX  " : "I   "))) + "]:  Speed:\t" + fmt.format(profile.getSpeedValue()) + " Capacity:\t" + fmt.format(profile.getCapacityValue()) + " Integration:\t" + fmt.format(profile.getIntegrationValue()) + " Active?\t" + profile.getIsActive() + " Failing?\t" + profile.getIsFailing());
                continue;
            }
            System.out.println("Peer " + peer.toBase64().substring(0, 4) + " [" + (organizer.isFast(peer) ? "F+R " : (organizer.isHighCapacity(peer) ? "R   " : (organizer.isFailing(peer) ? "X   " : "    "))) + "]:  Speed:\t" + fmt.format(profile.getSpeedValue()) + " Capacity:\t" + fmt.format(profile.getCapacityValue()) + " Integration:\t" + fmt.format(profile.getIntegrationValue()) + " Active?\t" + profile.getIsActive() + " Failing?\t" + profile.getIsFailing());
        }
        System.out.println("Thresholds:");
        System.out.println("Speed:       " + ProfileOrganizer.num(organizer.getSpeedThreshold()) + " (" + organizer.countFastPeers() + " fast peers)");
        System.out.println("Capacity:    " + ProfileOrganizer.num(organizer.getCapacityThreshold()) + " (" + organizer.countHighCapacityPeers() + " reliable peers)");
    }

    public static enum Slice {
        SLICE_ALL(0, 0),
        SLICE_0_1(2, 0),
        SLICE_2_3(2, 2),
        SLICE_0(3, 0),
        SLICE_1(3, 1),
        SLICE_2(3, 2),
        SLICE_3(3, 3);

        final int mask;
        final int val;

        private Slice(int mask, int val) {
            this.mask = mask;
            this.val = val;
        }
    }
}

