/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLException;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.ConnThrottler;
import net.i2p.i2ptunnel.HTTPResponseOutputStream;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class I2PTunnelHTTPServer
extends I2PTunnelServer {
    public static final String OPT_POST_WINDOW = "postCheckTime";
    public static final String OPT_POST_BAN_TIME = "postBanTime";
    public static final String OPT_POST_TOTAL_BAN_TIME = "postTotalBanTime";
    public static final String OPT_POST_MAX = "maxPosts";
    public static final String OPT_POST_TOTAL_MAX = "maxTotalPosts";
    public static final String OPT_REJECT_INPROXY = "rejectInproxy";
    public static final String OPT_REJECT_REFERER = "rejectReferer";
    public static final String OPT_REJECT_USER_AGENTS = "rejectUserAgents";
    public static final String OPT_USER_AGENTS = "userAgentRejectList";
    public static final int DEFAULT_POST_WINDOW = 300;
    public static final int DEFAULT_POST_BAN_TIME = 1200;
    public static final int DEFAULT_POST_TOTAL_BAN_TIME = 600;
    public static final int DEFAULT_POST_MAX = 6;
    public static final int DEFAULT_POST_TOTAL_MAX = 20;
    private String _spoofHost;
    private static final String HASH_HEADER = "X-I2P-DestHash";
    private static final String DEST64_HEADER = "X-I2P-DestB64";
    private static final String DEST32_HEADER = "X-I2P-DestB32";
    private static final String[] CLIENT_SKIPHEADERS = new String[]{"X-I2P-DestHash".toLowerCase(Locale.US), "X-I2P-DestB64".toLowerCase(Locale.US), "X-I2P-DestB32".toLowerCase(Locale.US)};
    private static final String DATE_HEADER = "date";
    private static final String SERVER_HEADER = "server";
    private static final String X_POWERED_BY_HEADER = "x-powered-by";
    private static final String X_RUNTIME_HEADER = "x-runtime";
    private static final String PROXY_HEADER = "proxy";
    private static final String[] SERVER_SKIPHEADERS = new String[]{"date", "server", "x-powered-by", "x-runtime", "proxy"};
    private static final long HEADER_TIMEOUT = 15000L;
    private static final long TOTAL_HEADER_TIMEOUT = 30000L;
    private static final long START_INTERVAL = 180000L;
    private static final int MAX_LINE_LENGTH = 8192;
    private static final int MAX_HEADERS = 60;
    private static final int MAX_TOTAL_HEADER_SIZE = 32768;
    private static final long DEFAULT_HTTP_READ_TIMEOUT = -1L;
    private static final int SERVER_READ_TIMEOUT_GET = 300000;
    private static final int SERVER_READ_TIMEOUT_POST = 14400000;
    private long _startedOn = 0L;
    private ConnThrottler _postThrottler;
    private static final String ERR_UNAVAILABLE = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>503 Service Unavailable</title></head>\n<body><h2>503 Service Unavailable</h2>\n<p>This I2P website is unavailable. It may be down or undergoing maintenance.</p>\n</body></html>";
    private static final String ERR_DENIED = "HTTP/1.1 429 Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>429 Denied</title></head>\n<body><h2>429 Denied</h2>\n<p>Denied due to excessive requests. Please try again later.</p>\n</body></html>";
    private static final String ERR_INPROXY = "HTTP/1.1 403 Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>403 Denied</title></head>\n<body><h2>403 Denied</h2>\n<p>Inproxy access denied. You must run <a href=\"https://geti2p.net/\">I2P</a> to access this site.</p>\n</body></html>";
    private static final String ERR_SSL = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>503 Service Unavailable</title></head>\n<body><h2>503 Service Unavailable</h2>\n<p>This I2P website is not configured for SSL.</p>\n</body></html>";
    private static final String ERR_REQUEST_URI_TOO_LONG = "HTTP/1.1 414 Request URI too long\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>414 Request URI Too Long</title></head>\n<body><h2>414 Request URI too long</h2>\n</body></html>";
    private static final String ERR_HEADERS_TOO_LARGE = "HTTP/1.1 431 Request header fields too large\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>431 Request Header Fields Too Large</title></head>\n<body><h2>431 Request header fields too large</h2>\n</body></html>";
    protected static final String ERR_REQUEST_TIMEOUT = "HTTP/1.1 408 Request timeout\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>408 Request Timeout</title></head>\n<body><h2>408 Request timeout</h2>\n</body></html>";
    private static final String ERR_BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>400 Bad Request</title></head>\n<body><h2>400 Bad request</h2>\n</body></html>";
    private static final int MIN_TO_COMPRESS = 1300;

    public I2PTunnelHTTPServer(InetAddress host, int port, String privData, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, File privkey, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privkey, privkeyname, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, InputStream privData, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, privkeyname, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    private void setupI2PTunnelHTTPServer(String spoofHost) {
        this._spoofHost = spoofHost != null && spoofHost.trim().length() > 0 ? spoofHost.trim() : null;
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpserver.blockingHandleTime", "how long the blocking handle takes to complete", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L, 10800000L});
        this.readTimeout = -1L;
    }

    @Override
    public void startRunning() {
        super.startRunning();
        this._startedOn = this.getTunnel().getContext().clock().now();
        this.setupPostThrottle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPostThrottle() {
        int pp = this.getIntOption(OPT_POST_MAX, 0);
        int pt = this.getIntOption(OPT_POST_TOTAL_MAX, 0);
        I2PTunnelHTTPServer i2PTunnelHTTPServer = this;
        synchronized (i2PTunnelHTTPServer) {
            if (pp != 0 || pt != 0 || this._postThrottler != null) {
                long pw = 1000L * (long)this.getIntOption(OPT_POST_WINDOW, 300);
                long pb = 1000L * (long)this.getIntOption(OPT_POST_BAN_TIME, 1200);
                long px = 1000L * (long)this.getIntOption(OPT_POST_TOTAL_BAN_TIME, 600);
                if (this._postThrottler == null) {
                    this._postThrottler = new ConnThrottler(pp, pt, pw, pb, px, "POST/PUT", this._log);
                } else {
                    this._postThrottler.updateLimits(pp, pt, pw, pb, px);
                }
                this._postThrottler.start();
            }
        }
    }

    private int getIntOption(String opt, int dflt) {
        Properties opts = this.getTunnel().getClientOptions();
        String o = opts.getProperty(opt);
        if (o != null) {
            try {
                return Integer.parseInt(o);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dflt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean forced) {
        I2PTunnelHTTPServer i2PTunnelHTTPServer = this;
        synchronized (i2PTunnelHTTPServer) {
            if (this._postThrottler != null) {
                this._postThrottler.stop();
            }
        }
        return super.close(forced);
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        if (this.getTunnel() != tunnel) {
            return;
        }
        this.setupPostThrottle();
        Properties props = tunnel.getClientOptions();
        String spoofHost = props.getProperty("spoofedHost");
        this._spoofHost = spoofHost != null && spoofHost.trim().length() > 0 ? spoofHost.trim() : null;
        super.optionsUpdated(tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blockingHandle(I2PSocket socket) {
        block150: {
            Hash peerHash = socket.getPeerDestination().calculateHash();
            String peerB32 = socket.getPeerDestination().toBase32();
            if (this._log.shouldLog(20)) {
                this._log.info("Incoming connection to '" + this.toString() + "' port " + socket.getLocalPort() + " from: " + peerB32 + " port " + socket.getPort());
            }
            try {
                boolean useGZIP;
                String conn;
                String portSpoof;
                String referer;
                List<String> h;
                Map<String, List<String>> headers;
                if (socket.getLocalPort() == 443) {
                    if (this.getTunnel().getClientOptions().getProperty("targetForPort.443") == null) {
                        try {
                            socket.getOutputStream().write(ERR_SSL.getBytes("UTF-8"));
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return;
                    }
                    Socket s = this.getSocket(socket.getPeerDestination().calculateHash(), 443);
                    I2PTunnelRunner t = new I2PTunnelRunner(s, socket, this.slock, null, null, null, (I2PTunnelRunner.FailCallback)null);
                    this._clientExecutor.execute(t);
                    return;
                }
                long afterAccept = this.getTunnel().getContext().clock().now();
                StringBuilder command = new StringBuilder(128);
                try {
                    headers = I2PTunnelHTTPServer.readHeaders(socket, null, command, CLIENT_SKIPHEADERS, this.getTunnel().getContext());
                }
                catch (SocketTimeoutException ste) {
                    try {
                        socket.getOutputStream().write(ERR_REQUEST_TIMEOUT.getBytes("UTF-8"));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error in the HTTP request from " + peerB32, ste);
                    }
                    return;
                }
                catch (EOFException eofe) {
                    try {
                        socket.getOutputStream().write(ERR_BAD_REQUEST.getBytes("UTF-8"));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error in the HTTP request from " + peerB32, eofe);
                    }
                    return;
                }
                catch (LineTooLongException ltle) {
                    try {
                        socket.getOutputStream().write(ERR_HEADERS_TOO_LARGE.getBytes("UTF-8"));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error in the HTTP request from " + peerB32, ltle);
                    }
                    return;
                }
                catch (RequestTooLongException rtle) {
                    try {
                        socket.getOutputStream().write(ERR_REQUEST_URI_TOO_LONG.getBytes("UTF-8"));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error in the HTTP request from " + peerB32, rtle);
                    }
                    return;
                }
                catch (BadRequestException bre) {
                    try {
                        socket.getOutputStream().write(ERR_BAD_REQUEST.getBytes("UTF-8"));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error in the HTTP request from " + peerB32, bre);
                    }
                    return;
                }
                long afterHeaders = this.getTunnel().getContext().clock().now();
                Properties opts = this.getTunnel().getClientOptions();
                if (Boolean.parseBoolean(opts.getProperty(OPT_REJECT_INPROXY)) && (headers.containsKey("X-Forwarded-For") || headers.containsKey("X-Forwarded-Server") || headers.containsKey("Forwarded") || headers.containsKey("X-Forwarded-Host"))) {
                    if (this._log.shouldLog(30)) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("Refusing inproxy access: ").append(peerB32);
                        List<String> h2 = headers.get("X-Forwarded-For");
                        if (h2 != null) {
                            buf.append(" from: ").append(h2.get(0));
                        }
                        if ((h2 = headers.get("X-Forwarded-Server")) != null) {
                            buf.append(" via: ").append(h2.get(0));
                        }
                        if ((h2 = headers.get("X-Forwarded-Host")) != null) {
                            buf.append(" for: ").append(h2.get(0));
                        }
                        if ((h2 = headers.get("Forwarded")) != null) {
                            buf.append(h2.get(0));
                        }
                        this._log.warn(buf.toString());
                    }
                    try {
                        socket.getOutputStream().write(ERR_INPROXY.getBytes("UTF-8"));
                    }
                    catch (IOException buf) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException buf) {
                        // empty catch block
                    }
                    return;
                }
                if (Boolean.parseBoolean(opts.getProperty(OPT_REJECT_REFERER)) && (h = headers.get("Referer")) != null && (referer = h.get(0)).length() > 9 && ((referer = referer.substring(9)).startsWith("http://") || referer.startsWith("https://"))) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Refusing access from: " + peerB32 + " with Referer: " + referer);
                    }
                    try {
                        socket.getOutputStream().write(ERR_INPROXY.getBytes("UTF-8"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                if (Boolean.parseBoolean(opts.getProperty(OPT_REJECT_USER_AGENTS))) {
                    if (headers.containsKey("User-Agent")) {
                        String blockAgents;
                        String ua = headers.get("User-Agent").get(0);
                        if (!ua.startsWith("MYOB") && (blockAgents = opts.getProperty(OPT_USER_AGENTS)) != null) {
                            String[] agents = DataHelper.split(blockAgents, ",");
                            for (int i = 0; i < agents.length; ++i) {
                                String ag2 = agents[i].trim();
                                if (ag2.equals("none") || ag2.length() <= 0 || !ua.contains(ag2)) continue;
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Refusing access from: " + peerB32 + " with User-Agent: " + ua);
                                }
                                try {
                                    socket.getOutputStream().write(ERR_INPROXY.getBytes("UTF-8"));
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                    } else {
                        String blockAgents = opts.getProperty(OPT_USER_AGENTS);
                        if (blockAgents != null) {
                            String[] agents = DataHelper.split(blockAgents, ",");
                            for (int i = 0; i < agents.length; ++i) {
                                String ag = agents[i].trim();
                                if (!ag.equals("none")) continue;
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Refusing access from: " + peerB32 + " with empty User-Agent");
                                }
                                try {
                                    socket.getOutputStream().write(ERR_INPROXY.getBytes("UTF-8"));
                                }
                                catch (IOException ag2) {
                                    // empty catch block
                                }
                                try {
                                    socket.close();
                                }
                                catch (IOException ag2) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                    }
                }
                if (this._postThrottler != null && command.length() >= 5 && (command.substring(0, 5).toUpperCase(Locale.US).equals("POST ") || command.substring(0, 4).toUpperCase(Locale.US).equals("PUT ")) && this._postThrottler.shouldThrottle(peerHash)) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Refusing POST/PUT since peer is throttled: " + peerB32);
                    }
                    try {
                        socket.getOutputStream().write(ERR_DENIED.getBytes("UTF-8"));
                    }
                    catch (IOException blockAgents) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException blockAgents) {
                        // empty catch block
                    }
                    return;
                }
                I2PTunnelHTTPServer.addEntry(headers, HASH_HEADER, peerHash.toBase64());
                I2PTunnelHTTPServer.addEntry(headers, DEST32_HEADER, peerB32);
                I2PTunnelHTTPServer.addEntry(headers, DEST64_HEADER, socket.getPeerDestination().toBase64());
                int ourPort = socket.getLocalPort();
                String spoofHost = ourPort != 80 && ourPort > 0 && ourPort <= 65535 ? ((portSpoof = opts.getProperty("spoofedHost." + ourPort)) != null ? portSpoof.trim() : this._spoofHost) : this._spoofHost;
                if (spoofHost != null) {
                    I2PTunnelHTTPServer.setEntry(headers, "Host", spoofHost);
                }
                if ((conn = I2PTunnelHTTPServer.getEntryOrNull(headers, "Connection")) == null || !conn.toLowerCase(Locale.US).contains("upgrade")) {
                    I2PTunnelHTTPServer.setEntry(headers, "Connection", "close");
                }
                String enc = I2PTunnelHTTPServer.getEntryOrNull(headers, "Accept-Encoding");
                String altEnc = I2PTunnelHTTPServer.getEntryOrNull(headers, "X-Accept-Encoding");
                socket.setReadTimeout(this.readTimeout);
                Socket s = this.getSocket(socket.getPeerDestination().calculateHash(), socket.getLocalPort());
                long afterSocket = this.getTunnel().getContext().clock().now();
                boolean allowGZIP = true;
                String val = opts.getProperty("i2ptunnel.gzip");
                if (val != null && !Boolean.parseBoolean(val)) {
                    allowGZIP = false;
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("HTTP server encoding header: " + enc + "/" + altEnc);
                }
                boolean alt = altEnc != null && altEnc.indexOf("x-i2p-gzip") >= 0;
                boolean bl = useGZIP = alt || enc != null && enc.indexOf("x-i2p-gzip") >= 0;
                if (alt) {
                    headers.remove("X-Accept-Encoding");
                }
                String modifiedHeader = I2PTunnelHTTPServer.formatHeaders(headers, command);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Modified header: [" + modifiedHeader + "]");
                }
                if (modifiedHeader.startsWith("GET ") || modifiedHeader.startsWith("HEAD ")) {
                    s.setSoTimeout(300000);
                } else {
                    s.setSoTimeout(14400000);
                }
                boolean compress = allowGZIP && useGZIP;
                CompressedRequestor t = new CompressedRequestor(s, socket, modifiedHeader, this.getTunnel().getContext(), this._log, compress);
                this._clientExecutor.execute(t);
                long afterHandle = this.getTunnel().getContext().clock().now();
                long timeToHandle = afterHandle - afterAccept;
                this.getTunnel().getContext().statManager().addRateData("i2ptunnel.httpserver.blockingHandleTime", timeToHandle);
                if (timeToHandle > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("Took a while to handle the request for " + this.remoteHost + ':' + this.remotePort + " from: " + peerB32 + " [" + timeToHandle + ", read headers: " + (afterHeaders - afterAccept) + ", socket create: " + (afterSocket - afterHeaders) + ", start runners: " + (afterHandle - afterSocket) + "]");
                }
            }
            catch (SocketException ex) {
                int level;
                try {
                    socket.getOutputStream().write(ERR_UNAVAILABLE.getBytes("UTF-8"));
                }
                catch (IOException t) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException t) {
                    // empty catch block
                }
                int n = level = this.getTunnel().getContext().clock().now() - this._startedOn > 180000L ? 40 : 30;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "Error connecting to HTTP server " + this.remoteHost + ':' + this.remotePort, ex);
                }
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error in the HTTP request from: " + peerB32, ex);
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    socket.getOutputStream().write(ERR_UNAVAILABLE.getBytes("UTF-8"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this._log.shouldLog(40)) break block150;
                this._log.error("OOM in HTTP server", oom);
            }
        }
    }

    protected static String formatHeaders(Map<String, List<String>> headers, StringBuilder command) {
        StringBuilder buf = new StringBuilder(command.length() + headers.size() * 64);
        buf.append(command.toString().trim()).append("\r\n");
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String name = e.getKey();
            for (String val : e.getValue()) {
                buf.append(name.trim()).append(": ").append(val.trim()).append("\r\n");
            }
        }
        buf.append("\r\n");
        return buf.toString();
    }

    private static void addEntry(Map<String, List<String>> headers, String key, String value) {
        List<String> entry = headers.get(key);
        if (entry == null) {
            entry = new ArrayList<String>(1);
            headers.put(key, entry);
        }
        entry.add(value);
    }

    private static void setEntry(Map<String, List<String>> headers, String key, String value) {
        List<String> entry = headers.get(key);
        if (entry == null) {
            entry = new ArrayList<String>(1);
            headers.put(key, entry);
        } else {
            entry.clear();
        }
        entry.add(value);
    }

    private static String getEntryOrNull(Map<String, List<String>> headers, String key) {
        List<String> entries = headers.get(key);
        if (entries == null || entries.size() < 1) {
            return null;
        }
        return entries.get(0);
    }

    static Map<String, List<String>> readHeaders(I2PSocket socket, InputStream in, StringBuilder command, String[] skipHeaders, I2PAppContext ctx) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        StringBuilder buf = new StringBuilder(128);
        long expire = ctx.clock().now() + 30000L;
        if (socket != null) {
            try {
                I2PTunnelHTTPServer.readLine(socket, command, 15000L);
            }
            catch (LineTooLongException ltle) {
                throw new RequestTooLongException("Request too long - max 8192");
            }
        } else {
            boolean ok = DataHelper.readLine(in, command);
            if (!ok) {
                throw new EOFException("EOF reached before the end of the headers");
            }
        }
        int totalSize = command.length();
        int i = 0;
        while (true) {
            if (++i > 60) {
                throw new LineTooLongException("Too many header lines - max 60");
            }
            buf.setLength(0);
            if (socket != null) {
                I2PTunnelHTTPServer.readLine(socket, buf, expire - ctx.clock().now());
            } else {
                boolean ok = DataHelper.readLine(in, buf);
                if (!ok) {
                    throw new BadRequestException("EOF reached before the end of the headers");
                }
            }
            if (buf.length() == 0 || buf.charAt(0) == '\n' || buf.charAt(0) == '\r') {
                return headers;
            }
            if (ctx.clock().now() > expire) {
                throw new SocketTimeoutException("Headers took too long");
            }
            int split = buf.indexOf(":");
            if (split <= 0) {
                throw new BadRequestException("Invalid HTTP header, missing colon: \"" + buf + "\" request: \"" + command + '\"');
            }
            if ((totalSize += buf.length()) > 32768) {
                throw new LineTooLongException("Req+headers too big");
            }
            String name = buf.substring(0, split).trim();
            String value = null;
            value = buf.length() > split + 1 ? buf.substring(split + 1).trim() : "";
            String lcName = name.toLowerCase(Locale.US);
            if ("accept-encoding".equals(lcName)) {
                name = "Accept-Encoding";
            } else if ("x-accept-encoding".equals(lcName)) {
                name = "X-Accept-Encoding";
            } else if ("x-forwarded-for".equals(lcName)) {
                name = "X-Forwarded-For";
            } else if ("x-forwarded-server".equals(lcName)) {
                name = "X-Forwarded-Server";
            } else if ("x-forwarded-host".equals(lcName)) {
                name = "X-Forwarded-Host";
            } else if ("forwarded".equals(lcName)) {
                name = "Forwarded";
            } else if ("user-agent".equals(lcName)) {
                name = "User-Agent";
            } else if ("referer".equals(lcName)) {
                name = "Referer";
            } else if ("connection".equals(lcName)) {
                name = "Connection";
            }
            boolean skip = false;
            for (String skipHeader : skipHeaders) {
                if (!skipHeader.equals(lcName)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            I2PTunnelHTTPServer.addEntry(headers, name, value);
        }
    }

    private static void readLine(I2PSocket socket, StringBuilder buf, long timeout) throws IOException {
        int c;
        if (timeout <= 0L) {
            throw new SocketTimeoutException();
        }
        long expires = System.currentTimeMillis() + timeout;
        InputStream in = socket.getInputStream();
        int i = 0;
        socket.setReadTimeout(timeout);
        while ((c = in.read()) != -1) {
            if (++i > 8192) {
                throw new LineTooLongException("Line too long - max 8192");
            }
            if (c == 10) break;
            long newTimeout = expires - System.currentTimeMillis();
            if (newTimeout <= 0L) {
                throw new SocketTimeoutException();
            }
            buf.append((char)c);
            if (newTimeout == timeout) continue;
            timeout = newTimeout;
            socket.setReadTimeout(timeout);
        }
        if (c == -1) {
            if (System.currentTimeMillis() >= expires) {
                throw new SocketTimeoutException();
            }
            throw new EOFException();
        }
    }

    private static class BadRequestException
    extends IOException {
        public BadRequestException(String s) {
            super(s);
        }
    }

    private static class CompressedRequestor
    implements Runnable {
        private final Socket _webserver;
        private final I2PSocket _browser;
        private final String _headers;
        private final I2PAppContext _ctx;
        private final Log _log;
        private final boolean _shouldCompress;
        private static final int BUF_SIZE = 8192;

        public CompressedRequestor(Socket webserver, I2PSocket browser, String headers, I2PAppContext ctx, Log log, boolean shouldCompress) {
            this._webserver = webserver;
            this._browser = browser;
            this._headers = headers;
            this._ctx = ctx;
            this._log = log;
            this._shouldCompress = shouldCompress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            InputStream serverin;
            InputStream browserin;
            OutputStream browserout;
            OutputStream serverout;
            block133: {
                boolean i2pReset;
                serverout = null;
                browserout = null;
                browserin = null;
                serverin = null;
                Sender s = null;
                IOException ioex = null;
                try {
                    serverout = this._webserver.getOutputStream();
                    if (this._log.shouldLog(20)) {
                        this._log.info("request headers: " + this._headers);
                    }
                    serverout.write(DataHelper.getUTF8(this._headers));
                    browserin = this._browser.getInputStream();
                    if (!this._headers.startsWith("GET ") && !this._headers.startsWith("HEAD ") || browserin.available() > 0) {
                        I2PAppThread sender = new I2PAppThread(new Sender(serverout, browserin, "server: browser to server", this._log), Thread.currentThread().getName() + "hcs");
                        sender.start();
                    }
                    browserout = this._browser.getOutputStream();
                    try {
                        serverin = new BufferedInputStream(this._webserver.getInputStream(), 8192);
                    }
                    catch (NullPointerException npe) {
                        throw new IOException("getInputStream NPE");
                    }
                    StringBuilder command = new StringBuilder(128);
                    Map<String, List<String>> headers = I2PTunnelHTTPServer.readHeaders(null, serverin, command, SERVER_SKIPHEADERS, this._ctx);
                    String modifiedHeaders = I2PTunnelHTTPServer.formatHeaders(headers, command);
                    if (this._shouldCompress) {
                        CompressedResponseOutputStream compressedOut = new CompressedResponseOutputStream(browserout);
                        compressedOut.write(DataHelper.getUTF8(modifiedHeaders));
                        s = new Sender(compressedOut, serverin, "server: server to browser compressor", this._log);
                    } else {
                        browserout.write(DataHelper.getUTF8(modifiedHeaders));
                        s = new Sender(browserout, serverin, "server: server to browser uncompressed", this._log);
                    }
                    s.run();
                    if (ioex == null && s != null) {
                        ioex = s.getFailure();
                    }
                    if (ioex == null) break block133;
                    i2pReset = false;
                }
                catch (SSLException she) {
                    block134: {
                        this._log.error("SSL error", she);
                        try {
                            if (browserout == null) {
                                browserout = this._browser.getOutputStream();
                            }
                            browserout.write(I2PTunnelHTTPServer.ERR_UNAVAILABLE.getBytes("UTF-8"));
                        }
                        catch (IOException msg) {
                            // empty catch block
                        }
                        if (ioex == null && s != null) {
                            ioex = s.getFailure();
                        }
                        if (ioex == null) break block134;
                        boolean i2pReset2 = false;
                        if (ioex instanceof I2PSocketException) {
                            I2PSocketException ise = (I2PSocketException)ioex;
                            int status = ise.getStatus();
                            boolean bl = i2pReset2 = status == 512;
                            if (i2pReset2) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Server got I2P reset, resetting socket", ioex);
                                }
                                try {
                                    this._webserver.setSoLinger(true, 0);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this._webserver.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this._browser.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!i2pReset2 && ioex instanceof SocketException) {
                            boolean sockReset;
                            String msg = ioex.getMessage();
                            boolean bl = sockReset = msg != null && msg.contains("reset");
                            if (sockReset) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Server got socket reset, resetting I2P socket");
                                }
                                try {
                                    this._browser.reset();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this._webserver.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (browserout != null) {
                        try {
                            browserout.close();
                        }
                        catch (IOException i2pReset2) {
                            // empty catch block
                        }
                    }
                    if (serverout != null) {
                        try {
                            serverout.close();
                        }
                        catch (IOException i2pReset2) {
                            // empty catch block
                        }
                    }
                    if (browserin != null) {
                        try {
                            browserin.close();
                        }
                        catch (IOException i2pReset2) {
                            // empty catch block
                        }
                    }
                    if (serverin != null) {
                        try {
                            serverin.close();
                        }
                        catch (IOException i2pReset2) {}
                    }
                }
                catch (IOException ioe) {
                    block135: {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("error compressing", ioe);
                        }
                        if ((ioex = ioe) == null && s != null) {
                            ioex = s.getFailure();
                        }
                        if (ioex == null) break block135;
                        boolean i2pReset3 = false;
                        {
                            catch (Throwable throwable) {
                                if (ioex == null && s != null) {
                                    ioex = s.getFailure();
                                }
                                if (ioex != null) {
                                    boolean i2pReset4 = false;
                                    if (ioex instanceof I2PSocketException) {
                                        I2PSocketException ise = (I2PSocketException)ioex;
                                        int status = ise.getStatus();
                                        boolean bl = i2pReset4 = status == 512;
                                        if (i2pReset4) {
                                            if (this._log.shouldWarn()) {
                                                this._log.warn("Server got I2P reset, resetting socket", ioex);
                                            }
                                            try {
                                                this._webserver.setSoLinger(true, 0);
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            try {
                                                this._webserver.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            try {
                                                this._browser.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (!i2pReset4 && ioex instanceof SocketException) {
                                        boolean sockReset;
                                        String msg = ioex.getMessage();
                                        boolean bl = sockReset = msg != null && msg.contains("reset");
                                        if (sockReset) {
                                            if (this._log.shouldWarn()) {
                                                this._log.warn("Server got socket reset, resetting I2P socket");
                                            }
                                            try {
                                                this._browser.reset();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            try {
                                                this._webserver.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                                if (browserout != null) {
                                    try {
                                        browserout.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (serverout != null) {
                                    try {
                                        serverout.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (browserin != null) {
                                    try {
                                        browserin.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (serverin != null) {
                                    try {
                                        serverin.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                        }
                        if (ioex instanceof I2PSocketException) {
                            I2PSocketException ise = (I2PSocketException)ioex;
                            int status = ise.getStatus();
                            boolean bl = i2pReset3 = status == 512;
                            if (i2pReset3) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Server got I2P reset, resetting socket", ioex);
                                }
                                try {
                                    this._webserver.setSoLinger(true, 0);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this._webserver.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this._browser.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!i2pReset3 && ioex instanceof SocketException) {
                            boolean sockReset;
                            String msg = ioex.getMessage();
                            boolean bl = sockReset = msg != null && msg.contains("reset");
                            if (sockReset) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Server got socket reset, resetting I2P socket");
                                }
                                try {
                                    this._browser.reset();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this._webserver.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (browserout != null) {
                        try {
                            browserout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (serverout != null) {
                        try {
                            serverout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (browserin != null) {
                        try {
                            browserin.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (serverin != null) {
                        try {
                            serverin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (ioex instanceof I2PSocketException) {
                    I2PSocketException ise = (I2PSocketException)ioex;
                    int status = ise.getStatus();
                    boolean bl = i2pReset = status == 512;
                    if (i2pReset) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Server got I2P reset, resetting socket", ioex);
                        }
                        try {
                            this._webserver.setSoLinger(true, 0);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            this._webserver.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            this._browser.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (!i2pReset && ioex instanceof SocketException) {
                    boolean sockReset;
                    String msg = ioex.getMessage();
                    boolean bl = sockReset = msg != null && msg.contains("reset");
                    if (sockReset) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Server got socket reset, resetting I2P socket");
                        }
                        try {
                            this._browser.reset();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            this._webserver.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (browserout != null) {
                try {
                    browserout.close();
                }
                catch (IOException i2pReset) {
                    // empty catch block
                }
            }
            if (serverout != null) {
                try {
                    serverout.close();
                }
                catch (IOException i2pReset) {
                    // empty catch block
                }
            }
            if (browserin != null) {
                try {
                    browserin.close();
                }
                catch (IOException i2pReset) {
                    // empty catch block
                }
            }
            if (serverin != null) {
                try {
                    serverin.close();
                }
                catch (IOException i2pReset) {}
            }
        }
    }

    private static class CompressedResponseOutputStream
    extends HTTPResponseOutputStream {
        private InternalGZIPOutputStream _gzipOut;

        public CompressedResponseOutputStream(OutputStream o) {
            super(o);
            this._dataExpected = -1L;
        }

        @Override
        protected String filterResponseLine(String line) {
            String[] s = DataHelper.split(line, " ", 3);
            if (s.length > 1 && (s[1].startsWith("3") || s[1].startsWith("5"))) {
                this._dataExpected = 0L;
            }
            return line;
        }

        @Override
        protected boolean shouldCompress() {
            return (this._dataExpected < 0L || this._dataExpected >= 1300L) && this._contentEncoding == null && (this._contentType == null || !this._contentType.startsWith("audio/") && !this._contentType.startsWith("image/") && !this._contentType.startsWith("video/") && !this._contentType.equals("application/compress") && !this._contentType.equals("application/bzip2") && !this._contentType.equals("application/gzip") && !this._contentType.equals("application/x-bzip") && !this._contentType.equals("application/x-bzip2") && !this._contentType.equals("application/x-gzip") && !this._contentType.equals("application/zip"));
        }

        @Override
        protected void finishHeaders() throws IOException {
            if (this.shouldCompress()) {
                this.out.write(DataHelper.getASCII("Content-Encoding: x-i2p-gzip\r\n"));
            }
            super.finishHeaders();
        }

        @Override
        protected void beginProcessing() throws IOException {
            if (this.shouldCompress()) {
                this._gzipOut = new InternalGZIPOutputStream(this.out);
                this.out = this._gzipOut;
            }
        }

        public long getTotalRead() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalRead();
            }
            return 0L;
        }

        public long getTotalCompressed() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalCompressed();
            }
            return 0L;
        }
    }

    private static class InternalGZIPOutputStream
    extends GZIPOutputStream {
        public InternalGZIPOutputStream(OutputStream target) throws IOException {
            super(target);
        }

        public long getTotalRead() {
            try {
                return this.def.getTotalIn();
            }
            catch (RuntimeException e) {
                return 0L;
            }
        }

        public long getTotalCompressed() {
            try {
                return this.def.getTotalOut();
            }
            catch (RuntimeException e) {
                return 0L;
            }
        }
    }

    private static class LineTooLongException
    extends IOException {
        public LineTooLongException(String s) {
            super(s);
        }
    }

    private static class RequestTooLongException
    extends IOException {
        public RequestTooLongException(String s) {
            super(s);
        }
    }

    private static class Sender
    implements Runnable {
        private final OutputStream _out;
        private final InputStream _in;
        private final String _name;
        private final Log _log;
        private IOException _failure;

        public Sender(OutputStream out, InputStream in, String name, Log log) {
            this._out = out;
            this._in = in;
            this._name = name;
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._log.shouldDebug()) {
                this._log.debug(this._name + ": Begin sending");
            }
            try {
                DataHelper.copy(this._in, this._out);
                if (this._log.shouldDebug()) {
                    this._log.debug(this._name + ": Done sending");
                }
            }
            catch (IOException ioe) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this._name + " Error sending", ioe);
                }
                Sender sender = this;
                synchronized (sender) {
                    this._failure = ioe;
                }
            }
            finally {
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this._in != null) {
                    try {
                        this._in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public synchronized IOException getFailure() {
            return this._failure;
        }
    }
}

