/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.TransportUtil;
import net.i2p.util.Addresses;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.Translate;
import org.cybergarage.http.HTTPServer;
import org.cybergarage.http.HTTPServerList;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ActionList;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.ServiceStateTable;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.UPnPStatus;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.event.EventListener;
import org.cybergarage.upnp.ssdp.SSDPNotifySocket;
import org.cybergarage.upnp.ssdp.SSDPNotifySocketList;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.upnp.ssdp.SSDPSearchResponseSocket;
import org.cybergarage.upnp.ssdp.SSDPSearchResponseSocketList;
import org.cybergarage.util.Debug;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

public class UPnP
extends ControlPoint
implements DeviceChangeListener,
EventListener {
    private final Log _log;
    private final I2PAppContext _context;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WAN_IP_CONNECTION = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WAN_PPP_CONNECTION = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private static final String ROUTER_DEVICE_2 = "urn:schemas-upnp-org:device:InternetGatewayDevice:2";
    private static final String WAN_DEVICE_2 = "urn:schemas-upnp-org:device:WANDevice:2";
    private static final String WANCON_DEVICE_2 = "urn:schemas-upnp-org:device:WANConnectionDevice:2";
    private static final String WAN_IP_CONNECTION_2 = "urn:schemas-upnp-org:service:WANIPConnection:2";
    private static final String WAN_IPV6_CONNECTION = "urn:schemas-upnp-org:service:WANIPv6FirewallControl:1";
    public static final int LEASE_TIME_SECONDS = 10800;
    private Device _router;
    private Service _service;
    private Service _service6;
    private final Map<String, Device> _otherUDNs;
    private final Map<String, String> _eventVars;
    private volatile boolean _serviceLacksAPM;
    private volatile boolean _permanentLeasesOnly;
    private final Object lock = new Object();
    private volatile boolean thinksWeAreDoubleNatted = false;
    private final Set<ForwardPort> portsToForward;
    private final Set<ForwardPort> portsForwarded;
    private ForwardPortCallback forwardCallback;
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    private static final String PROP_IGNORE = "i2np.upnp.ignore";
    private static final boolean ALLOW_SAME_HOST = false;
    private String _lastAction;
    private Service _lastService;
    private ArgumentList _lastArgumentList;
    private final Object toStringLock = new Object();
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final AtomicInteger __id = new AtomicInteger();
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public UPnP(I2PAppContext context, int ssdpPort, int httpPort, InetAddress[] binds) {
        super(ssdpPort, httpPort, binds);
        this._context = context;
        this._log = this._context.logManager().getLog(UPnP.class);
        this.portsToForward = new HashSet<ForwardPort>();
        this.portsForwarded = new HashSet<ForwardPort>();
        this._otherUDNs = new HashMap<String, Device>(4);
        this._eventVars = new HashMap<String, String>(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean runPlugin() {
        this.addDeviceChangeListener(this);
        this.addEventListener(this);
        Object object = this.lock;
        synchronized (object) {
            this.portsToForward.clear();
            this.portsForwarded.clear();
            this._eventVars.clear();
        }
        return super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        this.removeDeviceChangeListener(this);
        this.removeEventListener(this);
        Object object = this.lock;
        synchronized (object) {
            this.portsToForward.clear();
            this._eventVars.clear();
        }
        this.unregisterPortMappings();
        int i = 0;
        while (i++ < 20 && !this.portsForwarded.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.stop();
        Object object2 = this.lock;
        synchronized (object2) {
            this._router = null;
            this._service = null;
            this._service6 = null;
            this._serviceLacksAPM = false;
            this._permanentLeasesOnly = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectedIP[] getAddress() {
        Service service;
        this._log.info("UP&P.getAddress() is called \\o/");
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("No UP&P device found, detection of the external ip address using the plugin has failed");
                }
                return null;
            }
            service = this._service;
        }
        String natAddress = this.getNATAddress(service);
        if (natAddress == null || natAddress.length() <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No external address returned");
            }
            return null;
        }
        DetectedIP result = null;
        try {
            InetAddress detectedIP = InetAddress.getByName(natAddress);
            short status = 1;
            boolean bl = this.thinksWeAreDoubleNatted = !TransportUtil.isPubliclyRoutable(detectedIP.getAddress(), false);
            if (this._log.shouldLog(30)) {
                this._log.warn("NATAddress: \"" + natAddress + "\" detectedIP: " + detectedIP + " double? " + this.thinksWeAreDoubleNatted);
            }
            if (this.portsForwarded.size() > 1 && !this.thinksWeAreDoubleNatted) {
                status = 2;
            }
            result = new DetectedIP(detectedIP, status);
            if (this._log.shouldLog(30)) {
                this._log.warn("Successful UP&P discovery :" + result);
            }
            return new DetectedIP[]{result};
        }
        catch (UnknownHostException e) {
            this._log.error("Caught an UnknownHostException resolving " + natAddress, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceAdded(Device dev) {
        byte[] b2;
        byte[] b1;
        boolean v62;
        boolean v61;
        String pktIP;
        SSDPPacket pkt;
        String type;
        if (!dev.hasUDN()) {
            if (this._log.shouldInfo()) {
                this._log.info("Bad device, no UDN");
            }
            return;
        }
        String udn = dev.getUDN();
        String name = dev.getFriendlyName();
        if (name == null) {
            name = udn;
        }
        boolean isIGD = (ROUTER_DEVICE.equals(type = dev.getDeviceType()) || ROUTER_DEVICE_2.equals(type)) && dev.isRootDevice();
        name = name + (isIGD ? " IGD" : ' ' + type);
        String ip = UPnP.getIP(dev);
        if (ip != null) {
            name = name + ' ' + ip;
        }
        if (!isIGD) {
            if (this._log.shouldInfo()) {
                this._log.info("UP&P non-IGD device found, ignoring " + name + ' ' + dev.getDeviceType());
            }
            Object object = this.lock;
            synchronized (object) {
                this._otherUDNs.put(udn, dev);
            }
            return;
        }
        boolean ignore = false;
        String toIgnore = this._context.getProperty(PROP_IGNORE);
        if (toIgnore != null) {
            String[] ignores = DataHelper.split(toIgnore, "[,; \r\n\t]");
            for (int i = 0; i < ignores.length; ++i) {
                if (!ignores[i].equals(udn)) continue;
                ignore = true;
                if (!this._log.shouldWarn()) break;
                this._log.warn("Ignoring by config: " + name + " UDN: " + udn);
                break;
            }
        }
        SortedSet<String> myAddresses = Addresses.getAddresses(true, true);
        if (!ignore && ip != null && myAddresses.contains(ip)) {
            ignore = true;
            if (this._log.shouldWarn()) {
                this._log.warn("Ignoring UPnP on same host: " + name + " UDN: " + udn);
            }
        }
        if (!(ignore || (pkt = dev.getSSDPPacket()) == null || UPnP.stringEquals(ip, pktIP = pkt.getRemoteAddress()) || (v61 = ip.contains(":")) != (v62 = pktIP.contains(":")) || DataHelper.eq(b1 = Addresses.getIP(ip), b2 = Addresses.getIP(pktIP)))) {
            ignore = true;
            if (this._log.shouldWarn()) {
                this._log.warn("Ignoring UPnP with IP mismatch: " + name + " UDN: " + udn + " dev IP " + ip + " pkt IP: " + pktIP);
            }
        }
        List<Service> services = null;
        Service service = null;
        String extIP = null;
        boolean subscriptionFailed = false;
        if (!ignore) {
            services = this.discoverService(dev);
            if (services == null) {
                ignore = true;
            } else {
                service = services.get(0);
                extIP = this.getNATAddress(service);
                if (extIP == null) {
                    boolean ok = this.subscribe(service, 10800L);
                    if (ok) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("UPnP subscribed but ignoring disconnected device " + name + " UDN: " + udn);
                        }
                    } else {
                        subscriptionFailed = true;
                        if (this._log.shouldWarn()) {
                            this._log.warn("Failed subscription to disconnected device " + name + " UDN: " + udn);
                        }
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("UPnP found device " + name + " UDN: " + udn + " with external IP: " + extIP);
                }
            }
        }
        ForwardPortCallback fpc = null;
        HashMap<ForwardPort, ForwardPortStatus> removeMap = null;
        Iterator<Service> iterator = this.lock;
        synchronized (iterator) {
            if (ignore) {
                this._otherUDNs.put(udn, dev);
                return;
            }
            if (this._router != null && this._service != null) {
                if (udn.equals(this._router.getUDN())) {
                    return;
                }
                ignore = true;
                String curIP = null;
                if (extIP != null) {
                    curIP = this.getNATAddress(this._service);
                    if (curIP == null) {
                        ignore = false;
                    } else {
                        byte[] cur = Addresses.getIP(curIP);
                        byte[] ext = Addresses.getIP(extIP);
                        if (cur != null && ext != null && TransportUtil.isPubliclyRoutable(ext, false) && !TransportUtil.isPubliclyRoutable(cur, false)) {
                            ignore = false;
                        }
                    }
                }
                if (ignore) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("UPnP ignoring additional device " + name + " UDN: " + udn);
                    }
                    this._otherUDNs.put(udn, dev);
                    if (!subscriptionFailed) {
                        boolean ok = this.subscribe(service);
                        if (this._log.shouldInfo()) {
                            if (ok) {
                                this._log.info("Subscribed to additional device " + name + " UDN: " + udn);
                            } else {
                                this._log.info("Failed subscription to additional device " + name + " UDN: " + udn);
                            }
                        }
                        return;
                    }
                } else {
                    String oldudn = this._router.getUDN();
                    if (this._log.shouldWarn()) {
                        String oldname = this._router.getFriendlyName();
                        if (oldname == null) {
                            oldname = "";
                        }
                        oldname = oldname + " IGD";
                        String oldip = UPnP.getIP(this._router);
                        if (oldip != null) {
                            oldname = oldname + ' ' + oldip;
                        }
                        this._log.warn("Replacing device " + oldname + " (external IP " + curIP + ") with new device " + name + " UDN: " + udn + " external IP: " + extIP);
                    }
                    this._otherUDNs.put(oldudn, this._router);
                }
                if (!this.portsForwarded.isEmpty()) {
                    fpc = this.forwardCallback;
                    removeMap = new HashMap<ForwardPort, ForwardPortStatus>(this.portsForwarded.size());
                    for (ForwardPort port : this.portsForwarded) {
                        ForwardPortStatus fps = new ForwardPortStatus(-2, "UPnP device changed", port.portNumber);
                        removeMap.put(port, fps);
                    }
                }
                this.portsForwarded.clear();
            }
            this._otherUDNs.remove(udn);
            this._eventVars.clear();
            this._router = dev;
            this._service = service;
            if (services.size() > 1) {
                this._service6 = services.get(1);
            }
            this._permanentLeasesOnly = false;
        }
        if (fpc != null) {
            fpc.portForwardStatus(removeMap);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("UP&P IGD found : " + name + " UDN: " + udn + " lease time: " + dev.getLeaseTime());
        }
        if (!subscriptionFailed) {
            for (Service svc : services) {
                boolean ok = this.subscribe(svc);
                if (!this._log.shouldInfo()) continue;
                if (ok) {
                    this._log.info("Subscribed to " + svc.getServiceType() + " on device " + name);
                    continue;
                }
                this._log.info("Failed subscription to " + svc.getServiceType() + " on device " + name);
            }
        }
        this.registerPortMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        if (ports.isEmpty()) {
            return;
        }
        this.registerPorts(ports);
    }

    private List<Service> discoverService(Device router) {
        for (Device current : router.getDeviceList()) {
            String type = current.getDeviceType();
            if (!WAN_DEVICE.equals(type) && !WAN_DEVICE_2.equals(type)) continue;
            DeviceList l = current.getDeviceList();
            for (int i = 0; i < current.getDeviceList().size(); ++i) {
                Device current2 = l.getDevice(i);
                type = current2.getDeviceType();
                if (!WANCON_DEVICE.equals(type) && !WANCON_DEVICE_2.equals(type)) continue;
                Service service = current2.getService(WAN_IP_CONNECTION_2);
                if (service == null && (service = current2.getService(WAN_IP_CONNECTION)) == null && (service = current2.getService(WAN_PPP_CONNECTION)) == null && this._log.shouldWarn()) {
                    this._log.warn(this._router.getFriendlyName() + " doesn't have any recognized connection type; we won't be able to use it!");
                }
                if (service == null) continue;
                Service svc2 = current2.getService(WAN_IPV6_CONNECTION);
                if (svc2 != null) {
                    ArrayList<Service> rv = new ArrayList<Service>(2);
                    rv.add(service);
                    rv.add(svc2);
                    return rv;
                }
                return Collections.singletonList(service);
            }
        }
        return null;
    }

    private boolean tryAddMapping(String protocol, int port, String description, ForwardPort fp) {
        if (this._log.shouldWarn()) {
            this._log.warn("Registering a port mapping for " + port + "/" + protocol + " IPv" + (fp.isIP6 ? (char)'6' : '4'));
        }
        int nbOfTries = 0;
        int maxTries = fp.isIP6 ? 1 : 3;
        boolean isPortForwarded = false;
        while (!(this._serviceLacksAPM || nbOfTries++ >= maxTries || (isPortForwarded = this.addMapping(protocol, port, description, fp)) || this._serviceLacksAPM || ++nbOfTries >= maxTries)) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._log.shouldLog(30)) {
            this._log.warn((isPortForwarded ? "Mapping is successful!" : "Mapping has failed!") + " (" + nbOfTries + " tries)");
        }
        return isPortForwarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        if (ports.isEmpty()) {
            return;
        }
        this.unregisterPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceRemoved(Device dev) {
        if (!dev.hasUDN()) {
            return;
        }
        String udn = dev.getUDN();
        if (this._log.shouldLog(30)) {
            this._log.warn("UP&P device removed : " + dev.getFriendlyName() + " UDN: " + udn);
        }
        ForwardPortCallback fpc = null;
        HashMap<ForwardPort, ForwardPortStatus> removeMap = null;
        boolean runSearch = false;
        Object object = this.lock;
        synchronized (object) {
            this._otherUDNs.remove(udn);
            if (this._router == null) {
                return;
            }
            String type = dev.getDeviceType();
            if ((ROUTER_DEVICE.equals(type) || ROUTER_DEVICE_2.equals(type)) && dev.isRootDevice() && UPnP.stringEquals(this._router.getFriendlyName(), dev.getFriendlyName()) && UPnP.stringEquals(this._router.getUDN(), udn)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("UP&P IGD device removed : " + dev.getFriendlyName());
                }
                runSearch = true;
                this._router = null;
                this._service = null;
                this._service6 = null;
                this._eventVars.clear();
                this._serviceLacksAPM = false;
                this._permanentLeasesOnly = false;
                if (!this.portsForwarded.isEmpty()) {
                    fpc = this.forwardCallback;
                    removeMap = new HashMap<ForwardPort, ForwardPortStatus>(this.portsForwarded.size());
                    for (ForwardPort port : this.portsForwarded) {
                        ForwardPortStatus fps = new ForwardPortStatus(-2, "UPnP device removed", port.portNumber);
                        removeMap.put(port, fps);
                    }
                }
                this.portsForwarded.clear();
            }
        }
        if (fpc != null) {
            fpc.portForwardStatus(removeMap);
        }
        if (runSearch) {
            this.retryOtherDevices();
            this.search();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventNotifyReceived(String uuid, long seq, String varName, String value) {
        if (uuid == null || varName == null || value == null) {
            return;
        }
        if (varName.length() > 128 || value.length() > 128) {
            return;
        }
        String old = null;
        Device newdev = null;
        Object object = this.lock;
        synchronized (object) {
            if (this._eventVars.size() >= 20 && !this._eventVars.containsKey(varName)) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Ignoring event from " + uuid + ": " + varName + " changed to " + value);
                }
                return;
            }
            if (this._service == null || !uuid.equals(this._service.getSID())) {
                if (varName.equals("ConnectionStatus") && value.equals("Connected") && (newdev = this.SIDtoDevice(uuid)) == null && this._log.shouldInfo()) {
                    this._log.debug("Can't map event SID " + uuid + " to device");
                }
                if (newdev == null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Ignoring event from " + uuid + ": " + varName + " changed to " + value);
                    }
                    return;
                }
            }
            if (newdev == null) {
                old = this._eventVars.put(varName, value);
            }
        }
        if (newdev != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Possibly promoting device on connected event: " + newdev.getUDN());
            }
            this.deviceAdded(newdev);
            return;
        }
        if (!value.equals(old)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Event: " + varName + " changed from " + old + " to " + value);
            }
            if (varName.equals("ConnectionStatus") && "Connected".equals(old)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Device connection change to: " + value + ", starting search");
                }
                this.retryOtherDevices();
                this.search();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Device SIDtoDevice(String sid) {
        Object object = this.lock;
        synchronized (object) {
            for (Device dev : this._otherUDNs.values()) {
                List<Service> services;
                String type = dev.getDeviceType();
                boolean isIGD = (ROUTER_DEVICE.equals(type) || ROUTER_DEVICE_2.equals(type)) && dev.isRootDevice();
                if (!isIGD || (services = this.discoverService(dev)) == null) continue;
                for (Service service : services) {
                    if (!sid.equals(service.getSID())) continue;
                    return dev;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryOtherDevices() {
        int sz = this._otherUDNs.size();
        if (sz <= 0) {
            return;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Device change, retrying " + sz + " other devices");
        }
        ArrayList<Device> others = new ArrayList<Device>(sz);
        Iterator iterator = this.lock;
        synchronized (iterator) {
            others.addAll(this._otherUDNs.values());
        }
        for (Device dev : others) {
            this.deviceAdded(dev);
        }
    }

    static Set<String> getLocalAddresses() {
        SortedSet<String> addrs = Addresses.getAddresses(true, false, true, false);
        Iterator iter = addrs.iterator();
        while (iter.hasNext()) {
            String addr = (String)iter.next();
            byte[] ip = Addresses.getIP(addr);
            if (ip != null && !TransportUtil.isPubliclyRoutable(ip, true)) continue;
            iter.remove();
        }
        return addrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInterfaces() {
        Set<String> addrs = UPnP.getLocalAddresses();
        HashSet<String> oldaddrs = new HashSet<String>(addrs.size());
        UPnP uPnP = this;
        synchronized (uPnP) {
            int pct;
            HTTPServerList hlist = this.getHTTPServerList();
            Iterator<Object> iter = hlist.iterator();
            while (iter.hasNext()) {
                HTTPServer skt = (HTTPServer)iter.next();
                String addr = skt.getBindAddress();
                int slash = addr.indexOf(47);
                if (slash >= 0) {
                    addr = addr.substring(slash + 1);
                }
                if ((pct = addr.indexOf(37)) > 0) {
                    addr = addr.substring(0, pct);
                }
                if (!addrs.contains(addr)) {
                    iter.remove();
                    skt.close();
                    skt.stop();
                    if (this._log.shouldWarn()) {
                        this._log.warn("Closed HTTP server socket: " + addr);
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Retained HTTP server socket: " + addr);
                }
                oldaddrs.add(addr);
            }
            iter = addrs.iterator();
            while (iter.hasNext()) {
                String addr = (String)iter.next();
                if (oldaddrs.contains(addr)) continue;
                HTTPServer socket = new HTTPServer();
                boolean ok = socket.open(addr, this.getHTTPPort());
                if (ok) {
                    socket.addRequestListener(this);
                    socket.start();
                    hlist.add(socket);
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Added HTTP server socket: " + addr);
                    continue;
                }
                iter.remove();
                if (!this._log.shouldWarn()) continue;
                this._log.warn("open() failed on new HTTP server socket: " + addr);
            }
            oldaddrs.clear();
            SSDPSearchResponseSocketList list = this.getSSDPSearchResponseSocketList();
            Iterator<Object> iter2 = list.iterator();
            while (iter2.hasNext()) {
                SSDPSearchResponseSocket skt = (SSDPSearchResponseSocket)iter2.next();
                String addr = skt.getLocalAddress();
                pct = addr.indexOf(37);
                if (pct > 0) {
                    addr = addr.substring(0, pct);
                }
                if (!addrs.contains(addr)) {
                    iter2.remove();
                    skt.setControlPoint(null);
                    skt.close();
                    skt.stop();
                    if (this._log.shouldWarn()) {
                        this._log.warn("Closed SSDP search response socket: " + addr);
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Retained SSDP search response socket: " + addr);
                }
                oldaddrs.add(addr);
            }
            for (String addr : addrs) {
                if (oldaddrs.contains(addr)) continue;
                SSDPSearchResponseSocket socket = new SSDPSearchResponseSocket(addr, this.getSSDPPort());
                socket.setControlPoint(this);
                socket.start();
                list.add(socket);
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Added SSDP search response socket: " + addr);
            }
            oldaddrs.clear();
            SSDPNotifySocketList nlist = this.getSSDPNotifySocketList();
            Iterator iter3 = nlist.iterator();
            while (iter3.hasNext()) {
                SSDPNotifySocket skt = (SSDPNotifySocket)iter3.next();
                String addr = skt.getLocalAddress();
                int pct2 = addr.indexOf(37);
                if (pct2 > 0) {
                    addr = addr.substring(0, pct2);
                }
                if (!addrs.contains(addr)) {
                    iter3.remove();
                    skt.setControlPoint(null);
                    skt.close();
                    skt.stop();
                    if (this._log.shouldWarn()) {
                        this._log.warn("Closed SSDP notify socket: " + addr);
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Retained SSDP notify socket: " + addr);
                }
                oldaddrs.add(addr);
            }
            for (String addr : addrs) {
                if (oldaddrs.contains(addr)) continue;
                try {
                    SSDPNotifySocket socket = new SSDPNotifySocket(addr);
                    socket.setControlPoint(this);
                    socket.start();
                    nlist.add(socket);
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Added SSDP notify socket: " + addr);
                }
                catch (IOException ioe) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Failed to add SSDP notify socket: " + addr, ioe);
                }
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Current sockets:\nHTTP: " + hlist + "\nSearch response: " + list + "\nNotify: " + nlist);
            }
        }
    }

    @Override
    public void search() {
        this.updateInterfaces();
        super.search();
    }

    private static boolean stringEquals(String a, String b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNATPresent() {
        Object object = this.lock;
        synchronized (object) {
            return this._router != null && this._service != null;
        }
    }

    private String getNATAddress(Service service) {
        Action getIP = service.getAction("GetExternalIPAddress");
        if (getIP == null || !getIP.postControlAction()) {
            return null;
        }
        Argument a = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress");
        if (a == null) {
            return null;
        }
        String rv = a.getValue();
        if ("0.0.0.0".equals(rv) || rv == null || rv.length() <= 0) {
            return null;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUpstreamMaxBitRate() {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
                return -1;
            }
            service = this._service;
        }
        Action getIP = service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        Argument a = getIP.getOutputArgumentList().getArgument("NewUpstreamMaxBitRate");
        if (a == null) {
            return -1;
        }
        try {
            return Integer.parseInt(a.getValue());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDownstreamMaxBitRate() {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
                return -1;
            }
            service = this._service;
        }
        Action getIP = service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        Argument a = getIP.getOutputArgumentList().getArgument("NewDownstreamMaxBitRate");
        if (a == null) {
            return -1;
        }
        try {
            return Integer.parseInt(a.getValue());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static void listStateTable(Service serv, StringBuilder sb) {
        ServiceStateTable table;
        try {
            table = serv.getServiceStateTable();
        }
        catch (RuntimeException e) {
            sb.append(" : no state");
            return;
        }
        sb.append("<ul><small>");
        for (int i = 0; i < table.size(); ++i) {
            StateVariable current = table.getStateVariable(i);
            sb.append("<li>").append(DataHelper.escapeHTML(current.getName())).append(" : \"").append(DataHelper.escapeHTML(current.getValue())).append("\"</li>");
        }
        sb.append("</small></ul>");
    }

    private static void listActionsArguments(Action action, StringBuilder sb) {
        ArgumentList ar = action.getArgumentList();
        sb.append("<ol>");
        for (int i = 0; i < ar.size(); ++i) {
            Argument argument = ar.getArgument(i);
            if (argument == null) continue;
            sb.append("<li><small>argument : ").append(DataHelper.escapeHTML(argument.getName())).append("</small></li>");
        }
        sb.append("</ol>");
    }

    private static void listActions(Service service, StringBuilder sb) {
        ActionList al = service.getActionList();
        sb.append("<ul>");
        for (int i = 0; i < al.size(); ++i) {
            Action action = al.getAction(i);
            if (action == null) continue;
            sb.append("<li>").append(DataHelper.escapeHTML(action.getName()));
            UPnP.listActionsArguments(action, sb);
            sb.append("</li>");
        }
        sb.append("</ul>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(String action, String arg, Service serv) {
        Object object = this.toStringLock;
        synchronized (object) {
            Argument a;
            if (!action.equals(this._lastAction) || !serv.equals(this._lastService) || this._lastArgumentList == null) {
                Action getIP = serv.getAction(action);
                if (getIP == null || !getIP.postControlAction()) {
                    this._lastAction = null;
                    return null;
                }
                this._lastAction = action;
                this._lastService = serv;
                this._lastArgumentList = getIP.getOutputArgumentList();
            }
            if ((a = this._lastArgumentList.getArgument(arg)) == null) {
                return "";
            }
            String rv = a.getValue();
            return DataHelper.escapeHTML(rv);
        }
    }

    private String toLong(String action, String arg, Service serv) {
        String rv = this.toString(action, arg, serv);
        if (rv != null && rv.length() > 0) {
            try {
                long l = Long.parseLong(rv);
                rv = DataHelper.formatSize2Decimal(l);
                if (l == 0xFFFFFFFFL) {
                    rv = "&gt; " + rv;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    private String toTime(String action, String arg, Service serv) {
        String rv = this.toString(action, arg, serv);
        if (rv != null && rv.length() > 0) {
            try {
                long l = Long.parseLong(rv);
                rv = DataHelper.formatDuration2(l * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    private String toBoolean(String action, String arg, Service serv) {
        String rv = this.toString(action, arg, serv);
        return Boolean.toString("1".equals(rv));
    }

    private void listSubServices(Device dev, StringBuilder sb) {
        ServiceList sl = dev.getServiceList();
        if (sl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int i = 0; i < sl.size(); ++i) {
            Service serv = sl.getService(i);
            if (serv == null) continue;
            sb.append("<li>").append(this._t("Service")).append(": ");
            String type = serv.getServiceType();
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(type)) {
                sb.append(this._t("WAN Common Interface Configuration"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetCommonLinkProperties", "NewPhysicalLinkStatus", serv));
                sb.append("<li>").append(this._t("Type")).append(": ").append(this.toString("GetCommonLinkProperties", "NewWANAccessType", serv));
                sb.append("<li>").append(this._t("Upstream")).append(": ").append(this.toLong("GetCommonLinkProperties", "NewLayer1UpstreamMaxBitRate", serv)).append("bps");
                sb.append("<li>").append(this._t("Downstream")).append(": ").append(this.toLong("GetCommonLinkProperties", "NewLayer1DownstreamMaxBitRate", serv)).append("bps");
                if (this._context.getBooleanProperty(PROP_ADVANCED)) {
                    sb.append("<li>").append("Sent: ").append(this.toLong("GetTotalBytesSent", "NewTotalBytesSent", serv)).append('B');
                    sb.append("<li>").append("Received: ").append(this.toLong("GetTotalBytesReceived", "NewTotalBytesReceived", serv)).append('B');
                    sb.append("<li>").append("Sent packets: ").append(this.toLong("GetTotalPacketsSent", "NewTotalPacketsSent", serv));
                    sb.append("<li>").append("Received packets: ").append(this.toLong("GetTotalPacketsReceived", "NewTotalPacketsReceived", serv));
                }
            } else if (WAN_PPP_CONNECTION.equals(type)) {
                sb.append(this._t("WAN PPP Connection"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>").append(this._t("Uptime")).append(": ").append(this.toTime("GetStatusInfo", "NewUptime", serv));
                sb.append("<li>").append(this._t("Type")).append(": ").append(this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>").append(this._t("Upstream")).append(": ").append(this.toLong("GetLinkLayerMaxBitRates", "NewUpstreamMaxBitRate", serv)).append("bps");
                sb.append("<li>").append(this._t("Downstream")).append(": ").append(this.toLong("GetLinkLayerMaxBitRates", "NewDownstreamMaxBitRate", serv)).append("bps");
                sb.append("<li>").append(this._t("External IP")).append(": ").append(this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv));
            } else if ("urn:schemas-upnp-org:service:Layer3Forwarding:1".equals(type)) {
                sb.append(this._t("Layer 3 Forwarding"));
                sb.append("<ul><li>").append(this._t("Default Connection Service")).append(": ").append(this.toString("GetDefaultConnectionService", "NewDefaultConnectionService", serv));
            } else if (WAN_IP_CONNECTION.equals(type) || WAN_IP_CONNECTION_2.equals(type)) {
                sb.append(this._t("WAN IP Connection"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>").append(this._t("Uptime")).append(": ").append(this.toTime("GetStatusInfo", "NewUptime", serv));
                String error = this.toString("GetStatusInfo", "NewLastConnectionError", serv);
                if (error != null && error.length() > 0 && !error.equals("ERROR_NONE")) {
                    sb.append("<li>").append("Last Error").append(": ").append(error);
                }
                sb.append("<li>").append(this._t("Type")).append(": ").append(this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>").append(this._t("External IP")).append(": ").append(this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv));
            } else if (WAN_IPV6_CONNECTION.equals(type)) {
                sb.append("WAN IPv6 Connection");
                sb.append("<ul><li>").append("Firewall Enabled").append(": ").append(this.toBoolean("GetFirewallStatus", "FirewallEnabled", serv));
                sb.append("<li>").append("Pinhole Allowed").append(": ").append(this.toBoolean("GetFirewallStatus", "InboundPinholeAllowed", serv));
            } else if ("urn:schemas-upnp-org:service:WANEthernetLinkConfig:1".equals(type)) {
                sb.append(this._t("WAN Ethernet Link Configuration"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetEthernetLinkStatus", "NewEthernetLinkStatus", serv));
            } else {
                sb.append(DataHelper.escapeHTML(type)).append("<ul>");
            }
            if (this._context.getBooleanProperty(PROP_ADVANCED)) {
                sb.append("<li>Actions");
                UPnP.listActions(serv, sb);
                sb.append("</li><li>States");
                UPnP.listStateTable(serv, sb);
                sb.append("</li>");
            }
            sb.append("</ul>\n");
        }
        sb.append("</ul>\n");
    }

    private void listSubDev(String prefix, Device dev, StringBuilder sb) {
        if (prefix == null) {
            sb.append("<p><b>").append(this._t("Found Device")).append(":</b> ");
        } else {
            sb.append("<li>").append(this._t("Subdevice")).append(": ");
        }
        sb.append(DataHelper.escapeHTML(dev.getFriendlyName()));
        if (prefix == null) {
            String udn;
            String ip = UPnP.getIP(dev);
            if (ip != null) {
                sb.append("<br>IP: ").append(ip);
            }
            if ((udn = dev.getUDN()) != null) {
                sb.append("<br>UDN: ").append(DataHelper.escapeHTML(udn));
            }
        }
        this.listSubServices(dev, sb);
        DeviceList dl = dev.getDeviceList();
        if (dl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int j = 0; j < dl.size(); ++j) {
            Device subDev = dl.getDevice(j);
            if (subDev == null) continue;
            this.listSubDev(dev.getFriendlyName(), subDev, sb);
        }
        sb.append("</ul>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderStatusHTML() {
        Service service;
        Device router;
        StringBuilder sb = new StringBuilder();
        sb.append("<h3 id=\"upnp\">").append(this._t("UPnP Status")).append("</h3><div id=\"upnpscan\">");
        Object object = this.lock;
        synchronized (object) {
            if (!this._otherUDNs.isEmpty()) {
                sb.append("<b>");
                sb.append(this._t("Disabled UPnP Devices"));
                sb.append(":</b>");
                ArrayList<Map.Entry<String, Device>> other = new ArrayList<Map.Entry<String, Device>>(this._otherUDNs.entrySet());
                Collections.sort(other, new UDNComparator());
                boolean found = false;
                for (Map.Entry entry : other) {
                    String type;
                    boolean isIGD;
                    String udn = (String)entry.getKey();
                    Device dev = (Device)entry.getValue();
                    String name = dev.getFriendlyName();
                    if (name == null) {
                        name = udn;
                    }
                    boolean bl = isIGD = (ROUTER_DEVICE.equals(type = dev.getDeviceType()) || ROUTER_DEVICE_2.equals(type)) && dev.isRootDevice();
                    if (!isIGD && !this._context.getBooleanProperty(PROP_ADVANCED)) continue;
                    if (!found) {
                        found = true;
                        sb.append("<ul>");
                    }
                    name = name + (isIGD ? " IGD" : ' ' + type);
                    String ip = UPnP.getIP(dev);
                    if (ip != null) {
                        name = name + ' ' + ip;
                    }
                    sb.append("<li>").append(DataHelper.escapeHTML(name));
                    sb.append("<br>UDN: ").append(DataHelper.escapeHTML(udn)).append("</li>");
                }
                if (found) {
                    sb.append("</ul>");
                } else {
                    sb.append(" none");
                }
            }
            if (!this.isNATPresent()) {
                sb.append("<p>");
                sb.append(this._t("UPnP has not found any UPnP-aware, compatible device on your LAN."));
                return sb.toString();
            }
            router = this._router;
            service = this._service;
            Service service6 = this._service6;
        }
        this.listSubDev(null, router, sb);
        String addr = this.getNATAddress(service);
        sb.append("<p>");
        if (addr != null) {
            sb.append(this._t("The current external IP address reported by UPnP is {0}", DataHelper.escapeHTML(addr)));
        } else {
            sb.append(this._t("The current external IP address is not available."));
        }
        int downstreamMaxBitRate = this.getDownstreamMaxBitRate();
        int upstreamMaxBitRate = this.getUpstreamMaxBitRate();
        if (downstreamMaxBitRate > 0) {
            sb.append("<br>").append(this._t("UPnP reports the maximum downstream bit rate is {0}bits/sec", DataHelper.formatSize2Decimal(downstreamMaxBitRate)));
        }
        if (upstreamMaxBitRate > 0) {
            sb.append("<br>").append(this._t("UPnP reports the maximum upstream bit rate is {0}bits/sec", DataHelper.formatSize2Decimal(upstreamMaxBitRate)));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            for (ForwardPort port : this.portsToForward) {
                sb.append("<br>");
                if (port.isIP6) {
                    sb.append("IPv6 ");
                    sb.append(((IPv6ForwardPort)port).getIP()).append(' ');
                } else {
                    sb.append("IPv4 ");
                    if (addr != null) {
                        sb.append(DataHelper.escapeHTML(addr)).append(' ');
                    }
                }
                if (this.portsForwarded.contains(port)) {
                    sb.append(this._t("{0} port {1,number,#####} was successfully forwarded by UPnP.", UPnP.protoToString(port.protocol), port.portNumber));
                    continue;
                }
                sb.append(this._t("{0} port {1,number,#####} was not forwarded by UPnP.", UPnP.protoToString(port.protocol), port.portNumber));
            }
        }
        sb.append("</p></div>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(String protocol, int port, String description, ForwardPort fp) {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent() || this._router == null) {
                this._log.error("Can't addMapping: " + this.isNATPresent() + " " + this._router);
                return false;
            }
            service = fp.isIP6 ? this._service6 : this._service;
        }
        if (service == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No service for IPv" + (fp.isIP6 ? (char)'6' : '4'));
            }
            return false;
        }
        if (fp.isIP6) {
            return this.addMappingV6(service, port, (IPv6ForwardPort)fp);
        }
        return this.addMappingV4(service, protocol, port, description, fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMappingV4(Service service, String protocol, int port, String description, ForwardPort fp) {
        int controlStatus;
        UPnPStatus status;
        int level;
        Action add = service.getAction("AddPortMapping");
        if (add == null) {
            if (this._serviceLacksAPM) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Couldn't find AddPortMapping action!");
                }
            } else {
                this._serviceLacksAPM = true;
                this._log.logAlways(30, "UPnP device does not support port forwarding");
            }
            return false;
        }
        add.setArgumentValue("NewRemoteHost", "");
        add.setArgumentValue("NewExternalPort", port);
        String intf = this._router.getInterfaceAddress();
        String us = this.getOurAddress(intf);
        if (this._log.shouldLog(30) && !us.equals(intf)) {
            this._log.warn("Requesting port forward to " + us + ':' + port + " when cybergarage wanted " + intf);
        }
        add.setArgumentValue("NewInternalClient", us);
        add.setArgumentValue("NewInternalPort", port);
        add.setArgumentValue("NewProtocol", protocol);
        add.setArgumentValue("NewPortMappingDescription", description);
        add.setArgumentValue("NewEnabled", "1");
        int leaseTime = this._permanentLeasesOnly ? 0 : 10800;
        add.setArgumentValue("NewLeaseDuration", leaseTime);
        boolean rv = add.postControlAction();
        if (rv) {
            Object object = this.lock;
            synchronized (object) {
                this.portsForwarded.add(fp);
            }
        }
        int n = level = rv ? 20 : 30;
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder();
            buf.append("AddPortMapping result for ").append(protocol).append(" port ").append(port);
            UPnPStatus status2 = add.getStatus();
            if (status2 != null) {
                buf.append(" Status: ").append(status2.getCode()).append(' ').append(status2.getDescription());
            }
            if ((status2 = add.getControlStatus()) != null) {
                buf.append(" ControlStatus: ").append(status2.getCode()).append(' ').append(status2.getDescription());
            }
            this._log.log(level, buf.toString());
        }
        if (!rv && (status = add.getControlStatus()) != null && (controlStatus = status.getCode()) == 725) {
            if (this._log.shouldWarn()) {
                this._log.warn("UPnP device supports permanent leases only");
            }
            this._permanentLeasesOnly = true;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMappingV6(Service service, int port, IPv6ForwardPort fp) {
        int level;
        Action add = service.getAction("AddPinhole");
        if (add == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("UPnP device does not support pinholing");
            }
            return false;
        }
        String ip = fp.getIP();
        add.setArgumentValue("RemoteHost", "");
        add.setArgumentValue("RemotePort", 0);
        add.setArgumentValue("InternalClient", ip);
        add.setArgumentValue("InternalPort", port);
        add.setArgumentValue("Protocol", fp.protocol);
        add.setArgumentValue("LeaseTime", 10800);
        int uid = fp.getUID();
        if (uid < 0) {
            uid = this.getNewUID();
            fp.setUID(uid);
        }
        add.setArgumentValue("UniqueID", uid);
        String hisIP = service.getRootDevice().getLocation(true);
        boolean rv = hisIP != null && hisIP.contains(":") ? add.postControlAction(ip) : add.postControlAction();
        if (rv) {
            Argument a = add.getOutputArgumentList().getArgument("UniqueID");
            if (a != null) {
                try {
                    int newuid = Integer.parseInt(a.getValue());
                    if (newuid != uid) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Updating UID from " + uid + " to " + newuid + " for " + fp);
                        }
                        fp.setUID(newuid);
                    }
                }
                catch (NumberFormatException newuid) {
                    // empty catch block
                }
            }
            Object newuid = this.lock;
            synchronized (newuid) {
                this.portsForwarded.add(fp);
            }
        }
        int n = level = rv ? 20 : 30;
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder();
            buf.append("AddPinhole result for ").append(fp.toString());
            UPnPStatus status = add.getStatus();
            if (status != null) {
                buf.append(" Status: ").append(status.getCode()).append(' ').append(status.getDescription());
            }
            if ((status = add.getControlStatus()) != null) {
                buf.append(" ControlStatus: ").append(status.getCode()).append(' ').append(status.getDescription());
            }
            this._log.log(level, buf.toString());
        }
        return rv;
    }

    private int getNewUID() {
        Object object = this.lock;
        synchronized (object) {
            int rv;
            boolean dup;
            block3: do {
                rv = this._context.random().nextInt(65536);
                dup = false;
                for (ForwardPort fp : this.portsToForward) {
                    if (!fp.isIP6 || ((IPv6ForwardPort)fp).getUID() != rv) continue;
                    dup = true;
                    continue block3;
                }
            } while (dup);
            return rv;
        }
    }

    private static String getIP(Device dev) {
        URI url2;
        String rv = null;
        String him = dev.getURLBase();
        if (him != null && him.length() > 0) {
            try {
                url2 = new URI(him);
                rv = url2.getHost();
            }
            catch (URISyntaxException url2) {
                // empty catch block
            }
        }
        if (rv == null && (him = dev.getLocation()) != null && him.length() > 0) {
            try {
                url2 = new URI(him);
                rv = url2.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (rv != null && rv.startsWith("[") && rv.endsWith("]")) {
            rv = rv.substring(1, rv.length() - 1);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOurAddress(String deflt) {
        Device router;
        String rv = deflt;
        Object object = this.lock;
        synchronized (object) {
            router = this._router;
        }
        if (router == null) {
            return rv;
        }
        String hisIP = UPnP.getIP(router);
        if (hisIP == null) {
            return rv;
        }
        try {
            byte[] hisBytes = InetAddress.getByName(hisIP).getAddress();
            if (hisBytes.length != 4) {
                return deflt;
            }
            long hisLong = DataHelper.fromLong(hisBytes, 0, 4);
            long distance = Long.MAX_VALUE;
            SortedSet<String> myAddresses = Addresses.getAddresses(true, false);
            myAddresses.add(deflt);
            for (String me : myAddresses) {
                if (me.startsWith("127.") || me.equals("0.0.0.0")) continue;
                try {
                    byte[] myBytes = InetAddress.getByName(me).getAddress();
                    long myLong = DataHelper.fromLong(myBytes, 0, 4);
                    long newDistance = myLong ^ hisLong;
                    if (newDistance >= distance) continue;
                    rv = me;
                    distance = newDistance;
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(String protocol, int port, ForwardPort fp, boolean noLog) {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Can't removeMapping: " + this.isNATPresent() + " " + this._router);
                }
                return false;
            }
            service = fp.isIP6 ? this._service6 : this._service;
        }
        if (service == null) {
            if (this._log.shouldInfo()) {
                this._log.info("No service for IPv" + (fp.isIP6 ? (char)'6' : '4'));
            }
            return false;
        }
        if (fp.isIP6) {
            return this.removeMappingV6(service, protocol, port, (IPv6ForwardPort)fp, noLog);
        }
        return this.removeMappingV4(service, protocol, port, fp, noLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMappingV4(Service service, String protocol, int port, ForwardPort fp, boolean noLog) {
        int level;
        Action remove = service.getAction("DeletePortMapping");
        if (remove == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Couldn't find DeletePortMapping action!");
            }
            return false;
        }
        remove.setArgumentValue("NewExternalPort", port);
        remove.setArgumentValue("NewProtocol", protocol);
        boolean retval = remove.postControlAction();
        Object object = this.lock;
        synchronized (object) {
            this.portsForwarded.remove(fp);
        }
        int n = level = retval ? 20 : 30;
        if (!noLog && this._log.shouldLog(level)) {
            if (retval) {
                this._log.log(level, "UPnP: Removed IPv4 mapping for " + fp.name + " " + port + " / " + protocol);
            } else {
                this._log.log(level, "UPnP: Failed to remove IPv4 mapping for " + fp.name + " " + port + " / " + protocol);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMappingV6(Service service, String protocol, int port, IPv6ForwardPort fp, boolean noLog) {
        int level;
        boolean retval;
        Object ip;
        int uid = fp.getUID();
        if (uid < 0) {
            return false;
        }
        Action remove = service.getAction("DeletePinhole");
        if (remove == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Couldn't find DeletePinhole action!");
            }
            return false;
        }
        remove.setArgumentValue("UniqueID", uid);
        String hisIP = service.getRootDevice().getLocation(true);
        if (hisIP != null && hisIP.contains(":")) {
            ip = fp.getIP();
            retval = remove.postControlAction((String)ip);
        } else {
            retval = remove.postControlAction();
        }
        ip = this.lock;
        synchronized (ip) {
            this.portsForwarded.remove(fp);
        }
        int n = level = retval ? 20 : 30;
        if (!noLog && this._log.shouldLog(level)) {
            String ip2 = fp.getIP();
            if (retval) {
                this._log.log(level, "UPnP: Removed IPv6 mapping for " + fp);
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("UPnP: Failed to remove IPv6 mapping for ").append(fp.toString());
                UPnPStatus status = remove.getStatus();
                if (status != null) {
                    buf.append(" Status: ").append(status.getCode()).append(' ').append(status.getDescription());
                }
                if ((status = remove.getControlStatus()) != null) {
                    buf.append(" ControlStatus: ").append(status.getCode()).append(' ').append(status.getDescription());
                }
                this._log.log(level, buf.toString());
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangePublicPorts(Set<ForwardPort> ports, ForwardPortCallback cb) {
        Set<ForwardPort> portsToDumpNow = null;
        Set<ForwardPort> portsToForwardNow = null;
        if (this._log.shouldLog(20)) {
            this._log.info("UP&P Forwarding " + ports.size() + " ports...", new Exception());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.forwardCallback != null && this.forwardCallback != cb && cb != null) {
                this._log.error("ForwardPortCallback changed from " + this.forwardCallback + " to " + cb + " - using new value, but this is very strange!");
            }
            this.forwardCallback = cb;
            if (this.portsToForward.isEmpty()) {
                this.portsToForward.addAll(ports);
                portsToForwardNow = ports;
                portsToDumpNow = null;
            } else if (ports.isEmpty()) {
                portsToDumpNow = this.portsToForward;
                this.portsToForward.clear();
                portsToForwardNow = null;
            } else {
                portsToForwardNow = new HashSet<ForwardPort>();
                for (ForwardPort port : ports) {
                    portsToForwardNow.add(port);
                }
                for (ForwardPort port : this.portsToForward) {
                    if (ports.contains(port)) {
                        if (!port.isIP6) continue;
                        ports.remove(port);
                        ports.add(port);
                        portsToForwardNow.remove(port);
                        portsToForwardNow.add(port);
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Retaining: " + port);
                        continue;
                    }
                    boolean keep = false;
                    if (port.isIP6) {
                        IPv6ForwardPort v6port = (IPv6ForwardPort)port;
                        long now = this._context.clock().now();
                        long exp = v6port.getExpiration();
                        if (exp > 0L) {
                            boolean bl = keep = exp > now;
                            if (this._log.shouldDebug()) {
                                if (keep) {
                                    this._log.debug("Deprecated address not expired, continue forwarding: " + v6port);
                                } else {
                                    this._log.debug("Deprecated address expired, stop forwarding: " + v6port);
                                }
                            }
                        } else {
                            try {
                                Inet6Address v6addr = (Inet6Address)InetAddress.getByName(v6port.getIP());
                                if (Addresses.isTemporary(v6addr)) {
                                    v6port.setExpiration(now + 86400000L);
                                    keep = true;
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("Address now deprecated, continue forwarding for 24h: " + v6port);
                                    }
                                }
                            }
                            catch (UnknownHostException unknownHostException) {
                                // empty catch block
                            }
                        }
                        if (keep) {
                            ports.add(port);
                            portsToForwardNow.remove(port);
                            portsToForwardNow.add(port);
                        }
                    }
                    if (keep) continue;
                    if (portsToDumpNow == null) {
                        portsToDumpNow = new HashSet<ForwardPort>();
                    }
                    portsToDumpNow.add(port);
                }
                this.portsToForward.clear();
                this.portsToForward.addAll(ports);
            }
            if (this._router == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("No UPnP router available to update");
                }
                return;
            }
        }
        if (portsToDumpNow != null && !portsToDumpNow.isEmpty()) {
            this.unregisterPorts(portsToDumpNow);
        }
        this.registerPorts(portsToForwardNow);
    }

    private static String protoToString(int p) {
        if (p == 17) {
            return "UDP";
        }
        if (p == 6) {
            return "TCP";
        }
        return "?";
    }

    private void registerPorts(Set<ForwardPort> portsToForwardNow) {
        if (this._serviceLacksAPM && portsToForwardNow != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("UPnP device does not support port forwarding");
            }
            HashMap<ForwardPort, ForwardPortStatus> map = new HashMap<ForwardPort, ForwardPortStatus>(portsToForwardNow.size());
            for (ForwardPort port : portsToForwardNow) {
                ForwardPortStatus fps = new ForwardPortStatus(-2, "UPnP device does not support port forwarding", port.portNumber);
                map.put(port, fps);
            }
            this.forwardCallback.portForwardStatus(map);
            return;
        }
        if (this._log.shouldInfo()) {
            if (portsToForwardNow != null) {
                this._log.info("Starting thread to forward " + portsToForwardNow.size() + " ports");
            } else {
                this._log.info("Starting thread to renew subscriptions");
            }
        }
        I2PThread t = new I2PThread(new RegisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Opener " + __id.incrementAndGet());
        t.setDaemon(true);
        ((Thread)t).start();
    }

    private void unregisterPorts(Set<ForwardPort> portsToForwardNow) {
        if (this._log.shouldLog(20)) {
            this._log.info("Starting thread to un-forward " + portsToForwardNow.size() + " ports");
        }
        I2PThread t = new I2PThread(new UnregisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Closer " + __id.incrementAndGet());
        t.setDaemon(true);
        ((Thread)t).start();
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty(PROP_ADVANCED, "true");
        I2PAppContext ctx = new I2PAppContext(props);
        Set<String> addrs = UPnP.getLocalAddresses();
        ArrayList<InetAddress> ias = new ArrayList<InetAddress>(addrs.size());
        for (String addr : addrs) {
            try {
                InetAddress ia = InetAddress.getByName(addr);
                ias.add(ia);
            }
            catch (UnknownHostException ia) {}
        }
        InetAddress[] binds = ias.toArray(new InetAddress[ias.size()]);
        UPnP cp = new UPnP(ctx, 8008, 8058, binds);
        org.cybergarage.upnp.UPnP.setEnable(9);
        Debug.initialize(ctx);
        cp.setHTTPPort(49152 + ctx.random().nextInt(5000));
        cp.setSSDPPort(54152 + ctx.random().nextInt(5000));
        long start = System.currentTimeMillis();
        cp.start();
        long s2 = System.currentTimeMillis();
        System.err.println("Start took " + (s2 - start) + "ms");
        System.err.println("Searching for UPnP devices");
        start = System.currentTimeMillis();
        cp.search();
        s2 = System.currentTimeMillis();
        System.err.println("Search kickoff took " + (s2 - start) + "ms");
        System.err.println("Waiting 10 seconds for responses");
        Thread.sleep(10000L);
        DeviceList list = cp.getDeviceList();
        if (list.isEmpty()) {
            System.err.println("No UPnP devices found");
            System.exit(1);
        }
        System.err.println("Found " + list.size() + " devices.");
        System.err.println("Redirect the following output to an html file and view in a browser.");
        StringBuilder sb = new StringBuilder();
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            Device device = (Device)it.next();
            cp.listSubDev(device.toString(), device, sb);
            System.out.println("<h3>Device " + ++i + ": " + DataHelper.escapeHTML(device.getFriendlyName()) + "</h3>");
            System.out.println("<p>UDN: " + DataHelper.escapeHTML(device.getUDN()));
            System.out.println("<br>IP: " + UPnP.getIP(device));
            String loc = device.getLocation();
            if (loc != null && loc.length() > 0) {
                System.out.println("<br>URL: <a href=\"" + loc + "\">" + loc + "</a>");
            }
            System.out.println(sb.toString());
            sb.setLength(0);
        }
        System.exit(0);
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private final String _t(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    private final String _t(String s, Object o, Object o2) {
        return Translate.getString(s, o, o2, this._context, BUNDLE_NAME);
    }

    static class IPv6ForwardPort
    extends ForwardPort {
        private final String _ip;
        private int _uid = -1;
        private long _expires;

        public IPv6ForwardPort(String name, int protocol, int port, String ip) {
            super(name, true, protocol, port);
            if (ip == null) {
                throw new IllegalArgumentException();
            }
            this._ip = ip;
        }

        public String getIP() {
            return this._ip;
        }

        public synchronized int getUID() {
            return this._uid;
        }

        public synchronized void setUID(int uid) {
            this._uid = uid;
        }

        public synchronized long getExpiration() {
            return this._expires;
        }

        public synchronized void setExpiration(long expires) {
            this._expires = expires;
        }

        @Override
        public int hashCode() {
            return this._ip.hashCode() ^ super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IPv6ForwardPort)) {
                return false;
            }
            IPv6ForwardPort f = (IPv6ForwardPort)o;
            return this._ip.equals(f.getIP()) && super.equals(o);
        }

        public String toString() {
            return "IPv6FP " + this.name + ' ' + this.protocol + ' ' + this._ip + ' ' + this.portNumber + ' ' + this._uid + ' ' + this._expires;
        }
    }

    private class RegisterPortsThread
    implements Runnable {
        private final Set<ForwardPort> portsToForwardNow;

        public RegisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            UPnP.this.renewSubscriberService(10800L);
            if (this.portsToForwardNow == null) {
                return;
            }
            HashMap<ForwardPort, ForwardPortStatus> map = new HashMap<ForwardPort, ForwardPortStatus>(this.portsToForwardNow.size());
            for (ForwardPort port : this.portsToForwardNow) {
                IPv6ForwardPort v6port;
                String proto = UPnP.protoToString(port.protocol);
                ForwardPortStatus fps = proto.length() <= 1 ? new ForwardPortStatus(-2, "Protocol not supported", port.portNumber) : (UPnP.this.tryAddMapping(proto, port.portNumber, port.name, port) ? new ForwardPortStatus(1, "Port apparently forwarded by UPnP", port.portNumber) : new ForwardPortStatus(-1, "UPnP port forwarding apparently failed", port.portNumber));
                if (port.isIP6 && (v6port = (IPv6ForwardPort)port).getExpiration() > 0L) {
                    if (!UPnP.this._log.shouldDebug()) continue;
                    UPnP.this._log.debug("Not reporting result for deprecated " + v6port + " - " + fps.reasonString);
                    continue;
                }
                map.put(port, fps);
            }
            UPnP.this.forwardCallback.portForwardStatus(map);
        }
    }

    private static class UDNComparator
    implements Comparator<Map.Entry<String, Device>>,
    Serializable {
        private UDNComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Device> l, Map.Entry<String, Device> r) {
            String rs;
            Device ld = l.getValue();
            Device rd = r.getValue();
            String ls = ld.getFriendlyName();
            if (ls == null) {
                ls = ld.getUDN();
            }
            if ((rs = rd.getFriendlyName()) == null) {
                rs = rd.getUDN();
            }
            return Collator.getInstance().compare(ls, rs);
        }
    }

    private class UnregisterPortsThread
    implements Runnable {
        private final Set<ForwardPort> portsToForwardNow;

        public UnregisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                if (proto.length() <= 1) continue;
                UPnP.this.removeMapping(proto, port.portNumber, port, false);
            }
        }
    }
}

