/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.TransportUtil;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;

public abstract class TransportImpl
implements Transport {
    private final Log _log;
    private TransportEventListener _listener;
    protected final List<RouterAddress> _currentAddresses;
    private final BlockingQueue<OutNetMessage> _sendPool;
    protected final RouterContext _context;
    private final Map<Hash, Long> _unreachableEntries;
    private final Map<Hash, Long> _wasUnreachableEntries;
    private volatile Hash _lastReachablePeer;
    private final Set<InetAddress> _localAddresses;
    private static final Map<Hash, byte[]> _IPMap;
    private final long UNREACHABLE_PERIOD;
    private final long WAS_UNREACHABLE_PERIOD;
    public static final String CAP_IPV4 = "4";
    public static final String CAP_IPV6 = "6";
    public static final String CAP_IPV4_IPV6 = "46";
    protected static final String PROP_IPV6_FIREWALLED = "i2np.lastIPv6Firewalled";
    private static final int MAX_CONNECTION_FACTOR = 50;
    private final boolean REBALANCE_NTCP;
    private static final int DEFAULT_CAPACITY_PCT = 75;
    protected static final boolean ADJUST_COST = true;
    protected static final int CONGESTION_COST_ADJUSTMENT = 1;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public TransportImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(this.getClass());
        this._context.statManager().createRateStat("transport.sendMessageFailureLifetime", "How long the lifetime of messages that fail are?", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendMessageSize", "Size of sent messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.receiveMessageSize", "Size of received messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageTime", "How long it takes to read a message?", "Transport", new long[]{60000L, 300000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageTimeSlow", "How long it takes to read a message (when it takes more than a second)?", "Transport", new long[]{60000L, 300000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendProcessingTime", "Time to process and send a message (ms)", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.expiredOnQueueLifetime", "How long a message that expires on our outbound queue is processed", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._currentAddresses = new CopyOnWriteArrayList<RouterAddress>();
        this._sendPool = this.getStyle().equals("NTCP") ? new ArrayBlockingQueue<OutNetMessage>(8) : null;
        this._unreachableEntries = new ConcurrentHashMap<Hash, Long>(32);
        this._wasUnreachableEntries = new ConcurrentHashMap<Hash, Long>(32);
        this._localAddresses = new ConcurrentHashSet<InetAddress>(4);
        if (this.allowLocal()) {
            this.UNREACHABLE_PERIOD = 60000L;
            this.WAS_UNREACHABLE_PERIOD = 60000L;
        } else {
            this.UNREACHABLE_PERIOD = 300000L;
            this.WAS_UNREACHABLE_PERIOD = 1800000L;
        }
        this._context.simpleTimer2().addPeriodicEvent(new CleanupUnreachable(), 2L * this.UNREACHABLE_PERIOD, this.UNREACHABLE_PERIOD / 2L);
        String installed = this._context.getProperty("router.firstVersion");
        this.REBALANCE_NTCP = SystemVersion.isSlow() || !SystemVersion.isMac() && !SystemVersion.isWindows() && SystemVersion.hasWrapper() && installed != null && VersionComparator.comp(installed, "0.9.33") >= 0;
    }

    @Override
    public abstract int countPeers();

    @Override
    public abstract int countActivePeers();

    @Override
    public abstract int countActiveSendPeers();

    public int getMaxConnections() {
        if (this._context.commSystem().isDummy()) {
            return 0;
        }
        String style = this.getStyle();
        String maxProp = style.equals("SSU") ? "i2np.udp.maxConnections" : (style.equals("NTCP") ? "i2np.ntcp.maxConnections" : "i2np." + style.toLowerCase(Locale.US) + ".maxConnections");
        int def = 50;
        char bw = this._context.router().getBandwidthClass();
        switch (bw) {
            default: {
                break;
            }
            case 'L': {
                def *= 2;
                break;
            }
            case 'M': {
                def *= 3;
                break;
            }
            case 'N': {
                def *= 5;
                break;
            }
            case 'O': {
                def *= 9;
                break;
            }
            case 'P': {
                def *= 11;
                break;
            }
            case 'X': {
                def *= 14;
            }
        }
        if (this._context.netDb().floodfillEnabled()) {
            def *= 17;
            def /= 10;
        }
        if (style.equals("SSU")) {
            if (this.REBALANCE_NTCP) {
                def *= 5;
                def /= 2;
            } else {
                def *= 3;
            }
        } else if (style.equals("NTCP") && this.REBALANCE_NTCP) {
            def *= 3;
            if ((def /= 2) > 1500) {
                def = 1500;
            }
        }
        return this._context.getProperty(maxProp, def);
    }

    @Override
    public boolean haveCapacity() {
        return this.haveCapacity(75);
    }

    @Override
    public boolean haveCapacity(int pct) {
        return this.countPeers() < this.getMaxConnections() * pct / 100;
    }

    @Override
    public List<Long> getClockSkews() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getMostRecentErrorMessages() {
        return Collections.emptyList();
    }

    protected OutNetMessage getNextMessage() {
        OutNetMessage msg = (OutNetMessage)this._sendPool.poll();
        if (msg != null) {
            msg.beginSend();
        }
        return msg;
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful) {
        this.afterSend(msg, sendSuccessful, true, 0L);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue) {
        this.afterSend(msg, sendSuccessful, allowRequeue, 0L);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, long msToSend) {
        this.afterSend(msg, sendSuccessful, true, msToSend);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        long lifetime;
        if (msg.getTarget() == null) {
            return;
        }
        boolean debug = this._log.shouldDebug();
        if (sendSuccessful) {
            msg.timestamp("afterSend(successful)");
        } else {
            msg.timestamp("afterSend(failed)");
        }
        if (!sendSuccessful) {
            msg.transportFailed(this.getStyle());
        }
        if (msToSend > 1500L && debug) {
            this._log.debug(this.getStyle() + " afterSend slow: " + (sendSuccessful ? "success " : "FAIL ") + msg.getMessageSize() + " byte " + msg.getMessageType() + ' ' + msg.getMessageId() + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + " took " + msToSend + " ms");
        }
        if ((lifetime = msg.getLifetime()) > 3000L) {
            int level = 10;
            if (this._log.shouldLog(level)) {
                this._log.log(level, this.getStyle() + " afterSend slow (" + (sendSuccessful ? "success " : "FAIL ") + lifetime + "/" + msToSend + "): " + msg.getMessageSize() + " byte " + msg.getMessageType() + " " + msg.getMessageId() + " from " + this._context.routerHash().toBase64().substring(0, 6) + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + ": " + msg.toString());
            }
        } else if (debug) {
            this._log.debug(this.getStyle() + " afterSend: " + (sendSuccessful ? "success " : "FAIL ") + msg.getMessageSize() + " byte " + msg.getMessageType() + " " + msg.getMessageId() + " from " + this._context.routerHash().toBase64().substring(0, 6) + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + "\n" + msg.toString());
        }
        long now = this._context.clock().now();
        if (sendSuccessful) {
            Job j;
            if (debug) {
                this._log.debug(this.getStyle() + " Sent " + msg.getMessageType() + " successfully to " + msg.getTarget().getIdentity().getHash().toBase64());
            }
            if ((j = msg.getOnSendJob()) != null) {
                this._context.jobQueue().addJob(j);
            }
            msg.discardData();
        } else {
            MessageSelector selector;
            if (debug) {
                this._log.debug(this.getStyle() + " Failed to send " + msg.getMessageType() + " to " + msg.getTarget().getIdentity().getHash().toBase64() + " (details: " + msg + ')');
            }
            if (msg.getExpiration() < now) {
                this._context.statManager().addRateData("transport.expiredOnQueueLifetime", lifetime);
            }
            if (allowRequeue) {
                if ((msg.getExpiration() <= 0L || msg.getExpiration() > now) && msg.getMessage() != null) {
                    this._context.outNetMessagePool().add(msg);
                } else {
                    if (debug) {
                        this._log.debug("No more time left (" + new Date(msg.getExpiration()) + ", expiring without sending successfully the " + msg.getMessageType());
                    }
                    if (msg.getOnFailedSendJob() != null) {
                        this._context.jobQueue().addJob(msg.getOnFailedSendJob());
                    }
                    if ((selector = msg.getReplySelector()) != null) {
                        this._context.messageRegistry().unregisterPending(msg);
                    }
                    msg.discardData();
                }
            } else {
                selector = msg.getReplySelector();
                if (debug) {
                    this._log.debug("Failed and no requeue allowed for a " + msg.getMessageSize() + " byte " + msg.getMessageType() + " message with selector " + selector, new Exception("fail cause"));
                }
                if (msg.getOnFailedSendJob() != null) {
                    this._context.jobQueue().addJob(msg.getOnFailedSendJob());
                }
                if (msg.getOnFailedReplyJob() != null) {
                    this._context.jobQueue().addJob(msg.getOnFailedReplyJob());
                }
                if (selector != null) {
                    this._context.messageRegistry().unregisterPending(msg);
                }
                msg.discardData();
            }
        }
        long sendTime = now - msg.getSendBegin();
        long allTime = now - msg.getCreated();
        if (allTime > 5000L) {
            if (debug) {
                this._log.debug("Took too long from preparation to afterSend(ok? " + sendSuccessful + "): " + allTime + "ms/" + sendTime + "ms after failing on: " + msg.getFailedTransports() + (sendSuccessful ? " and succeeding on " + this.getStyle() : ""));
            }
            if (allTime > 60000L && sendSuccessful) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Severe latency? More than a minute slow? " + msg.getMessageType() + " of id " + msg.getMessageId() + " (send begin on " + new Date(msg.getSendBegin()) + " / created on " + new Date(msg.getCreated()) + "): " + msg);
                }
                this._context.messageHistory().messageProcessingError(msg.getMessageId(), msg.getMessageType(), "Took too long to send [" + allTime + "ms]");
            }
        }
        if (sendSuccessful) {
            this._context.statManager().addRateData("transport.sendProcessingTime", lifetime);
            this._context.profileManager().messageSent(msg.getTarget().getIdentity().getHash(), this.getStyle(), sendTime, msg.getMessageSize());
            this._context.statManager().addRateData("transport.sendMessageSize", msg.getMessageSize(), sendTime);
        } else {
            this._context.profileManager().messageFailed(msg.getTarget().getIdentity().getHash(), this.getStyle());
            this._context.statManager().addRateData("transport.sendMessageFailureLifetime", lifetime);
        }
    }

    @Override
    public void send(OutNetMessage msg) {
        if (msg.getTarget() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error - bad message enqueued [target is null]: " + msg, new Exception("Added by"));
            }
            return;
        }
        try {
            this._sendPool.put(msg);
        }
        catch (InterruptedException ie) {
            if (this._log.shouldLog(40)) {
                this._log.error("Interrupted during send " + msg);
            }
            return;
        }
        this.outboundMessageReady();
    }

    protected abstract void outboundMessageReady();

    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        int level = 10;
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Message received: ").append(inMsg.getClass().getSimpleName());
            buf.append(" / ").append(inMsg.getUniqueId());
            buf.append(" in ").append(msToReceive).append("ms containing ");
            buf.append(bytesReceived).append(" bytes ");
            buf.append(" from ");
            if (remoteIdentHash != null) {
                buf.append(remoteIdentHash.toBase64());
            } else if (remoteIdent != null) {
                buf.append(remoteIdent.getHash().toBase64());
            } else {
                buf.append("[unknown]");
            }
            this._log.log(level, buf.toString());
        }
        if (remoteIdent != null) {
            remoteIdentHash = remoteIdent.getHash();
        }
        if (remoteIdentHash != null) {
            this._context.profileManager().messageReceived(remoteIdentHash, this.getStyle(), msToReceive, bytesReceived);
            this._context.statManager().addRateData("transport.receiveMessageSize", bytesReceived, msToReceive);
        }
        this._context.statManager().addRateData("transport.receiveMessageTime", msToReceive);
        if (msToReceive > 1000L) {
            this._context.statManager().addRateData("transport.receiveMessageTimeSlow", msToReceive);
        }
        if (this._listener != null) {
            this._listener.messageReceived(inMsg, remoteIdent, remoteIdentHash);
        } else if (this._log.shouldLog(40)) {
            this._log.error("Null listener! this = " + this.toString(), new Exception("Null listener"));
        }
    }

    @Override
    public List<RouterAddress> getCurrentAddresses() {
        return this._currentAddresses;
    }

    @Override
    public RouterAddress getCurrentAddress(boolean ipv6) {
        for (RouterAddress ra : this._currentAddresses) {
            if (ipv6 != TransportUtil.isIPv6(ra)) continue;
            return ra;
        }
        return null;
    }

    @Override
    public boolean hasCurrentAddress() {
        return !this._currentAddresses.isEmpty();
    }

    @Override
    public List<RouterAddress> updateAddress() {
        return this._currentAddresses;
    }

    protected void replaceAddress(RouterAddress address) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Replacing address with " + address, new Exception());
        }
        if (address == null) {
            this._currentAddresses.clear();
        } else {
            boolean isIPv6 = TransportUtil.isIPv6(address);
            for (RouterAddress ra : this._currentAddresses) {
                if (isIPv6 != TransportUtil.isIPv6(ra)) continue;
                this._currentAddresses.remove(ra);
            }
            this._currentAddresses.add(address);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn(this.getStyle() + " now has " + this._currentAddresses.size() + " addresses");
        }
        if (this._listener != null) {
            this._listener.transportAddressChanged();
        }
    }

    protected void removeAddress(RouterAddress address) {
        if (this._log.shouldWarn()) {
            this._log.warn("Removing address " + address, new Exception());
        }
        boolean changed = this._currentAddresses.remove(address);
        changed = true;
        if (changed) {
            if (this._log.shouldWarn()) {
                this._log.warn(this.getStyle() + " now has " + this._currentAddresses.size() + " addresses");
            }
            if (this._listener != null) {
                this._listener.transportAddressChanged();
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn(this.getStyle() + " no addresses removed");
        }
    }

    protected void removeAddress(boolean ipv6) {
        if (this._log.shouldWarn()) {
            this._log.warn("Removing addresses, ipv6? " + ipv6, new Exception());
        }
        boolean changed = false;
        for (RouterAddress ra : this._currentAddresses) {
            if (ipv6 != TransportUtil.isIPv6(ra) || !this._currentAddresses.remove(ra)) continue;
            changed = true;
        }
        if (changed) {
            if (this._log.shouldWarn()) {
                this._log.warn(this.getStyle() + " now has " + this._currentAddresses.size() + " addresses");
            }
            if (this._listener != null) {
                this._listener.transportAddressChanged();
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn(this.getStyle() + " no addresses removed");
        }
    }

    protected void saveLocalAddress(InetAddress address) {
        this._localAddresses.add(address);
    }

    protected Collection<InetAddress> getSavedLocalAddresses() {
        ArrayList<InetAddress> rv = new ArrayList<InetAddress>(this._localAddresses);
        this._localAddresses.clear();
        return rv;
    }

    public List<RouterAddress> getTargetAddresses(RouterInfo target) {
        String alt = this.getAltStyle();
        List<RouterAddress> rv = alt != null ? target.getTargetAddresses(this.getStyle(), alt) : target.getTargetAddresses(this.getStyle());
        if (rv.size() > 1) {
            int adj;
            Collections.shuffle(rv, this._context.random());
            TransportUtil.IPv6Config config = this.getIPv6Config();
            switch (config) {
                case IPV6_DISABLED: {
                    adj = 10;
                    break;
                }
                case IPV6_NOT_PREFERRED: {
                    adj = 1;
                    break;
                }
                default: {
                    adj = 0;
                    break;
                }
                case IPV6_PREFERRED: {
                    adj = -1;
                    break;
                }
                case IPV6_ONLY: {
                    adj = -10;
                }
            }
            Collections.sort(rv, new AddrComparator(adj));
        }
        return rv;
    }

    @Override
    public abstract void externalAddressReceived(Transport.AddressSource var1, byte[] var2, int var3);

    @Override
    public void externalAddressRemoved(Transport.AddressSource source, boolean ipv6) {
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
    }

    @Override
    public int getRequestedPort() {
        return -1;
    }

    @Override
    public void setListener(TransportEventListener listener) {
        this._listener = listener;
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this.renderStatusHTML(out);
    }

    @Override
    public abstract CommSystemFacade.Status getReachabilityStatus();

    @Override
    @Deprecated
    public void recheckReachability() {
    }

    @Override
    public boolean isIPv4Firewalled() {
        return TransportUtil.isIPv4Firewalled(this._context, this.getStyle());
    }

    @Override
    public boolean isIPv6Firewalled() {
        return TransportUtil.isIPv6Firewalled(this._context, this.getStyle());
    }

    @Override
    public boolean isBacklogged(Hash peer) {
        return false;
    }

    @Override
    public boolean isEstablished(Hash peer) {
        return false;
    }

    @Override
    public void mayDisconnect(Hash peer) {
    }

    @Override
    public boolean isUnreachable(Hash peer) {
        if (peer == this._lastReachablePeer) {
            return false;
        }
        Long when = this._unreachableEntries.get(peer);
        boolean rv = when != null;
        if (rv) {
            long now = this._context.clock().now();
            boolean bl = rv = when + this.UNREACHABLE_PERIOD >= now;
            if (!rv) {
                this._lastReachablePeer = peer;
                this._unreachableEntries.remove(peer);
            }
        } else {
            this._lastReachablePeer = peer;
        }
        return rv;
    }

    public void markUnreachable(Hash peer) {
        CommSystemFacade.Status status = this._context.commSystem().getStatus();
        if (status == CommSystemFacade.Status.DISCONNECTED || status == CommSystemFacade.Status.HOSED) {
            return;
        }
        Long now = this._context.clock().now();
        this._unreachableEntries.put(peer, now);
        if (peer == this._lastReachablePeer) {
            this._lastReachablePeer = null;
        }
        this.markWasUnreachable(peer, true);
    }

    public void markReachable(Hash peer, boolean isInbound) {
        this._context.banlist().unbanlistRouter(peer);
        this._unreachableEntries.remove(peer);
        if (!isInbound) {
            this.markWasUnreachable(peer, false);
        }
    }

    @Override
    public boolean wasUnreachable(Hash peer) {
        Long when = this._wasUnreachableEntries.get(peer);
        if (when != null) {
            long now = this._context.clock().now();
            if (when + this.WAS_UNREACHABLE_PERIOD < now) {
                this._unreachableEntries.remove(peer);
                return false;
            }
            return true;
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return false;
        }
        String alt = this.getAltStyle();
        if (alt != null) {
            List<RouterAddress> addrs = ri.getTargetAddresses(this.getStyle(), alt);
            return addrs.isEmpty();
        }
        RouterAddress addr = ri.getTargetAddress(this.getStyle());
        return addr == null;
    }

    private void markWasUnreachable(Hash peer, boolean yes) {
        if (yes) {
            Long now = this._context.clock().now();
            this._wasUnreachableEntries.put(peer, now);
        } else {
            this._wasUnreachableEntries.remove(peer);
        }
        if (this._log.shouldDebug()) {
            this._log.debug(this.getStyle() + " setting wasUnreachable to " + yes + " for " + peer, yes ? new Exception() : null);
        }
    }

    public boolean allowLocal() {
        return this._context.getBooleanProperty("i2np.allowLocal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIP(Hash peer, byte[] ip) {
        byte[] old;
        Map<Hash, byte[]> map = _IPMap;
        synchronized (map) {
            old = _IPMap.put(peer, ip);
        }
        if (!DataHelper.eq(old, ip)) {
            this._context.commSystem().queueLookup(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIP(Hash peer) {
        Map<Hash, byte[]> map = _IPMap;
        synchronized (map) {
            return _IPMap.get(peer);
        }
    }

    public String getAltStyle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<Hash, byte[]> map = _IPMap;
        synchronized (map) {
            _IPMap.clear();
        }
    }

    @Override
    public TransportUtil.IPv6Config getIPv6Config() {
        return TransportUtil.getIPv6Config(this._context, this.getStyle());
    }

    protected boolean isPubliclyRoutable(byte[] addr) {
        TransportUtil.IPv6Config cfg = this.getIPv6Config();
        return TransportUtil.isPubliclyRoutable(addr, cfg != TransportUtil.IPv6Config.IPV6_ONLY, cfg != TransportUtil.IPv6Config.IPV6_DISABLED);
    }

    protected String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    protected String _t(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    protected String ngettext(String s, String p, int n) {
        return Translate.getString(n, s, p, (I2PAppContext)this._context, BUNDLE_NAME);
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        long min = 512L;
        long max = 4096L;
        int size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 131072L));
        _IPMap = new LHMCache<Hash, byte[]>(size);
    }

    private static class AddrComparator
    implements Comparator<RouterAddress>,
    Serializable {
        private final int adj;

        public AddrComparator(int ipv6Adjustment) {
            this.adj = ipv6Adjustment;
        }

        @Override
        public int compare(RouterAddress l, RouterAddress r) {
            int lc = l.getCost();
            int rc = r.getCost();
            byte[] lip = l.getIP();
            byte[] rip = r.getIP();
            if (lip == null) {
                lc += 20;
            } else if (lip.length == 16) {
                lc += this.adj;
            }
            if (rip == null) {
                rc += 20;
            } else if (rip.length == 16) {
                rc += this.adj;
            }
            if (lc > rc) {
                return 1;
            }
            if (lc < rc) {
                return -1;
            }
            return 0;
        }
    }

    private class CleanupUnreachable
    implements SimpleTimer.TimedEvent {
        private CleanupUnreachable() {
        }

        @Override
        public void timeReached() {
            Long when;
            long now = TransportImpl.this._context.clock().now();
            long limit = now - TransportImpl.this.UNREACHABLE_PERIOD;
            Iterator iter = TransportImpl.this._unreachableEntries.values().iterator();
            while (iter.hasNext()) {
                when = (Long)iter.next();
                if (when >= limit) continue;
                iter.remove();
            }
            limit = now - TransportImpl.this.WAS_UNREACHABLE_PERIOD;
            iter = TransportImpl.this._wasUnreachableEntries.values().iterator();
            while (iter.hasNext()) {
                when = (Long)iter.next();
                if (when >= limit) continue;
                iter.remove();
            }
        }
    }
}

