/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.GeoIP;
import net.i2p.router.transport.GetBidsJob;
import net.i2p.router.transport.StrictCountries;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.crypto.X25519KeyFactory;
import net.i2p.util.AddressType;
import net.i2p.util.Addresses;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class CommSystemFacadeImpl
extends CommSystemFacade {
    private final Log _log;
    private final RouterContext _context;
    private final TransportManager _manager;
    private final GeoIP _geoIP;
    private volatile boolean _netMonitorStatus;
    private boolean _wasStarted;
    private static final String PROP_DISABLED = "i2np.disable";
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final String COUNTRY_BUNDLE_NAME = "net.i2p.router.countries.messages";
    private static final int START_DELAY = SystemVersion.isSlow() ? 300000 : 5000;
    private static final int LOOKUP_TIME = 1800000;
    private static final int TIME_START_DELAY = 300000;
    private static final int TIME_REPEAT_DELAY = 600000;

    public CommSystemFacadeImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(CommSystemFacadeImpl.class);
        this._netMonitorStatus = true;
        this._geoIP = new GeoIP(this._context);
        this._manager = new TransportManager(this._context);
    }

    @Override
    public synchronized void startup() {
        this._log.info("Starting up the comm system");
        this._manager.startListening();
        this.startTimestamper();
        this.startNetMonitor();
        this._wasStarted = true;
    }

    @Override
    public synchronized void shutdown() {
        this._manager.shutdown();
        this._geoIP.shutdown();
    }

    @Override
    public synchronized void restart() {
        if (!this._wasStarted) {
            this.startup();
        } else {
            this._wasStarted = false;
            this._manager.restart();
            this._wasStarted = true;
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return this._wasStarted;
    }

    @Override
    public int countActivePeers() {
        return this._manager.countActivePeers();
    }

    @Override
    public int countActiveSendPeers() {
        return this._manager.countActiveSendPeers();
    }

    @Override
    public boolean haveInboundCapacity(int pct) {
        return this._manager.haveInboundCapacity(pct);
    }

    @Override
    public boolean haveOutboundCapacity(int pct) {
        return this._manager.haveOutboundCapacity(pct);
    }

    @Override
    public boolean haveHighOutboundCapacity() {
        return this._manager.haveHighOutboundCapacity();
    }

    @Override
    public long getFramedAveragePeerClockSkew(int percentToInclude) {
        List<Long> skews = this._manager.getClockSkews();
        if (skews == null || skews.isEmpty() || skews.size() < 5 && this._context.clock().getUpdatedSuccessfully()) {
            return this._context.clock().getOffset();
        }
        Collections.sort(skews);
        if (this._log.shouldLog(10)) {
            this._log.debug("Clock skews: " + skews);
        }
        int frameSize = Math.max(skews.size() * percentToInclude / 100, 1);
        int first = skews.size() / 2 - frameSize / 2;
        int last = Math.min(skews.size() / 2 + frameSize / 2, skews.size() - 1);
        long sum = 0L;
        for (int i = first; i <= last; ++i) {
            long value = skews.get(i);
            sum += value;
        }
        return sum * 1000L / (long)frameSize;
    }

    @Override
    public void processMessage(OutNetMessage msg) {
        if (this.isDummy()) {
            GetBidsJob.fail(this._context, msg);
            return;
        }
        GetBidsJob.getBids(this._context, this._manager, msg);
    }

    @Override
    public boolean isBacklogged(Hash peer) {
        return this._manager.isBacklogged(peer);
    }

    @Override
    public boolean isEstablished(Hash peer) {
        return this._manager.isEstablished(peer);
    }

    @Override
    public Set<Hash> getEstablished() {
        return this._manager.getEstablished();
    }

    @Override
    public boolean wasUnreachable(Hash peer) {
        return this._manager.wasUnreachable(peer);
    }

    @Override
    public byte[] getIP(Hash peer) {
        return this._manager.getIP(peer);
    }

    @Override
    public void mayDisconnect(Hash peer) {
        this._manager.mayDisconnect(peer);
    }

    @Override
    public void forceDisconnect(Hash peer) {
        this._manager.forceDisconnect(peer);
    }

    @Override
    public List<String> getMostRecentErrorMessages() {
        return this._manager.getMostRecentErrorMessages();
    }

    @Override
    public CommSystemFacade.Status getStatus() {
        if (!this._netMonitorStatus) {
            return CommSystemFacade.Status.DISCONNECTED;
        }
        CommSystemFacade.Status rv = this._manager.getReachabilityStatus();
        if (rv != CommSystemFacade.Status.HOSED && this._context.router().isHidden()) {
            return CommSystemFacade.Status.OK;
        }
        return rv;
    }

    @Override
    public String getLocalizedStatusString() {
        return Translate.getString(this.getStatus().toStatusString(), this._context, "net.i2p.router.util.messages");
    }

    @Override
    @Deprecated
    public void recheckReachability() {
        this._manager.recheckReachability();
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this._manager.renderStatusHTML(out, urlBase, sortFlags);
    }

    @Override
    public SortedMap<String, Transport> getTransports() {
        return this._manager.getTransports();
    }

    @Override
    public List<RouterAddress> createAddresses() {
        ArrayList<RouterAddress> addresses = new ArrayList<RouterAddress>(this._manager.getAddresses());
        if (addresses.size() > 1) {
            Collections.sort(addresses, new AddrComparator());
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Creating addresses: " + addresses, new Exception("creator"));
        }
        return addresses;
    }

    @Override
    public void notifyReplaceAddress(RouterAddress udpAddr) {
        Transport udp;
        byte[] ip = null;
        int port = 0;
        if (udpAddr != null && udpAddr.getOption("itag0") == null) {
            ip = udpAddr.getIP();
            port = udpAddr.getPort();
        }
        if (port < 0 && (udp = this._manager.getTransport("SSU")) != null) {
            port = udp.getRequestedPort();
        }
        if (ip != null || port > 0) {
            this._manager.externalAddressReceived(Transport.AddressSource.SOURCE_SSU, ip, port);
        } else {
            this.notifyRemoveAddress(udpAddr);
        }
    }

    @Override
    public void notifyRemoveAddress(RouterAddress address) {
        this.notifyRemoveAddress(address != null && TransportUtil.isIPv6(address));
    }

    @Override
    public void notifyRemoveAddress(boolean ipv6) {
        this._manager.externalAddressRemoved(Transport.AddressSource.SOURCE_SSU, ipv6);
    }

    @Override
    public void registerTransport(Transport t) {
        this._manager.registerAndStart(t);
    }

    @Override
    public void unregisterTransport(Transport t) {
        this._manager.stopAndUnregister(t);
    }

    @Override
    public DHSessionKeyBuilder.Factory getDHFactory() {
        return this._manager.getDHFactory();
    }

    @Override
    public X25519KeyFactory getXDHFactory() {
        return this._manager.getXDHFactory();
    }

    @Override
    public void initGeoIP() {
        this.startGeoIP();
    }

    private void startGeoIP() {
        this._context.simpleTimer2().addEvent(new QueueAll(), START_DELAY);
    }

    @Override
    public void queueLookup(byte[] ip) {
        this._geoIP.add(ip);
    }

    @Override
    public String getOurCountry() {
        return this._context.getProperty("i2np.lastCountry");
    }

    @Override
    public boolean isInStrictCountry() {
        String us = this.getOurCountry();
        return us != null && StrictCountries.contains(us) || this._context.getBooleanProperty("router.forceStrictCountry");
    }

    @Override
    public boolean isInStrictCountry(Hash peer) {
        String c = this.getCountry(peer);
        return c != null && StrictCountries.contains(c);
    }

    @Override
    public boolean isInStrictCountry(RouterInfo ri) {
        byte[] ip = CommSystemFacadeImpl.getIP(ri);
        if (ip == null) {
            return false;
        }
        String c = this._geoIP.get(ip);
        return c != null && StrictCountries.contains(c);
    }

    @Override
    public String getCountry(Hash peer) {
        byte[] ip = TransportImpl.getIP(peer);
        if (ip != null) {
            return this._geoIP.get(ip);
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return null;
        }
        ip = CommSystemFacadeImpl.getValidIP(ri);
        if (ip != null) {
            return this._geoIP.get(ip);
        }
        return null;
    }

    private static byte[] getIP(RouterInfo ri) {
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    private static byte[] getValidIP(RouterInfo ri) {
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null || !TransportUtil.isPubliclyRoutable(rv, true)) continue;
            return rv;
        }
        return null;
    }

    @Override
    public String getCountryName(String c) {
        if (this._geoIP == null) {
            return c;
        }
        String n = this._geoIP.fullName(c);
        if (n == null) {
            return c;
        }
        return n;
    }

    @Override
    public Map<String, String> getCountries() {
        if (this._geoIP == null) {
            return Collections.emptyMap();
        }
        return this._geoIP.getCountries();
    }

    @Override
    public String renderPeerHTML(Hash peer) {
        boolean found;
        String h = peer.toBase64();
        StringBuilder buf = new StringBuilder(128);
        String c = this.getCountry(peer);
        if (c != null) {
            String countryName = this.getCountryName(c);
            if (countryName.length() > 2) {
                countryName = Translate.getString(countryName, this._context, COUNTRY_BUNDLE_NAME);
            }
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(c.toUpperCase(Locale.US)).append("\" title=\"");
            buf.append(countryName);
            buf.append("\" src=\"/flags.jsp?c=").append(c).append("\"> ");
        } else {
            buf.append("<img class=\"unknownflag\" height=\"11\" width=\"16\" alt=\"??\" src=\"/flags.jsp?c=a0\" title=\"").append(this._t("unknown")).append("\"> ");
        }
        buf.append("<tt>");
        boolean bl = found = this._context.netDb().lookupRouterInfoLocally(peer) != null;
        if (found) {
            buf.append("<a title=\"").append(this._t("NetDb entry")).append("\" href=\"netdb?r=").append(h).append("\">");
        }
        buf.append(h, 0, 4);
        if (found) {
            buf.append("</a>");
        }
        buf.append("</tt>");
        return buf.toString();
    }

    @Override
    public boolean isDummy() {
        return this._context.getBooleanProperty(PROP_DISABLED);
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private void startTimestamper() {
        this._context.simpleTimer2().addPeriodicEvent(new Timestamper(), 300000L, 600000L);
    }

    private void startNetMonitor() {
        new NetMonitor();
    }

    private static class AddrComparator
    implements Comparator<RouterAddress>,
    Serializable {
        private AddrComparator() {
        }

        @Override
        public int compare(RouterAddress l, RouterAddress r) {
            int rh;
            int rv = l.getCost() - r.getCost();
            if (rv != 0) {
                return rv;
            }
            int lh = l.hashCode();
            if (lh > (rh = l.hashCode())) {
                return 1;
            }
            if (lh < rh) {
                return -1;
            }
            return 0;
        }
    }

    private class Lookup
    implements SimpleTimer.TimedEvent {
        private Lookup() {
        }

        @Override
        public void timeReached() {
            new LookupThread().start();
        }
    }

    private class LookupThread
    extends I2PThread {
        public LookupThread() {
            super("GeoIP Lookup");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            CommSystemFacadeImpl.this._geoIP.blockingLookup();
            if (CommSystemFacadeImpl.this._log.shouldLog(20)) {
                CommSystemFacadeImpl.this._log.info("GeoIP lookup took " + (System.currentTimeMillis() - start));
            }
        }
    }

    private class NetMonitor
    extends SimpleTimer2.TimedEvent {
        private static final long SHORT_DELAY = 15000L;
        private static final long LONG_DELAY = 180000L;

        public NetMonitor() {
            super(CommSystemFacadeImpl.this._context.simpleTimer2(), 0L);
        }

        @Override
        public void timeReached() {
            boolean good;
            Set<AddressType> addrs = Addresses.getConnectedAddressTypes();
            boolean bl = good = addrs.contains((Object)AddressType.IPV4) || addrs.contains((Object)AddressType.IPV6);
            if (CommSystemFacadeImpl.this._netMonitorStatus != good) {
                if (good) {
                    CommSystemFacadeImpl.this._log.logAlways(20, "Network reconnected");
                } else {
                    CommSystemFacadeImpl.this._log.error("Network disconnected");
                }
                CommSystemFacadeImpl.this._context.router().eventLog().addEvent("network", good ? "connected" : "disconnected");
                CommSystemFacadeImpl.this._netMonitorStatus = good;
                if (good) {
                    CommSystemFacadeImpl.this._manager.initializeAddress();
                    CommSystemFacadeImpl.this._manager.transportAddressChanged();
                }
            }
            this.reschedule(good ? 180000L : 15000L);
        }
    }

    private class QueueAll
    implements SimpleTimer.TimedEvent {
        private QueueAll() {
        }

        @Override
        public void timeReached() {
            for (Hash h : CommSystemFacadeImpl.this._context.netDb().getAllRouters()) {
                byte[] ip;
                RouterInfo ri = CommSystemFacadeImpl.this._context.netDb().lookupRouterInfoLocally(h);
                if (ri == null || (ip = CommSystemFacadeImpl.getIP(ri)) == null) continue;
                CommSystemFacadeImpl.this._geoIP.add(ip);
            }
            CommSystemFacadeImpl.this._context.simpleTimer2().addPeriodicEvent(new Lookup(), 5000L, 1800000L);
        }
    }

    private class Timestamper
    implements SimpleTimer.TimedEvent {
        private Timestamper() {
        }

        @Override
        public void timeReached() {
            long peerOffset = CommSystemFacadeImpl.this.getFramedAveragePeerClockSkew(33);
            if (peerOffset == 0L) {
                return;
            }
            long currentOffset = CommSystemFacadeImpl.this._context.clock().getOffset();
            long newOffset = currentOffset - peerOffset;
            CommSystemFacadeImpl.this._context.clock().setOffset(newOffset);
        }
    }
}

