/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

public class SimpleTimer2 {
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 4;
    private final ScheduledThreadPoolExecutor _executor;
    private final String _name;
    private final AtomicInteger _count = new AtomicInteger();
    private final int _threads;
    private final I2PAppContext _context;
    private final Runnable _shutdown;

    public static SimpleTimer2 getInstance() {
        return I2PAppContext.getGlobalContext().simpleTimer2();
    }

    public SimpleTimer2(I2PAppContext context) {
        this(context, "SimpleTimer2");
    }

    protected SimpleTimer2(I2PAppContext context, String name) {
        this(context, name, true);
    }

    protected SimpleTimer2(I2PAppContext context, String name, boolean prestartAllThreads) {
        this._context = context;
        this._name = name;
        long maxMemory = SystemVersion.getMaxMemory();
        this._threads = (int)Math.max(2L, Math.min(4L, 1L + maxMemory / 0x2000000L));
        this._executor = new CustomScheduledThreadPoolExecutor(this._threads, new CustomThreadFactory());
        if (prestartAllThreads) {
            this._executor.prestartAllCoreThreads();
        }
        this._shutdown = new Shutdown();
        context.addShutdownTask(this._shutdown);
    }

    public void stop() {
        this.stop(true);
    }

    private void stop(boolean removeTask) {
        if (removeTask) {
            this._context.removeShutdownTask(this._shutdown);
        }
        this._executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        this._executor.shutdownNow();
    }

    private ScheduledFuture<?> schedule(TimedEvent t, long timeoutMs) {
        return this._executor.schedule(t, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void addEvent(final SimpleTimer.TimedEvent event, long timeoutMs) {
        if (event == null) {
            throw new IllegalArgumentException("addEvent null");
        }
        new TimedEvent(this, timeoutMs){

            @Override
            public void timeReached() {
                event.timeReached();
            }

            public String toString() {
                return event.toString();
            }
        };
    }

    public void addPeriodicEvent(SimpleTimer.TimedEvent event, long timeoutMs) {
        this.addPeriodicEvent(event, timeoutMs, timeoutMs);
    }

    public void addPeriodicEvent(final SimpleTimer.TimedEvent event, long delay, long timeoutMs) {
        new PeriodicTimedEvent(this, delay, timeoutMs){

            @Override
            public void timeReached() {
                event.timeReached();
            }

            public String toString() {
                return event.toString();
            }
        };
    }

    public String toString() {
        return this._name;
    }

    private long getCompletedTaskCount() {
        return this._executor.getCompletedTaskCount();
    }

    private String debug() {
        this._executor.purge();
        return " Pool: " + this._name + " Active: " + this._executor.getActiveCount() + '/' + this._executor.getPoolSize() + " Completed: " + this._executor.getCompletedTaskCount() + " Queued: " + this._executor.getQueue().size();
    }

    private static class CustomScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        public CustomScheduledThreadPoolExecutor(int threads, ThreadFactory factory) {
            super(threads, factory);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(SimpleTimer2.class);
                log.log(50, "event borked: " + r, t);
            }
        }
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(SimpleTimer2.this._name + ' ' + SimpleTimer2.this._count.incrementAndGet() + '/' + SimpleTimer2.this._threads);
            rv.setDaemon(true);
            rv.setPriority(6);
            return rv;
        }
    }

    private static abstract class PeriodicTimedEvent
    extends TimedEvent {
        private final long _timeoutMs;

        public PeriodicTimedEvent(SimpleTimer2 pool, long delay, long timeoutMs) {
            super(pool, delay);
            if (timeoutMs < 5000L) {
                throw new IllegalArgumentException("timeout minimum 5000");
            }
            this._timeoutMs = timeoutMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            PeriodicTimedEvent periodicTimedEvent = this;
            synchronized (periodicTimedEvent) {
                if (this._state == TimedEventState.IDLE) {
                    this.schedule(this._timeoutMs);
                }
            }
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            SimpleTimer2.this.stop(false);
        }
    }

    public static abstract class TimedEvent
    implements Runnable {
        private final Log _log;
        private final SimpleTimer2 _pool;
        private int _fuzz;
        protected static final int DEFAULT_FUZZ = 3;
        private ScheduledFuture<?> _future;
        protected TimedEventState _state;
        private long _nextRun;
        private boolean _rescheduleAfterRun;
        private boolean _cancelAfterRun;

        public TimedEvent(SimpleTimer2 pool) {
            this._pool = pool;
            this._fuzz = 3;
            this._log = I2PAppContext.getGlobalContext().logManager().getLog(SimpleTimer2.class);
            this._state = TimedEventState.IDLE;
        }

        public TimedEvent(SimpleTimer2 pool, long timeoutMs) {
            this(pool);
            this.schedule(timeoutMs);
        }

        public synchronized void setFuzz(int fuzz) {
            this._fuzz = fuzz;
        }

        public synchronized void schedule(long timeoutMs) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Scheduling: " + this + " timeout = " + timeoutMs + " state: " + (Object)((Object)this._state));
            }
            if (timeoutMs <= 0L) {
                if (timeoutMs < 0L && this._log.shouldLog(30)) {
                    this._log.warn("Sched. timeout < 0: " + this + " timeout = " + timeoutMs + " state: " + (Object)((Object)this._state));
                }
                timeoutMs = 1L;
            }
            this._nextRun = timeoutMs + System.currentTimeMillis();
            this._cancelAfterRun = false;
            switch (this._state) {
                case RUNNING: {
                    this._rescheduleAfterRun = true;
                    break;
                }
                case IDLE: 
                case CANCELLED: {
                    this._future = this._pool.schedule(this, timeoutMs);
                    this._state = TimedEventState.SCHEDULED;
                    break;
                }
            }
        }

        public void reschedule(long timeoutMs) {
            this.reschedule(timeoutMs, true);
        }

        public synchronized void reschedule(long timeoutMs, boolean useEarliestTime) {
            if (timeoutMs <= 0L) {
                if (timeoutMs < 0L && this._log.shouldInfo()) {
                    this._log.info("Resched. timeout < 0: " + this + " timeout = " + timeoutMs + " state: " + (Object)((Object)this._state));
                }
                timeoutMs = 1L;
            }
            long now = System.currentTimeMillis();
            boolean scheduled = this._state == TimedEventState.SCHEDULED;
            long oldTimeout = scheduled ? this._nextRun - now : timeoutMs;
            if (oldTimeout - (long)this._fuzz > timeoutMs && useEarliestTime || oldTimeout + (long)this._fuzz < timeoutMs && !useEarliestTime || !scheduled) {
                if (scheduled && oldTimeout <= 5L) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("not rescheduling to " + timeoutMs + ", about to execute " + this + " in " + oldTimeout);
                    }
                    return;
                }
                if (scheduled && now + timeoutMs < this._nextRun) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Re-scheduling: " + this + " timeout = " + timeoutMs + " old timeout was " + oldTimeout + " state: " + (Object)((Object)this._state));
                    }
                    this.cancel();
                }
                this.schedule(timeoutMs);
            }
        }

        public synchronized void forceReschedule(long timeoutMs) {
            if (this._state == TimedEventState.SCHEDULED) {
                this.cancel();
            }
            this.schedule(timeoutMs);
        }

        public synchronized boolean cancel() {
            this._rescheduleAfterRun = false;
            switch (this._state) {
                case IDLE: 
                case CANCELLED: {
                    break;
                }
                case RUNNING: {
                    this._cancelAfterRun = true;
                    return true;
                }
                case SCHEDULED: {
                    boolean cancelled = this._future.cancel(true);
                    if (cancelled) {
                        this._state = TimedEventState.CANCELLED;
                    } else if (this._log.shouldWarn()) {
                        this._log.warn("could not cancel " + this + " to run in " + (this._nextRun - System.currentTimeMillis()), new Exception());
                    }
                    return cancelled;
                }
            }
            return false;
        }

        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (RuntimeException re) {
                this._log.error("timer error", re);
                throw re;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run2() {
            long completed;
            if (this._log.shouldLog(10)) {
                this._log.debug("Running: " + this);
            }
            long before = System.currentTimeMillis();
            long delay = 0L;
            TimedEvent timedEvent = this;
            synchronized (timedEvent) {
                if (Thread.currentThread().isInterrupted()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("I was interrupted in run, state " + (Object)((Object)this._state) + " event " + this);
                    }
                    return;
                }
                if (this._rescheduleAfterRun) {
                    throw new IllegalStateException(this + " rescheduleAfterRun cannot be true here");
                }
                switch (this._state) {
                    case CANCELLED: {
                        if (this._log.shouldInfo()) {
                            this._log.info("Not actually running: CANCELLED " + this);
                        }
                        return;
                    }
                    case RUNNING: 
                    case IDLE: {
                        throw new IllegalStateException(this + " not possible to be in " + (Object)((Object)this._state));
                    }
                }
                long difference = this._nextRun - before;
                if (difference > (long)this._fuzz) {
                    this._state = TimedEventState.IDLE;
                    if (this._log.shouldInfo()) {
                        this._log.info("Early execution, Rescheduling for " + difference + " later: " + this);
                    }
                    this.schedule(difference);
                    return;
                }
                this._state = TimedEventState.RUNNING;
            }
            if (this._future != null) {
                delay = this._future.getDelay(TimeUnit.MILLISECONDS);
            } else if (this._log.shouldLog(30)) {
                this._log.warn(this._pool + " no _future " + this);
            }
            if (this._log.shouldWarn()) {
                if (delay > 100L) {
                    this._log.warn(this._pool + " early execution " + delay + ": " + this);
                } else if (delay < -1000L) {
                    this._log.warn(" late execution " + (0L - delay) + ": " + this + this._pool.debug());
                }
            }
            try {
                this.timeReached();
            }
            catch (Throwable t) {
                this._log.log(50, this._pool + ": Timed task " + this + " exited unexpectedly, please report", t);
            }
            finally {
                timedEvent = this;
                synchronized (timedEvent) {
                    switch (this._state) {
                        case IDLE: 
                        case SCHEDULED: {
                            throw new IllegalStateException(this + " can't be " + (Object)((Object)this._state));
                        }
                        case CANCELLED: {
                            break;
                        }
                        case RUNNING: {
                            if (this._cancelAfterRun) {
                                this._cancelAfterRun = false;
                                this._state = TimedEventState.CANCELLED;
                                break;
                            }
                            this._state = TimedEventState.IDLE;
                            if (!this._rescheduleAfterRun) break;
                            this._rescheduleAfterRun = false;
                            if (this._log.shouldInfo()) {
                                this._log.info("Reschedule after run: " + this);
                            }
                            this.schedule(this._nextRun - System.currentTimeMillis());
                        }
                    }
                }
            }
            long time = System.currentTimeMillis() - before;
            if (time > 500L && this._log.shouldLog(30)) {
                this._log.warn(this._pool + " event execution took " + time + ": " + this);
            } else if (this._log.shouldDebug()) {
                this._log.debug("Execution finished in " + time + ": " + this);
            }
            if (this._log.shouldLog(20) && (completed = this._pool.getCompletedTaskCount()) % 250L == 0L) {
                this._log.info(this._pool.debug());
            }
        }

        public abstract void timeReached();
    }

    private static enum TimedEventState {
        IDLE,
        SCHEDULED,
        RUNNING,
        CANCELLED;

    }
}

